/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.context;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.Display;
import net.sourceforge.jeuclid.context.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutContextImpl
implements MutableLayoutContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Parameter, Object> context;

    protected LayoutContextImpl() {
        this.context = new TreeMap<Parameter, Object>();
        this.context.put(Parameter.MATHSIZE, Float.valueOf(12.0f));
        this.context.put(Parameter.SCRIPTMINSIZE, Float.valueOf(8.0f));
        this.context.put(Parameter.ANTIALIAS_MINSIZE, Float.valueOf(10.0f));
        this.context.put(Parameter.SCRIPTSIZEMULTIPLIER, Float.valueOf(0.71f));
        this.context.put(Parameter.SCRIPTLEVEL, 0);
        this.context.put(Parameter.DISPLAY, (Object)Display.BLOCK);
        this.context.put(Parameter.DEBUG, false);
        this.context.put(Parameter.ANTIALIAS, true);
        this.context.put(Parameter.MATHCOLOR, Color.BLACK);
        this.context.put(Parameter.MATHBACKGROUND, null);
        ArrayList<String> arrayList = new ArrayList<String>(12);
        arrayList.add("Verdana");
        arrayList.add("Helvetica");
        arrayList.add("Arial");
        arrayList.add("Arial Unicode MS");
        arrayList.add("Lucida Sans Unicode");
        arrayList.add("Lucida Sans");
        arrayList.add("Lucida Grande");
        arrayList.add("DejaVu Sans");
        arrayList.add("DejaVuSans");
        arrayList.add("Bitstream Vera Sans");
        arrayList.add("Luxi Sans");
        arrayList.add("FreeSans");
        arrayList.add("sansserif");
        this.context.put(Parameter.FONTS_SANSSERIF, Collections.unmodifiableList(arrayList));
        ArrayList<String> arrayList2 = new ArrayList<String>(10);
        arrayList2.add("Constantina");
        arrayList2.add("Cambria");
        arrayList2.add("Times");
        arrayList2.add("Times New Roman");
        arrayList2.add("Lucida Bright");
        arrayList2.add("DejaVu Serif");
        arrayList2.add("DejaVuSerif");
        arrayList2.add("Bitstream Vera Serif");
        arrayList2.add("Luxi Serif");
        arrayList2.add("FreeSerif");
        arrayList2.add("serif");
        this.context.put(Parameter.FONTS_SERIF, Collections.unmodifiableList(arrayList2));
        ArrayList<String> arrayList3 = new ArrayList<String>(10);
        arrayList3.add("Andale Mono");
        arrayList3.add("Courier");
        arrayList3.add("Courier Mono");
        arrayList3.add("Courier New");
        arrayList3.add("Lucida Sans Typewriter");
        arrayList3.add("DejaVu Sans Mono");
        arrayList3.add("DejaVuSansMono");
        arrayList3.add("Bitstream Vera Sans Mono");
        arrayList3.add("Luxi Mono");
        arrayList3.add("FreeMono");
        arrayList3.add("monospaced");
        this.context.put(Parameter.FONTS_MONOSPACED, Collections.unmodifiableList(arrayList3));
        ArrayList<String> arrayList4 = new ArrayList<String>(12);
        arrayList4.add("EUSM10");
        arrayList4.add("cmsy10");
        arrayList4.add("Math5");
        arrayList4.add("Mathematica5");
        arrayList4.add("Savoye LET");
        arrayList4.add("Brush Script MT");
        arrayList4.add("Zapfino");
        arrayList4.add("Apple Chancery");
        arrayList4.add("Edwardian Script ITC");
        arrayList4.add("Lucida Handwriting");
        arrayList4.add("Monotype Corsiva");
        arrayList4.add("Santa Fe LET");
        this.context.put(Parameter.FONTS_SCRIPT, Collections.unmodifiableList(arrayList4));
        ArrayList<String> arrayList5 = new ArrayList<String>(7);
        arrayList5.add("EUFM10");
        arrayList5.add("Mathematica6");
        arrayList5.add("FetteFraktur");
        arrayList5.add("Fette Fraktur");
        arrayList5.add("Euclid Fraktur");
        arrayList5.add("Lucida Blackletter");
        arrayList5.add("Blackmoor LET");
        this.context.put(Parameter.FONTS_FRAKTUR, Collections.unmodifiableList(arrayList5));
        ArrayList<String> arrayList6 = new ArrayList<String>(8);
        arrayList6.add("MSBM10");
        arrayList6.add("Mathematica7");
        arrayList6.add("Caslon Open Face");
        arrayList6.add("Caslon Openface");
        arrayList6.add("Cloister Open Face");
        arrayList6.add("Academy Engraved LET");
        arrayList6.add("Colonna MT");
        arrayList6.add("Imprint MT Shadow");
        this.context.put(Parameter.FONTS_DOUBLESTRUCK, Collections.unmodifiableList(arrayList6));
        this.context.put(Parameter.MFRAC_KEEP_SCRIPTLEVEL, Boolean.FALSE);
    }

    public LayoutContextImpl(LayoutContext layoutContext) {
        if (!(layoutContext instanceof LayoutContextImpl)) {
            throw new UnsupportedOperationException("LayoutContextImpl(" + layoutContext.getClass() + ") not supported.");
        }
        this.context = new TreeMap<Parameter, Object>(((LayoutContextImpl)layoutContext).getParameters());
    }

    public static LayoutContext getDefaultLayoutContext() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public LayoutContext setParameter(Parameter parameter, Object object) {
        if (parameter.valid(object)) {
            this.context.put(parameter, object);
        } else {
            this.context.put(parameter, parameter.fromString(object.toString()));
        }
        return this;
    }

    @Override
    public Object getParameter(Parameter parameter) {
        return this.context.get((Object)parameter);
    }

    private Map<Parameter, Object> getParameters() {
        return Collections.unmodifiableMap(this.context);
    }

    private static final class SingletonHolder {
        private static final LayoutContextImpl INSTANCE = new LayoutContextImpl();

        private SingletonHolder() {
        }
    }
}

