/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.vector;

import org.la4j.factory.Factory;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;
import org.la4j.vector.Vectors;
import org.la4j.vector.functor.VectorAccumulator;
import org.la4j.vector.functor.VectorFunction;
import org.la4j.vector.functor.VectorPredicate;
import org.la4j.vector.functor.VectorProcedure;

public abstract class AbstractVector
implements Vector {
    protected int length;
    protected Factory factory;

    protected AbstractVector(Factory factory) {
        this(factory, 0);
    }

    protected AbstractVector(Factory factory, int length) {
        this.ensureLengthIsNotNegative(length);
        this.factory = factory;
        this.length = length;
    }

    @Override
    public void swap(int i, int j) {
        double s = this.get(i);
        this.set(i, this.get(j));
        this.set(j, s);
    }

    @Override
    public void assign(double value) {
        for (int i = 0; i < this.length; ++i) {
            this.set(i, value);
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Vector add(double value) {
        return this.add(value, this.factory);
    }

    @Override
    public Vector add(double value, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Vector result = this.blank(factory);
        for (int i = 0; i < this.length; ++i) {
            result.set(i, this.get(i) + value);
        }
        return result;
    }

    @Override
    public Vector add(Vector vector) {
        return this.add(vector, this.factory);
    }

    @Override
    public Vector add(Vector vector, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        if (vector == null) {
            throw new IllegalArgumentException("Vector can't be null.");
        }
        if (this.length != vector.length()) {
            throw new IllegalArgumentException("Worong vector length: " + vector.length());
        }
        Vector result = this.blank(factory);
        for (int i = 0; i < this.length; ++i) {
            result.set(i, this.get(i) + vector.get(i));
        }
        return result;
    }

    @Override
    public Vector multiply(double value) {
        return this.multiply(value, this.factory);
    }

    @Override
    public Vector multiply(double value, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Vector result = this.blank(factory);
        for (int i = 0; i < this.length; ++i) {
            result.set(i, this.get(i) * value);
        }
        return result;
    }

    @Override
    public Vector multiply(Vector vector) {
        return this.multiply(vector, this.factory);
    }

    @Override
    public Vector multiply(Vector vector, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        if (vector == null) {
            throw new IllegalArgumentException("Vector can't be null.");
        }
        if (this.length != vector.length()) {
            throw new IllegalArgumentException("Wrong vector length: " + vector.length());
        }
        Vector result = this.blank(factory);
        for (int i = 0; i < this.length; ++i) {
            result.set(i, this.get(i) * vector.get(i));
        }
        return result;
    }

    @Override
    public Vector multiply(Matrix matrix) {
        return this.multiply(matrix, this.factory);
    }

    @Override
    public Vector multiply(Matrix matrix, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix can't be null.");
        }
        if (this.length != matrix.rows()) {
            throw new IllegalArgumentException("Wrong matrix dimenstions: " + matrix.rows() + "x" + matrix.columns() + ".");
        }
        Vector result = factory.createVector(matrix.columns());
        for (int j = 0; j < matrix.columns(); ++j) {
            double summand = 0.0;
            for (int i = 0; i < matrix.rows(); ++i) {
                summand += this.get(i) * matrix.get(i, j);
            }
            result.set(j, summand);
        }
        return result;
    }

    @Override
    public Vector subtract(double value) {
        return this.subtract(value, this.factory);
    }

    @Override
    public Vector subtract(double value, Factory factory) {
        return this.add(-value, factory);
    }

    @Override
    public Vector subtract(Vector vector) {
        return this.subtract(vector, this.factory);
    }

    @Override
    public Vector subtract(Vector vector, Factory factory) {
        return this.add(vector.multiply(-1.0), factory);
    }

    @Override
    public Vector divide(double value) {
        return this.divide(value, this.factory);
    }

    @Override
    public Vector divide(double value, Factory factory) {
        return this.multiply(1.0 / value, factory);
    }

    @Override
    public double product(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Vector can't be null.");
        }
        if (this.length != vector.length()) {
            throw new IllegalArgumentException("Wrong vector length: " + vector.length());
        }
        double result = 0.0;
        for (int i = 0; i < this.length; ++i) {
            result += this.get(i) * vector.get(i);
        }
        return result;
    }

    @Override
    public double norm() {
        return Math.sqrt(this.product(this));
    }

    @Override
    public Vector normalize() {
        return this.normalize(this.factory);
    }

    @Override
    public Vector normalize(Factory factory) {
        return this.divide(this.norm(), factory);
    }

    @Override
    public Vector blank() {
        return this.blank(this.factory);
    }

    @Override
    public Vector blank(Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        return factory.createVector(this.length);
    }

    @Override
    public Vector copy() {
        return this.copy(this.factory);
    }

    @Override
    public Vector copy(Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        return factory.createVector(this);
    }

    @Override
    public Vector resize(int length) {
        return this.resize(length, this.factory);
    }

    @Override
    public Vector resize(int length, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Vector result = factory.createVector(length);
        for (int i = 0; i < Math.min(length, this.length); ++i) {
            result.set(i, this.get(i));
        }
        return result;
    }

    @Override
    public Vector sliceLeft(int until) {
        return this.slice(0, until, this.factory);
    }

    @Override
    public Vector sliceLeft(int until, Factory factory) {
        return this.slice(0, until, factory);
    }

    @Override
    public Vector sliceRight(int from) {
        return this.slice(from, this.length, this.factory);
    }

    @Override
    public Vector sliceRight(int from, Factory factory) {
        return this.slice(from, this.length, factory);
    }

    @Override
    public Vector slice(int from, int until) {
        return this.slice(from, until, this.factory);
    }

    @Override
    public Vector slice(int from, int until, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Vector result = factory.createVector(until - from);
        for (int i = from; i < until; ++i) {
            result.set(i - from, this.get(i));
        }
        return result;
    }

    @Override
    public Factory factory() {
        return this.factory;
    }

    @Override
    public void each(VectorProcedure procedure) {
        for (int i = 0; i < this.length; ++i) {
            procedure.apply(i, this.get(i));
        }
    }

    @Override
    public Vector transform(VectorFunction function) {
        return this.transform(function, this.factory);
    }

    @Override
    public Vector transform(VectorFunction function, Factory factory) {
        Vector result = this.blank(factory);
        for (int i = 0; i < this.length; ++i) {
            result.set(i, function.evaluate(i, this.get(i)));
        }
        return result;
    }

    @Override
    public Vector transform(int i, VectorFunction function) {
        return this.transform(i, function, this.factory);
    }

    @Override
    public Vector transform(int i, VectorFunction function, Factory factory) {
        Vector result = this.copy(factory);
        result.set(i, function.evaluate(i, this.get(i)));
        return result;
    }

    @Override
    public void update(VectorFunction function) {
        for (int i = 0; i < this.length; ++i) {
            this.set(i, function.evaluate(i, this.get(i)));
        }
    }

    @Override
    public void update(int i, VectorFunction function) {
        this.set(i, function.evaluate(i, this.get(i)));
    }

    @Override
    public double fold(VectorAccumulator accumulator) {
        for (int i = 0; i < this.length; ++i) {
            accumulator.update(i, this.get(i));
        }
        return accumulator.accumulate();
    }

    @Override
    public boolean is(VectorPredicate predicate) {
        boolean result = true;
        for (int i = 0; i < this.length; ++i) {
            result = result && predicate.test(i, this.get(i));
        }
        return result;
    }

    @Override
    public Vector unsafe() {
        return this;
    }

    public int hashCode() {
        int result = 17;
        for (int i = 0; i < this.length; ++i) {
            long value = (long)this.get(i);
            result = 37 * result + (int)(value ^ value >>> 32);
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Vector)) {
            return false;
        }
        Vector vector = (Vector)object;
        if (this.length != vector.length()) {
            return false;
        }
        boolean result = true;
        for (int i = 0; result && i < this.length; ++i) {
            double a = this.get(i);
            double b = vector.get(i);
            double diff = Math.abs(a - b);
            result = result && a == b ? true : (diff < Matrices.EPS ? true : diff / Math.max(Math.abs(a), Math.abs(b)) < Vectors.EPS);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.length; ++i) {
            sb.append(String.format("%6.3f", this.get(i)));
            sb.append(i < this.length - 1 ? ", " : " ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected void ensureFactoryIsNotNull(Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory can't be null.");
        }
    }

    protected void ensureLengthIsNotNegative(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Wrong vector length: " + length);
        }
    }
}

