/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.la4j.factory.Basic2DFactory;
import org.la4j.factory.Factory;
import org.la4j.linear.GaussianSolver;
import org.la4j.linear.JacobiSolver;
import org.la4j.linear.LinearSystemSolver;
import org.la4j.linear.SeidelSolver;
import org.la4j.linear.SquareRootSolver;
import org.la4j.linear.SweepSolver;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;

public class LinearSystem
implements Externalizable {
    private static final LinearSystemSolver[] SOLVERS = new LinearSystemSolver[]{new SweepSolver(), new JacobiSolver(), new SeidelSolver(), new SquareRootSolver(), new GaussianSolver()};
    private int equations;
    private int variables;
    private Matrix a;
    private Vector b;
    private LinearSystemSolver solver;
    private Factory factory;

    public LinearSystem(Matrix a, Vector b) {
        this(a, b, new Basic2DFactory(), null);
    }

    public LinearSystem(Matrix a, Vector b, Factory factory) {
        this(a, b, factory, null);
    }

    public LinearSystem(Matrix a, Vector b, LinearSystemSolver solver) {
        this(a, b, new Basic2DFactory(), solver);
    }

    public LinearSystem(Matrix a, Vector b, Factory factory, LinearSystemSolver solver) {
        this.a = a;
        this.b = b;
        this.equations = a.rows();
        this.variables = a.columns();
        this.factory = factory;
        if (solver == null) {
            solver = this.chooseEffectiveSolver();
        }
        this.solver = solver;
    }

    public int equations() {
        return this.equations;
    }

    public int variables() {
        return this.variables;
    }

    public Matrix coefficientsMatrix() {
        return this.a;
    }

    public Vector rightHandVector() {
        return this.b;
    }

    public Vector solve() {
        return this.solve(this.solver, this.factory);
    }

    public Vector solve(Factory factory) {
        return this.solve(this.solver, factory);
    }

    public Vector solve(LinearSystemSolver solver) {
        return this.solve(solver, this.factory);
    }

    public Vector solve(LinearSystemSolver solver, Factory factory) {
        return solver.solve(this, factory);
    }

    public boolean isSolution(Vector vector) {
        if (vector == null) {
            return false;
        }
        if (vector.length() != this.variables) {
            return false;
        }
        Vector r = this.innacary(vector);
        boolean result = true;
        for (int i = 0; i < r.length(); ++i) {
            result = result && Math.abs(r.get(i)) < Matrices.EPS;
        }
        return result;
    }

    private Vector innacary(Vector vector) {
        return this.a.multiply(vector).subtract(this.b);
    }

    private LinearSystemSolver chooseEffectiveSolver() {
        for (LinearSystemSolver solver : SOLVERS) {
            if (!solver.suitableFor(this)) continue;
            return solver;
        }
        return Matrices.DEFAULT_SOLVER;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.a = (Matrix)in.readObject();
        this.b = (Vector)in.readObject();
        this.equations = this.a.rows();
        this.variables = this.a.columns();
        this.solver = (LinearSystemSolver)in.readObject();
        this.factory = (Factory)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.a);
        out.writeObject(this.b);
        out.writeObject(this.solver);
        out.writeObject(this.factory);
    }
}

