/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.factory;

import java.util.Arrays;
import java.util.Random;
import org.la4j.factory.AbstractFactory;
import org.la4j.factory.Factory;
import org.la4j.vector.Vector;
import org.la4j.vector.source.VectorSource;
import org.la4j.vector.sparse.CompressedVector;

public abstract class CompressedFactory
extends AbstractFactory
implements Factory {
    private static final long serialVersionUID = 4071505L;
    public static final int DENSITY = 4;

    @Override
    public Vector createVector() {
        return new CompressedVector();
    }

    @Override
    public Vector createVector(int length) {
        return new CompressedVector(length);
    }

    @Override
    public Vector createVector(double[] array) {
        return new CompressedVector(array);
    }

    @Override
    public Vector createVector(Vector vector) {
        return new CompressedVector(vector);
    }

    @Override
    public Vector createVector(VectorSource source) {
        return new CompressedVector(source);
    }

    @Override
    public Vector createConstantVector(int length, double value) {
        double[] values = new double[length];
        int[] indices = new int[length];
        for (int i = 0; i < length; ++i) {
            indices[i] = i;
            values[i] = value;
        }
        return new CompressedVector(length, length, values, indices);
    }

    @Override
    public Vector createRandomVector(int length) {
        Random random = new Random();
        int cardinality = length / 4;
        double[] values = new double[cardinality];
        int[] indices = new int[cardinality];
        for (int i = 0; i < cardinality; ++i) {
            values[i] = random.nextDouble();
            indices[i] = random.nextInt(length);
        }
        Arrays.sort(indices);
        return new CompressedVector(length, cardinality, values, indices);
    }
}

