/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.typography.mathml;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.jeuclid.converter.Converter;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.renderer.FImageRenderer;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.image.renderer.MBFImageRenderer;
import org.openimaj.image.typography.FontRenderer;
import org.openimaj.image.typography.FontStyle;
import org.openimaj.image.typography.mathml.MathMLFont;
import org.openimaj.image.typography.mathml.MathMLFontStyle;
import org.openimaj.math.geometry.shape.Rectangle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;

public class MathMLFontRenderer<T>
extends FontRenderer<T, MathMLFontStyle<T>> {
    @Override
    public void renderText(ImageRenderer<T, ?> renderer, String text, int x, int y, MathMLFontStyle<T> sty) {
        MBFImage img = this.renderToMBFImage(text, sty);
        if (sty.getHorizontalAlignment() != FontStyle.HorizontalAlignment.HORIZONTAL_LEFT) {
            float len = img.getWidth();
            x = sty.getHorizontalAlignment() == FontStyle.HorizontalAlignment.HORIZONTAL_CENTER ? (int)((float)x - len / 2.0f) : (int)((float)x - len);
        }
        if (sty.getVerticalAlignment() != FontStyle.VerticalAlignment.VERTICAL_TOP) {
            switch (sty.getVerticalAlignment()) {
                case VERTICAL_BOTTOM: {
                    y -= img.getHeight();
                    break;
                }
                case VERTICAL_HALF: {
                    y = (int)((float)y - (float)img.getHeight() / 2.0f);
                    break;
                }
            }
        }
        if (renderer instanceof MBFImageRenderer) {
            MBFImageRenderer render = (MBFImageRenderer)renderer;
            render.drawImage(img, x, y);
        } else if (renderer instanceof FImageRenderer) {
            FImageRenderer render = (FImageRenderer)renderer;
            render.drawImage(img.flatten(), x, y);
        }
    }

    private MBFImage renderToMBFImage(String text, MathMLFontStyle<T> style) {
        Converter c = Converter.getInstance();
        Node node = null;
        switch (style.getMathInput()) {
            case LATEX: {
                text = style.isTextMode() ? String.format("$\\mathrm{%s}$", text) : String.format("$%s$", text);
                node = this.latexToNode(text);
                break;
            }
            case MATHML: {
                node = this.mathmlToNode(text);
            }
        }
        BufferedImage rend = null;
        try {
            rend = c.render(node, style.getLayoutContext());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MBFImage img = ImageUtilities.createMBFImage(rend, true);
        return img;
    }

    @Override
    public Rectangle getSize(String string, MathMLFontStyle<T> style) {
        MBFImage mbf = this.renderToMBFImage(string, style);
        return mbf.getBounds();
    }

    private Node latexToNode(String latex) {
        SnuggleEngine engine = new SnuggleEngine();
        try {
            SnuggleSession createSession = engine.createSession();
            createSession.parseInput(new SnuggleInput(latex));
            NodeList dst = createSession.buildDOMSubtree();
            return dst.item(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Element mathmlToNode(String string) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes())).getDocumentElement();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        MathMLFontRenderer<Float[]> rend = new MathMLFontRenderer<Float[]>();
        String mathML = "x = 2\\mathrm{wang}wang";
        MBFImage img = new MBFImage(300, 300, ColourSpace.RGB);
        img.fill(RGBColour.WHITE);
        MBFImageRenderer renderer = img.createRenderer();
        MathMLFontStyle<Float[]> style = new MathMLFontStyle<Float[]>(new MathMLFont(), RGBColour.WHITE);
        style.setColour(RGBColour.RED);
        style.setFontSize(30);
        rend.renderText((ImageRenderer<Float[], ?>)renderer, mathML, 0, 100, style);
        DisplayUtilities.display(img);
        MathMLFontRenderer<Float> rendf = new MathMLFontRenderer<Float>();
        FImage imgf = new FImage(300, 300);
        imgf.fill(0.0f);
        FImageRenderer rendererf = imgf.createRenderer();
        MathMLFontStyle<Float> stylef = new MathMLFontStyle<Float>(new MathMLFont(), Float.valueOf(0.5f));
        stylef.setFontSize(30);
        rendf.renderText((ImageRenderer<Float, ?>)rendererf, mathML, 0, 100, stylef);
        DisplayUtilities.display(imgf);
    }
}

