/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.typography.hershey;

import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.image.typography.FontRenderer;
import org.openimaj.image.typography.FontStyle;
import org.openimaj.image.typography.hershey.HersheyFont;
import org.openimaj.image.typography.hershey.HersheyFontData;
import org.openimaj.image.typography.hershey.HersheyFontStyle;
import org.openimaj.math.geometry.shape.Rectangle;

final class HersheyFontRenderer<T>
extends FontRenderer<T, HersheyFontStyle<T>> {
    protected static HersheyFontRenderer<?> INSTANCE = new HersheyFontRenderer();

    private HersheyFontRenderer() {
    }

    @Override
    public void renderText(ImageRenderer<T, ?> renderer, String text, int x, int y, HersheyFontStyle<T> style) {
        this.drawText(text, style, x, y, true, new Rectangle(), renderer);
    }

    @Override
    public Rectangle getSize(String text, HersheyFontStyle<T> style) {
        Rectangle r = new Rectangle();
        this.drawText(text, style, 0, 0, false, r, null);
        return r;
    }

    protected void drawText(String text, HersheyFontStyle<T> sty, int xc, int yc, boolean Draw, Rectangle r, ImageRenderer<T, ?> renderer) {
        int character;
        HersheyFontData fnt = ((HersheyFont)sty.getFont()).data;
        int rotpx = 0;
        int rotpy = 0;
        boolean rotate = false;
        float cosTheta = 0.0f;
        float sinTheta = 0.0f;
        float verticalOffsetFactor = 0.0f;
        boolean bl = rotate = (double)sty.getAngle() != 0.0;
        if (rotate) {
            float theta = -sty.getAngle();
            cosTheta = (float)Math.cos(theta);
            sinTheta = (float)Math.sin(theta);
            rotpx = xc;
            rotpy = yc;
        }
        int xp = xc;
        int yp = yc;
        switch (sty.getVerticalAlignment()) {
            case VERTICAL_TOP: {
                verticalOffsetFactor = 0.0f;
                break;
            }
            case VERTICAL_HALF: {
                verticalOffsetFactor = 0.5f;
                break;
            }
            case VERTICAL_BOTTOM: {
                verticalOffsetFactor = 1.0f;
                break;
            }
            case VERTICAL_CAP: {
                verticalOffsetFactor = 0.25f;
            }
        }
        yp -= (int)(verticalOffsetFactor * (sty.getActualHeightScale() * (float)(fnt.characterSetMaxY - fnt.characterSetMinY)));
        if (sty.getHorizontalAlignment() != FontStyle.HorizontalAlignment.HORIZONTAL_LEFT) {
            int len = 0;
            for (int j = 0; j < text.length(); ++j) {
                character = text.charAt(j) - 32;
                len = (int)((float)len + (float)(fnt.characterMaxX[character] - fnt.characterMinX[character]) * sty.getActualWidthScale());
            }
            xp = sty.getHorizontalAlignment() == FontStyle.HorizontalAlignment.HORIZONTAL_CENTER ? (xp -= len / 2) : (xp -= len);
        }
        r.y = 2.1474836E9f;
        r.x = 2.1474836E9f;
        for (int j = 0; j < text.length(); ++j) {
            character = text.charAt(j) - 32;
            if (character < 0) {
                character = 32;
            }
            this.drawCharacter(xp, yp, rotpx, rotpy, sty.getActualWidthScale(), sty.getActualHeightScale(), rotate, sinTheta, cosTheta, Draw, fnt.characterVectors[character], fnt.numberOfPoints[character], fnt.characterMinX[character], fnt.characterSetMinY, sty.getStrokeWidth(), sty.isItalic(), sty.getItalicSlant(), renderer, sty.getColour(), r);
            int actualWidth = (int)((float)(fnt.characterMaxX[character] - fnt.characterMinX[character]) * sty.getActualWidthScale());
            xp += actualWidth;
        }
    }

    protected int fontAdjustment(String fontname) {
        int xadjust = 0;
        if (fontname.indexOf("scri") < 0) {
            xadjust = fontname.indexOf("goth") >= 0 ? 2 : 3;
        }
        return xadjust;
    }

    protected void drawCharacter(int xp, int yp, int rotpx, int rotpy, float width, float height, boolean rotate, float sinTheta, float cosTheta, boolean draw, char[][] vectors, int numberOfPoints, int minX, int characterSetMinY, int lineWidth, boolean italics, float slant, ImageRenderer<T, ?> renderer, T colour, Rectangle bounds) {
        int oldx = 0;
        int oldy = 0;
        boolean skip = true;
        float finalSlant = height * -slant;
        int maxX = 0;
        int maxY = 0;
        for (int i = 1; i < numberOfPoints; ++i) {
            if (vectors[0][i] == ' ') {
                skip = true;
                continue;
            }
            int x = (int)(italics ? (float)(vectors[1][i] - characterSetMinY) * finalSlant : 0.0f) + this.transformX(xp, vectors[0][i], minX, width);
            int y = this.transformY(yp, vectors[1][i], characterSetMinY, height);
            if (rotate) {
                float xd = x - rotpx;
                float yd = y - rotpy;
                float xd2 = xd * cosTheta - yd * sinTheta;
                float yd2 = xd * sinTheta + yd * cosTheta;
                x = (int)((double)xd2 + 0.5) + rotpx;
                y = (int)((double)yd2 + 0.5) + rotpy;
            }
            if (!skip) {
                if (draw) {
                    renderer.drawLine(oldx, oldy, x, y, lineWidth, colour);
                }
                bounds.x = Math.min(bounds.x, (float)x);
                bounds.y = Math.min(bounds.y, (float)y);
                maxX = Math.max(maxX, x);
                maxY = Math.max(maxY, y);
            }
            skip = false;
            oldx = x;
            oldy = y;
        }
        bounds.width = Math.max(bounds.width, (float)maxX - bounds.x);
        bounds.height = Math.max(bounds.height, (float)maxY - bounds.y);
    }

    protected final int transformX(int xoffset, int px, int minx, float mag) {
        return (int)((float)xoffset + (float)(px - minx) * mag);
    }

    protected final int transformY(int yoffset, int py, int miny, float mag) {
        return (int)((float)yoffset + (float)(py - miny) * mag);
    }
}

