/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class BufferedRandomAccessReader
implements Closeable {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    final File file;
    final ByteBuffer buffer;
    RandomAccessFile raFile;
    FileChannel fileChannel;
    long raFileLen;
    long raFilePos;
    boolean bufferContainsData;

    public BufferedRandomAccessReader(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        this.buffer = ByteBuffer.allocateDirect(8192);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.file = file;
        this.raFile = new RandomAccessFile(file, "r");
        this.fileChannel = this.raFile.getChannel();
        this.raFileLen = this.raFile.length();
        this.raFilePos = 0L;
        this.raFile.seek(0L);
        this.bufferContainsData = false;
    }

    @Override
    public void close() throws IOException {
        if (this.raFile != null) {
            this.raFile.close();
            this.raFile = null;
        }
        this.fileChannel = null;
    }

    public File getFileReference() {
        return this.file;
    }

    public long getFileSize() {
        return this.raFileLen;
    }

    public long getFilePosition() {
        return this.raFilePos;
    }

    private void prepareBufferForRead(int bytesToRead) throws IOException {
        int bytesNotRead = bytesToRead;
        if (this.raFile == null) {
            throw new IOException("Reading from a file that was closed");
        }
        if (this.raFilePos >= this.raFileLen) {
            throw new EOFException();
        }
        boolean readEnabled = true;
        if (this.bufferContainsData) {
            int remaining = this.buffer.remaining();
            if (remaining >= bytesNotRead) {
                readEnabled = false;
            } else {
                readEnabled = true;
                if (remaining == 0) {
                    this.buffer.clear();
                } else {
                    this.buffer.compact();
                    this.raFilePos += (long)remaining;
                    bytesNotRead -= remaining;
                }
            }
        }
        if (readEnabled) {
            this.raFile.seek(this.raFilePos);
            int nBytesRead = this.fileChannel.read(this.buffer);
            if (nBytesRead <= 0) {
                throw new IOException("Failed to read " + bytesNotRead + " from file position " + this.raFilePos);
            }
            this.buffer.flip();
            this.bufferContainsData = true;
        }
        this.raFilePos += (long)bytesNotRead;
    }

    public String readAscii(int maximumLength) throws IOException {
        if (maximumLength <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(maximumLength);
        this.readAscii(builder, maximumLength);
        return builder.toString();
    }

    public int readAscii(StringBuilder builder, int maximumLength) throws IOException {
        if (maximumLength <= 0) {
            return 0;
        }
        for (int k = 0; k < maximumLength; ++k) {
            byte b = this.readByte();
            if (b == 0) {
                if (k < maximumLength) {
                    this.skipBytes(maximumLength - k);
                }
                return k;
            }
            builder.append((char)(b & 0xFF));
        }
        return maximumLength;
    }

    public boolean readBoolean() throws IOException {
        this.prepareBufferForRead(1);
        byte test = this.buffer.get();
        return test != 0;
    }

    public byte readByte() throws IOException {
        this.prepareBufferForRead(1);
        return this.buffer.get();
    }

    public int readUnsignedByte() throws IOException {
        this.prepareBufferForRead(1);
        return this.buffer.get() & 0xFF;
    }

    public long readUnsignedInt() throws IOException {
        this.prepareBufferForRead(4);
        return (long)this.buffer.getInt() & 0xFFFFFFFFL;
    }

    public int readUnsignedShort() throws IOException {
        this.prepareBufferForRead(2);
        return this.buffer.getShort() & 0xFFFF;
    }

    public int readInt() throws IOException {
        this.prepareBufferForRead(4);
        return this.buffer.getInt();
    }

    public int readIntBigEndian() throws IOException {
        this.prepareBufferForRead(4);
        int i = this.buffer.getInt();
        return i >>> 24 | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24;
    }

    public double readDoubleBigEndian() throws IOException {
        this.prepareBufferForRead(8);
        long r = this.buffer.getLong();
        long b = r >>> 56 | r >> 48 & 0xFF00L | r >> 40 & 0xFF0000L | r >> 32 & 0xFF000000L | r << 32 & 0xFF00000000L | r << 40 & 0xFF0000000000L | r << 48 & 0xFF000000000000L | r << 56;
        return Double.longBitsToDouble(b);
    }

    public double readDouble() throws IOException {
        this.prepareBufferForRead(8);
        return this.buffer.getDouble();
    }

    public float readFloat() throws IOException {
        this.prepareBufferForRead(4);
        return this.buffer.getFloat();
    }

    public long readLong() throws IOException {
        this.prepareBufferForRead(8);
        return this.buffer.getLong();
    }

    public short readShort() throws IOException {
        this.prepareBufferForRead(2);
        return this.buffer.getShort();
    }

    public void seek(long position) throws IOException {
        if (this.bufferContainsData) {
            int bufferPosition = this.buffer.position();
            int bufferRemaining = this.buffer.remaining();
            long pos0 = this.raFilePos - (long)bufferPosition;
            long pos1 = this.raFilePos + (long)bufferRemaining - 1L;
            if (pos0 <= position && position <= pos1) {
                this.raFilePos = position;
                long bufferPos = position - pos0;
                this.buffer.position((int)bufferPos);
                return;
            }
        }
        this.bufferContainsData = false;
        this.buffer.clear();
        this.raFilePos = position;
    }

    public int skipBytes(int n) throws IOException {
        this.raFilePos += (long)n;
        if (this.bufferContainsData) {
            int remaining = this.buffer.remaining();
            if (n < remaining) {
                int position = this.buffer.position();
                this.buffer.position(position + n);
            } else {
                this.buffer.clear();
                this.bufferContainsData = false;
            }
        }
        return n;
    }
}

