/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.unit;

import java.util.Collections;
import java.util.Map;
import org.ngs.ngunits.UnconvertibleException;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.converter.AbstractUnitConverter;
import org.ngs.ngunits.unit.AbstractUnit;
import org.ngs.ngunits.unit.UnitDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProductUnit
extends AbstractUnit {
    private Map<Unit, Integer> _entries;

    ProductUnit(UnitDelegate unitDelegate, Map<Unit, Integer> map) {
        super(unitDelegate);
        this._entries = map;
    }

    @Override
    public Unit getSystemUnit() {
        if (this.hasOnlySystemUnits()) {
            return this;
        }
        Unit<?> unit = this.delegate.one();
        for (Map.Entry<Unit, Integer> entry : this._entries.entrySet()) {
            unit = unit.multiply(entry.getKey().getSystemUnit().pow(entry.getValue()));
        }
        return unit;
    }

    @Override
    public UnitConverter toSystemUnit() {
        if (this.hasOnlySystemUnits()) {
            return AbstractUnitConverter.IDENTITY;
        }
        UnitConverter unitConverter = AbstractUnitConverter.IDENTITY;
        for (Map.Entry<Unit, Integer> entry : this._entries.entrySet()) {
            UnitConverter unitConverter2 = ((AbstractUnit)entry.getKey()).toSystemUnit();
            if (!unitConverter2.isLinear()) {
                throw new UnconvertibleException("unit is non-linear, cannot convert", entry.getKey(), entry.getKey().getSystemUnit());
            }
            int n = entry.getValue();
            if (n < 0) {
                n = -n;
                unitConverter2 = unitConverter2.inverse();
            }
            for (int i = 0; i < n; ++i) {
                unitConverter = unitConverter.concatenate(unitConverter2);
            }
        }
        return unitConverter;
    }

    @Override
    public Map<Unit, Integer> getProductUnits() {
        return Collections.unmodifiableMap(this._entries);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ProductUnit && ((Object)((ProductUnit)object)._entries).equals(this._entries);
    }

    public int hashCode() {
        return ((Object)this._entries).hashCode();
    }

    private boolean hasOnlySystemUnits() {
        for (Unit unit : this._entries.keySet()) {
            if (unit == unit.getSystemUnit()) continue;
            return false;
        }
        return true;
    }
}

