/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processor;

import org.openimaj.image.Image;
import org.openimaj.video.Video;

public abstract class VideoProcessor<T extends Image<?, T>>
extends Video<T> {
    private Video<T> video = null;
    private T currentFrame = null;

    public VideoProcessor() {
    }

    public VideoProcessor(Video<T> v) {
        this.video = v;
    }

    public abstract T processFrame(T var1);

    public void processingComplete() {
    }

    public void process(Video<T> video) {
        T frame = null;
        while (true) {
            T t = video.getNextFrame();
            frame = t;
            if (t == null) break;
            this.processFrame(frame);
        }
        this.processingComplete();
    }

    public void process() {
        if (this.video == null) {
            throw new UnsupportedOperationException("Chain method called on non-chainable processor");
        }
        this.process(this.video);
    }

    @Override
    public int getWidth() {
        if (this.video == null) {
            throw new UnsupportedOperationException("Chain method called on non-chainable processor");
        }
        return this.video.getWidth();
    }

    @Override
    public int getHeight() {
        if (this.video == null) {
            throw new UnsupportedOperationException("Chain method called on non-chainable processor");
        }
        return this.video.getHeight();
    }

    @Override
    public T getNextFrame() {
        if (this.video == null) {
            throw new UnsupportedOperationException("Chain method called on non-chainable processor");
        }
        this.currentFrame = this.video.getNextFrame();
        if (this.currentFrame == null) {
            return null;
        }
        return this.processFrame(this.currentFrame);
    }

    @Override
    public boolean hasNextFrame() {
        if (this.video == null) {
            throw new UnsupportedOperationException("Chain method called on non-chainable processor");
        }
        return this.video.hasNextFrame();
    }

    @Override
    public long countFrames() {
        if (this.video == null) {
            throw new UnsupportedOperationException("Chain method called on non-chainable processor");
        }
        return this.video.countFrames();
    }

    @Override
    public T getCurrentFrame() {
        if (this.video == null) {
            throw new UnsupportedOperationException("Chain method called on non-chainable processor");
        }
        if (this.currentFrame == null) {
            this.currentFrame = this.processFrame(this.getNextFrame());
        }
        return this.currentFrame;
    }

    @Override
    public void reset() {
    }

    @Override
    public long getTimeStamp() {
        return this.video.getTimeStamp();
    }

    @Override
    public double getFPS() {
        return this.video.getFPS();
    }
}

