/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.video.Video;

public abstract class FileBackedVideo<T extends Image<?, T>>
extends Video<T> {
    private List<File> files;
    private T heldCurrentFrame;
    private int heldCurrentFrameIndex = -1;
    private boolean loop;
    private double fps = 30.0;

    public FileBackedVideo(List<File> files) {
        this.files = files;
        this.fps = 30.0;
        this.loop = false;
    }

    public FileBackedVideo(List<File> files, double fps) {
        this.files = files;
        this.fps = fps;
        this.loop = false;
    }

    public FileBackedVideo(String filenameFormat, int start, int stop) {
        this(FileBackedVideo.getFilesList(filenameFormat, start, stop));
    }

    @Override
    public synchronized T getNextFrame() {
        T frame = this.getCurrentFrame();
        this.incrementFrame();
        return frame;
    }

    private void incrementFrame() {
        if (this.currentFrame + 1 < this.files.size() || this.loop) {
            ++this.currentFrame;
        }
    }

    @Override
    public boolean hasNextFrame() {
        return this.loop || this.getCurrentFrameIndex() + 1 < this.files.size();
    }

    @Override
    public T getCurrentFrame() {
        try {
            if (this.currentFrame != this.heldCurrentFrameIndex) {
                this.heldCurrentFrame = this.loadImage(this.files.get(this.currentFrame % this.files.size()));
                this.heldCurrentFrameIndex = this.currentFrame;
            }
        }
        catch (IOException e) {
            this.heldCurrentFrameIndex = this.currentFrame;
            this.heldCurrentFrame = null;
        }
        return this.heldCurrentFrame;
    }

    @Override
    public int getWidth() {
        return this.getCurrentFrame().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getCurrentFrame().getHeight();
    }

    protected abstract T loadImage(File var1) throws IOException;

    @Override
    public long countFrames() {
        return this.files.size();
    }

    @Override
    public void reset() {
        this.currentFrame = 0;
    }

    @Override
    public long getTimeStamp() {
        return (long)((double)this.getCurrentFrameIndex() / this.fps) * 1000L;
    }

    @Override
    public double getFPS() {
        return this.fps;
    }

    public static List<File> getFilesList(String filenameFormat, int start, int stop) {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = start; i < stop; ++i) {
            files.add(new File(String.format(filenameFormat, i)));
        }
        return files;
    }
}

