/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.boxes;

import java.nio.ByteBuffer;
import org.jcodec.containers.mkv.MKVType;
import org.jcodec.containers.mkv.boxes.EbmlBase;
import org.jcodec.containers.mkv.boxes.EbmlMaster;
import org.jcodec.containers.mkv.util.EbmlUtil;

public class MkvSegment
extends EbmlMaster {
    int headerSize = 0;

    public MkvSegment(byte[] id) {
        super(id);
    }

    public MkvSegment() {
        super(MKVType.Segment.id);
    }

    public ByteBuffer getHeader() {
        long headerSize = this.getHeaderSize();
        if (headerSize > Integer.MAX_VALUE) {
            System.out.println("MkvSegment.getHeader: id.length " + this.id.length + "  Element.getEbmlSize(" + this.dataLen + "): " + EbmlUtil.ebmlLength(this.dataLen) + " size: " + this.dataLen);
        }
        ByteBuffer bb = ByteBuffer.allocate((int)headerSize);
        bb.put(this.id);
        bb.put(EbmlUtil.ebmlEncode(this.getDataLen()));
        if (this.children != null && !this.children.isEmpty()) {
            for (EbmlBase e : this.children) {
                if (MKVType.Cluster.equals((Object)e.type)) continue;
                bb.put(e.getData());
            }
        }
        bb.flip();
        return bb;
    }

    public long getHeaderSize() {
        long returnValue = this.id.length;
        returnValue += (long)EbmlUtil.ebmlLength(this.getDataLen());
        if (this.children != null && !this.children.isEmpty()) {
            for (EbmlBase e : this.children) {
                if (MKVType.Cluster.equals((Object)e.type)) continue;
                returnValue += e.size();
            }
        }
        return returnValue;
    }
}

