/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics.normalisation;

import org.openimaj.math.statistics.normalisation.Denormaliser;
import org.openimaj.math.statistics.normalisation.TrainableNormaliser;

public class ZScore
implements TrainableNormaliser,
Denormaliser {
    double[] mean;
    double[] sigma;
    double eps = 0.0;

    public ZScore() {
    }

    public ZScore(double eps) {
        this.eps = eps;
    }

    @Override
    public void train(double[][] data) {
        int c;
        int r;
        this.mean = new double[data[0].length];
        this.sigma = new double[data[0].length];
        for (r = 0; r < data.length; ++r) {
            for (c = 0; c < data[0].length; ++c) {
                int n = c;
                this.mean[n] = this.mean[n] + data[r][c];
            }
        }
        int c2 = 0;
        while (c2 < data[0].length) {
            int n = c2++;
            this.mean[n] = this.mean[n] / (double)data.length;
        }
        for (r = 0; r < data.length; ++r) {
            c = 0;
            while (c < data[0].length) {
                double delta = data[r][c] - this.mean[c];
                int n = c++;
                this.sigma[n] = this.sigma[n] + delta * delta;
            }
        }
        for (c2 = 0; c2 < data[0].length; ++c2) {
            this.sigma[c2] = Math.sqrt(this.eps + this.sigma[c2] / (double)(data.length - 1));
        }
    }

    @Override
    public double[] normalise(double[] vector) {
        double[] out = new double[vector.length];
        for (int c = 0; c < out.length; ++c) {
            out[c] = (vector[c] - this.mean[c]) / this.sigma[c];
        }
        return out;
    }

    @Override
    public double[][] normalise(double[][] data) {
        double[][] out = new double[data.length][];
        for (int c = 0; c < out.length; ++c) {
            out[c] = this.normalise(data[c]);
        }
        return out;
    }

    @Override
    public double[] denormalise(double[] vector) {
        double[] out = new double[vector.length];
        for (int c = 0; c < out.length; ++c) {
            out[c] = this.sigma[c] * vector[c] + this.mean[c];
        }
        return out;
    }

    @Override
    public double[][] denormalise(double[][] data) {
        double[][] out = new double[data.length][];
        for (int c = 0; c < out.length; ++c) {
            out[c] = this.denormalise(data[c]);
        }
        return out;
    }
}

