/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics.distribution;

import gnu.trove.procedure.TObjectDoubleProcedure;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.openimaj.math.statistics.distribution.AbstractMultivariateDistribution;
import org.openimaj.math.statistics.distribution.kernel.UnivariateKernel;
import org.openimaj.util.pair.ObjectDoublePair;
import org.openimaj.util.tree.DoubleKDTree;

public class MultivariateKernelDensityEstimate
extends AbstractMultivariateDistribution {
    double[][] data;
    UnivariateKernel kernel;
    private double bandwidth;
    DoubleKDTree tree;

    public MultivariateKernelDensityEstimate(double[][] data, UnivariateKernel kernel, double bandwidth) {
        this.data = data;
        this.tree = new DoubleKDTree(data);
        this.kernel = kernel;
        this.bandwidth = bandwidth;
    }

    public MultivariateKernelDensityEstimate(List<double[]> data, UnivariateKernel kernel, double bandwidth) {
        this.data = (double[][])data.toArray((T[])new double[data.size()][]);
        this.tree = new DoubleKDTree(this.data);
        this.kernel = kernel;
        this.bandwidth = bandwidth;
    }

    @Override
    public double[] sample(Random rng) {
        double[] pt = (double[])this.data[rng.nextInt(this.data.length)].clone();
        for (int i = 0; i < pt.length; ++i) {
            pt[i] = pt[i] + this.kernel.sample(rng) * this.getBandwidth();
        }
        return pt;
    }

    @Override
    public double estimateProbability(double[] sample) {
        final double[] prob = new double[1];
        final int[] count = new int[1];
        this.tree.coordinateRadiusSearch(sample, this.kernel.getCutOff() * this.getBandwidth(), (TObjectDoubleProcedure)new TObjectDoubleProcedure<double[]>(){

            public boolean execute(double[] point, double distance) {
                prob[0] = prob[0] + MultivariateKernelDensityEstimate.this.kernel.evaluate(Math.sqrt(distance) / MultivariateKernelDensityEstimate.this.getBandwidth());
                count[0] = count[0] + 1;
                return true;
            }
        });
        return prob[0] / (this.getBandwidth() * (double)count[0]);
    }

    public List<ObjectDoublePair<double[]>> getSupport(double[] sample) {
        final ArrayList<ObjectDoublePair<double[]>> support = new ArrayList<ObjectDoublePair<double[]>>();
        this.tree.coordinateRadiusSearch(sample, this.kernel.getCutOff() * this.getBandwidth(), (TObjectDoubleProcedure)new TObjectDoubleProcedure<double[]>(){

            public boolean execute(double[] a, double b) {
                support.add(ObjectDoublePair.pair((Object)a, (double)MultivariateKernelDensityEstimate.this.kernel.evaluate(Math.sqrt(b) / MultivariateKernelDensityEstimate.this.getBandwidth())));
                return true;
            }
        });
        return support;
    }

    public double[][] getData() {
        return this.data;
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public double getScaledBandwidth() {
        return this.bandwidth * this.kernel.getCutOff();
    }

    @Override
    public double[] estimateLogProbability(double[][] x) {
        double[] lps = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            lps[i] = this.estimateLogProbability(x[i]);
        }
        return lps;
    }
}

