/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix.algorithm.whitening;

import Jama.Matrix;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.math.matrix.algorithm.pca.SvdPrincipalComponentAnalysis;
import org.openimaj.math.matrix.algorithm.whitening.WhiteningTransform;
import org.openimaj.math.statistics.normalisation.Normaliser;
import org.openimaj.math.statistics.normalisation.TrainableNormaliser;

@Reference(type=ReferenceType.Book, author={"Hyvrinen, Aapo", "Hurri, Jarmo", "Hoyer, Patrick O."}, title="Natural Image Statistics: A Probabilistic Approach to Early Computational Vision.", year="2009", edition="1st", publisher="Springer Publishing Company, Incorporated", customData={"isbn", "1848824904, 9781848824904"})
public class PCAWhitening
extends WhiteningTransform {
    protected double eps;
    protected Normaliser ns;
    protected Matrix transform;
    protected int ndims = -1;

    public PCAWhitening(double eps, Normaliser ns) {
        this.eps = eps;
        this.ns = ns;
    }

    public PCAWhitening(double eps, Normaliser ns, int ndims) {
        this.eps = eps;
        this.ns = ns;
        this.ndims = ndims;
    }

    @Override
    public double[] whiten(double[] vector) {
        double[] normVec = this.ns.normalise(vector);
        Matrix vec = new Matrix((double[][])new double[][]{normVec});
        return vec.times(this.transform).getColumnPackedCopy();
    }

    @Override
    public void train(double[][] data) {
        if (this.ns instanceof TrainableNormaliser) {
            ((TrainableNormaliser)this.ns).train(data);
        }
        double[][] normData = this.ns.normalise(data);
        SvdPrincipalComponentAnalysis pca = new SvdPrincipalComponentAnalysis(this.ndims);
        pca.learnBasisNorm(new Matrix(normData));
        this.transform = pca.getBasis();
        double[] weight = pca.getEigenValues();
        double[][] td = this.transform.getArray();
        for (int c = 0; c < weight.length; ++c) {
            weight[c] = 1.0 / Math.sqrt(weight[c] + this.eps);
        }
        for (int r = 0; r < td.length; ++r) {
            for (int c = 0; c < td[0].length; ++c) {
                td[r][c] = td[r][c] * weight[c];
            }
        }
    }

    public Matrix getTransform() {
        return this.transform;
    }
}

