/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import ch.akuhn.matrix.DenseMatrix;
import ch.akuhn.matrix.DenseVector;
import ch.akuhn.matrix.SparseMatrix;
import ch.akuhn.matrix.SparseVector;
import ch.akuhn.matrix.Vector;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLDouble;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntProcedure;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import org.openimaj.math.matrix.DiagonalMatrix;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.array.SparseBinSearchDoubleArray;
import org.openimaj.util.array.SparseDoubleArray;

public class MatlibMatrixUtils {
    private static final double EPS = 1.0E-8;

    public static double sparsity(ch.akuhn.matrix.Matrix mat) {
        return 1.0 - mat.density();
    }

    public static <T extends ch.akuhn.matrix.Matrix> T powInplace(T matrix, double d) {
        int rowN = 0;
        for (Vector ent : matrix.rows()) {
            for (Vector.Entry row : ent.entries()) {
                matrix.put(rowN, row.index, Math.pow(row.value, d));
            }
            ++rowN;
        }
        return matrix;
    }

    public static SparseMatrix times(DiagonalMatrix D, SparseMatrix A) {
        SparseMatrix mat = new SparseMatrix(A.rowCount(), A.columnCount());
        double[] Dvals = D.getVals();
        int rowIndex = 0;
        for (Vector row : A.rows()) {
            for (Vector.Entry ent : row.entries()) {
                mat.put(rowIndex, ent.index, ent.value * Dvals[rowIndex]);
            }
            ++rowIndex;
        }
        return mat;
    }

    public static SparseMatrix times(SparseMatrix A, DiagonalMatrix D) {
        SparseMatrix mat = new SparseMatrix(A.rowCount(), A.columnCount());
        int rowIndex = 0;
        double[] Dvals = D.getVals();
        for (Vector row : A.rows()) {
            for (Vector.Entry ent : row.entries()) {
                mat.put(rowIndex, ent.index, ent.value * Dvals[ent.index]);
            }
            ++rowIndex;
        }
        return mat;
    }

    public static SparseMatrix plusInplace(SparseMatrix A, ch.akuhn.matrix.Matrix B) {
        for (int i = 0; i < A.rowCount(); ++i) {
            A.addToRow(i, B.row(i));
        }
        return A;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T plusInplace(T A, ch.akuhn.matrix.Matrix B) {
        if (A instanceof SparseMatrix) {
            return (T)MatlibMatrixUtils.plusInplace((SparseMatrix)A, B);
        }
        for (int i = 0; i < A.rowCount(); ++i) {
            Vector brow = B.row(i);
            for (int j = 0; j < A.columnCount(); ++j) {
                A.row(i).add(j, brow.get(j));
            }
        }
        return A;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T plusInplace(T A, double d) {
        for (int i = 0; i < A.rowCount(); ++i) {
            for (int j = 0; j < A.columnCount(); ++j) {
                A.row(i).add(j, d);
            }
        }
        return A;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T minusInplace(DiagonalMatrix D, T A) {
        double[] Dval = D.getVals();
        for (int i = 0; i < Dval.length; ++i) {
            Iterable rowents = A.row(i).entries();
            for (Vector.Entry entry : rowents) {
                A.put(i, entry.index, -entry.value);
            }
            A.put(i, i, Dval[i] - A.get(i, i));
        }
        return A;
    }

    public static ch.akuhn.matrix.Matrix minusInplace(ch.akuhn.matrix.Matrix A, ch.akuhn.matrix.Matrix B) {
        for (int i = 0; i < A.rowCount(); ++i) {
            Iterable rowents = A.row(i).entries();
            for (Vector.Entry entry : rowents) {
                A.put(i, entry.index, entry.value - B.get(i, entry.index));
            }
        }
        return A;
    }

    public static <T extends Vector> T minusInplace(T A, Vector D) {
        for (int i = 0; i < A.size(); ++i) {
            A.put(i, A.get(i) - D.get(i));
        }
        return A;
    }

    public static <T extends Vector> T plusInplace(T A, Vector D) {
        for (int i = 0; i < A.size(); ++i) {
            A.put(i, A.get(i) + D.get(i));
        }
        return A;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T plusInplace(DiagonalMatrix D, T A) {
        double[] Dval = D.getVals();
        for (int i = 0; i < Dval.length; ++i) {
            A.put(i, i, A.get(i, i) + Dval[i]);
        }
        return A;
    }

    public static ch.akuhn.matrix.Matrix transposeDotProduct(ch.akuhn.matrix.Matrix A, ch.akuhn.matrix.Matrix B) {
        int mA = A.columnCount();
        int nB = B.columnCount();
        ch.akuhn.matrix.Matrix ret = A.newInstance(mA, nB);
        for (int i = 0; i < mA; ++i) {
            Vector column = A.column(i);
            for (int j = 0; j < nB; ++j) {
                double dot = column.dot(B.column(j));
                if (!(Math.abs(dot) > 1.0E-8)) continue;
                ret.put(i, j, dot);
            }
        }
        return ret;
    }

    public static ch.akuhn.matrix.Matrix dotProductTranspose(ch.akuhn.matrix.Matrix A, ch.akuhn.matrix.Matrix B) {
        ch.akuhn.matrix.Matrix ret = A.newInstance(A.rowCount(), B.rowCount());
        return MatlibMatrixUtils.dotProductTranspose(A, B, ret);
    }

    public static ch.akuhn.matrix.Matrix dotProductTransposeTranspose(ch.akuhn.matrix.Matrix A, ch.akuhn.matrix.Matrix B) {
        int mA = A.columnCount();
        int nB = B.rowCount();
        ch.akuhn.matrix.Matrix ret = A.newInstance(mA, nB);
        for (int i = 0; i < mA; ++i) {
            Vector column = A.column(i);
            for (int j = 0; j < nB; ++j) {
                double dot = column.dot(B.row(j));
                if (!(Math.abs(dot) > 1.0E-8)) continue;
                ret.put(i, j, dot);
            }
        }
        return ret;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T dotProductTranspose(ch.akuhn.matrix.Matrix A, ch.akuhn.matrix.Matrix B, T Y) {
        if (A.columnCount() != B.columnCount()) {
            throw new RuntimeException(String.format("Matrix size mismatch, A.cols == %d and B.T.cols == %d", A.columnCount(), B.columnCount()));
        }
        int mA = A.rowCount();
        int nB = B.rowCount();
        for (int i = 0; i < mA; ++i) {
            Vector arow = A.row(i);
            for (int j = 0; j < nB; ++j) {
                Vector brow = B.row(j);
                double dot = arow.dot(brow);
                if (!(Math.abs(dot) > 1.0E-8)) continue;
                Y.put(i, j, dot);
            }
        }
        return Y;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T scaleInplace(T A, double s) {
        for (Vector row : A.rows()) {
            row.timesEquals(s);
        }
        return A;
    }

    public static Jama.Matrix toJama(ch.akuhn.matrix.Matrix laplacian) {
        double[][] asArray = null;
        asArray = laplacian instanceof DenseMatrix ? ((DenseMatrix)laplacian).unwrap() : laplacian.asArray();
        Jama.Matrix ret = new Jama.Matrix(asArray, laplacian.rowCount(), laplacian.columnCount());
        return ret;
    }

    public static Jama.Matrix toColJama(Vector vector) {
        double[] vec = new double[vector.size()];
        vector.storeOn(vec, 0);
        Jama.Matrix ret = new Jama.Matrix(vec.length, 1);
        for (int i = 0; i < vec.length; ++i) {
            ret.set(i, 0, vec[i]);
        }
        return ret;
    }

    public static Jama.Matrix toRowJama(Vector vector) {
        double[] vec = new double[vector.size()];
        vector.storeOn(vec, 0);
        Jama.Matrix ret = new Jama.Matrix(1, vec.length);
        for (int i = 0; i < vec.length; ++i) {
            ret.set(0, i, vec[i]);
        }
        return ret;
    }

    public static ch.akuhn.matrix.Matrix fromJama(Jama.Matrix sol) {
        DenseMatrix mat = new DenseMatrix(sol.getArray());
        return mat;
    }

    public static no.uib.cipr.matrix.Matrix toMTJ(ch.akuhn.matrix.Matrix sol) {
        no.uib.cipr.matrix.DenseMatrix mat;
        if (sol instanceof SparseMatrix) {
            FlexCompRowMatrix fmat = new FlexCompRowMatrix(sol.rowCount(), sol.columnCount());
            int i = 0;
            for (Vector vec : sol.rows()) {
                no.uib.cipr.matrix.sparse.SparseVector x = new no.uib.cipr.matrix.sparse.SparseVector(vec.size(), vec.used());
                for (Vector.Entry ve : vec.entries()) {
                    x.set(ve.index, ve.value);
                }
                fmat.setRow(i, x);
                ++i;
            }
            mat = fmat;
        } else {
            mat = new no.uib.cipr.matrix.DenseMatrix(sol.rowCount(), sol.columnCount());
            for (int i = 0; i < sol.rowCount(); ++i) {
                for (int j = 0; j < sol.columnCount(); ++j) {
                    mat.set(i, j, sol.get(i, j));
                }
            }
        }
        return mat;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T subMatrix(T mat, int rowstart, int rowend, int colstart, int colend) {
        ch.akuhn.matrix.Matrix ret = mat.newInstance(rowend - rowstart, colend - colstart);
        for (int i = 0; i < ret.rowCount(); ++i) {
            Vector row = mat.row(i + rowstart);
            for (Vector.Entry ent : row.entries()) {
                if (ent.index < colstart || ent.index >= colend) continue;
                ret.put(i, ent.index - colstart, ent.value);
            }
        }
        return (T)ret;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T subMatrix(final T mat, TIntCollection rows, TIntCollection cols) {
        TIntIntHashMap actualCols;
        if (!(cols instanceof TIntIntHashMap)) {
            actualCols = new TIntIntHashMap();
            cols.forEach(new TIntProcedure(){
                int seen = 0;

                public boolean execute(int value) {
                    actualCols.put(value, this.seen++);
                    return true;
                }
            });
        } else {
            actualCols = (TIntIntHashMap)cols;
        }
        final ch.akuhn.matrix.Matrix ret = mat.newInstance(rows.size(), cols.size());
        rows.forEach(new TIntProcedure(){
            int seenrows = 0;

            public boolean execute(int rowIndex) {
                Vector row = mat.row(rowIndex);
                for (Vector.Entry ent : row.entries()) {
                    if (!actualCols.contains(ent.index)) continue;
                    ret.put(this.seenrows, actualCols.get(ent.index), ent.value);
                }
                ++this.seenrows;
                return true;
            }
        });
        return (T)ret;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T subMatrix(final T mat, TIntArrayList rows, final int colstart, final int colend) {
        final ch.akuhn.matrix.Matrix ret = mat.newInstance(rows.size(), colend - colstart);
        rows.forEach(new TIntProcedure(){
            int seen = 0;

            public boolean execute(int rowIndex) {
                Vector row = mat.row(rowIndex);
                for (Vector.Entry ent : row.entries()) {
                    if (ent.index < colstart || ent.index >= colend) continue;
                    ret.put(this.seen, ent.index - colstart, ent.value);
                }
                ++this.seen;
                return true;
            }
        });
        return (T)ret;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T subMatrix(final T mat, final int rowstart, final int rowend, TIntArrayList cols) {
        final ch.akuhn.matrix.Matrix ret = mat.newInstance(rowend - rowstart, cols.size());
        cols.forEach(new TIntProcedure(){
            int seen = 0;

            public boolean execute(int colIndex) {
                Vector col = mat.column(colIndex);
                for (Vector.Entry ent : col.entries()) {
                    if (ent.index < rowstart || ent.index >= rowend) continue;
                    ret.put(ent.index - rowstart, this.seen, ent.value);
                }
                ++this.seen;
                return true;
            }
        });
        return (T)ret;
    }

    public static MLDouble asMatlab(ch.akuhn.matrix.Matrix m) {
        double[][] retArr = new double[m.rowCount()][m.columnCount()];
        for (int i = 0; i < retArr.length; ++i) {
            for (int j = 0; j < retArr[i].length; ++j) {
                retArr[i][j] = m.get(i, j);
            }
        }
        MLDouble ret = new MLDouble("out", retArr);
        return ret;
    }

    public static double[] minmaxmean(ch.akuhn.matrix.Matrix mat) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double mean = 0.0;
        double size = mat.rowCount() * mat.columnCount();
        for (Vector v : mat.rows()) {
            for (Vector.Entry ent : v.entries()) {
                min = Math.min(min, ent.value);
                max = Math.max(max, ent.value);
                mean += ent.value / size;
            }
        }
        return new double[]{min, max, mean};
    }

    public static double min(ch.akuhn.matrix.Matrix mat) {
        return MatlibMatrixUtils.minmaxmean(mat)[0];
    }

    public static double max(ch.akuhn.matrix.Matrix mat) {
        return MatlibMatrixUtils.minmaxmean(mat)[1];
    }

    public static double mean(ch.akuhn.matrix.Matrix mat) {
        return MatlibMatrixUtils.minmaxmean(mat)[2];
    }

    public static <T extends ch.akuhn.matrix.Matrix> T minus(T l, double v) {
        ch.akuhn.matrix.Matrix ret = l.newInstance(l.rowCount(), l.columnCount());
        int r = 0;
        for (Vector vec : l.rows()) {
            for (Vector.Entry ent : vec.entries()) {
                ret.put(r, ent.index, ent.value - v);
            }
            ++r;
        }
        return (T)ret;
    }

    public static Vector minus(Vector l, Vector v) {
        Vector ret = DenseVector.dense((int)l.size());
        for (int i = 0; i < l.size(); ++i) {
            ret.put(i, l.get(i) - v.get(i));
        }
        return ret;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T minus(double v, T l) {
        ch.akuhn.matrix.Matrix ret = l.newInstance(l.rowCount(), l.columnCount());
        for (int i = 0; i < l.rowCount(); ++i) {
            for (int j = 0; j < l.columnCount(); ++j) {
                ret.put(i, j, v - l.get(i, j));
            }
        }
        return (T)ret;
    }

    public static ch.akuhn.matrix.Matrix fromMatlab(MLArray mlArray) {
        DenseMatrix mat = new DenseMatrix(mlArray.getM(), mlArray.getN());
        MLDouble mlDouble = (MLDouble)mlArray;
        for (int i = 0; i < mat.rowCount(); ++i) {
            for (int j = 0; j < mat.columnCount(); ++j) {
                mat.put(i, j, ((Double)mlDouble.get(i, j)).doubleValue());
            }
        }
        return mat;
    }

    public static double sum(DiagonalMatrix d) {
        return ArrayUtils.sumValues((double[])d.getVals());
    }

    public static void setSubMatrix(ch.akuhn.matrix.Matrix to, int row, int col, ch.akuhn.matrix.Matrix from) {
        for (int i = row; i < row + from.rowCount(); ++i) {
            for (int j = col; j < col + from.columnCount(); ++j) {
                to.put(i, j, from.get(i - row, j - col));
            }
        }
    }

    public static <T extends ch.akuhn.matrix.Matrix> T transpose(T mat) {
        ch.akuhn.matrix.Matrix ret = mat.newInstance(mat.columnCount(), mat.rowCount());
        for (int i = 0; i < mat.rowCount(); ++i) {
            Vector v = mat.row(i);
            for (Vector.Entry ent : v.entries()) {
                ret.put(ent.index, i, ent.value);
            }
        }
        return (T)ret;
    }

    public static SparseMatrix maxInplace(SparseMatrix A, SparseMatrix B) {
        for (int i = 0; i < A.rowCount(); ++i) {
            Vector arow = A.row(i);
            Vector brow = B.row(i);
            for (Vector.Entry br : brow.entries()) {
                if (!(arow.get(br.index) < br.value)) continue;
                A.put(i, br.index, br.value);
            }
        }
        return A;
    }

    public static SparseMatrix minInplace(SparseMatrix A, SparseMatrix B) {
        for (int i = 0; i < A.rowCount(); ++i) {
            Vector arow = A.row(i);
            Vector brow = B.row(i);
            for (Vector.Entry br : brow.entries()) {
                if (!(arow.get(br.index) > br.value)) continue;
                A.put(i, br.index, br.value);
            }
        }
        return A;
    }

    public static SparseMatrix timesInplace(SparseMatrix A, SparseMatrix B) {
        for (int i = 0; i < A.rowCount(); ++i) {
            Vector arow = A.row(i);
            Vector brow = B.row(i);
            for (Vector.Entry br : brow.entries()) {
                A.put(i, br.index, br.value * arow.get(br.index));
            }
            for (Vector.Entry ar : arow.entries()) {
                if (brow.get(ar.index) != 0.0) continue;
                A.put(i, ar.index, 0.0);
            }
        }
        return A;
    }

    public static ch.akuhn.matrix.Matrix timesInplace(ch.akuhn.matrix.Matrix A, ch.akuhn.matrix.Matrix B) {
        for (int i = 0; i < A.rowCount(); ++i) {
            Vector arow = A.row(i);
            Vector brow = B.row(i);
            for (Vector.Entry br : brow.entries()) {
                A.put(i, br.index, br.value * arow.get(br.index));
            }
            for (Vector.Entry ar : arow.entries()) {
                if (brow.get(ar.index) != 0.0) continue;
                A.put(i, ar.index, 0.0);
            }
        }
        return A;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T copy(T sparseMatrix) {
        ch.akuhn.matrix.Matrix t = sparseMatrix.newInstance();
        for (int r = 0; r < sparseMatrix.rowCount(); ++r) {
            Vector row = sparseMatrix.row(r);
            for (Vector.Entry ent : row.entries()) {
                t.put(r, ent.index, ent.value);
            }
        }
        return (T)t;
    }

    public static SparseMatrix threshold(SparseMatrix data, double thresh) {
        SparseMatrix newdata = (SparseMatrix)data.newInstance();
        for (int r = 0; r < data.rowCount(); ++r) {
            Vector vec = data.row(r);
            for (Vector.Entry ent : vec.entries()) {
                if (!(ent.value > thresh)) continue;
                newdata.put(r, ent.index, 1.0);
            }
        }
        return newdata;
    }

    public static SparseDoubleArray sparseVectorToSparseArray(SparseVector row) {
        SparseBinSearchDoubleArray sda = new SparseBinSearchDoubleArray(row.size(), row.used(), row.keys(), row.values());
        return sda;
    }

    public static void setSubVector(Vector to, int startindex, Vector from) {
        if (to instanceof DenseVector && from instanceof DenseVector) {
            double[] tod = ((DenseVector)to).unwrap();
            double[] fromd = ((DenseVector)from).unwrap();
            System.arraycopy(fromd, 0, tod, startindex, fromd.length);
            return;
        }
        for (int i = 0; i < from.size(); ++i) {
            to.put(i + startindex, from.get(i));
        }
    }

    public static void setSubMatrixRow(ch.akuhn.matrix.Matrix to, int row, int col, Vector v) {
        int i = col;
        int j = 0;
        while (i < col + v.size()) {
            to.put(row, i, v.get(j));
            ++i;
            ++j;
        }
    }

    public static void setSubMatrixCol(ch.akuhn.matrix.Matrix to, int row, int col, Vector v) {
        int i = row;
        int j = 0;
        while (i < row + v.size()) {
            to.put(i, col, v.get(j));
            ++i;
            ++j;
        }
    }

    public static Vector lessThan(Vector v, double d) {
        SparseVector out = new SparseVector(v.size(), 1);
        for (int i = 0; i < v.size(); ++i) {
            if (!(v.get(i) < d)) continue;
            out.put(i, 1.0);
        }
        return out;
    }

    public static boolean any(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) == 0.0) continue;
            return true;
        }
        return false;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T appendColumn(T m, Vector col) {
        ch.akuhn.matrix.Matrix ret = m.newInstance(m.rowCount(), m.columnCount() + 1);
        MatlibMatrixUtils.setSubMatrixCol(ret, 0, m.columnCount(), col);
        return (T)ret;
    }

    public static <T extends ch.akuhn.matrix.Matrix> T appendRow(T m, Vector row) {
        ch.akuhn.matrix.Matrix ret = m.newInstance(m.rowCount() + 1, m.columnCount());
        MatlibMatrixUtils.setSubMatrixRow(ret, m.rowCount(), 0, row);
        return (T)ret;
    }

    public static ch.akuhn.matrix.Matrix fromCF(Matrix init) {
        int m = init.getNumRows();
        int n = init.getNumColumns();
        Object ret = init instanceof gov.sandia.cognition.math.matrix.mtj.SparseMatrix ? SparseMatrix.sparse((int)init.getNumRows(), (int)init.getNumColumns()) : DenseMatrix.dense((int)m, (int)n);
        for (MatrixEntry ent : init) {
            ret.put(ent.getRowIndex(), ent.getColumnIndex(), ent.getValue());
        }
        return ret;
    }

    public static ch.akuhn.matrix.Matrix dotProduct(ch.akuhn.matrix.Matrix X, ch.akuhn.matrix.Matrix W) {
        ch.akuhn.matrix.Matrix ret = X.newInstance(X.rowCount(), W.columnCount());
        for (int j = 0; j < ret.columnCount(); ++j) {
            Vector column = W.column(j);
            for (int i = 0; i < ret.rowCount(); ++i) {
                ret.put(i, j, X.row(i).dot(column));
            }
        }
        return ret;
    }

    public static double norm2(Vector row) {
        double norm = 0.0;
        for (Vector.Entry e : row.entries()) {
            norm += e.value * e.value;
        }
        return Math.sqrt(norm);
    }

    public static ch.akuhn.matrix.Matrix minus(ch.akuhn.matrix.Matrix A, ch.akuhn.matrix.Matrix B) {
        ch.akuhn.matrix.Matrix ret = MatlibMatrixUtils.copy(A);
        MatlibMatrixUtils.minusInplace(ret, B);
        return ret;
    }

    public static double normF(ch.akuhn.matrix.Matrix A) {
        double scale = 0.0;
        double ssq = 1.0;
        for (Vector v : A.rows()) {
            for (Vector.Entry e : v.entries()) {
                double Aval = e.value;
                if (Aval == 0.0) continue;
                double absxi = Math.abs(Aval);
                if (scale < absxi) {
                    ssq = 1.0 + ssq * Math.pow(scale / absxi, 2.0);
                    scale = absxi;
                    continue;
                }
                ssq += Math.pow(absxi / scale, 2.0);
            }
        }
        return scale * Math.sqrt(ssq);
    }

    public static ch.akuhn.matrix.Matrix vstack(ch.akuhn.matrix.Matrix ... matricies) {
        int nrows = 0;
        int ncols = 0;
        for (ch.akuhn.matrix.Matrix matrix : matricies) {
            nrows += matrix.rowCount();
            ncols = matrix.columnCount();
        }
        ch.akuhn.matrix.Matrix ret = matricies[0].newInstance(nrows, ncols);
        int currentRow = 0;
        for (ch.akuhn.matrix.Matrix matrix : matricies) {
            MatlibMatrixUtils.setSubMatrix(ret, currentRow, 0, matrix);
            currentRow += matrix.rowCount();
        }
        return ret;
    }
}

