/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.graph.algorithm;

import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.UndirectedSubgraph;
import org.jgrapht.util.FibonacciHeap;
import org.jgrapht.util.FibonacciHeapNode;

public class CharikarDensestSubgraph<V, E> {
    protected UndirectedGraph<V, E> graph;
    protected UndirectedSubgraph<V, E> bestSubGraph;
    protected FibonacciHeap<V> heap = new FibonacciHeap();

    public CharikarDensestSubgraph(UndirectedGraph<V, E> graph) {
        this.graph = graph;
        for (Object vertex : graph.vertexSet()) {
            this.heap.insert(new FibonacciHeapNode(vertex), (double)graph.degreeOf(vertex));
        }
        this.calculateDensestSubgraph();
    }

    protected V getMinDegreeVertexBruteForce(UndirectedGraph<V, E> graph) {
        int minDegree = Integer.MAX_VALUE;
        V minDegreeVertex = null;
        for (Object vertex : graph.vertexSet()) {
            int degree = graph.degreeOf(vertex);
            if (degree >= minDegree) continue;
            minDegreeVertex = (V)vertex;
            break;
        }
        return minDegreeVertex;
    }

    protected V getMinDegreeVertex(UndirectedGraph<V, E> graph) {
        return (V)this.heap.removeMin().getData();
    }

    protected void calculateDensestSubgraph() {
        UndirectedSubgraph currentSubGraph = new UndirectedSubgraph(this.graph, this.graph.vertexSet(), null);
        double bestDensity = CharikarDensestSubgraph.calculateDensity(this.graph);
        while (currentSubGraph.vertexSet().size() > 0) {
            currentSubGraph = new UndirectedSubgraph(this.graph, currentSubGraph.vertexSet(), null);
            currentSubGraph.removeVertex(this.getMinDegreeVertex((UndirectedGraph<V, E>)currentSubGraph));
            double density = CharikarDensestSubgraph.calculateDensity(currentSubGraph);
            if (!(density > bestDensity)) continue;
            bestDensity = density;
            this.bestSubGraph = currentSubGraph;
        }
    }

    public static double calculateDensity(Graph<?, ?> g) {
        return (double)g.edgeSet().size() / (double)g.vertexSet().size();
    }

    public UndirectedSubgraph<V, E> getDensestSubgraph() {
        return this.bestSubGraph;
    }
}

