/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms;

import Jama.Matrix;
import java.util.List;
import org.openimaj.math.geometry.point.Point3d;
import org.openimaj.math.geometry.transforms.MatrixTransformProvider;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.util.pair.IndependentPair;

public class AffineTransformModel3d
implements EstimatableModel<Point3d, Point3d>,
MatrixTransformProvider {
    protected Matrix transform = new Matrix(3, 3);

    public AffineTransformModel3d() {
        this.transform.set(2, 0, 0.0);
        this.transform.set(2, 1, 0.0);
        this.transform.set(2, 2, 1.0);
    }

    public AffineTransformModel3d clone() {
        AffineTransformModel3d atm = new AffineTransformModel3d();
        atm.transform = this.transform.copy();
        return atm;
    }

    @Override
    public Matrix getTransform() {
        return this.transform;
    }

    @Override
    public boolean estimate(List<? extends IndependentPair<Point3d, Point3d>> data) {
        this.transform = TransformUtilities.affineMatrixND(data);
        return true;
    }

    @Override
    public Point3d predict(Point3d p) {
        return p.transform(this.transform);
    }

    @Override
    public int numItemsToEstimate() {
        return 6;
    }

    public String toString() {
        double[][] mat;
        String str = "";
        double[][] dArray = mat = this.transform.getArray();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] r;
            for (double v : r = dArray[i]) {
                str = str + " " + v;
            }
            str = str + "\n";
        }
        return str;
    }
}

