/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Triangle;

public class ConvexityDefect {
    public Point2d start;
    public Point2d end;
    public Point2d deepestPoint;
    public float depth;

    private ConvexityDefect() {
    }

    public Triangle getTriangle() {
        return new Triangle(this.start, this.deepestPoint, this.end);
    }

    public static List<ConvexityDefect> findDefects(Polygon p) {
        return ConvexityDefect.findDefects(p, p.calculateConvexHull());
    }

    public static List<ConvexityDefect> findDefects(Polygon p, Polygon hull) {
        int index1 = p.points.indexOf(hull.points.get(0));
        int index2 = p.points.indexOf(hull.points.get(1));
        int index3 = p.points.indexOf(hull.points.get(2));
        int sign = 0;
        sign += index2 > index1 ? 1 : 0;
        sign += index3 > index2 ? 1 : 0;
        boolean reverseOri = (sign += index1 > index3 ? 1 : 0) != 2;
        ArrayList<ConvexityDefect> defects = new ArrayList<ConvexityDefect>();
        for (int i = 0; i < hull.points.size(); ++i) {
            ConvexityDefect defect = new ConvexityDefect();
            defect.start = hull.get(i);
            defect.end = i == hull.points.size() - 1 ? hull.get(0) : hull.get(i + 1);
            double dx0 = defect.end.getX() - defect.start.getX();
            double dy0 = defect.end.getY() - defect.start.getY();
            double scale = 1.0 / Math.sqrt(dx0 * dx0 + dy0 * dy0);
            float depth = 0.0f;
            boolean isDefect = false;
            int curi = p.points.indexOf(defect.start);
            while (true) {
                double dy;
                Point2d cur;
                if (reverseOri) {
                    if (--curi < 0) {
                        curi = p.points.size() - 1;
                    }
                } else if (++curi >= p.points.size()) {
                    curi = 0;
                }
                if ((cur = (Point2d)p.points.get(curi)) == defect.end) break;
                double dx = (double)cur.getX() - (double)defect.start.getX();
                double dist = Math.abs(-dy0 * dx + dx0 * (dy = (double)cur.getY() - (double)defect.start.getY())) * scale;
                if (!(dist > (double)depth)) continue;
                depth = (float)dist;
                defect.deepestPoint = cur;
                defect.depth = depth;
                isDefect = true;
            }
            if (!isDefect) continue;
            defects.add(defect);
        }
        return defects;
    }
}

