/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.point;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.math.geometry.point.Point3d;

public class Point3dImpl
implements Point3d,
Cloneable {
    public double x;
    public double y;
    public double z;

    public Point3dImpl(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3dImpl(double[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
    }

    public Point3dImpl(Point3d p) {
        this.copyFrom(p);
    }

    public Point3dImpl() {
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setX(double x) {
        this.x = x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setY(double y) {
        this.y = y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public void setZ(double z) {
        this.z = z;
    }

    @Override
    public void copyFrom(Point3d p) {
        this.x = p.getX();
        this.y = p.getY();
        this.z = p.getZ();
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public Point3dImpl clone() {
        Point3dImpl clone;
        try {
            clone = (Point3dImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return clone;
    }

    @Override
    public Double getOrdinate(int dimension) {
        if (dimension == 0) {
            return this.x;
        }
        if (dimension == 1) {
            return this.y;
        }
        return this.z;
    }

    @Override
    public int getDimensions() {
        return 3;
    }

    @Override
    public void translate(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    @Override
    public void translate(Point3d v) {
        this.x += v.getX();
        this.y += v.getY();
        this.z += v.getZ();
    }

    @Override
    public Point3dImpl transform(Matrix transform) {
        if (transform.getRowDimension() == 4) {
            double xt = transform.get(0, 0) * this.getX() + transform.get(0, 1) * this.getY() + transform.get(0, 2) * this.getZ() + transform.get(0, 3);
            double yt = transform.get(1, 0) * this.getX() + transform.get(1, 1) * this.getY() + transform.get(1, 2) * this.getZ() + transform.get(1, 3);
            double zt = transform.get(2, 0) * this.getX() + transform.get(2, 1) * this.getY() + transform.get(2, 2) * this.getZ() + transform.get(2, 3);
            double ft = transform.get(3, 0) * this.getX() + transform.get(3, 1) * this.getY() + transform.get(3, 2) * this.getZ() + transform.get(3, 3);
            return new Point3dImpl(xt /= ft, yt /= ft, zt /= ft);
        }
        throw new IllegalArgumentException("Transform matrix has unexpected size");
    }

    public boolean equals(Object o) {
        if (!(o instanceof Point3d)) {
            return false;
        }
        Point3d p = (Point3d)o;
        return p.getX() == this.x && p.getY() == this.y && p.getZ() == this.getZ();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Point3d minus(Point3d a) {
        return new Point3dImpl(this.x - a.getX(), this.y - a.getY(), this.z - a.getZ());
    }

    public void readASCII(Scanner in) throws IOException {
        this.x = in.nextDouble();
        this.y = in.nextDouble();
        this.z = in.nextDouble();
    }

    public String asciiHeader() {
        return "Point3d";
    }

    public void readBinary(DataInput in) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
    }

    public byte[] binaryHeader() {
        return "PT3D".getBytes();
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.format("%f %f %f", this.x, this.y, this.z);
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }

    @Override
    public Point3dImpl copy() {
        return this.clone();
    }

    public static Point3d createRandomPoint() {
        return new Point3dImpl(Math.random(), Math.random(), Math.random());
    }

    @Override
    public void setOrdinate(int dimension, Number value) {
        if (dimension == 0) {
            this.x = value.floatValue();
        }
        if (dimension == 1) {
            this.y = value.floatValue();
        }
        if (dimension == 2) {
            this.z = value.floatValue();
        }
    }
}

