/*
 * Decompiled with CFR 0.152.
 */
package view25d.view;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import view25d.view.PatchView;

public class PatchViewOptions
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    PatchView myWindow;
    private JRadioButton structuresButton;
    private JRadioButton sheetButton;
    private JRadioButton pinsButton;
    private JRadioButton threeDButton;
    private JRadioButton twoDButton;

    public PatchViewOptions(PatchView parent, boolean str, boolean she, boolean pin, boolean threeD, boolean twoD) {
        this.myWindow = parent;
        this.setLayout(new GridLayout(1, 0));
        this.setupUI(str, she, pin, threeD, twoD);
    }

    private void setupUI(boolean str, boolean she, boolean pin, boolean threeD, boolean twoD) {
        this.structuresButton = new JRadioButton("Structures");
        this.structuresButton.setActionCommand("structures");
        if (str) {
            this.structuresButton.setSelected(true);
        }
        this.sheetButton = new JRadioButton("Sheet");
        this.sheetButton.setActionCommand("sheet");
        if (she) {
            this.sheetButton.setSelected(true);
        }
        this.pinsButton = new JRadioButton("Pins");
        this.pinsButton.setActionCommand("pins");
        if (pin) {
            this.pinsButton.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.structuresButton);
        group.add(this.sheetButton);
        group.add(this.pinsButton);
        this.threeDButton = new JRadioButton("xyz");
        this.threeDButton.setActionCommand("xyz");
        if (threeD) {
            this.threeDButton.setSelected(true);
        }
        this.twoDButton = new JRadioButton("xy-plane");
        this.twoDButton.setActionCommand("xy-plane");
        if (twoD) {
            this.twoDButton.setSelected(true);
        }
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.threeDButton);
        group2.add(this.twoDButton);
        this.structuresButton.addChangeListener(this);
        this.sheetButton.addChangeListener(this);
        this.pinsButton.addChangeListener(this);
        this.threeDButton.addChangeListener(this);
        this.twoDButton.addChangeListener(this);
        this.setLayout(new GridLayout(2, 4));
        this.add(new JLabel("  Display Options:"));
        this.add(this.structuresButton);
        this.add(this.sheetButton);
        this.add(this.pinsButton);
        this.add(new JLabel("  Link Options:"));
        this.add(this.threeDButton);
        this.add(this.twoDButton);
        this.setSize(new Dimension(600, 60));
    }

    public boolean sticks() {
        return this.pinsButton.isSelected();
    }

    public boolean tangents() {
        return this.sheetButton.isSelected() || this.pinsButton.isSelected();
    }

    public boolean structures() {
        return this.structuresButton.isSelected();
    }

    public boolean linksAreThreeD() {
        return this.threeDButton.isSelected();
    }

    public boolean linksAreTwoD() {
        return this.twoDButton.isSelected();
    }

    public void setLinksDisplayMode(boolean linksInXYPlane) {
        if (linksInXYPlane) {
            this.twoDButton.setSelected(true);
        } else {
            this.threeDButton.setSelected(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JRadioButton aButton = (JRadioButton)changeEvent.getSource();
        ButtonModel aModel = aButton.getModel();
        String text = aButton.getText();
        if (aModel.isSelected()) {
            if (text.equals("Sheet") || text.equals("Pins")) {
                this.threeDButton.setEnabled(false);
                this.twoDButton.setEnabled(false);
            }
            if (text.equals("Structures")) {
                this.threeDButton.setEnabled(true);
                this.twoDButton.setEnabled(true);
            }
        }
        this.myWindow.refresh();
    }
}

