/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.gui.scale;

public class ZoomableXScale {
    private int max_pixels = 800;
    private double min_value;
    private double max_value;
    private double offset_val = 0.0;
    private int offset_px = 0;
    private double scale = 1.0;
    private double max_zoom_val = 1.0;
    private double one_val_in_pixels_relative = (double)this.max_pixels / (this.max_value - this.min_value);
    private double one_px_in_values_relative = (this.max_value - this.min_value) / (double)this.max_pixels;
    private boolean autofixzoomandoffset = true;
    private final Object locker = new Object();

    public ZoomableXScale(double d, double d2, double d3) {
        this.setMinMaxValue(d, d2, d3);
    }

    public ZoomableXScale(double d, double d2) {
        this(d, d2, 1.0);
    }

    public ZoomableXScale(double d) {
        this(0.0, 100.0, d);
    }

    public ZoomableXScale() {
        this(0.0, 100.0, 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autofixZoomAndOffsetEnabled(boolean bl) {
        Object object = this.locker;
        synchronized (object) {
            this.autofixzoomandoffset = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPixels(int n) {
        Object object = this.locker;
        synchronized (object) {
            this.max_pixels = n;
            this.calculateValues_unsafe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinMaxValue(double d, double d2, double d3) {
        Object object = this.locker;
        synchronized (object) {
            this.max_zoom_val = d3;
            this.setMinMaxValue(d, d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinMaxValue(double d, double d2) {
        Object object = this.locker;
        synchronized (object) {
            this.min_value = d;
            this.max_value = d2;
            this.calculateValues_unsafe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveOffsetWithPixels(int n) {
        Object object = this.locker;
        synchronized (object) {
            this.setPxOffset_unsafe(this.offset_px - n);
            if (this.autofixzoomandoffset) {
                this.autoFixOffset_unsafe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveOffsetWithValue(double d) {
        Object object = this.locker;
        synchronized (object) {
            this.setValOffset_unsafe(this.offset_val - d);
            if (this.autofixzoomandoffset) {
                this.autoFixOffset_unsafe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomAround(int n, double d) {
        Object object = this.locker;
        synchronized (object) {
            double d2 = this.pixels_to_value_absolute(n);
            this.scale *= d;
            this.calculateValues_unsafe();
            double d3 = this.pixels_to_value_absolute(n);
            this.setValOffset_unsafe(this.offset_val - d3 + d2);
            if (this.autofixzoomandoffset) {
                this.autoFixOffset_unsafe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixOffset() {
        Object object = this.locker;
        synchronized (object) {
            this.autoFixOffset_unsafe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.locker;
        synchronized (object) {
            this.reset_unsafe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double pixels_to_value_absolute(int n) {
        Object object = this.locker;
        synchronized (object) {
            return (double)n * this.one_px_in_values_relative + this.offset_val + this.min_value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double pixels_to_value_relative(int n) {
        Object object = this.locker;
        synchronized (object) {
            return (double)n * this.one_px_in_values_relative;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int value_to_pixel_absolute(double d) {
        Object object = this.locker;
        synchronized (object) {
            return (int)((d - this.min_value) * this.one_val_in_pixels_relative) - this.offset_px;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int value_to_pixel_relative(double d) {
        Object object = this.locker;
        synchronized (object) {
            return (int)(d * this.one_val_in_pixels_relative);
        }
    }

    private void setPxOffset_unsafe(int n) {
        this.offset_px = n;
        this.offset_val = this.pixels_to_value_relative(n);
    }

    private void setValOffset_unsafe(double d) {
        this.offset_val = d;
        this.offset_px = this.value_to_pixel_relative(d);
    }

    private void calculateValues_unsafe() {
        this.one_val_in_pixels_relative = (double)this.max_pixels / ((this.max_value - this.min_value) * this.scale);
        this.one_px_in_values_relative = (this.max_value - this.min_value) * this.scale / (double)this.max_pixels;
        double d = this.pixels_to_value_relative(this.max_pixels);
        if (d < this.max_zoom_val) {
            this.scale = this.max_zoom_val / (this.max_value - this.min_value);
            this.one_val_in_pixels_relative = (double)this.max_pixels / ((this.max_value - this.min_value) * this.scale);
            this.one_px_in_values_relative = (this.max_value - this.min_value) * this.scale / (double)this.max_pixels;
        }
    }

    private void reset_unsafe() {
        this.scale = 1.0;
        this.offset_val = 0.0;
        this.offset_px = 0;
        this.calculateValues_unsafe();
    }

    private void autoFixOffset_unsafe() {
        double d;
        if (this.offset_px < 0) {
            this.setPxOffset_unsafe(0);
        }
        if ((d = this.pixels_to_value_absolute(this.max_pixels)) > this.max_value) {
            this.setValOffset_unsafe(this.max_value - this.pixels_to_value_relative(this.max_pixels) - this.min_value);
        }
        if (this.offset_px < 0) {
            this.reset_unsafe();
        }
    }
}

