//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cAnimation.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cAnimation_hpp
#define cAnimation_hpp
//==============================================================================
// Includes
#include <vector>
#include <string>
#include "Types.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//==============================================================================
//! Animation
//------------------------------------------------------------------------------
class cAnimation
{
	// Constructor & Destructor
	public:
		//! Constructor
		cAnimation (void);
		//! Destructor
		~cAnimation (void);
	
	// Public methods
	public:
		//! Load configuration from file
		void LoadConfig (string filename);
		//! Set frame size
		void SetFrameSize (Uint16 width, Uint16 height)
		{
			mWidth = width;
			mHeight = height;
		};
		//! Add frame to animation
		void AddFrame (Uint32 texture, float x, float y, float w, float h);
		//! Compile animation
		Uint32 Compile (void);
		//! Get display list
		Uint32 GetDisplayList (void) const { return mDisplayList; };
	
		//! Render frame
		void RenderFrame (Uint16 frame);
	
	// Internal structures
	private:
		struct tAnimationFrame
		{
			Uint32 mTextureID;
			float mX;
			float mY;
			float mW;
			float mH;
		};
	
	// Member variables
	private:
		Uint16 mWidth;
		Uint16 mHeight;
		vector<tAnimationFrame> mFrames;
		Uint32 mDisplayList;
		Uint16 mListRange;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cAnimation_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
