//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: Types.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef Types_hpp
#define Types_hpp
//==============================================================================
// Includes
#include "SDL_types.h"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//! ObjectID
typedef unsigned int ObjectID;

#ifndef POW2	
	#define POW2(x)	((x) * (x))
#endif

enum CollisionModel
{
	CollisionModel_Circle = 1,
	CollisionModel_Ray,
	CollisionModel_Particle
};

enum ContactModel
{
	ContactModel_Slide = 1,
	ContactModel_Stop,
	ContactModel_Bounce
};

//! Convert degrees to radians
inline float D2R (float angle)
{
	return angle / 180.0f * 3.141592654f;
}

//! Convert radians to degrees
inline float R2D (float angle)
{
	return angle / 3.141592654f * 180.0f;
}

//==============================================================================
}		// End of the ShootingStar namespace
#endif // Types_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
