/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.InternalQuantity;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXBoolean;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UserNumber;
import java.io.IOException;

public class LaTeX3Boolean
extends Command
implements TeXBoolean,
TeXNumber,
InternalQuantity {
    protected boolean value = false;

    public LaTeX3Boolean(String string) {
        this(string, false);
    }

    public LaTeX3Boolean(String string, boolean bl) {
        super(string);
        this.value = bl;
    }

    @Override
    public Object clone() {
        return new LaTeX3Boolean(this.getName(), this.value);
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public int getValue() {
        return this.value ? 1 : 0;
    }

    @Override
    public double doubleValue() {
        return this.getValue();
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.getValue();
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.value = this.getValue() + numerical.number(teXParser) > 0;
    }

    @Override
    public void divide(int n) {
    }

    @Override
    public void multiply(int n) {
        this.value = this.getValue() * n > 0;
    }

    @Override
    public void setQuantity(TeXParser teXParser, TeXObject teXObject) throws TeXSyntaxException {
        try {
            if (teXObject instanceof Numerical) {
                this.value = ((Numerical)teXObject).number(teXParser) > 0;
            } else if (teXParser.isStack(teXObject)) {
                Numerical numerical = TeXParserUtils.popNumericalArg(teXParser, (TeXObjectList)teXObject);
                this.value = numerical.number(teXParser) > 0;
            } else {
                String string = teXParser.expandToString(teXObject, teXParser);
                this.value = string.equals("0");
            }
        }
        catch (IOException iOException) {
            throw new TeXSyntaxException((Throwable)iOException, teXParser, "tex.error.number_expected", teXObject);
        }
    }

    @Override
    public TeXObject getQuantity(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.value ? UserNumber.ONE : UserNumber.ZERO;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) {
        TeXObjectList teXObjectList = teXParser.getListener().createStack();
        teXObjectList.add(new TeXCsRef("char"));
        teXObjectList.add(teXParser.getListener().getOther(34));
        teXObjectList.add(teXParser.getListener().getOther(this.value ? 49 : 48));
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) {
        return teXParser.getListener().createString(this.value ? "1" : "0");
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) {
        return this.expandfully(teXParser);
    }
}

