add_library(steamsdk INTERFACE)
if (STEAMSDK)
    if(${CMAKE_SIZEOF_VOID_P} EQUAL 4)
        if(WIN32)
            target_link_libraries(steamsdk INTERFACE steam_api)
            target_link_directories(steamsdk INTERFACE "${STEAMSDK}/redistributable_bin")
        endif()
        if(UNIX AND NOT APPLE)
            target_link_libraries(steamsdk INTERFACE steam_api)
            target_link_directories(steamsdk INTERFACE "${STEAMSDK}/redistributable_bin/linux32")
        endif()
    else()
        if(WIN32)
            target_link_libraries(steamsdk INTERFACE steam_api64)
            target_link_directories(steamsdk INTERFACE "${STEAMSDK}/redistributable_bin/win64")
        endif()
        if(UNIX AND NOT APPLE)
            target_link_libraries(steamsdk INTERFACE steam_api)
            target_link_directories(steamsdk INTERFACE "${STEAMSDK}/redistributable_bin/linux64")
        endif()
    endif()
    target_include_directories(steamsdk INTERFACE "${STEAMSDK}/public")
    target_compile_definitions(steamsdk INTERFACE STEAMSDK=1)
    message(STATUS "Using steam SDK at ${STEAMSDK}")
else()
    message(STATUS "Not using steam SDK")
endif()
