// Auto generated by `tasks/compat_data/src/lib.rs`.
#![allow(clippy::enum_glob_use, clippy::match_same_arms)]
use super::{Engine, EngineTargets};
use browserslist::Version;
use rustc_hash::FxHashMap;
use std::sync::OnceLock;
#[derive(Debug, Clone, Copy, Eq, PartialEq, Hash)]
pub enum ESFeature {
    ES5MemberExpressionLiterals,
    ES5PropertyLiterals,
    ES5ReservedWords,
    ES2015Parameters,
    ES2015TemplateLiterals,
    ES2015Literals,
    ES2015FunctionName,
    ES2015ArrowFunctions,
    ES2015BlockScopedFunctions,
    ES2015Classes,
    ES2015ObjectSuper,
    ES2015ShorthandProperties,
    ES2015DuplicateKeys,
    ES2015ComputedProperties,
    ES2015ForOf,
    ES2015StickyRegex,
    ES2015UnicodeEscapes,
    ES2015UnicodeRegex,
    ES2015Spread,
    ES2015Destructuring,
    ES2015BlockScoping,
    ES2015TypeofSymbol,
    ES2015NewTarget,
    ES2015Regenerator,
    ES2016ExponentiationOperator,
    ES2017AsyncToGenerator,
    ES2018AsyncGeneratorFunctions,
    ES2018ObjectRestSpread,
    ES2018DotallRegex,
    ES2018UnicodePropertyRegex,
    ES2018NamedCapturingGroupsRegex,
    ES2018LookbehindRegex,
    ES2019JsonStrings,
    ES2019OptionalCatchBinding,
    ES2020NullishCoalescingOperator,
    ES2020OptionalChaining,
    ES2020BigInt,
    ES2021NumericSeparator,
    ES2021LogicalAssignmentOperators,
    ES2022ClassStaticBlock,
    ES2022PrivatePropertyInObject,
    ES2022ClassProperties,
    ES2022PrivateMethods,
    ES2022MatchIndicesRegex,
    ES2024UnicodeSetsRegex,
    ES2025DuplicateNamedCapturingGroupsRegex,
    ES2025RegexpModifiers,
    ES2026ExplicitResourceManagement,
    ES2020ExportNamespaceFrom,
}
pub fn features() -> &'static FxHashMap<ESFeature, EngineTargets> {
    use ESFeature::*;
    use Engine::*;
    static FEATURES: OnceLock<FxHashMap<ESFeature, EngineTargets>> = OnceLock::new();
    FEATURES.get_or_init(|| {
        FxHashMap::from_iter([
            (
                ES5MemberExpressionLiterals,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(1u16, 0u16, 0u16)),
                    (Node, Version(0u16, 4u16, 0u16)),
                    (Firefox, Version(2u16, 0u16, 0u16)),
                    (Android, Version(4u16, 0u16, 0u16)),
                    (Safari, Version(5u16, 1u16, 0u16)),
                    (Chrome, Version(7u16, 0u16, 0u16)),
                    (Ios, Version(6u16, 0u16, 0u16)),
                    (Edge, Version(12u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 13u16)),
                    (OperaMobile, Version(12u16, 0u16, 0u16)),
                    (Ie, Version(9u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 20u16, 0u16)),
                    (Opera, Version(12u16, 0u16, 0u16)),
                    (Es, Version(5u16, 0, 0)),
                ])),
            ),
            (
                ES5PropertyLiterals,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(1u16, 0u16, 0u16)),
                    (Node, Version(0u16, 4u16, 0u16)),
                    (Firefox, Version(2u16, 0u16, 0u16)),
                    (Android, Version(4u16, 0u16, 0u16)),
                    (Safari, Version(5u16, 1u16, 0u16)),
                    (Chrome, Version(7u16, 0u16, 0u16)),
                    (Ios, Version(6u16, 0u16, 0u16)),
                    (Edge, Version(12u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 13u16)),
                    (OperaMobile, Version(12u16, 0u16, 0u16)),
                    (Ie, Version(9u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 20u16, 0u16)),
                    (Opera, Version(12u16, 0u16, 0u16)),
                    (Es, Version(5u16, 0, 0)),
                ])),
            ),
            (
                ES5ReservedWords,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(1u16, 0u16, 0u16)),
                    (Node, Version(0u16, 6u16, 0u16)),
                    (Firefox, Version(2u16, 0u16, 0u16)),
                    (Android, Version(4u16, 4u16, 0u16)),
                    (Safari, Version(3u16, 1u16, 0u16)),
                    (Chrome, Version(13u16, 0u16, 0u16)),
                    (Ios, Version(6u16, 0u16, 0u16)),
                    (Edge, Version(12u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 13u16)),
                    (OperaMobile, Version(10u16, 1u16, 0u16)),
                    (Ie, Version(9u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 20u16, 0u16)),
                    (Opera, Version(10u16, 50u16, 0u16)),
                    (Es, Version(5u16, 0, 0)),
                ])),
            ),
            (
                ES2015Parameters,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(6u16, 0u16, 0u16)),
                    (Firefox, Version(53u16, 0u16, 0u16)),
                    (Chrome, Version(49u16, 0u16, 0u16)),
                    (Safari, Version(16u16, 3u16, 0u16)),
                    (Ios, Version(16u16, 3u16, 0u16)),
                    (Edge, Version(18u16, 0u16, 0u16)),
                    (OperaMobile, Version(36u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 37u16, 0u16)),
                    (Opera, Version(36u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015TemplateLiterals,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(8u16, 0u16, 0u16)),
                    (Node, Version(8u16, 10u16, 0u16)),
                    (Firefox, Version(53u16, 0u16, 0u16)),
                    (Chrome, Version(62u16, 0u16, 0u16)),
                    (Safari, Version(13u16, 0u16, 0u16)),
                    (Ios, Version(13u16, 0u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (OperaMobile, Version(46u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(3u16, 0u16, 0u16)),
                    (Opera, Version(49u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015Literals,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(4u16, 0u16, 0u16)),
                    (Node, Version(4u16, 0u16, 0u16)),
                    (Firefox, Version(53u16, 0u16, 0u16)),
                    (Chrome, Version(44u16, 0u16, 0u16)),
                    (Safari, Version(9u16, 0u16, 0u16)),
                    (Ios, Version(9u16, 0u16, 0u16)),
                    (Edge, Version(12u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 15u16)),
                    (OperaMobile, Version(32u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 30u16, 0u16)),
                    (Opera, Version(31u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015FunctionName,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(6u16, 5u16, 0u16)),
                    (Firefox, Version(53u16, 0u16, 0u16)),
                    (Chrome, Version(51u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (OperaMobile, Version(41u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(1u16, 2u16, 0u16)),
                    (Opera, Version(38u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015ArrowFunctions,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(6u16, 0u16, 0u16)),
                    (Firefox, Version(43u16, 0u16, 0u16)),
                    (Chrome, Version(47u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(13u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 13u16)),
                    (OperaMobile, Version(34u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 36u16, 0u16)),
                    (Opera, Version(34u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015BlockScopedFunctions,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(3u16, 4u16, 0u16)),
                    (Node, Version(4u16, 0u16, 0u16)),
                    (Firefox, Version(46u16, 0u16, 0u16)),
                    (Chrome, Version(41u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(12u16, 0u16, 0u16)),
                    (OperaMobile, Version(28u16, 0u16, 0u16)),
                    (Ie, Version(11u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 21u16, 0u16)),
                    (Opera, Version(28u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015Classes,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(5u16, 0u16, 0u16)),
                    (Firefox, Version(45u16, 0u16, 0u16)),
                    (Chrome, Version(46u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(13u16, 0u16, 0u16)),
                    (OperaMobile, Version(33u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 36u16, 0u16)),
                    (Opera, Version(33u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015ObjectSuper,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(5u16, 0u16, 0u16)),
                    (Firefox, Version(45u16, 0u16, 0u16)),
                    (Chrome, Version(46u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(13u16, 0u16, 0u16)),
                    (OperaMobile, Version(33u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 36u16, 0u16)),
                    (Opera, Version(33u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015ShorthandProperties,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(4u16, 0u16, 0u16)),
                    (Node, Version(4u16, 0u16, 0u16)),
                    (Firefox, Version(33u16, 0u16, 0u16)),
                    (Chrome, Version(43u16, 0u16, 0u16)),
                    (Safari, Version(9u16, 0u16, 0u16)),
                    (Ios, Version(9u16, 0u16, 0u16)),
                    (Edge, Version(12u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 14u16)),
                    (OperaMobile, Version(30u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 27u16, 0u16)),
                    (Opera, Version(30u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015DuplicateKeys,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(3u16, 4u16, 0u16)),
                    (Node, Version(4u16, 0u16, 0u16)),
                    (Firefox, Version(34u16, 0u16, 0u16)),
                    (Chrome, Version(42u16, 0u16, 0u16)),
                    (Safari, Version(9u16, 0u16, 0u16)),
                    (Ios, Version(9u16, 0u16, 0u16)),
                    (Edge, Version(12u16, 0u16, 0u16)),
                    (OperaMobile, Version(29u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 25u16, 0u16)),
                    (Opera, Version(29u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015ComputedProperties,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(4u16, 0u16, 0u16)),
                    (Node, Version(4u16, 0u16, 0u16)),
                    (Firefox, Version(34u16, 0u16, 0u16)),
                    (Chrome, Version(44u16, 0u16, 0u16)),
                    (Safari, Version(7u16, 1u16, 0u16)),
                    (Ios, Version(8u16, 0u16, 0u16)),
                    (Edge, Version(12u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 8u16, 0u16)),
                    (OperaMobile, Version(32u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 30u16, 0u16)),
                    (Opera, Version(31u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015ForOf,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(6u16, 5u16, 0u16)),
                    (Firefox, Version(53u16, 0u16, 0u16)),
                    (Chrome, Version(51u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(15u16, 0u16, 0u16)),
                    (OperaMobile, Version(41u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(1u16, 2u16, 0u16)),
                    (Opera, Version(38u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015StickyRegex,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(6u16, 0u16, 0u16)),
                    (Firefox, Version(3u16, 0u16, 0u16)),
                    (Chrome, Version(49u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(13u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 15u16)),
                    (OperaMobile, Version(36u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 37u16, 0u16)),
                    (Opera, Version(36u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015UnicodeEscapes,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(4u16, 0u16, 0u16)),
                    (Node, Version(4u16, 0u16, 0u16)),
                    (Firefox, Version(53u16, 0u16, 0u16)),
                    (Chrome, Version(44u16, 0u16, 0u16)),
                    (Safari, Version(9u16, 0u16, 0u16)),
                    (Ios, Version(9u16, 0u16, 0u16)),
                    (Edge, Version(12u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 15u16)),
                    (OperaMobile, Version(32u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 30u16, 0u16)),
                    (Opera, Version(31u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015UnicodeRegex,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(6u16, 0u16, 0u16)),
                    (Firefox, Version(46u16, 0u16, 0u16)),
                    (Chrome, Version(50u16, 0u16, 0u16)),
                    (Safari, Version(12u16, 0u16, 0u16)),
                    (Ios, Version(12u16, 0u16, 0u16)),
                    (Edge, Version(13u16, 0u16, 0u16)),
                    (OperaMobile, Version(37u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(1u16, 1u16, 0u16)),
                    (Opera, Version(37u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015Spread,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(5u16, 0u16, 0u16)),
                    (Firefox, Version(45u16, 0u16, 0u16)),
                    (Chrome, Version(46u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(13u16, 0u16, 0u16)),
                    (OperaMobile, Version(33u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 36u16, 0u16)),
                    (Opera, Version(33u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015Destructuring,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(6u16, 5u16, 0u16)),
                    (Firefox, Version(53u16, 0u16, 0u16)),
                    (Chrome, Version(51u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(15u16, 0u16, 0u16)),
                    (OperaMobile, Version(41u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(1u16, 2u16, 0u16)),
                    (Opera, Version(38u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015BlockScoping,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(6u16, 0u16, 0u16)),
                    (Firefox, Version(53u16, 0u16, 0u16)),
                    (Chrome, Version(50u16, 0u16, 0u16)),
                    (Safari, Version(11u16, 0u16, 0u16)),
                    (Ios, Version(11u16, 0u16, 0u16)),
                    (Edge, Version(14u16, 0u16, 0u16)),
                    (OperaMobile, Version(37u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(1u16, 1u16, 0u16)),
                    (Opera, Version(37u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015TypeofSymbol,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(3u16, 0u16, 0u16)),
                    (Node, Version(0u16, 12u16, 0u16)),
                    (Firefox, Version(36u16, 0u16, 0u16)),
                    (Chrome, Version(38u16, 0u16, 0u16)),
                    (Safari, Version(9u16, 0u16, 0u16)),
                    (Ios, Version(9u16, 0u16, 0u16)),
                    (Edge, Version(12u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 13u16)),
                    (OperaMobile, Version(25u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 20u16, 0u16)),
                    (Opera, Version(25u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015NewTarget,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(5u16, 0u16, 0u16)),
                    (Firefox, Version(41u16, 0u16, 0u16)),
                    (Chrome, Version(46u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(14u16, 0u16, 0u16)),
                    (OperaMobile, Version(33u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(0u16, 36u16, 0u16)),
                    (Opera, Version(33u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2015Regenerator,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(5u16, 0u16, 0u16)),
                    (Node, Version(6u16, 0u16, 0u16)),
                    (Firefox, Version(53u16, 0u16, 0u16)),
                    (Chrome, Version(50u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 0u16, 0u16)),
                    (Ios, Version(10u16, 0u16, 0u16)),
                    (Edge, Version(13u16, 0u16, 0u16)),
                    (OperaMobile, Version(37u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(1u16, 1u16, 0u16)),
                    (Opera, Version(37u16, 0u16, 0u16)),
                    (Es, Version(2015u16, 0, 0)),
                ])),
            ),
            (
                ES2016ExponentiationOperator,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(6u16, 0u16, 0u16)),
                    (Node, Version(7u16, 0u16, 0u16)),
                    (Firefox, Version(52u16, 0u16, 0u16)),
                    (Chrome, Version(52u16, 0u16, 0u16)),
                    (Safari, Version(10u16, 1u16, 0u16)),
                    (Ios, Version(10u16, 3u16, 0u16)),
                    (Edge, Version(14u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 14u16)),
                    (OperaMobile, Version(41u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(1u16, 3u16, 0u16)),
                    (Opera, Version(39u16, 0u16, 0u16)),
                    (Es, Version(2016u16, 0, 0)),
                ])),
            ),
            (
                ES2017AsyncToGenerator,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(6u16, 0u16, 0u16)),
                    (Node, Version(7u16, 6u16, 0u16)),
                    (Firefox, Version(52u16, 0u16, 0u16)),
                    (Chrome, Version(55u16, 0u16, 0u16)),
                    (Safari, Version(11u16, 0u16, 0u16)),
                    (Ios, Version(11u16, 0u16, 0u16)),
                    (Edge, Version(15u16, 0u16, 0u16)),
                    (OperaMobile, Version(42u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(1u16, 6u16, 0u16)),
                    (Opera, Version(42u16, 0u16, 0u16)),
                    (Es, Version(2017u16, 0, 0)),
                ])),
            ),
            (
                ES2018AsyncGeneratorFunctions,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(8u16, 0u16, 0u16)),
                    (Node, Version(10u16, 0u16, 0u16)),
                    (Firefox, Version(57u16, 0u16, 0u16)),
                    (Chrome, Version(63u16, 0u16, 0u16)),
                    (Safari, Version(12u16, 0u16, 0u16)),
                    (Ios, Version(12u16, 0u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (OperaMobile, Version(46u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(3u16, 0u16, 0u16)),
                    (Opera, Version(50u16, 0u16, 0u16)),
                    (Es, Version(2018u16, 0, 0)),
                ])),
            ),
            (
                ES2018ObjectRestSpread,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(8u16, 0u16, 0u16)),
                    (Node, Version(8u16, 3u16, 0u16)),
                    (Firefox, Version(55u16, 0u16, 0u16)),
                    (Chrome, Version(60u16, 0u16, 0u16)),
                    (Safari, Version(11u16, 1u16, 0u16)),
                    (Ios, Version(11u16, 3u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (OperaMobile, Version(44u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(2u16, 0u16, 0u16)),
                    (Opera, Version(47u16, 0u16, 0u16)),
                    (Es, Version(2018u16, 0, 0)),
                ])),
            ),
            (
                ES2018DotallRegex,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(8u16, 0u16, 0u16)),
                    (Node, Version(8u16, 10u16, 0u16)),
                    (Firefox, Version(78u16, 0u16, 0u16)),
                    (Chrome, Version(62u16, 0u16, 0u16)),
                    (Safari, Version(11u16, 1u16, 0u16)),
                    (Ios, Version(11u16, 3u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 15u16)),
                    (OperaMobile, Version(46u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(3u16, 0u16, 0u16)),
                    (Opera, Version(49u16, 0u16, 0u16)),
                    (Es, Version(2018u16, 0, 0)),
                ])),
            ),
            (
                ES2018UnicodePropertyRegex,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(9u16, 0u16, 0u16)),
                    (Node, Version(10u16, 0u16, 0u16)),
                    (Firefox, Version(78u16, 0u16, 0u16)),
                    (Chrome, Version(64u16, 0u16, 0u16)),
                    (Safari, Version(11u16, 1u16, 0u16)),
                    (Ios, Version(11u16, 3u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (OperaMobile, Version(47u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(3u16, 0u16, 0u16)),
                    (Opera, Version(51u16, 0u16, 0u16)),
                    (Es, Version(2018u16, 0, 0)),
                ])),
            ),
            (
                ES2018NamedCapturingGroupsRegex,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(9u16, 0u16, 0u16)),
                    (Node, Version(10u16, 0u16, 0u16)),
                    (Firefox, Version(78u16, 0u16, 0u16)),
                    (Chrome, Version(64u16, 0u16, 0u16)),
                    (Safari, Version(11u16, 1u16, 0u16)),
                    (Ios, Version(11u16, 3u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (OperaMobile, Version(47u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(3u16, 0u16, 0u16)),
                    (Opera, Version(51u16, 0u16, 0u16)),
                    (Es, Version(2018u16, 0, 0)),
                ])),
            ),
            (
                ES2018LookbehindRegex,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(8u16, 0u16, 0u16)),
                    (Node, Version(8u16, 10u16, 0u16)),
                    (Firefox, Version(78u16, 0u16, 0u16)),
                    (Chrome, Version(62u16, 0u16, 0u16)),
                    (Safari, Version(16u16, 4u16, 0u16)),
                    (Ios, Version(16u16, 4u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (OperaMobile, Version(46u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(3u16, 0u16, 0u16)),
                    (Opera, Version(49u16, 0u16, 0u16)),
                    (Es, Version(2018u16, 0, 0)),
                ])),
            ),
            (
                ES2019JsonStrings,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(9u16, 0u16, 0u16)),
                    (Node, Version(10u16, 0u16, 0u16)),
                    (Firefox, Version(62u16, 0u16, 0u16)),
                    (Chrome, Version(66u16, 0u16, 0u16)),
                    (Safari, Version(12u16, 0u16, 0u16)),
                    (Ios, Version(12u16, 0u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 14u16)),
                    (OperaMobile, Version(47u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(3u16, 0u16, 0u16)),
                    (Opera, Version(53u16, 0u16, 0u16)),
                    (Es, Version(2019u16, 0, 0)),
                ])),
            ),
            (
                ES2019OptionalCatchBinding,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(9u16, 0u16, 0u16)),
                    (Node, Version(10u16, 0u16, 0u16)),
                    (Firefox, Version(58u16, 0u16, 0u16)),
                    (Chrome, Version(66u16, 0u16, 0u16)),
                    (Safari, Version(11u16, 1u16, 0u16)),
                    (Ios, Version(11u16, 3u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (OperaMobile, Version(47u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(3u16, 0u16, 0u16)),
                    (Opera, Version(53u16, 0u16, 0u16)),
                    (Es, Version(2019u16, 0, 0)),
                ])),
            ),
            (
                ES2020NullishCoalescingOperator,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(13u16, 0u16, 0u16)),
                    (Node, Version(14u16, 0u16, 0u16)),
                    (Firefox, Version(72u16, 0u16, 0u16)),
                    (Chrome, Version(80u16, 0u16, 0u16)),
                    (Safari, Version(13u16, 1u16, 0u16)),
                    (Ios, Version(13u16, 4u16, 0u16)),
                    (Edge, Version(80u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 8u16, 0u16)),
                    (OperaMobile, Version(57u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(8u16, 0u16, 0u16)),
                    (Opera, Version(67u16, 0u16, 0u16)),
                    (Es, Version(2020u16, 0, 0)),
                ])),
            ),
            (
                ES2020OptionalChaining,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(16u16, 0u16, 0u16)),
                    (Node, Version(16u16, 9u16, 0u16)),
                    (Firefox, Version(74u16, 0u16, 0u16)),
                    (Chrome, Version(91u16, 0u16, 0u16)),
                    (Safari, Version(13u16, 1u16, 0u16)),
                    (Ios, Version(13u16, 4u16, 0u16)),
                    (Edge, Version(91u16, 0u16, 0u16)),
                    (OperaMobile, Version(64u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 9u16, 0u16)),
                    (Electron, Version(13u16, 0u16, 0u16)),
                    (Opera, Version(77u16, 0u16, 0u16)),
                    (Es, Version(2020u16, 0, 0)),
                ])),
            ),
            (
                ES2020BigInt,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(9u16, 0u16, 0u16)),
                    (Node, Version(10u16, 4u16, 0u16)),
                    (Firefox, Version(68u16, 0u16, 0u16)),
                    (Chrome, Version(67u16, 0u16, 0u16)),
                    (Safari, Version(14u16, 0u16, 0u16)),
                    (Ios, Version(14u16, 0u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 14u16)),
                    (OperaMobile, Version(48u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(4u16, 0u16, 0u16)),
                    (Opera, Version(54u16, 0u16, 0u16)),
                    (Es, Version(2020u16, 0, 0)),
                ])),
            ),
            (
                ES2021NumericSeparator,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(11u16, 0u16, 0u16)),
                    (Node, Version(12u16, 5u16, 0u16)),
                    (Firefox, Version(70u16, 0u16, 0u16)),
                    (Chrome, Version(75u16, 0u16, 0u16)),
                    (Safari, Version(13u16, 0u16, 0u16)),
                    (Ios, Version(13u16, 0u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (Rhino, Version(1u16, 7u16, 14u16)),
                    (OperaMobile, Version(54u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(6u16, 0u16, 0u16)),
                    (Opera, Version(62u16, 0u16, 0u16)),
                    (Es, Version(2021u16, 0, 0)),
                ])),
            ),
            (
                ES2021LogicalAssignmentOperators,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(14u16, 0u16, 0u16)),
                    (Node, Version(15u16, 0u16, 0u16)),
                    (Firefox, Version(79u16, 0u16, 0u16)),
                    (Chrome, Version(85u16, 0u16, 0u16)),
                    (Safari, Version(14u16, 0u16, 0u16)),
                    (Ios, Version(14u16, 0u16, 0u16)),
                    (Edge, Version(85u16, 0u16, 0u16)),
                    (OperaMobile, Version(60u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 2u16, 0u16)),
                    (Electron, Version(10u16, 0u16, 0u16)),
                    (Opera, Version(71u16, 0u16, 0u16)),
                    (Es, Version(2021u16, 0, 0)),
                ])),
            ),
            (
                ES2022ClassStaticBlock,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(17u16, 0u16, 0u16)),
                    (Node, Version(16u16, 11u16, 0u16)),
                    (Firefox, Version(93u16, 0u16, 0u16)),
                    (Chrome, Version(94u16, 0u16, 0u16)),
                    (Safari, Version(16u16, 4u16, 0u16)),
                    (Ios, Version(16u16, 4u16, 0u16)),
                    (Edge, Version(94u16, 0u16, 0u16)),
                    (OperaMobile, Version(66u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 14u16, 0u16)),
                    (Electron, Version(15u16, 0u16, 0u16)),
                    (Opera, Version(80u16, 0u16, 0u16)),
                    (Es, Version(2022u16, 0, 0)),
                ])),
            ),
            (
                ES2022PrivatePropertyInObject,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(16u16, 0u16, 0u16)),
                    (Node, Version(16u16, 9u16, 0u16)),
                    (Firefox, Version(90u16, 0u16, 0u16)),
                    (Chrome, Version(91u16, 0u16, 0u16)),
                    (Safari, Version(15u16, 0u16, 0u16)),
                    (Ios, Version(15u16, 0u16, 0u16)),
                    (Edge, Version(91u16, 0u16, 0u16)),
                    (OperaMobile, Version(64u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 9u16, 0u16)),
                    (Electron, Version(13u16, 0u16, 0u16)),
                    (Opera, Version(77u16, 0u16, 0u16)),
                    (Es, Version(2022u16, 0, 0)),
                ])),
            ),
            (
                ES2022ClassProperties,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(11u16, 0u16, 0u16)),
                    (Node, Version(12u16, 0u16, 0u16)),
                    (Firefox, Version(90u16, 0u16, 0u16)),
                    (Chrome, Version(98u16, 0u16, 0u16)),
                    (Safari, Version(16u16, 0u16, 0u16)),
                    (Ios, Version(16u16, 0u16, 0u16)),
                    (Edge, Version(98u16, 0u16, 0u16)),
                    (OperaMobile, Version(53u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 18u16, 0u16)),
                    (Electron, Version(17u16, 0u16, 0u16)),
                    (Opera, Version(84u16, 0u16, 0u16)),
                    (Es, Version(2022u16, 0, 0)),
                ])),
            ),
            (
                ES2022PrivateMethods,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(14u16, 0u16, 0u16)),
                    (Node, Version(14u16, 6u16, 0u16)),
                    (Firefox, Version(90u16, 0u16, 0u16)),
                    (Chrome, Version(84u16, 0u16, 0u16)),
                    (Safari, Version(15u16, 0u16, 0u16)),
                    (Ios, Version(15u16, 0u16, 0u16)),
                    (Edge, Version(84u16, 0u16, 0u16)),
                    (OperaMobile, Version(60u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(10u16, 0u16, 0u16)),
                    (Opera, Version(70u16, 0u16, 0u16)),
                    (Es, Version(2022u16, 0, 0)),
                ])),
            ),
            (
                ES2022MatchIndicesRegex,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(15u16, 0u16, 0u16)),
                    (Node, Version(16u16, 0u16, 0u16)),
                    (Firefox, Version(91u16, 0u16, 0u16)),
                    (Chrome, Version(90u16, 0u16, 0u16)),
                    (Safari, Version(15u16, 0u16, 0u16)),
                    (Ios, Version(15u16, 0u16, 0u16)),
                    (Edge, Version(90u16, 0u16, 0u16)),
                    (OperaMobile, Version(64u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 8u16, 0u16)),
                    (Electron, Version(13u16, 0u16, 0u16)),
                    (Opera, Version(76u16, 0u16, 0u16)),
                    (Es, Version(2022u16, 0, 0)),
                ])),
            ),
            (
                ES2024UnicodeSetsRegex,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(23u16, 0u16, 0u16)),
                    (Node, Version(20u16, 0u16, 0u16)),
                    (Firefox, Version(116u16, 0u16, 0u16)),
                    (Chrome, Version(112u16, 0u16, 0u16)),
                    (Safari, Version(17u16, 0u16, 0u16)),
                    (Ios, Version(17u16, 0u16, 0u16)),
                    (Edge, Version(112u16, 0u16, 0u16)),
                    (OperaMobile, Version(75u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 32u16, 0u16)),
                    (Electron, Version(24u16, 0u16, 0u16)),
                    (Opera, Version(98u16, 0u16, 0u16)),
                    (Es, Version(2024u16, 0, 0)),
                ])),
            ),
            (
                ES2025DuplicateNamedCapturingGroupsRegex,
                EngineTargets::new(FxHashMap::from_iter([
                    (Chrome, Version(126u16, 0u16, 0u16)),
                    (Node, Version(23u16, 0u16, 0u16)),
                    (Firefox, Version(129u16, 0u16, 0u16)),
                    (Safari, Version(17u16, 4u16, 0u16)),
                    (Ios, Version(17u16, 4u16, 0u16)),
                    (Edge, Version(126u16, 0u16, 0u16)),
                    (Electron, Version(31u16, 0u16, 0u16)),
                    (Opera, Version(112u16, 0u16, 0u16)),
                    (Es, Version(2025u16, 0, 0)),
                ])),
            ),
            (
                ES2025RegexpModifiers,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(27u16, 0u16, 0u16)),
                    (Node, Version(23u16, 0u16, 0u16)),
                    (Firefox, Version(132u16, 0u16, 0u16)),
                    (Electron, Version(31u16, 0u16, 0u16)),
                    (Chrome, Version(125u16, 0u16, 0u16)),
                    (Opera, Version(111u16, 0u16, 0u16)),
                    (Edge, Version(125u16, 0u16, 0u16)),
                    (Es, Version(2025u16, 0, 0)),
                ])),
            ),
            (
                ES2026ExplicitResourceManagement,
                EngineTargets::new(FxHashMap::from_iter([
                    (Chrome, Version(134u16, 0u16, 0u16)),
                    (Node, Version(24u16, 0u16, 0u16)),
                    (Firefox, Version(141u16, 0u16, 0u16)),
                    (Edge, Version(134u16, 0u16, 0u16)),
                    (Es, Version(2026u16, 0, 0)),
                ])),
            ),
            (
                ES2020ExportNamespaceFrom,
                EngineTargets::new(FxHashMap::from_iter([
                    (Samsung, Version(11u16, 0u16, 0u16)),
                    (Node, Version(13u16, 2u16, 0u16)),
                    (Firefox, Version(80u16, 0u16, 0u16)),
                    (Chrome, Version(72u16, 0u16, 0u16)),
                    (Safari, Version(14u16, 1u16, 0u16)),
                    (Ios, Version(14u16, 5u16, 0u16)),
                    (Edge, Version(79u16, 0u16, 0u16)),
                    (OperaMobile, Version(51u16, 0u16, 0u16)),
                    (Deno, Version(1u16, 0u16, 0u16)),
                    (Electron, Version(5u16, 0u16, 0u16)),
                    (Opera, Version(60u16, 0u16, 0u16)),
                    (Es, Version(2020u16, 0, 0)),
                ])),
            ),
        ])
    })
}
