/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.HashMap;
import java.util.Map;

public class CoderResult {
    private static final int CR_UNDERFLOW = 0;
    private static final int CR_OVERFLOW = 1;
    private static final int CR_ERROR_MIN = 2;
    private static final int CR_MALFORMED = 2;
    private static final int CR_UNMAPPABLE = 3;
    private static final String[] names = new String[]{"UNDERFLOW", "OVERFLOW", "MALFORMED", "UNMAPPABLE"};
    private final int type;
    private final int length;
    public static final CoderResult UNDERFLOW = new CoderResult(0, 0);
    public static final CoderResult OVERFLOW = new CoderResult(1, 0);
    private static Cache malformedCache = new Cache(){

        @Override
        public CoderResult create(int n) {
            return new CoderResult(2, n);
        }
    };
    private static Cache unmappableCache = new Cache(){

        @Override
        public CoderResult create(int n) {
            return new CoderResult(3, n);
        }
    };

    private CoderResult(int n, int n2) {
        this.type = n;
        this.length = n2;
    }

    public String toString() {
        String string = names[this.type];
        return this.isError() ? string + "[" + this.length + "]" : string;
    }

    public boolean isUnderflow() {
        return this.type == 0;
    }

    public boolean isOverflow() {
        return this.type == 1;
    }

    public boolean isError() {
        return this.type >= 2;
    }

    public boolean isMalformed() {
        return this.type == 2;
    }

    public boolean isUnmappable() {
        return this.type == 3;
    }

    public int length() {
        if (!this.isError()) {
            throw new UnsupportedOperationException();
        }
        return this.length;
    }

    public static CoderResult malformedForLength(int n) {
        return CoderResult.malformedCache.get(n);
    }

    public static CoderResult unmappableForLength(int n) {
        return CoderResult.unmappableCache.get(n);
    }

    public void throwException() throws CharacterCodingException {
        switch (this.type) {
            case 0: {
                throw new BufferUnderflowException();
            }
            case 1: {
                throw new BufferOverflowException();
            }
            case 2: {
                throw new MalformedInputException(this.length);
            }
            case 3: {
                throw new UnmappableCharacterException(this.length);
            }
        }
        assert (false);
    }

    private static abstract class Cache {
        private Map<Integer, WeakReference<CoderResult>> cache = null;

        private Cache() {
        }

        protected abstract CoderResult create(int var1);

        private synchronized CoderResult get(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Non-positive length");
            }
            Integer n2 = new Integer(n);
            CoderResult coderResult = null;
            if (this.cache == null) {
                this.cache = new HashMap<Integer, WeakReference<CoderResult>>();
            } else {
                WeakReference<CoderResult> weakReference = this.cache.get(n2);
                if (weakReference != null) {
                    coderResult = (CoderResult)weakReference.get();
                }
            }
            if (coderResult == null) {
                coderResult = this.create(n);
                this.cache.put(n2, new WeakReference<CoderResult>(coderResult));
            }
            return coderResult;
        }
    }
}

