#include <stddef.h>
#include <stdint.h>
#include "types.h"
#include "base32.h"

static const u8 base32f[256] = {
	//00    01    02    03    04    05    06    07
	//08    09    0A    0B    0C    0D    0E    0F
	// 0x00..0x3F
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 0x00
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 0x08
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 0x10
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 0x18
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 0x20
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 0x28
	0xFF, 0xFF, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, // 0x30
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 0x38
	// 0x40..0x7F
	0xFF, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, // 0x40
	0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, // 0x48
	0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, // 0x50
	0x17, 0x18, 0x19, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 0x58
	0xFF, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, // 0x60
	0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, // 0x68
	0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, // 0x70
	0x17, 0x18, 0x19, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 0x78
	// 0x80..0xBF
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	// 0xC0..0xFF
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};
/*
+--first octet--+-second octet--+--third octet--+--forth octet--+--fifth octet--+
|7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0|7 6 5 4 3 2 1 0|
+---------+-----+---+---------+-+-------+-------+-+---------+---+-----+---------+
|4 3 2 1 0|4 3 2 1 0|4 3 2 1 0|4 3 2 1 0|4 3 2 1 0|4 3 2 1 0|4 3 2 1 0|4 3 2 1 0|
+-1.index-+-2.index-+-3.index-+-4.index-+-5.index-+-6.index-+-7.index-+-8.index-+
*/
size_t base32_from(u8 *dst,u8 *dmask,const char *src)
{
	size_t i, j, k = (size_t)-1, l, sk = 0;
	u8 mask = 0, cmask = 0;
	for (i = 0;;i += 5) {
		j = i/5;
		if (!src[j]) {
			if (k != (size_t)-1)
				dst[k] &= cmask;
			if (dmask)
				*dmask = cmask;
			return k + 1;
		}
		l = i%8;
		k = i/8;
		if (k != sk)
			cmask = 0;
		sk = k;
		mask = (0x1F << 3) >> l;
		cmask |= mask;
		//printf("1:m[%02X] cm[%02X]\n",mask,cmask);
		dst[k] &= ~mask;
		dst[k] |= (base32f[(u8)src[j]] << 3) >> l;
		if (((0x1F << 8) >> (l+5-8)) & 0xFF) {
			++k;
			sk = k;
			mask = ((0x1F << 8) >> (l+5-8)) & 0xFF;
			cmask = mask;
			//printf("2:m[%02X] cm[%02X]\n",mask,cmask);
			dst[k] &= ~mask;
			dst[k] |= ((base32f[(u8)src[j]] << 8) >> (l+5-8)) & 0xFF;
		}
		//printf("i = %02d, i/8 = %02d, i%8 = %02d, i%8+5-8 = %02d\n", i, i/8, i%8, i%8+5-8);
		//printf("mask0: %02x\n", (0x1F << 3) >> (i%8));
		//printf("mask1: %02x\n", ((0x1F << 8) >> (i%8+5-8)) & 0xFF);
	}
}

int base32_valid(const char *src,size_t *count)
{
	const char *p;

	for (p = src;base32f[(u8)*p] != 0xFF;++p)
		;

	if (count)
		*count = (size_t) (p - src);
	return !*p;
}
