//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvpixelbufferpool?language=objc)
#[doc(alias = "CVPixelBufferPoolRef")]
#[repr(C)]
pub struct CVPixelBufferPool {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CVPixelBufferPool {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CVPixelBufferPool"> for CVPixelBufferPool {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvpixelbufferpoolminimumbuffercountkey?language=objc)
    pub static kCVPixelBufferPoolMinimumBufferCountKey: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvpixelbufferpoolmaximumbufferagekey?language=objc)
    pub static kCVPixelBufferPoolMaximumBufferAgeKey: &'static CFString;
}

unsafe impl ConcreteType for CVPixelBufferPool {
    #[doc(alias = "CVPixelBufferPoolGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CVPixelBufferPoolGetTypeID() -> CFTypeID;
        }
        unsafe { CVPixelBufferPoolGetTypeID() }
    }
}

impl CVPixelBufferPool {
    /// Creates a new Pixel Buffer pool.
    ///
    /// Parameter `allocator`: The CFAllocatorRef to use for allocating this buffer pool.  May be NULL.
    ///
    /// Parameter `attributes`: A CFDictionaryRef containing the attributes to be used for creating new PixelBuffers within the pool.
    ///
    /// Parameter `poolOut`: The newly created pool will be placed here
    ///
    /// Returns: Returns kCVReturnSuccess on success
    ///
    /// # Safety
    ///
    /// - `pool_attributes` generics must be of the correct type.
    /// - `pixel_buffer_attributes` generics must be of the correct type.
    /// - `pool_out` must be a valid pointer.
    #[doc(alias = "CVPixelBufferPoolCreate")]
    #[cfg(feature = "CVReturn")]
    #[inline]
    pub unsafe fn create(
        allocator: Option<&CFAllocator>,
        pool_attributes: Option<&CFDictionary>,
        pixel_buffer_attributes: Option<&CFDictionary>,
        pool_out: NonNull<*mut CVPixelBufferPool>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVPixelBufferPoolCreate(
                allocator: Option<&CFAllocator>,
                pool_attributes: Option<&CFDictionary>,
                pixel_buffer_attributes: Option<&CFDictionary>,
                pool_out: NonNull<*mut CVPixelBufferPool>,
            ) -> CVReturn;
        }
        unsafe {
            CVPixelBufferPoolCreate(
                allocator,
                pool_attributes,
                pixel_buffer_attributes,
                pool_out,
            )
        }
    }

    /// Returns the pool attributes dictionary for a CVPixelBufferPool
    ///
    /// Parameter `pool`: The CVPixelBufferPoolRef to retrieve the attributes from
    ///
    /// Returns: Returns the pool attributes dictionary, or NULL on failure.
    #[doc(alias = "CVPixelBufferPoolGetAttributes")]
    #[inline]
    pub fn attributes(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CVPixelBufferPoolGetAttributes(
                pool: &CVPixelBufferPool,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CVPixelBufferPoolGetAttributes(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the attributes of pixel buffers that will be created from this pool.
    ///
    /// This function is provided for those cases where you may need to know some information about the buffers that
    /// will be created up front.
    ///
    /// Parameter `pool`: The CVPixelBufferPoolRef to retrieve the attributes from
    ///
    /// Returns: Returns the pixel buffer attributes dictionary, or NULL on failure.
    #[doc(alias = "CVPixelBufferPoolGetPixelBufferAttributes")]
    #[inline]
    pub fn pixel_buffer_attributes(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CVPixelBufferPoolGetPixelBufferAttributes(
                pool: &CVPixelBufferPool,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CVPixelBufferPoolGetPixelBufferAttributes(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Creates a new PixelBuffer object from the pool.
    ///
    /// The function creates a new (attachment-free) CVPixelBuffer using the pixel buffer attributes specifed during pool creation.
    ///
    /// Parameter `allocator`: The CFAllocatorRef to use for creating the pixel buffer.  May be NULL.
    ///
    /// Parameter `pool`: The CVPixelBufferPool that should create the new CVPixelBuffer.
    ///
    /// Parameter `pixelBufferOut`: The newly created pixel buffer will be placed here
    ///
    /// Returns: Returns kCVReturnSuccess on success
    ///
    /// # Safety
    ///
    /// `pixel_buffer_out` must be a valid pointer.
    #[doc(alias = "CVPixelBufferPoolCreatePixelBuffer")]
    #[cfg(all(
        feature = "CVBuffer",
        feature = "CVImageBuffer",
        feature = "CVPixelBuffer",
        feature = "CVReturn"
    ))]
    #[inline]
    pub unsafe fn create_pixel_buffer(
        allocator: Option<&CFAllocator>,
        pixel_buffer_pool: &CVPixelBufferPool,
        pixel_buffer_out: NonNull<*mut CVPixelBuffer>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVPixelBufferPoolCreatePixelBuffer(
                allocator: Option<&CFAllocator>,
                pixel_buffer_pool: &CVPixelBufferPool,
                pixel_buffer_out: NonNull<*mut CVPixelBuffer>,
            ) -> CVReturn;
        }
        unsafe {
            CVPixelBufferPoolCreatePixelBuffer(allocator, pixel_buffer_pool, pixel_buffer_out)
        }
    }

    /// # Safety
    ///
    /// - `aux_attributes` generics must be of the correct type.
    /// - `pixel_buffer_out` must be a valid pointer.
    #[doc(alias = "CVPixelBufferPoolCreatePixelBufferWithAuxAttributes")]
    #[cfg(all(
        feature = "CVBuffer",
        feature = "CVImageBuffer",
        feature = "CVPixelBuffer",
        feature = "CVReturn"
    ))]
    #[inline]
    pub unsafe fn create_pixel_buffer_with_aux_attributes(
        allocator: Option<&CFAllocator>,
        pixel_buffer_pool: &CVPixelBufferPool,
        aux_attributes: Option<&CFDictionary>,
        pixel_buffer_out: NonNull<*mut CVPixelBuffer>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVPixelBufferPoolCreatePixelBufferWithAuxAttributes(
                allocator: Option<&CFAllocator>,
                pixel_buffer_pool: &CVPixelBufferPool,
                aux_attributes: Option<&CFDictionary>,
                pixel_buffer_out: NonNull<*mut CVPixelBuffer>,
            ) -> CVReturn;
        }
        unsafe {
            CVPixelBufferPoolCreatePixelBufferWithAuxAttributes(
                allocator,
                pixel_buffer_pool,
                aux_attributes,
                pixel_buffer_out,
            )
        }
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvpixelbufferpoolallocationthresholdkey?language=objc)
    pub static kCVPixelBufferPoolAllocationThresholdKey: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvpixelbufferpoolfreebuffernotification?language=objc)
    pub static kCVPixelBufferPoolFreeBufferNotification: &'static CFString;
}

/// Flags to pass to CVPixelBufferPoolFlush()
///
/// This flag will cause CVPixelBufferPoolFlush to flush all unused buffers regardless of age.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvpixelbufferpoolflushflags?language=objc)
// NS_OPTIONS
#[cfg(feature = "CVBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CVPixelBufferPoolFlushFlags(pub CVOptionFlags);
#[cfg(feature = "CVBase")]
bitflags::bitflags! {
    impl CVPixelBufferPoolFlushFlags: CVOptionFlags {
        #[doc(alias = "kCVPixelBufferPoolFlushExcessBuffers")]
        const ExcessBuffers = 1;
    }
}

#[cfg(all(feature = "CVBase", feature = "objc2"))]
unsafe impl Encode for CVPixelBufferPoolFlushFlags {
    const ENCODING: Encoding = CVOptionFlags::ENCODING;
}

#[cfg(all(feature = "CVBase", feature = "objc2"))]
unsafe impl RefEncode for CVPixelBufferPoolFlushFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CVPixelBufferPool {
    /// Frees as many buffers from the pool as possible.
    ///
    /// By default, this function will free all aged out buffers.  Setting the
    /// kCVPixelBufferPoolFlushExcessBuffers flag will cause this call to free all unused
    /// buffers regardless of age.
    ///
    /// Parameter `pool`: The CVPixelBufferPool to be flushed.
    ///
    /// Parameter `options`: Set to kCVPixelBufferPoolFlushExcessBuffers to free all unused buffers
    /// regardless of their age.
    #[doc(alias = "CVPixelBufferPoolFlush")]
    #[cfg(feature = "CVBase")]
    #[inline]
    pub fn flush(&self, options: CVPixelBufferPoolFlushFlags) {
        extern "C-unwind" {
            fn CVPixelBufferPoolFlush(
                pool: &CVPixelBufferPool,
                options: CVPixelBufferPoolFlushFlags,
            );
        }
        unsafe { CVPixelBufferPoolFlush(self, options) }
    }
}

extern "C-unwind" {
    #[cfg(feature = "CVReturn")]
    #[deprecated = "renamed to `CVPixelBufferPool::create`"]
    pub fn CVPixelBufferPoolCreate(
        allocator: Option<&CFAllocator>,
        pool_attributes: Option<&CFDictionary>,
        pixel_buffer_attributes: Option<&CFDictionary>,
        pool_out: NonNull<*mut CVPixelBufferPool>,
    ) -> CVReturn;
}

#[deprecated = "renamed to `CVPixelBufferPool::attributes`"]
#[inline]
pub extern "C-unwind" fn CVPixelBufferPoolGetAttributes(
    pool: &CVPixelBufferPool,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CVPixelBufferPoolGetAttributes(
            pool: &CVPixelBufferPool,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CVPixelBufferPoolGetAttributes(pool) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CVPixelBufferPool::pixel_buffer_attributes`"]
#[inline]
pub extern "C-unwind" fn CVPixelBufferPoolGetPixelBufferAttributes(
    pool: &CVPixelBufferPool,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CVPixelBufferPoolGetPixelBufferAttributes(
            pool: &CVPixelBufferPool,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CVPixelBufferPoolGetPixelBufferAttributes(pool) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(all(
        feature = "CVBuffer",
        feature = "CVImageBuffer",
        feature = "CVPixelBuffer",
        feature = "CVReturn"
    ))]
    #[deprecated = "renamed to `CVPixelBufferPool::create_pixel_buffer`"]
    pub fn CVPixelBufferPoolCreatePixelBuffer(
        allocator: Option<&CFAllocator>,
        pixel_buffer_pool: &CVPixelBufferPool,
        pixel_buffer_out: NonNull<*mut CVPixelBuffer>,
    ) -> CVReturn;
}

extern "C-unwind" {
    #[cfg(all(
        feature = "CVBuffer",
        feature = "CVImageBuffer",
        feature = "CVPixelBuffer",
        feature = "CVReturn"
    ))]
    #[deprecated = "renamed to `CVPixelBufferPool::create_pixel_buffer_with_aux_attributes`"]
    pub fn CVPixelBufferPoolCreatePixelBufferWithAuxAttributes(
        allocator: Option<&CFAllocator>,
        pixel_buffer_pool: &CVPixelBufferPool,
        aux_attributes: Option<&CFDictionary>,
        pixel_buffer_out: NonNull<*mut CVPixelBuffer>,
    ) -> CVReturn;
}

#[cfg(feature = "CVBase")]
#[deprecated = "renamed to `CVPixelBufferPool::flush`"]
#[inline]
pub extern "C-unwind" fn CVPixelBufferPoolFlush(
    pool: &CVPixelBufferPool,
    options: CVPixelBufferPoolFlushFlags,
) {
    extern "C-unwind" {
        fn CVPixelBufferPoolFlush(pool: &CVPixelBufferPool, options: CVPixelBufferPoolFlushFlags);
    }
    unsafe { CVPixelBufferPoolFlush(pool, options) }
}
