//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
// 
// G4LowDataH2O.hh -- header file
//
// GEANT 4 class header file --- Copyright CERN 1995
// CERB Geneva Switzerland
//
// for information related to this code, please, contact
// CERN, CN Division, ASD Group
//
// Preparation of ionizing collision cross section according to Photo Absorption 
// Ionization (PAI) model for simulation of ionization energy losses in very thin
// layers of water for low energy protons and electrons.
//
// Author: Vladimir.Grichine@cern.ch
//
// History:
// 
// 2.12.24, V. Grichine: 1st version

#ifndef G4LOWDATAH2O_HH
#define G4LOWDATAH2O_HH

#include "G4LowPAIH2O.hh"

// The data array size

const G4int G4LowPAIH2O:: theBin = 1007;

/////////////////////////////////////////
//
// Transfer energies in Geant4 units (MeV)

const G4double G4LowPAIH2O::theEsum[1007] = {
  
1.00084e-07, 1.00315e-07, 1.00778e-07, 1.01243e-07, 1.01711e-07, 1.01945e-07,
1.02416e-07, 1.02888e-07, 1.03363e-07, 1.0384e-07, 1.0408e-07, 1.0456e-07,
1.05043e-07, 1.05528e-07, 1.06015e-07, 1.06504e-07, 1.06996e-07, 1.07242e-07,
1.07737e-07, 1.08235e-07, 1.08734e-07, 1.09348e-07, 1.0974e-07, 1.10247e-07,
1.10756e-07, 1.11267e-07, 1.11781e-07, 1.12296e-07, 1.12815e-07, 1.13336e-07,
1.13859e-07, 1.14384e-07, 1.14912e-07, 1.15443e-07, 1.15975e-07, 1.16511e-07,
1.17049e-07, 1.17589e-07, 1.18132e-07, 1.18677e-07, 1.19225e-07, 1.19775e-07,
1.20328e-07, 1.20883e-07, 1.21441e-07, 1.22283e-07, 1.22786e-07, 1.23414e-07,
1.23984e-07, 1.24557e-07, 1.25131e-07, 1.25999e-07, 1.2658e-07, 1.27165e-07,
1.27752e-07, 1.28341e-07, 1.29231e-07, 1.29827e-07, 1.30427e-07, 1.31331e-07,
1.31937e-07, 1.32546e-07, 1.33465e-07, 1.34081e-07, 1.347e-07, 1.35633e-07,
1.36259e-07, 1.36888e-07, 1.37837e-07, 1.38473e-07, 1.39433e-07, 1.40077e-07,
1.41048e-07, 1.41699e-07, 1.42353e-07, 1.4334e-07, 1.44333e-07, 1.44999e-07,
1.46005e-07, 1.46678e-07, 1.47695e-07, 1.48377e-07, 1.49405e-07, 1.5044e-07,
1.51135e-07, 1.52183e-07, 1.53238e-07, 1.53945e-07, 1.55012e-07, 1.56087e-07,
1.56807e-07, 1.57894e-07, 1.58989e-07, 1.60091e-07, 1.61201e-07, 1.61945e-07,
1.63067e-07, 1.64197e-07, 1.65336e-07, 1.66482e-07, 1.67636e-07, 1.68798e-07,
1.69968e-07, 1.71146e-07, 1.72332e-07, 1.73527e-07, 1.74729e-07, 1.75941e-07,
1.7716e-07,  1.78388e-07, 1.79625e-07, 1.8087e-07, 1.82124e-07, 1.83809e-07,
1.85083e-07, 1.86366e-07, 1.87658e-07, 1.89394e-07, 1.90707e-07, 1.92029e-07,
1.93806e-07, 1.95149e-07, 1.96955e-07, 1.9832e-07, 2.00155e-07, 2.01542e-07,
2.03407e-07, 2.04817e-07, 2.06712e-07, 2.08145e-07, 2.10071e-07, 2.12015e-07,
2.13977e-07, 2.1546e-07, 2.17453e-07, 2.19466e-07, 2.21496e-07, 2.23546e-07,
2.25614e-07, 2.27702e-07, 2.29809e-07, 2.31935e-07, 2.34081e-07, 2.36248e-07,
2.38433e-07, 2.40639e-07, 2.42866e-07, 2.45678e-07, 2.47951e-07, 2.50245e-07,
2.53143e-07, 2.55485e-07, 2.58444e-07, 2.60835e-07, 2.63856e-07, 2.66911e-07,
2.69381e-07, 2.725e-07, 2.75655e-07, 2.78847e-07, 2.82076e-07, 2.85342e-07,
2.88646e-07, 2.91989e-07, 2.9537e-07, 2.9879e-07, 3.0225e-07, 3.06455e-07,
3.10003e-07, 3.13593e-07, 3.17956e-07, 3.22379e-07, 3.26112e-07, 3.30648e-07,
3.35248e-07, 3.39912e-07, 3.44641e-07, 3.49435e-07, 3.54296e-07, 3.59225e-07,
3.65062e-07, 3.7014e-07, 3.75289e-07, 3.81387e-07, 3.87584e-07, 3.93882e-07,
4.00282e-07, 4.06786e-07, 4.13396e-07, 4.15304e-07, 4.16262e-07, 4.18183e-07,
4.19147e-07, 4.20113e-07, 4.22052e-07, 4.23025e-07, 4.24e-07, 4.24978e-07,
4.2694e-07,  4.27924e-07, 4.2891e-07, 4.29899e-07, 4.31883e-07, 4.32879e-07,
4.33877e-07, 4.34877e-07, 4.36884e-07, 4.37891e-07, 4.38901e-07, 4.39912e-07,
4.40927e-07, 4.42962e-07, 4.43983e-07, 4.45006e-07, 4.46032e-07, 4.48091e-07,
4.49124e-07, 4.50159e-07, 4.51197e-07, 4.52237e-07, 4.54325e-07, 4.55372e-07,
4.56422e-07, 4.57474e-07, 4.58528e-07, 4.59585e-07, 4.61707e-07, 4.62771e-07,
4.63838e-07, 4.64907e-07, 4.65979e-07, 4.67053e-07, 4.6813e-07, 4.70291e-07,
4.71375e-07, 4.72461e-07, 4.7355e-07, 4.74642e-07, 4.75736e-07, 4.77932e-07,
4.79034e-07, 4.80138e-07, 4.81245e-07, 4.82355e-07, 4.83467e-07, 4.85698e-07,
4.8794e-07,  4.90192e-07, 4.92455e-07, 4.9359e-07, 4.95868e-07, 4.98157e-07,
5.00456e-07, 5.0161e-07, 5.03926e-07, 5.06251e-07, 5.08588e-07, 5.09761e-07,
5.12114e-07, 5.14477e-07, 5.16852e-07, 5.19238e-07, 5.20435e-07, 5.22837e-07,
5.2525e-07,  5.27675e-07, 5.3011e-07, 5.32557e-07, 5.35015e-07, 5.36249e-07,
5.38724e-07, 5.41211e-07, 5.43709e-07, 5.46218e-07, 5.4874e-07, 5.51273e-07,
5.53817e-07, 5.53894e-07, 5.58941e-07, 5.61521e-07, 5.64113e-07, 5.66717e-07,
5.69333e-07, 5.71961e-07, 5.74601e-07, 5.77253e-07, 5.79918e-07, 5.82594e-07,
5.85284e-07, 5.87985e-07, 5.90699e-07, 5.93426e-07, 5.96165e-07, 5.98917e-07,
6.01681e-07, 6.04458e-07, 6.07248e-07, 6.11458e-07, 6.1428e-07, 6.17115e-07,
6.19964e-07, 6.22825e-07, 6.257e-07, 6.30037e-07, 6.32945e-07, 6.35867e-07,
6.38802e-07, 6.41751e-07, 6.46199e-07, 6.49182e-07, 6.52178e-07, 6.56699e-07,
6.5973e-07,  6.62775e-07, 6.65835e-07, 6.7045e-07, 6.73545e-07, 6.78213e-07,
6.81344e-07, 6.84489e-07, 6.89233e-07, 6.92415e-07, 6.97214e-07, 7.00433e-07,
7.03666e-07, 7.08543e-07, 7.11814e-07, 7.16748e-07, 7.20056e-07, 7.25047e-07,
7.30073e-07, 7.33443e-07, 7.38527e-07, 7.41936e-07, 7.47079e-07, 7.52257e-07,
7.55729e-07, 7.60968e-07, 7.6448e-07, 7.69779e-07, 7.75115e-07, 7.80488e-07,
7.84091e-07, 7.89526e-07, 7.94999e-07, 8.00509e-07, 8.04204e-07, 8.09779e-07,
8.15392e-07, 8.21044e-07, 8.26735e-07, 8.32465e-07, 8.38236e-07, 8.44046e-07,
8.49897e-07, 8.55788e-07, 8.6172e-07, 8.67694e-07, 8.73708e-07, 8.79764e-07,
8.85862e-07, 8.92003e-07, 8.98186e-07, 9.04412e-07, 9.10681e-07, 9.19108e-07,
9.25478e-07, 9.31894e-07, 9.38353e-07, 9.47036e-07, 9.536e-07, 9.6021e-07,
9.69095e-07, 9.75812e-07, 9.84842e-07, 9.91668e-07, 1.00084e-06, 1.00778e-06,
1.01711e-06, 1.02416e-06, 1.03363e-06, 1.0408e-06, 1.05043e-06, 1.06015e-06,
1.06996e-06, 1.07737e-06, 1.08734e-06, 1.0974e-06, 1.10756e-06, 1.11781e-06,
1.12815e-06, 1.13859e-06, 1.14912e-06, 1.15976e-06, 1.17049e-06, 1.18132e-06,
1.19225e-06, 1.20328e-06, 1.21441e-06, 1.22847e-06, 1.23984e-06, 1.24557e-06,
1.25131e-06, 1.25999e-06, 1.2658e-06, 1.27165e-06, 1.27752e-06, 1.28341e-06,
1.29231e-06, 1.29827e-06, 1.30427e-06, 1.31331e-06, 1.31937e-06, 1.32546e-06,
1.33465e-06, 1.34081e-06, 1.347e-06, 1.35633e-06, 1.36259e-06, 1.36888e-06,
1.37837e-06, 1.38473e-06, 1.39433e-06, 1.40077e-06, 1.41048e-06, 1.41699e-06,
1.42353e-06, 1.4334e-06, 1.44333e-06, 1.44999e-06, 1.46004e-06, 1.46678e-06,
1.47695e-06, 1.48377e-06, 1.49405e-06, 1.50441e-06, 1.51129e-06, 1.52183e-06,
1.53238e-06, 1.53945e-06, 1.55012e-06, 1.56087e-06, 1.56807e-06, 1.57894e-06,
1.58989e-06, 1.60091e-06, 1.612e-06, 1.61945e-06, 1.63067e-06, 1.64197e-06,
1.65336e-06, 1.66482e-06, 1.67636e-06, 1.68798e-06, 1.69968e-06, 1.71146e-06,
1.72332e-06, 1.73527e-06, 1.7473e-06, 1.75941e-06, 1.7716e-06, 1.78388e-06,
1.79625e-06, 1.8087e-06, 1.82124e-06, 1.83809e-06, 1.85083e-06, 1.86366e-06,
1.87658e-06, 1.89394e-06, 1.90707e-06, 1.92029e-06, 1.93806e-06, 1.95149e-06,
1.96955e-06, 1.9832e-06, 2.00155e-06, 2.01542e-06, 2.03407e-06, 2.04817e-06,
2.06712e-06, 2.08145e-06, 2.10071e-06, 2.12015e-06, 2.13977e-06, 2.1546e-06,
2.17447e-06, 2.19465e-06, 2.21496e-06, 2.23546e-06, 2.25614e-06, 2.27702e-06,
2.29809e-06, 2.31935e-06, 2.34081e-06, 2.36247e-06, 2.38433e-06, 2.40639e-06,
2.42866e-06, 2.45678e-06, 2.47951e-06, 2.50245e-06, 2.53143e-06, 2.55485e-06,
2.58444e-06, 2.60835e-06, 2.63856e-06, 2.66911e-06, 2.69381e-06, 2.725e-06,
2.75655e-06, 2.78847e-06, 2.82076e-06, 2.85342e-06, 2.88646e-06, 2.91989e-06,
2.9537e-06,  2.9879e-06, 3.0225e-06, 3.06455e-06, 3.10003e-06, 3.13593e-06,
3.17955e-06, 3.22379e-06, 3.26112e-06, 3.30648e-06, 3.35248e-06, 3.39912e-06,
3.4464e-06,  3.49435e-06, 3.54296e-06, 3.59225e-06, 3.65062e-06, 3.7014e-06,
3.75289e-06, 3.81387e-06, 3.87584e-06, 3.93882e-06, 4.00282e-06, 4.06786e-06,
4.13396e-06, 4.20113e-06, 4.27924e-06, 4.34877e-06, 4.42962e-06, 4.51197e-06,
4.59585e-06, 4.6813e-06, 4.76833e-06, 4.85698e-06, 4.95868e-06, 5.06252e-06,
5.16852e-06, 5.27669e-06, 5.38724e-06, 5.51272e-06, 5.64113e-06, 5.77253e-06,
5.90699e-06, 6.04458e-06, 6.19964e-06, 6.35867e-06, 6.52178e-06, 6.7045e-06,
6.89233e-06, 7.08543e-06, 7.11814e-06, 7.20056e-06, 7.30073e-06, 7.38527e-06,
7.47079e-06, 7.55729e-06, 7.6448e-06, 7.75115e-06, 7.84091e-06, 7.94999e-06,
8.04204e-06, 8.15392e-06, 8.26735e-06, 8.38236e-06, 8.49897e-06, 8.6172e-06,
8.73708e-06, 8.85863e-06, 8.98186e-06, 9.10681e-06, 9.25478e-06, 9.38353e-06,
9.536e-06, 9.69095e-06, 9.84841e-06, 1.00084e-05, 1.01711e-05, 1.03363e-05,
1.05043e-05, 1.06996e-05, 1.08734e-05, 1.10756e-05, 1.12815e-05, 1.14912e-05,
1.17049e-05, 1.19225e-05, 1.21441e-05, 1.23984e-05, 1.2658e-05, 1.29231e-05,
1.31937e-05, 1.347e-05, 1.37837e-05, 1.41048e-05, 1.44333e-05, 1.47695e-05,
1.51135e-05, 1.55012e-05, 1.58989e-05, 1.63067e-05, 1.67636e-05, 1.72332e-05,
1.7654e-05, 1.82124e-05, 1.87658e-05, 1.93806e-05, 2.00155e-05, 2.06712e-05,
2.13977e-05, 2.18265e-05, 2.24077e-05, 2.30044e-05, 2.3617e-05, 2.42459e-05,
2.48915e-05, 2.55543e-05, 2.62348e-05, 2.69334e-05, 2.76507e-05, 2.8387e-05,
2.91429e-05, 2.99189e-05, 3.07157e-05, 3.15336e-05, 3.23733e-05, 3.32354e-05,
3.41204e-05, 3.5029e-05, 3.59618e-05, 3.69194e-05, 3.79025e-05, 3.89119e-05,
3.99481e-05, 4.10118e-05, 4.21039e-05, 4.32251e-05, 4.43762e-05, 4.55579e-05,
4.6771e-05, 4.80165e-05, 4.92951e-05, 5.06078e-05, 5.19555e-05, 5.3339e-05,
5.47594e-05, 5.62176e-05, 5.77146e-05, 5.92515e-05, 6.08293e-05, 6.24491e-05,
6.41121e-05, 6.58193e-05, 6.75721e-05, 6.93714e-05, 7.12187e-05, 7.31152e-05,
7.50622e-05, 7.70611e-05, 7.91131e-05, 8.12198e-05, 8.33827e-05, 8.56031e-05,
8.78826e-05, 9.02228e-05, 9.26254e-05, 9.50919e-05, 9.76241e-05, 0.000100224,
0.000102893, 0.000105633, 0.000108445, 0.000111333, 0.000114298, 0.000117342,
0.000120466, 0.000123674, 0.000126968, 0.000130349, 0.00013382, 0.000137383,
0.000141042, 0.000144797, 0.000148653, 0.000152612, 0.000156676, 0.000160848,
0.000165131, 0.000169528, 0.000174043, 0.000178677, 0.000183435, 0.00018832,
0.000193335, 0.000198483, 0.000203769, 0.000209195, 0.000214765, 0.000220484,
0.000226356, 0.000232383, 0.000238572, 0.000244925, 0.000251447, 0.000258143,
0.000265017, 0.000272074, 0.000279319, 0.000286757, 0.000294393, 0.000302232,
0.000310281, 0.000318543, 0.000327026, 0.000335734, 0.000344674, 0.000353853,
0.000363275, 0.000372949, 0.00038288, 0.000393076, 0.000403544, 0.00041429,
0.000425322, 0.000436648, 0.000448275, 0.000460212, 0.000472467, 0.000485049,
0.000497965, 0.000511226, 0.000524839, 0.000538815, 0.000553163, 0.000567894,
0.000583016, 0.000598541, 0.00061448, 0.000630843, 0.000647642, 0.000664888,
0.000682593, 0.00070077, 0.000719431, 0.000738589, 0.000758257, 0.000778448,
0.000799178, 0.000820459, 0.000842307, 0.000864737, 0.000887764, 0.000911405,
0.000935675, 0.000960591, 0.000986171, 0.00101243, 0.00103939, 0.00106707,
0.00109548, 0.00112466, 0.0011546, 0.00118535, 0.00121692, 0.00124932,
0.00128259, 0.00131674, 0.00135181, 0.0013878, 0.00142476, 0.0014627, 0.00150165,
0.00154164, 0.00158269, 0.00162484, 0.00166811, 0.00171253, 0.00175813,
0.00180495, 0.00185301, 0.00190235, 0.00195301, 0.00200502, 0.00205841,
0.00211322, 0.0021695, 0.00222727, 0.00228658, 0.00234747, 0.00240998,
0.00247416, 0.00254004, 0.00260768, 0.00267712, 0.00274841, 0.0028216,
0.00289674, 0.00297387, 0.00305306, 0.00313436, 0.00321783, 0.00330352,
0.00339149, 0.0034818, 0.00357452, 0.0036697, 0.00376742, 0.00386775, 0.00397074,
0.00407648, 0.00418503, 0.00429648, 0.00441089, 0.00452835, 0.00464893,
0.00477273, 0.00489982, 0.0050303, 0.00516425, 0.00530177, 0.00544295,
0.00558789, 0.00573669, 0.00588946, 0.00604629, 0.0062073, 0.00637259,
0.00654229, 0.0067165, 0.00689536, 0.00707898, 0.00726748, 0.00746101,
0.00765969, 0.00786366, 0.00807306, 0.00828804, 0.00850874, 0.00873532,
0.00896794, 0.00920675, 0.00945191, 0.00970361, 0.00996201, 0.0102273,
0.0104996, 0.0107792, 0.0110663, 0.0113609, 0.0116635, 0.0119741, 0.0122929,
0.0126203, 0.0129564, 0.0133014, 0.0136556, 0.0140192, 0.0143925, 0.0147758,
0.0151692, 0.0155732, 0.0159879, 0.0164136, 0.0168507, 0.0172994, 0.0177601,
0.018233, 0.0187186, 0.019217, 0.0197288, 0.0202541, 0.0207935, 0.0213472,
0.0219156, 0.0224992, 0.0230984, 0.0237135, 0.0243449, 0.0249932, 0.0256588,
0.026342, 0.0270435, 0.0277636, 0.028503, 0.029262, 0.0300412, 0.0308412,
0.0316624, 0.0325056, 0.0333712, 0.0342598, 0.0351721, 0.0361087, 0.0370703,
0.0380574, 0.0390709, 0.0401113, 0.0411794, 0.042276, 0.0434017, 0.0445575,
0.045744, 0.0469622, 0.0482127, 0.0494966, 0.0508146, 0.0521678, 0.053557,
0.0549831, 0.0564473, 0.0579504, 0.0594936, 0.0610779, 0.0627043, 0.0643741,
0.0660883, 0.0678482, 0.0696549, 0.0715097, 0.073414, 0.0753689, 0.0773759,
0.0794364, 0.0815517, 0.0837234, 0.0859528, 0.0882417, 0.0905915, 0.0930039,
0.0954805, 0.098023, 0.100633, 0.103313, 0.106064, 0.108889, 0.111788, 0.114765,
0.117821, 0.120959, 0.12418, 0.127486, 0.130881, 0.134366, 0.137945, 0.141618,
0.145389, 0.149261, 0.153235, 0.157316, 0.161505, 0.165806, 0.170221, 0.174754,
0.179407, 0.184185, 0.18909, 0.194125, 0.199294, 0.204601, 0.21005, 0.215643,
0.221385, 0.227281, 0.233333, 0.239546, 0.245925, 0.252474, 0.259197, 0.266099,
0.273185, 0.28046, 0.287929, 0.295596, 0.303467, 0.311549, 0.319845, 0.328362,
0.337106, 0.346083, 0.355299, 0.36476, 0.374473, 0.384445, 0.394682, 0.405192,
0.415982, 0.42706, 0.438432, 0.450107, 0.462093, 0.474398, 0.487031

};

////////////////////////////////////////////////////
//
// Energy Loss Fuction (ELF) for water

const G4double G4LowPAIH2O::theELFsum[1007] = {

0.343701, 0.338322, 0.331699, 0.32522, 0.32051, 0.313544, 0.304649, 0.297559,
0.289704, 0.282644, 0.274489, 0.264361, 0.255236, 0.245748, 0.236871, 0.228919,
0.221906, 0.214845, 0.206271, 0.198028, 0.190106, 0.182071, 0.173805, 0.166123,
0.159188, 0.151848, 0.14468, 0.138038, 0.132675, 0.127068, 0.121363, 0.116174,
0.110695, 0.10539, 0.100535, 0.0958877, 0.0916441, 0.0878014, 0.0841337,
0.0806099, 0.0774056, 0.0731865, 0.0718562, 0.0685493, 0.065072, 0.0645778,
0.0627131, 0.0611187, 0.0595864, 0.0582351, 0.0570597, 0.0556476, 0.0545836,
0.0535382, 0.0526438, 0.051649, 0.0505599, 0.0496273, 0.0489336, 0.0479354,
0.0472902, 0.0466596, 0.0457391, 0.0451427, 0.0444471, 0.0437851, 0.0432295,
0.0426777, 0.0419665, 0.0414367, 0.0408504, 0.0403443, 0.0397835, 0.0392967,
0.0389018, 0.0383693, 0.0378514, 0.0374829, 0.0369796, 0.0367081, 0.0362265,
0.0358779, 0.0355725, 0.035119, 0.0348648, 0.0344976, 0.0341371, 0.0338999,
0.0335476, 0.0332797, 0.0330546, 0.0327189, 0.0323864, 0.032056, 0.0318024,
0.0316622, 0.0313428, 0.031206, 0.0309285, 0.0307598, 0.0305957, 0.0303611,
0.0301941, 0.0301014, 0.0298693, 0.0297723, 0.0296079, 0.0294363, 0.029396,
0.0294251, 0.0293818, 0.0294662, 0.0296168, 0.0297788, 0.0301786, 0.0307169,
0.0315479, 0.0327722, 0.0342432, 0.036205, 0.0384716, 0.0420536, 0.0476498,
0.0574523, 0.0721343, 0.106124, 0.117998, 0.120116, 0.109687, 0.0915872,
0.066625, 0.0458, 0.0343237, 0.0254945, 0.0204653, 0.0164614, 0.0138845,
0.0121716, 0.0110882, 0.0102305, 0.0153323, 0.00922561, 0.00907538, 0.00912068,
0.0092554, 0.00966081, 0.0100684, 0.0106331, 0.0111436, 0.0117403, 0.0122232,
0.0128286, 0.0133119, 0.013764, 0.0139136, 0.0137185, 0.0130353, 0.012035,
0.0109236, 0.0100244, 0.00902829, 0.00812679, 0.00734715, 0.00657945, 0.00593111,
0.00533323, 0.0047942, 0.00429417, 0.00387625, 0.00348138, 0.0031574, 0.00290842,
0.00278184, 0.00275416, 0.00287829, 0.00334779, 0.00401539, 0.00521023,
0.00708225, 0.0097644, 0.0140521, 0.0183347, 0.0250544, 0.0399675, 0.0587405,
0.0840311, 0.121028, 0.160966, 0.203027, 0.211079, 0.217312, 0.227821, 0.235095,
0.24169, 0.252298, 0.258592, 0.262752, 0.265536, 0.276661, 0.275552, 0.274533,
0.269661, 0.270219, 0.265797, 0.257128, 0.245891, 0.23504, 0.223146, 0.208363,
0.193196, 0.17773, 0.164163, 0.153071, 0.141107, 0.126677, 0.113678, 0.101827,
0.0886036, 0.0743801, 0.0618476, 0.0499254, 0.0367243, 0.0261855, 0.0232968,
0.0202302, 0.0176638, 0.0151418, 0.0124048, 0.0100069, 0.00849212, 0.00721195,
0.00611224, 0.00488681, 0.00485658, 0.00444412, 0.00363214, 0.00325423,
0.00293729, 0.0027827, 0.00264948, 0.00258351, 0.00253143, 0.00246953,
0.00243187, 0.00237879, 0.00223043, 0.00214095, 0.00207511, 0.00203558,
0.00199335, 0.00192966, 0.00183032, 0.00172071, 0.00158785, 0.00147243,
0.0013439, 0.00124105, 0.00114029, 0.001058, 0.000975114, 0.000892649,
0.000830566, 0.000773989, 0.000723575, 0.000665725, 0.000616754, 0.000579494,
0.000523586, 0.00049199, 0.000472557, 0.000449239, 0.000431062, 0.000409861,
0.000388832, 0.000370606, 0.000354888, 0.000338291, 0.000326973, 0.000321925,
0.000319208, 0.000317914, 0.000318873, 0.000322065, 0.000328313, 0.000335467,
0.000345962, 0.000356796, 0.000369682, 0.000388372, 0.000408962, 0.00043066,
0.000452471, 0.000489845, 0.000529109, 0.000572854, 0.000621666, 0.000680914,
0.000740288, 0.000816467, 0.000908885, 0.00100946, 0.00114474, 0.00128348,
0.00141561, 0.00156923, 0.00168858, 0.00174342, 0.00175514, 0.00166801,
0.0015318, 0.00105924, 0.000840322, 0.000657855, 0.000473997, 0.00029131,
0.000168926, 0.000140695, 0.000128445, 0.000124845, 0.000123977, 0.000122763,
0.00012008, 0.00010938, 0.000100936, 9.46588e-05, 8.99595e-05, 8.5502e-05,
7.99431e-05, 7.54954e-05, 7.22003e-05, 6.93847e-05, 6.79397e-05, 6.70749e-05,
6.62253e-05, 6.61113e-05, 6.77887e-05, 7.05426e-05, 7.2218e-05, 7.40878e-05,
7.84424e-05, 8.32266e-05, 8.84459e-05, 9.52342e-05, 0.00010135, 0.000110116,
0.000119698, 0.000127913, 0.000142122, 0.000154316, 0.000173446, 0.000199033,
0.000235344, 0.000266991, 0.000299439, 0.00031852, 0.000321345, 0.000320485,
0.00031236, 0.000282171, 0.000224058, 0.000134947, 9.34181e-05, 6.87239e-05,
5.10966e-05, 3.96443e-05, 3.55887e-05, 2.50008e-05, 1.97753e-05, 1.67933e-05,
1.43874e-05, 1.22857e-05, 1.07103e-05, 9.9882e-06, 9.55529e-06, 9.45036e-06,
9.63188e-06, 9.96535e-06, 1.01485e-05, 1.03076e-05, 1.0405e-05, 1.04779e-05,
1.03146e-05, 1.01275e-05, 9.76685e-06, 9.32094e-06, 8.1128e-06, 5.18542e-06,
3.36972e-06, 2.28825e-06, 1.77385e-06, 1.48604e-06, 1.30301e-06, 1.1547e-06,
1.09367e-06, 1.128e-06, 1.23206e-06, 1.46642e-06, 1.73534e-06, 2.03945e-06,
2.32915e-06, 2.59852e-06, 2.71171e-06, 2.81681e-06, 2.88823e-06, 2.95867e-06,
3.01136e-06, 3.02957e-06, 2.99639e-06, 2.90383e-06, 2.75796e-06, 2.53457e-06,
2.20994e-06, 1.87411e-06, 1.52972e-06, 1.18165e-06, 9.14966e-07, 7.1684e-07,
5.77823e-07, 4.91715e-07, 4.44251e-07, 4.19278e-07, 3.98474e-07, 3.79573e-07,
3.6493e-07, 3.49207e-07, 3.36684e-07, 3.22787e-07, 3.05344e-07, 2.88179e-07,
2.71379e-07, 2.52029e-07, 2.31401e-07, 2.11463e-07, 1.92818e-07, 1.75395e-07,
1.56274e-07, 1.39251e-07, 1.24357e-07, 1.14166e-07, 1.09005e-07, 1.07229e-07,
1.07939e-07, 1.09923e-07, 1.14802e-07, 1.20729e-07, 1.2667e-07, 1.30778e-07,
1.34412e-07, 1.353e-07, 1.35255e-07, 1.33352e-07, 1.30877e-07, 1.24656e-07,
1.1523e-07, 9.82685e-08, 7.80301e-08, 6.22455e-08, 5.11626e-08, 4.26378e-08,
3.49651e-08, 2.85412e-08, 2.52526e-08, 2.26017e-08, 2.10365e-08, 2.03456e-08,
1.85169e-08, 1.784e-08, 1.72669e-08, 1.64828e-08, 1.50933e-08, 1.42117e-08,
1.36272e-08, 1.3309e-08, 1.31507e-08, 1.34033e-08, 1.24588e-08, 1.1836e-08,
1.1246e-08, 1.04646e-08, 9.5612e-09, 8.13265e-09, 6.5166e-09, 5.36704e-09,
4.39996e-09, 3.7338e-09, 3.23547e-09, 2.88829e-09, 2.63234e-09, 2.41013e-09,
2.23222e-09, 2.04846e-09, 1.90159e-09, 1.75712e-09, 1.57936e-09, 1.46947e-09,
1.37036e-09, 1.31071e-09, 1.21947e-09, 1.05641e-09, 8.98271e-10, 7.69237e-10,
6.52693e-10, 6.09908e-10, 5.94159e-10, 5.8809e-10, 5.80861e-10, 6.03393e-10,
6.19614e-10, 6.27668e-10, 6.43036e-10, 6.66392e-10, 7.14854e-10, 7.68705e-10,
8.35919e-10, 8.92526e-10, 9.57347e-10, 1.02921e-09, 1.09379e-09, 1.1597e-09,
1.21236e-09, 1.28534e-09, 1.35021e-09, 1.42768e-09, 1.48883e-09, 1.56739e-09,
1.63815e-09, 1.70417e-09, 1.78093e-09, 1.85677e-09, 1.93572e-09, 2.01793e-09,
2.1132e-09, 2.19675e-09, 2.28431e-09, 2.35885e-09, 2.42877e-09, 2.50647e-09,
2.60432e-09, 2.76878e-09, 2.97722e-09, 3.21569e-09, 3.40185e-09, 3.68834e-09,
4.14105e-09, 4.40767e-09, 4.77438e-09, 5.17213e-09, 5.58864e-09, 5.96795e-09,
6.38569e-09, 6.85652e-09, 7.24103e-09, 7.60813e-09, 7.70074e-09, 7.84358e-09,
8.16024e-09, 8.84067e-09, 1.37338e-08, 2.60346e-08, 4.4736e-08, 7.19727e-08,
1.18248e-07, 2.25675e-07, 7.52606e-07, 3.45946e-05, 0.000184565, 0.000635798,
0.00103903, 0.0019317, 0.0182683, 0.0322752, 0.0456558, 0.0590582, 0.0728399,
0.0887233, 0.105449, 0.120398, 0.137241, 0.147511, 0.150233, 0.144037, 0.133044,
0.119254, 0.102717, 0.0833649, 0.0724089, 0.073295, 0.085751, 0.105138, 0.125623,
0.143651, 0.15568, 0.163681, 0.170532, 0.176964, 0.183206, 0.190715, 0.199072,
0.206747, 0.214796, 0.224665, 0.235198, 0.247949, 0.261726, 0.278921, 0.299982,
0.324028, 0.349266, 0.377322, 0.406436, 0.438649, 0.470931, 0.498468, 0.524826,
0.548057, 0.567545, 0.58861, 0.623154, 0.745122, 0.731576, 0.795212, 0.864073,
0.916613, 0.925369, 0.899703, 0.244356, 0.252615, 0.261018, 0.269569, 0.27827,
0.28712, 0.296119, 0.305263, 0.31455, 0.323972, 0.333522, 0.343189, 0.35296,
0.362819, 0.372747, 0.382722, 0.392719, 0.402707, 0.412654, 0.422523, 0.43227,
0.44185, 0.451211, 0.460298, 0.46905, 0.477403, 0.48529, 0.492639, 0.499376,
0.504367, 0.509777, 0.514929, 0.518523, 0.521151, 0.522737, 0.523212, 0.522524,
0.520632, 0.517512, 0.513156, 0.507572, 0.500784, 0.492833, 0.483774, 0.473678,
0.462625, 0.450709, 0.438027, 0.424686, 0.410794, 0.39646, 0.381793, 0.366898,
0.351875, 0.336819, 0.321818, 0.306951, 0.292288, 0.272404, 0.258131, 0.244245,
0.230786, 0.217783, 0.205262, 0.193237, 0.18172, 0.170717, 0.160228, 0.15025,
0.140775, 0.131796, 0.123299, 0.11527, 0.107696, 0.100558, 0.0938403, 0.0875248,
0.0815935, 0.0760284, 0.0708116, 0.0659252, 0.0613519, 0.0570747, 0.0530771,
0.0493433, 0.0458578, 0.0426059, 0.0395735, 0.0367473, 0.0341144, 0.0316626,
0.0293804, 0.0272569, 0.0252818, 0.0234452, 0.0217382, 0.0201519, 0.0186783,
0.0173098, 0.0160392, 0.0148597, 0.0137651, 0.0127495, 0.0118075, 0.0109337,
0.0101236, 0.00937242, 0.00867615, 0.00803086, 0.00743288, 0.00687884,
0.00636558, 0.00589016, 0.00544984, 0.00504208, 0.00466452, 0.00431495,
0.00399133, 0.00369177, 0.0034145, 0.00315789, 0.00292042, 0.00336515,
0.00310903, 0.00287178, 0.0026521, 0.00244876, 0.00226062, 0.00208661,
0.00192571, 0.00177698, 0.00163954, 0.00151256, 0.00139527, 0.00128696,
0.00118696, 0.00109464, 0.00100944, 0.000930809, 0.000858257, 0.000791323,
0.000729578, 0.000672625, 0.000620099, 0.000571659, 0.000526992, 0.000485805,
0.000447831, 0.000412821, 0.000380545, 0.000350791, 0.000323363, 0.000298079,
0.000274774, 0.000253293, 0.000233492, 0.000215242, 0.000198421, 0.000182917,
0.000168626, 0.000155455, 0.000143316, 0.000132126, 0.000121813, 0.000112308,
0.000103546, 9.547e-05, 8.8026e-05, 8.11643e-05, 7.48394e-05, 6.90091e-05,
6.36347e-05, 5.86803e-05, 5.4113e-05, 4.99025e-05, 4.60209e-05, 4.24422e-05,
3.91429e-05, 3.6101e-05, 3.32964e-05, 3.07105e-05, 2.83261e-05, 2.61275e-05,
2.41002e-05, 2.22307e-05, 2.05068e-05, 1.8917e-05, 1.74509e-05, 1.60987e-05,
1.48518e-05, 1.37016e-05, 1.26409e-05, 1.16625e-05, 1.07601e-05, 9.92771e-06,
9.1599e-06, 8.45163e-06, 7.79829e-06, 7.19558e-06, 6.63956e-06, 6.12673e-06,
5.65369e-06, 5.21733e-06, 4.81479e-06, 4.44345e-06, 4.10087e-06, 3.78481e-06,
3.49321e-06, 3.22417e-06, 2.97593e-06, 2.74688e-06, 2.53553e-06, 2.34051e-06,
2.16054e-06, 1.99446e-06, 1.8412e-06, 1.69976e-06, 1.56922e-06, 1.44874e-06,
1.33754e-06, 1.23491e-06, 1.14018e-06, 1.05274e-06, 9.72031e-07, 8.97527e-07,
8.28751e-07, 7.65262e-07, 7.06652e-07, 6.52544e-07, 6.02591e-07, 5.56473e-07,
5.13895e-07, 4.74583e-07, 4.38287e-07, 4.04775e-07, 3.73831e-07, 3.45259e-07,
3.18877e-07, 2.94515e-07, 2.7202e-07, 2.51246e-07, 2.32063e-07, 2.14348e-07,
1.97988e-07, 1.8288e-07, 1.68927e-07, 1.56041e-07, 1.4414e-07, 1.33148e-07,
1.22997e-07, 1.13621e-07, 1.04961e-07, 9.69623e-08, 8.95744e-08, 8.27505e-08,
7.64473e-08, 7.06252e-08, 6.52472e-08, 6.02795e-08, 5.56907e-08, 5.14518e-08,
4.75361e-08, 4.39188e-08, 4.05772e-08, 3.74902e-08, 3.46383e-08, 3.20037e-08,
2.95698e-08, 2.73212e-08, 2.52438e-08, 2.33245e-08, 2.15513e-08, 1.99131e-08,
1.83995e-08, 1.70011e-08, 1.5709e-08, 1.45153e-08, 1.34123e-08, 1.23933e-08,
1.14517e-08, 1.05817e-08, 9.77786e-09, 9.03513e-09, 8.34886e-09, 7.71475e-09,
7.12884e-09, 6.58746e-09, 6.08722e-09, 5.62498e-09, 5.19787e-09, 4.80321e-09,
4.43853e-09, 4.10156e-09, 3.79018e-09, 3.50245e-09, 3.23657e-09, 2.99089e-09,
2.76387e-09, 2.55408e-09, 2.36023e-09, 2.18109e-09, 2.01556e-09, 1.8626e-09,
1.72125e-09, 1.59062e-09, 1.46992e-09, 1.35838e-09, 1.2553e-09, 1.16005e-09,
1.07203e-09, 9.90691e-10, 9.15525e-10, 8.46063e-10, 7.81873e-10, 7.22554e-10,
6.67737e-10, 6.1708e-10, 5.70266e-10, 5.27005e-10, 4.87027e-10, 4.50082e-10,
4.15937e-10, 3.84386e-10, 3.55229e-10, 3.28284e-10, 3.03384e-10, 2.80373e-10,
2.59107e-10, 2.39455e-10, 2.21293e-10, 2.04509e-10, 1.88999e-10, 1.74665e-10,
1.61418e-10, 1.49176e-10, 1.37863e-10, 1.27408e-10, 1.17745e-10, 1.08816e-10,
1.00564e-10, 9.29376e-11, 8.58897e-11, 7.93764e-11, 7.33571e-11, 6.77943e-11,
6.26534e-11, 5.79023e-11, 5.35116e-11, 4.94538e-11, 4.57038e-11, 4.22381e-11,
3.90353e-11, 3.60753e-11, 3.33399e-11, 3.08118e-11, 2.84755e-11, 2.63163e-11,
2.43209e-11, 2.24767e-11, 2.07724e-11, 1.91974e-11, 1.77418e-11, 1.63965e-11,
1.51533e-11, 1.40043e-11, 1.29425e-11, 1.19612e-11, 1.10542e-11, 1.02161e-11,
9.44151e-12, 8.72564e-12, 8.06406e-12, 7.45264e-12, 6.88758e-12, 6.36536e-12,
5.88274e-12, 5.43672e-12, 5.02451e-12, 4.64356e-12, 4.29149e-12, 3.96612e-12,
3.66541e-12

};

//////////////////////////////
//
// Rutherford term (\int of ELF*omega) of the PAI model for water

const G4double G4LowPAIH2O::theRuthSum[1007] = {

0, 0.000783401, 0.00231191, 0.00379636, 0.00524157, 0.00594579, 0.00730817,
0.00862143, 0.00988839, 0.0111095, 0.0116985, 0.0128262, 0.0138996, 0.0149204,
0.0158897, 0.0168116, 0.0176908, 0.0181112, 0.0189103, 0.0196636, 0.0203729,
0.021186, 0.0216702, 0.0222506, 0.0227922, 0.0232961, 0.0237622, 0.0241923,
0.024591, 0.0249609, 0.0253014, 0.0256139, 0.025899, 0.0261568, 0.026389,
0.0265973, 0.0267833, 0.026949, 0.027096, 0.0272252, 0.0273377, 0.0274322,
0.0275132, 0.0275827, 0.0276361, 0.0277017, 0.0277353, 0.0277681, 0.0277901,
0.0278054, 0.0278147, 0.0278197, 0.0278173, 0.0278101, 0.0277985, 0.0277827,
0.0277521, 0.0277273, 0.027699, 0.0276512, 0.0276159, 0.0275781, 0.0275166,
0.0274727, 0.0274261, 0.0273525, 0.0273011, 0.0272477, 0.0271642, 0.0271063,
0.0270167, 0.0269551, 0.0268601, 0.0267951, 0.0267287, 0.026627, 0.0265231,
0.0264526, 0.0263451, 0.0262724, 0.0261621, 0.0260875, 0.0259747, 0.0258608,
0.0257841, 0.0256682, 0.0255515, 0.0254732, 0.025355, 0.0252364, 0.025157,
0.0250375, 0.0249173, 0.0247964, 0.0246752, 0.0245945, 0.0244731, 0.0243519,
0.0242309, 0.0241101, 0.0239897, 0.0238696, 0.0237499, 0.0236308, 0.0235123,
0.0233943, 0.023277, 0.0231601, 0.0230442, 0.0229297, 0.0228169, 0.0227057,
0.0225968, 0.0224554, 0.0223529, 0.0222551, 0.0221633, 0.0220523, 0.0219796,
0.0219197, 0.0218604, 0.0218367, 0.0218475, 0.0219083, 0.0220998, 0.0224082,
0.0230219, 0.0235228, 0.024142, 0.0245011, 0.0247757, 0.0248363, 0.0247485,
0.0246141, 0.0243745, 0.0240981, 0.0237967, 0.0234813, 0.0231588, 0.0228334,
0.0225333, 0.022234, 0.0219117, 0.0215947, 0.0212845, 0.0209824, 0.0206894,
0.0203363, 0.0200645, 0.0198027, 0.0194883, 0.0192469, 0.0189576, 0.0187351,
0.0184661, 0.018203, 0.0179929, 0.017726, 0.0174531, 0.017175, 0.0168925,
0.0166056, 0.0163156, 0.0160235, 0.0157299, 0.015436, 0.0151422, 0.0147915,
0.0145013, 0.014213, 0.0138709, 0.0135342, 0.0132585, 0.0129349, 0.0126208,
0.0123193, 0.0120337, 0.0117686, 0.0115317, 0.0113322, 0.0111617, 0.0110782,
0.0110721, 0.0112368, 0.0116636, 0.0124264, 0.0136592, 0.0154631, 0.0178602,
0.0186456, 0.019052, 0.0198976, 0.0203379, 0.0207921, 0.0217337, 0.0222207,
0.0227174, 0.0232199, 0.0242497, 0.0247726, 0.0252907, 0.0257995, 0.0268004,
0.027293, 0.0277682, 0.0282184, 0.029062, 0.0294548, 0.0298151, 0.0301393,
0.0304269, 0.0309315, 0.0311538, 0.0313486, 0.0315121, 0.0317741, 0.0318756,
0.0319479, 0.0319883, 0.0319978, 0.0319606, 0.0319133, 0.0318389, 0.0317495,
0.0316536, 0.0315517, 0.0313376, 0.0312253, 0.0311076, 0.0309859, 0.0308616,
0.0307351, 0.0306065, 0.0303482, 0.0302194, 0.0300899, 0.0299595, 0.029829,
0.0296985, 0.0294387, 0.0293095, 0.0291807, 0.0290523, 0.0289245, 0.0287971,
0.0285437, 0.028292, 0.0280423, 0.0277946, 0.0276715, 0.0274268, 0.027184,
0.0269429, 0.0268229, 0.026584, 0.0263467, 0.0261111, 0.0259939, 0.0257606,
0.0255291, 0.0252993, 0.0250713, 0.024958, 0.0247326, 0.024509, 0.0242873,
0.0240673, 0.0238492, 0.0236329, 0.0235254, 0.0233118, 0.0231001, 0.0228903,
0.0226823, 0.022476, 0.0222716, 0.022069, 0.022063, 0.0216692, 0.021472,
0.0212766, 0.021083, 0.0208912, 0.0207011, 0.0205129, 0.0203264, 0.0201416,
0.0199586, 0.0197774, 0.0195979, 0.0194202, 0.0192441, 0.0190699, 0.0188974,
0.0187266, 0.0185577, 0.0183905, 0.0181431, 0.0179803, 0.0178194, 0.0176605,
0.0175035, 0.0173486, 0.0171198, 0.0169697, 0.0168216, 0.0166752, 0.0165303,
0.0163153, 0.016173, 0.0160307, 0.0158173, 0.0156757, 0.0155346, 0.0153939,
0.0151843, 0.0150458, 0.0148403, 0.0147048, 0.0145705, 0.0143715, 0.0142403,
0.0140457, 0.0139174, 0.0137902, 0.0136017, 0.0134774, 0.013293, 0.0131715,
0.0129913, 0.0128135, 0.0126964, 0.0125226, 0.0124081, 0.0122383, 0.0120709,
0.0119605, 0.0117969, 0.0116891, 0.0115292, 0.0113716, 0.0112162, 0.0111138,
0.0109619, 0.0108123, 0.0106647, 0.0105675, 0.0104234, 0.0102814, 0.0101415,
0.0100036, 0.00986787, 0.00973419, 0.00960257, 0.00947294, 0.00934516,
0.00921914, 0.00909482, 0.00897207, 0.00885071, 0.0087305, 0.0086115, 0.0084939,
0.00837777, 0.00826314, 0.00811266, 0.00800156, 0.00789193, 0.00778377,
0.00764184, 0.00753708, 0.00743375, 0.00729816, 0.0071981, 0.0070668, 0.00696991,
0.00684278, 0.00674896, 0.00662588, 0.00653504, 0.00641585, 0.0063279,
0.00621249, 0.00609919, 0.00598796, 0.00590586, 0.00579813, 0.00569234,
0.00558847, 0.00548648, 0.00538636, 0.00528806, 0.00519155, 0.00509681,
0.00500379, 0.00491247, 0.00482282, 0.00473481, 0.00464841, 0.00454262,
0.00445973, 0.00441886, 0.00437835, 0.0043183, 0.00427872, 0.00423951,
0.00420066, 0.00416216, 0.00410507, 0.00406745, 0.00403017, 0.00397489,
0.00393846, 0.00390236, 0.00384883, 0.00381354, 0.00377859, 0.00372675,
0.00369258, 0.00365873, 0.00360853, 0.00357545, 0.0035264, 0.00349407,
0.00344613, 0.00341454, 0.00338323, 0.00333682, 0.00329104, 0.00326086,
0.00321613, 0.00318664, 0.00314292, 0.00311411, 0.00307138, 0.00302924,
0.00300172, 0.00296029, 0.00291967, 0.00289291, 0.00285321, 0.00281407,
0.00278827, 0.00275001, 0.00271228, 0.00267507, 0.00263837, 0.00261418,
0.00257831, 0.00254294, 0.00250805, 0.00247364, 0.0024397, 0.00240622,
0.00237321, 0.00234065, 0.00230854, 0.00227686, 0.00224562, 0.00221481,
0.00218442, 0.00215445, 0.00212489, 0.00209574, 0.00206698, 0.00202926,
0.00200141, 0.00197395, 0.00194687, 0.00191134, 0.00188511, 0.00185925,
0.00182531, 0.00180027, 0.00176741, 0.00174316, 0.00171134, 0.00168786,
0.00165706, 0.00163432, 0.00160449, 0.00158248, 0.00155359, 0.00152524,
0.0014974, 0.00147685, 0.00144998, 0.00142343, 0.00139745, 0.00137195,
0.00134691, 0.00132232, 0.00129819, 0.00127449, 0.00125123, 0.00122839,
0.00120597, 0.00118396, 0.00116235, 0.00113589, 0.00111516, 0.00109481,
0.00106989, 0.00105036, 0.00102645, 0.00100771, 0.000984776, 0.00096236,
0.000944795, 0.000923289, 0.000902272, 0.000881734, 0.000861663, 0.000842049,
0.000822882, 0.000804151, 0.000785846, 0.000767958, 0.000750477, 0.000730025,
0.000713407, 0.000697168, 0.000678168, 0.000659686, 0.00064467, 0.000627101,
0.000610011, 0.000593386, 0.000577215, 0.000561484, 0.000546182, 0.000531297,
0.000514444, 0.000500424, 0.000486786, 0.000471344, 0.000456392, 0.000441914,
0.000427896, 0.000414322, 0.000401179, 0.000388453, 0.000374402, 0.000362525,
0.000349412, 0.000336774, 0.000324593, 0.000312852, 0.000301536, 0.000290629,
0.00027883, 0.00026751, 0.000256649, 0.000246235, 0.000236233, 0.000225601,
0.000215447, 0.000205751, 0.000196491, 0.000187648, 0.000178381, 0.000169572,
0.0001612, 0.000152547, 0.000144823, 0.000139991, 0.000140589, 0.000146924,
0.000163174, 0.00027459, 0.000556121, 0.000987089, 0.00156066, 0.00241699,
0.00328156, 0.00451532, 0.00569793, 0.00729826, 0.0090396, 0.0108219, 0.0125318,
0.0140779, 0.015413, 0.016505, 0.0173227, 0.0179117, 0.0184991, 0.0190787,
0.0199878, 0.0211842, 0.0226481, 0.0243037, 0.0260656, 0.0278894, 0.0297607,
0.0319413, 0.0338936, 0.0361926, 0.0385534, 0.040971, 0.0434633, 0.0460499,
0.0487535, 0.0519478, 0.0553268, 0.0589571, 0.0628979, 0.067179, 0.0723321,
0.0778967, 0.0839009, 0.0903606, 0.0972024, 0.105039, 0.113101, 0.121291,
0.130311, 0.139594, 0.149138, 0.162421, 0.175168, 0.190137, 0.206066, 0.221952,
0.237589, 0.239452, 0.233554, 0.22817, 0.223279, 0.21886, 0.214892, 0.211355,
0.208231, 0.205504, 0.203155, 0.20117, 0.199533, 0.198228, 0.197241, 0.196558,
0.196165, 0.196047, 0.196192, 0.196584, 0.19721, 0.198054, 0.199103, 0.200341,
0.201752, 0.203318, 0.205023, 0.206849, 0.208777, 0.210786, 0.212842, 0.214926,
0.217038, 0.219155, 0.221242, 0.223276, 0.225233, 0.227086, 0.228812, 0.230385,
0.231782, 0.23298, 0.233958, 0.234697, 0.235181, 0.235394, 0.235326, 0.234967,
0.234312, 0.233357, 0.232103, 0.230551, 0.228707, 0.22658, 0.224178, 0.221515,
0.218602, 0.215457, 0.212095, 0.208462, 0.204579, 0.200534, 0.196346, 0.192033,
0.187615, 0.183109, 0.178532, 0.173902, 0.169233, 0.164542, 0.159841, 0.155145,
0.150466, 0.145815, 0.141203, 0.136638, 0.13213, 0.127686, 0.123312, 0.119015,
0.114801, 0.110672, 0.106635, 0.10269, 0.098842, 0.0950917, 0.0914411, 0.0878912,
0.0844426, 0.0810957, 0.0778502, 0.0747058, 0.0716619, 0.0687174, 0.0658712,
0.063122, 0.0604682, 0.0579081, 0.05544, 0.0530619, 0.0507717, 0.0485675,
0.046447, 0.0444081, 0.0424485, 0.040566, 0.0387584, 0.0370233, 0.0353586,
0.0337619, 0.0322311, 0.0307639, 0.0293582, 0.0280118, 0.0267226, 0.0254886,
0.0243077, 0.023178, 0.0220975, 0.0210643, 0.0200767, 0.0191328, 0.0182309,
0.0173779, 0.016571, 0.015799, 0.0150607, 0.0143549, 0.0136801, 0.0130353,
0.0124192, 0.0118306, 0.0112686, 0.0107319, 0.0102196, 0.00973068, 0.00926409,
0.00881894, 0.0083943, 0.00798931, 0.00760313, 0.00723493, 0.00688394, 0.0065494,
0.00623059, 0.00592681, 0.00563739, 0.0053617, 0.00509911, 0.00484903,
0.00461089, 0.00438416, 0.0041683, 0.00396282, 0.00376724, 0.0035811, 0.00340396,
0.00323541, 0.00307504, 0.00292246, 0.00277732, 0.00263926, 0.00250794,
0.00238305, 0.00226428, 0.00215134, 0.00204394, 0.00194183, 0.00184475,
0.00175246, 0.00166472, 0.00158132, 0.00150205, 0.0014267, 0.00135509,
0.00128704, 0.00122237, 0.00116091, 0.00110251, 0.00104702, 0.000994296,
0.000944203, 0.000896612, 0.000851398, 0.000808446, 0.000767644, 0.000728884,
0.000692067, 0.000657096, 0.000623879, 0.00059233, 0.000562366, 0.000533908,
0.000506881, 0.000481213, 0.000456838, 0.00043369, 0.000411709, 0.000390836,
0.000371015, 0.000352195, 0.000334325, 0.000317357, 0.000301246, 0.000285949,
0.000271426, 0.000257637, 0.000244546, 0.000232118, 0.000220318, 0.000209116,
0.000198482, 0.000188387, 0.000178803, 0.000169705, 0.000161069, 0.00015287,
0.000145088, 0.000137701, 0.000130689, 0.000124033, 0.000117714, 0.000111717,
0.000106025, 0.000100622, 9.54938e-05, 9.06262e-05, 8.60062e-05, 8.16212e-05,
7.74592e-05, 7.35091e-05, 6.976e-05, 6.62017e-05, 6.28245e-05, 5.96193e-05,
5.65774e-05, 5.36904e-05, 5.09504e-05, 4.835e-05, 4.58822e-05, 4.35401e-05,
4.13173e-05, 3.92079e-05, 3.7206e-05, 3.53062e-05, 3.35033e-05, 3.17923e-05,
3.01685e-05, 2.86276e-05, 2.71653e-05, 2.57776e-05, 2.44607e-05, 2.3211e-05,
2.20251e-05, 2.08997e-05, 1.98318e-05, 1.88184e-05, 1.78567e-05, 1.69441e-05,
1.60781e-05, 1.52563e-05, 1.44765e-05, 1.37365e-05, 1.30343e-05, 1.2368e-05,
1.17357e-05, 1.11357e-05, 1.05664e-05, 1.00261e-05, 9.51346e-06, 9.02701e-06,
8.56541e-06, 8.1274e-06, 7.71178e-06, 7.31739e-06, 6.94317e-06, 6.58807e-06,
6.25112e-06, 5.9314e-06, 5.62801e-06, 5.34014e-06, 5.06699e-06, 4.8078e-06,
4.56186e-06, 4.3285e-06, 4.10707e-06, 3.89696e-06, 3.69759e-06, 3.50843e-06,
3.32893e-06, 3.15861e-06, 2.99701e-06, 2.84367e-06, 2.69817e-06, 2.56011e-06,
2.42912e-06, 2.30482e-06, 2.18689e-06, 2.07498e-06, 1.9688e-06, 1.86806e-06,
1.77246e-06, 1.68176e-06, 1.5957e-06, 1.51404e-06, 1.43655e-06, 1.36304e-06,
1.29328e-06, 1.22709e-06, 1.16429e-06, 1.1047e-06, 1.04816e-06, 9.94518e-07,
9.43617e-07, 8.95321e-07, 8.49496e-07, 8.06016e-07, 7.64762e-07, 7.25618e-07,
6.88477e-07, 6.53238e-07, 6.19801e-07, 5.88076e-07, 5.57974e-07, 5.29413e-07,
5.02314e-07, 4.76602e-07, 4.52205e-07, 4.29057e-07, 4.07094e-07, 3.86255e-07,
3.66483e-07, 3.47723e-07, 3.29922e-07, 3.13033e-07, 2.97009e-07, 2.81805e-07,
2.67378e-07, 2.53691e-07, 2.40704e-07, 2.28381e-07, 2.1669e-07, 2.05597e-07,
1.95071e-07, 1.85085e-07, 1.7561e-07, 1.66619e-07, 1.58089e-07, 1.49996e-07,
1.42317e-07, 1.35031e-07, 1.28118e-07, 1.21559e-07, 1.15335e-07, 1.09431e-07,
1.03828e-07, 9.85126e-08, 9.3469e-08, 8.86837e-08, 8.41433e-08, 7.98354e-08,
7.5748e-08, 7.18699e-08, 6.81903e-08, 6.46991e-08, 6.13866e-08, 5.82437e-08,
5.52617e-08, 5.24324e-08, 4.97479e-08, 4.72009e-08, 4.47842e-08, 4.24913e-08,
4.03158e-08, 3.82516e-08, 3.62932e-08, 3.4435e-08, 3.26719e-08, 3.09991e-08,
2.9412e-08, 2.79061e-08, 2.64773e-08, 2.51216e-08

};
  
#endif   

//////////////////////   end of G4LowDataH2O header file  ////////////////
