\page ExampleP02 Example P02

## General description


This example shows how to store in a binary file and how to
read back the geometry tree using the 'reflection' technique for
persistency provided by the Reflex tool also included in ROOT. The
Reflex tool allows to create a dictionary for the geometry classes,
making then possible to save the entire tree in a .root file.  

The provided makefile produces the executable: 'exampleP02'. In order
to run it one has to specify the argument, either 'write' or
'read'. In the first case the geometry is instaciated in the standard
way and then saved into the root file (geo.root). In the second case,
the geometry is read from geo.root file.


## Building and running the example

This examples requires the ROOT toolkit of version 6 to be installed. The
provided CMake file checks for the existence of the package and its version. 
Once the CMake configuration has been succesfully done, the executable
for this example should be built using make 
(in your CMake build directory):
```
make
```

## Remark on dictionary generation

The dictionary is generated by ${ROOTSYS}/bin/genreflex
tool. The arguments that will be used by this tool are configured 
in CMakeLists.txt using the CMake function REFLEX_GENERATE_DICTIONARY
provided by ROOT. They include the header file including headers for
all the classes we want to generate the dictionary, and additionally,
a so called selection file (xml). The role of this file is to
specify which classes we want to generate the dictionary for. The
selection file for our dictionary is in xml/ directory. Please refer
to genreflex manual for more details concerning the usage of that
tool.  

Concerning generating dictionary for the Geant4 objects, there are
also two technical remarks that need to be made here. 
The Reflex tool requires all the templated classes to be
explicitely used somewhere in the included header files in order for
the generation of the dictionary to be possible. For those templated
classes for which it is not the case, the problem can be very easily
solved by instaciating them in the headerfile which is given to
genreflex (see ExP02Classes.hh) as argument.  
The second remark is that there is an unfortunate clash of names as
far as G4String class is concerned. The header of G4String class
defines __G4String which happens to be the name of a variable used
within the generated dictionary code. The solution for that is to do
```cpp
#undef __G4String
```
in include/ExP02Classes.hh file.

 