\page Examplegflasha Example gflasha

This example demonstrating usage 'gflash' shower parameterisation
in homogeneous calorimeter. Compare with glash1,2,3 the histograms
have been added in this example. This makes it possible to use this
example for fine tuning of GFLASH parameters.

This example allows to compare the shower profiles from fast simulation
with full simulation by histograming of longitudinal (slice)
and radial profiles with different "binning".
Then GFlash fast simulation can be "tuned" via modification
of the model parameters file:

include/ExGflashHomoShowerTuning.hh

in this example.

## Physics List


The Physics list factory is used in this example.
The default physics list is FTFP_BERT which has EM opt0.
Additionally, the G4FastSimulationPhysics physics
constructor was created to insert the G4FastSimulationManagerProcess
that is making the interface between the fast simulation and the tracking.

The default PHYSICS list may be changed via setting of the PHYSLIST environment
variable, e.g.:

```
export PHYSLIST=FTFP_BERT_EMZ # for FTFP_BERT with opt 4 EM physics
```

## Geometry Definition

In this example the calorimeter is a simple cube,
which consists of 10 x 10 crystals of PbWO4 (CMS like).

Geometry, sensitive detector and hits are defined respectively in:
- ExGflashDetectorConstruction
- ExGflashSensitiveDetector
- ExGflashHit

The geometry can be redefined in PreInit state via commands:

```
/exgflash/det/setNbCrys ncrys
/exgflash/det/setCrysWidth width [cm]
/exgflash/det/setCrysLength length [cm]
```

Materials can be chosen from Nist Materials: G4_Air G4_WATER ...
e.g.:
```
/exgflash/det/setMat G4_PbWO4
```
see also: csi1.mac

## Hit Scoring

The virtual cylinder sliced longitudinally (slice) and radially (ring) was used.
The size of the slices and rings are expressed in radiation
length units and Moliere radius (Rm) units for rings. The number
of division and division size in fraction of units and can be changed.
e.g.:
```
/exgflash/det/setLbin 20   1.    ---> 20 slices of 1. radl
/exgflash/det/setRbin  5   0.25  --->  5 rings of 0.25 Rm
     (MaxBin = 500 in both directions)
```

In ExGflashEventAction class the arrays corresponded slices and rings was
created and filled with hists information. These arrays where use to fill
histograms later.

## Visualization

The Visualization Manager is set in the main().
The initialization of the drawing is done via the commands /vis/...
in the macro vis.mac. To get visualization use:
```
/control/execute vis.mac
```

## How to start ?

- Execute ExGflasha in 'batch' mode from macro files
```
 % ./ExGflasha   test.mac
```

- Execute ExGflasha in 'interactive mode' with visualization
```
 % ./ExGflasha
   ....
  Idle> type your commands
  ....
  Idle> exit
```

The GFLASH activated via:
```
/GFlash/flag 1
```

## Histograms

ExGflasha produces several histograms:
The histograms defined in ExGflashHistoManager class

Content of these histo:

- h0 : energy deposit       per event
- h1 : the number of hits  per event
- h2 : the energy per hit ( in MeV )

- p0 : longitudinal energy profile
- p1 : radial energy profile

- p2 : cumulated longitudinal energy profile
- p3 : cumulated radial energy profile

To define the output file name with histograms, use the UI command :
```
/analysis/setFileName name
```

## Macros

The macros to run in batch mode:

- test.mac - default macro for example testing, it show how to use different application commands: redefine the histograms and profiles, change the geometry and material, etc

- csi.mac - like test.mac but produce profiles in CsI Material

- testLong.mac - make the runs with more statistics using default geometry and histograms setting, the material is G4_PbWO4

- csiLong.mac - show how to run testLong.mac with different material (CsI)

Each macro executes two runs with fast simulation flag ON (the output file
name is set to gflash01.root ) and OFF (the output file name is set to gflash00.root )

In addition, the ROOT macros cmpL.C, cmpR.C and cmpE.C file are provided,
which can be used to draw superimposed full and fast histograms for radial
and lateral profiles and also the normalized total energy deposition
in calorimeter.

See also [Category "parameterisations/gflash"](../../html/Examples_gflash.html) documentation.
