\page ExampleOpNovice2 Example OpNovice2 

Investigate optical properties and parameters. Details of optical
photon boundary interactions on a surface are recorded. Details 
of optical photon generation and transport are recorded. Group velocity
may be examined.

	
## GEOMETRY DEFINITION

 The geometry consists of a cube "box" with a side of 2 m inside 
 the world cube of side 20 m. Optical properties of the box, the world, 
 and the surface may be set interactively via the commands defined 
 in the DetectorMessenger class.

 Material properties may be added using the macro commands:
 - for the box:
```
/opnovice2/boxProperty NAME EN1 V1 EN2 V2 [ .. ENn Vn]
/opnovice2/boxConstProperty NAME VALUE
```
 - for the world:
```
 /opnovice2/worldProperty NAME EN1 V1 EN2 V2 [ .. ENn Vn]
 /opnovice2/worldConstProperty NAME VALUE
```
 - for the surface:
```
 /opnovice2/surfaceProperty NAME EN1 V1 EN2 V2 [ .. ENn Vn]
```

 Multiple energy and value pairs may be specified for the energy-dependent
 properties.

 Values are in Geant4 internal units. Energy is in MeV.

 Example:
```
/opnovice2/boxProperty RINDEX 0.000002 1.3 0.000005 1.32 0.000008 1.34
```
 sets the refractive index of the box to 1.3 at 2 eV, 1.32 at 5 eV, and
 1.34 at 8 eV.

## PHYSICS LIST

 The FTFP_BERT physics list is used, with electromagnetic option 
 EMZ (option4) and G4OpticalPhysics for the optical physics.
 	 
## AN EVENT : THE PRIMARY GENERATOR
 
 The primary kinematic consists of a single particle. The type of 
 the particle, its energy, position, and direction, are set 
 in the PrimaryGeneratorAction class, and can be changed via the G4 
 build-in commands of G4ParticleGun class (see the macros provided with 
 this example).
	
## VISUALIZATION
 
 The Visualization Manager is set in the main().
 The initialisation of the drawing is done via the commands
 /vis/... in the macro vis.mac. To get visualisation:
```
> /control/execute vis.mac
```
 or run the program with no command line arguments:
```
$ ./OpNovice2
```
 	
## HOW TO START ?
 
 - Execute OpNovice2 in 'batch' mode from macro files
```
% ./OpNovice2 electron.mac
```
 		
 - Execute OpNovice2 in 'interactive mode' with visualization
```
% ./OpNovice2
....
Idle> type your commands
....
Idle> exit
```

## RESULTS

 A table of optical photon events is printed at the end of the run.	
 Group velocity is printed with /tracking/verbose 1 or higher.

## HISTOGRAMS
 
   OpNovice2 has several predefined 1D histograms : 
   -  1 : Cerenkov spectrum
   -  2 : scintillation spectrum
   -  3 : scintillation time (global time)
   -  4 : WLS absorption spectrum
   -  5 : WLS emission spectrum
   -  6 : WLS emission time
   -  7 : WLS2 absorption spectrum
   -  8 : WLS2 emission spectrum
   -  9 : WLS2 emission time
   - 10 : boundary process status
   - 11 : X momentum dir of scattered photons with px < 0
   - 12 : Y momentum dir of scattered photons with px < 0
   - 13 : Z momentum dir of scattered photons with px < 0
   - 14 : X momentum dir of scattered photons with px >= 0
   - 15 : Y momentum dir of scattered photons with px >= 0
   - 16 : Z momentum dir of scattered photons with px >= 0
   - 17 : X momentum dir of Fresnel-refracted photons
   - 18 : Y momentum dir of Fresnel-refracted photons
   - 19 : Z momentum dir of Fresnel-refracted photons
   - 20 : fraction of photons refracted (i.e. Fresnel transmission)
   - 21 : fraction of photons Fresnel-reflected
   - 22 : fraction of photons total internal reflected (TIR)
   - 23 : fraction of photons reflected (Fresnel reflection plus TIR)
   - 24 : fraction of photons absorbed at surface
   - 25 : fraction of photons "transmitted" (i.e. TRANSMITTANCE material property)
   - 26 : fraction of photons spike-reflected

   Histograms 11-26 are recorded for photons scattered from the +X
   surface of the cube. Only the first interaction is recorded.  
 
   The histograms are managed by G4Analysis classes. 
   The histos can be individually activated with the command :
```
/analysis/h1/set id nbBins  valMin valMax
```
   The unit is hardcoded to be eV for energy and ns for time.
   
   One can control the name of the histograms file with the command:
```
/analysis/setFileName  name  (default opnovice2)
```
   
   It is possible to choose the format of the histogram file : root (default),
   hdf5, xml, csv, by changing the default file type in HistoManager.cc
   
   It is also possible to print selected histograms on an ascii file:
```
/analysis/h1/setAscii id
```
   All selected histos will be written on a file name.ascii  (default opnovice2) 

## MACROS

 Several macros are included.
 - boundary.mac: Set the surface to the various types and configurations of
               model, type, etc., shoot optical photons, and record statistics.
               This macro uses the command
               /opnovice2/stepping/killOnSecondSurface,
               which kills photon tracks incident on a second surface. This can
               be useful for visualizing surface scattering.
 - coated.mac: To show reflection/refraction from thin film coating
 - electron.mac: Shoot electrons and observe Cerenkov and scintillation radiation
 - fresnel.mac:  Shoot optical photons of fixed polarization and random direction
               at a surface, and plot reflectance/transmittance vs incident
               angle.
 - complexRindex.mac: Use a dielectric-metal surface with a complex index of
               refraction.
 - OpNovice2.mac: Shoot an optical photon inside a box.
 - scint_by_particle.mac: Configure scintillation to have particle-specific
               yields, yield ratios, and time constants. Shoot different types
               of particles.
 - vis.mac:    Configure visualization. The macro command
               /opnovice2/stepping/killOnSecondSurface, which kills photon
               tracks incident on a second surface, may be useful for
               visualizing surface scattering.
 - wls.mac:    Configure two wavelength-shifting processes, and shoot optical
               photons.
