\page Examplednadamage1 Example dnadamage1

This is a new example and it may contain bugs.
It was developed by Hoang Tran.
Damage analysis was developed by Le Tuan Anh.
If you find a bug, please contact IRSN:
yann.perrot@irsn.fr or carmen.villagrasa@irsn.fr

## INTRODUCTION
                                                                       
The dnadamage1 example shows a simple way to simulate dna direct and indirect damages 
using the Geant4-DNA physics and chemical processes in a molecular DNA geometry. 
Moreover, a clustering algorithm is introduced to demonstrate how to extract SSB, DSB (simple, complex).

This example is based on the work described in Sc. Rep. 7 (2017)11923 
and is provided by the Geant4-DNA collaboration.

Any report or published results obtained using the Geant4-DNA software shall 
cite the following Geant4-DNA collaboration publications:
- Phys. Med. 31 (2015) 861-874
- Med. Phys. 37 (2010) 4692-4708

## GEOMETRY SET-UP
 
The geometry is chromatical fiber in a 40-nm side cube (Voxel<straight>) made of liquid water (G4_WATER
material). Particles are randomly shot in a cicle of 5 nm2 radius from left side of the cube.

The DNA chromatical fiber geometry is generated by DnaFabric tool(https://bitbucket.org/sylMeylan/opendnafabric). 
For detail, please see: Sc. Rep. 7 (2017) 11923

## SET-UP
                                                                        
The code can be compiled with cmake.
It works in MT mode.
Chemistry stage is automatically activated. 

## HOW TO RUN THE EXAMPLE

In interactive mode, run:

```
./dnadamage1
```

Note: interactive mode needs at least 6Go of RAM for visualization and may not work correctly in some plateformes.

In batch, the macro dnadamage1.in can be used as bellows. It shows how to shoot different 
particle types and energies.

```
./dnadamage1 dnadamage1.in
```

## PHYSICS

This example shows:
- how to use the Geant4-DNA processes (physics and chemistry) through G4EmDNAPhysics and G4EmDNAChemistry_option2 constructors
(look at the PhysicsList class)
- how to count and save energy depositions giving rise to direct damages using an energy thershold 
of 17.5 eV in teh nucleotide backbone region.
(look at the SteppingAction class)
-how to forbid water radicals to be created at the DNA molecule volume (look at the SteppingAction class)
)

## CHEMISTRY

This example shows: 
- how to add a parallel world for chemistry
- how to add a new reaction of free radicals with a DNA molecule using "Step by step model"
(look at the G4EmDNAChemistry_option2)
- how to count and save occurrences of chemical reactions for indirect damages
(look at to TimeStepAction class)


## SIMULATION OUTPUT AND RESULT ANALYSIS

This file can be easily analyzed using the provided ROOT macro 
file analysis.C (and scandamages.C, molecule.C); The scandamages.C results in a text file using the SDD format: \n
 "A new standard DNA damage (SDD) data format" J. Schuemann et al. Published in Rad. Res. 191 (2019) 76-92

To do so :
- be sure to have ROOT installed on your machine (version 6 series)
- be sure to be in the directory containing the ROOT files created by dnadamage1
- copy analysis.C (and scandamges.C, molecule.C) into this directory
- from there, launch ROOT by typing root
- under your ROOT session, type in : .X analysis.C to execute the macro file
- alternatively you can type directly under your session : root -b analysis.C

Results will be obtained:
- Count numbers of direct and indirect SB (strand break)
- Count numbers of SSB, DSB (simple, complex)
- In function scandamges(), users change:
    - Break-energy to select direct damages (default is 17.5 ev)
    - probability to select indirect damages (default is 40%)
    - minium distance between two clusters (default is 10 bp)
to see how they affect direct/indirect SB, SSB, and DSB.
- Damages in SDD format
---------------------------------------------------------------------------

Contact: ngoc-hoang.tran@irsn.fr, carmen.villagrasa@irsn.fr
