\page ExampleTestEm5 Example TestEm5

 How to study the transmission, absorption and reflection of particles through
 a single, thin or thick, layer of material.
 In particular, the effects of the multiple scattering can be plotted.  
	
## GEOMETRY DEFINITION
 
 The "absorber" is a box made of a given material.                
 	
 Three parameters define the absorber :
 - the material of the absorber,
 - the thickness of an absorber,
 - the transverse size of the absorber (the input face is a square). 
    
 A volume "World" contains the "absorber". 

 In addition a transverse uniform magnetic field can be applied.
 	
 The default geometry is constructed in DetectorConstruction class, but all the
 parameters can be changed via commands defined in the DetectorMessenger class.
 The parameters of the "World" can be changed, too. However, if World material
 is not set to vacuum, the plots 10->43 below may be not pertinent.
 
## PHYSICS LIST

 Physics lists are based on modular design. Several modules are instantiated:
 1. Transportation
 2. EM physics
 3. Decays
 4. StepMax - for step limitation

 EM physics builders can be local (eg. in this example) or from G4 kernel
 physics_lists subdirectory.
     
 Local physics builders:	 
 - "local"   standard EM physics with current 'best' options setting
                 these options are explicited in PhysListEmStandard
 - "standardSSM" standard EM physics with alternative single Coulomb
                 scattering model instead of multiple scattering.

 From geant4/source/physics_lists/builders:
 - "emstandard_opt0" recommended standard EM physics for LHC
 - "emstandard_opt1" best CPU performance standard physics for LHC
 - "emstandard_opt2" similar fast simulation
 - "emstandard_opt3" best standard EM options - analog to "local" above
 - "emstandard_opt4" best current advanced EM options standard + lowenergy
 - "emstandardWVI" standard EM physics and WentzelVI multiple scattering
 - "emstandardSS"  standard EM physics and single scattering model
 - "emlivermore"  low-energy EM physics using Livermore data
 - "empenelope"   low-energy EM physics implementing Penelope models
 - "emlowenergy"  low-energy EM physics implementing experimental
                  low-energy models
           
 Physics lists and options can be (re)set with UI commands
    
 Please, notice that options set through G4EmProcessOptions are global, eg
 for all particle types. In G4 builders, it is shown how to set options per
 particle type.

## AN EVENT : THE PRIMARY GENERATOR
 
 The primary kinematic consists of a single particle which hits the absorber 
 perpendicular to the input face, so the default beam direction is along X 
 axis. The type of the particle and its energy are set in the 
 PrimaryGeneratorAction class, and can be changed via the G4 build-in 
 commands of G4ParticleGun class (see the macros provided with this example).

 If thickness of absorber is changed for some run in the same macro, then
 gun position should be modifined using /gun/position IU command.
 
## VISUALIZATION
 
 The Visualization Manager is set in the main().
 The initialisation of the drawing is done via the commands in vis.mac
 In interactive session:
```
 PreInit or Idle > /control/execute vis.mac
```
 	
 The example has a default view which is a longitudinal view of the detector.
 	
 The tracks are drawn at the end of event, and erased at the end of run.
 Optionally one can choose to draw all particles, only the charged, or none.
 This command is defined in EventActionMessenger class.
 
## TRACKING
 
 During the tracking, one can keep or not the secondaries : see StackingAction
 class and its Messenger (StackingMessenger).
 One can also limit 'by hand' the step lenght of the particle. As an example,
 this limitation is implemented as a 'full' process : see StepMax class and its
 Messenger. The 'StepMax process' is registered in the Physics List. 
  	
## DETECTOR RESPONSE
  	
 At the end of a run, from the histogram(s), one can study different
 physics quantities such as :
 - energy deposit in the absorber,
 - energy spectrum of secondaries at creation, 
 - energy spectrum and angle distribution of particles at exit,
 - transmission and backscattering coefficients,
 -  ...
 
## List of the built-in histograms
        
 The test contains more than 60 built-in 1D histograms, which are managed by
 G4AnalysisManager class and its Messenger. The histos can be individually activated
 with the command :
```
/analysis/h1/set id nbBins  valMin valMax unit 
```
 where unit is the desired unit for the histo (MeV or keV, deg or mrad, etc..)
 (see the macros xxxx.mac).
 
 - 1 :  "energy deposit in absorber"
 - 2 :  "energy of charged secondaries at creation"
 - 3 :  "energy of neutral secondaries at creation"
 - 4 :  "energy of charged at creation (log10(Ekin))"
 - 5 :  "energy of neutral at creation (log10(Ekin))"
 - 6 :  "x_vertex of charged secondaries (all)"
 - 7 :  "x_vertex of charged secondaries (not absorbed)"
 - 10 :  "(transmit, charged) : kinetic energy at exit of world"
 - 11 :  "(transmit, charged) : ener fluence: dE(MeV)/dOmega"      
 - 12 :  "(transmit, charged) : space angle dN/dOmega"
 - 13 :  "(transmit, charged) : projected angle at exit of world"
 - 14 :  "(transmit, charged) : projected position at exit of world"
 - 15 :  "(transmit, charged) : radius at exit of world"   
 - 20 :  "(transmit, neutral) : kinetic energy at exit of world"
 - 21 :  "(transmit, neutral) : ener fluence: dE(MeV)/dOmega"      
 - 22 :  "(transmit, neutral) : space angle dN/dOmega"
 - 23 :  "(transmit, neutral) : projected angle at exit of world"
 - 30 :  "(reflect , charged) : kinetic energy at exit of world"
 - 31 :  "(reflect , charged) : ener fluence: dE(MeV)/dOmega"      
 - 32 :  "(reflect , charged) : space angle dN/dOmega"
 - 33 :  "(reflect , charged) : projected angle at exit of world"
 - 40 :  "(reflect , neutral) : kinetic energy at exit of world"
 - 41 :  "(reflect , neutral) : ener fluence: dE(MeV)/dOmega"      
 - 42 :  "(reflect , neutral) : space angle dN/dOmega"
 - 43 :  "(reflect , neutral) : projected angle at exit of world"
 - 50 :  "energy of Auger e- at creation"
 - 51 :  "energy of fluorescence gamma at creation"
 - 52 :  "energy of Auger e- at creation (log scale)"
 - 53 :  "energy of fluorescence gamma at creation (log scale)"
 - 54 :  "energy of PIXE Auger e- at creation"
 - 55 :  "energy of PIXE gamma at creation"
 - 56 :  "energy of PIXE Auger e- at creation (log scale)"
 - 57 :  "energy of PIXE gamma at creation (log scale)"
 - 58 :  "energy of G4DNA Auger e- at creation"
 - 59 :  "energy of G4DNA gamma at creation"
 - 60 :  "energy of G4DNA Auger e- at creation (log scale)"
 - 61 :  "energy of G4DNA gamma at creation (log scale)"

 One can control the name of the histograms file with the command:
```
/analysis/setFileName  name  (default testem5)
```
    
 It is possible to choose the format of the histogram file : root (default),
 hdf5, xml, csv, by changing the default file type in HistoManager.cc
     
 It is also possible to print selected histograms on an ascii file:
```
/analysis/h1/setAscii id
```
 All selected histos will be written on a file name.ascii  (default testem5) 

## GEANT4/GEANT3/DATA COMPARISON

 A Geant4/Geant3/exp. data comparison is given here for a few cases.
 These cases can be classified as follow:
 - e-/e+ incident particles versus protons and others. 
 - 3 energy regimes: low: < 1MeV; medium: 1MeV -> few 10MeV; high: > 100MeV
 
 We indicate here the corresponding macros.
<pre> 
 	      |	low energy   |	medium energy	|  high energy
	--------------------------------------------------------
	      | acosta.mac   |                  |
	e-+   |	berger.mac   |	hanson.mac      |
	      |	hunger.mac   |	kulchi.mac      |
	      | tavora.mac   |			|
	--------------------------------------------------------
	others|	bichsel.mac  | 	vincour.mac	|  shen1.mac shen2.mac
	      | 	     |	gottsch.mac	|  tramu.mac
	--------------------------------------------------------
</pre>
	
## HOW TO START ?
 
 - Execute TestEm5 in 'batch' mode from macro files e.g.
```
% ./TestEm5   myMacro.mac
```
		
 - Execute TestEm5 in 'interactive' mode with visualization e.g.
```
% ./TestEm5
```
Then type your commands, for instance :
```
Idle> control/execute vis.mac
Idle> run/beamOn 5
....
```

Macros provided in this example:
- acosta.mac:  Back x-ray emission by 20 keV electrons in Silver.
     (E. Acosta et al. Journal of Applied Physics 83(11) 1998 page 6038,
     Fig. 4-5-6)
 - anthony.mac: LPM and dielectric effect measurement: 25 GeV electrons
     through thin foils.
     (P.L. Anthony et al. Phys.Rev. D 56 (1997) page 1373.)
 - atima.mac: to test PhysListEm19DStandard for ions
 - berger.mac: Energy deposit by 1 MeV electrons in silicon counters.
     (M.J.Berger et al. NIM 69 (1969) page 181.)
 - bichsel.mac: 0.766 MeV protons, transmitted through 1.37 mg/cm2 Al
     (H.Bichsel Phys.Rev. 112 (1958) page 182.)
 - dedx1.mac: to control dE/dx calculation.
 - dedx2.mac: to control dE/dx calculation. High statistic and plot
 - dna.mac: to illustrate DNA physics
 - fluo.mac: to illustrate atomic deexcitation options
 - gammaSpectrum.mac: to plot gamma spectrum  with/without atomic deexcitation.
 - geom.mac: to play with geometry (can be run interactively with visualization)
 - gottsch.mac: 158.6  MeV protons, transmitted through 0.2160 g/cm2 Al
     (B.Gottschalk et al. NIM B74 (1993) page 467.)
 - hanson.mac: Angle distribution of  15.7 MeV electrons transmitted through
     thin gold foils.
     (A.O.Hanson et al. Phys.Rev.84 (1951) page 634.)
 - hunger.mac: Back scattering of  41 keV electrons.
     (H.J. Hunger and L. Kuchler Phys. Stat. Sol.(a) 56, K45 (1979))
 - ion.mac: ion C12 in 1m Iron
 - kulchi.mac: 2.25 MeV e-, transmitted through 26.60 mg/cm2  Al
     (L.Kulchitsky Phys.Rev. 61 (1941) page 254.)
 - mumsc.mac: 100 GeV mu+, transmitted through 1 m of iron
 - mutev.mac: 1 TeV mu+, transmitted through 1 m of iron
 - pixe.mac: to illustrate atomic deexcitation options
 - pixe_ANSTO.mac: to illustrate how to activate the ANSTO PIXE data libraries,
   for both cross sections and fluorescence radiation yields (for materials with Z < 93).
   The cross sections are available for protons with energy < 5 MeV 
   and alpha particles with energy < 10 MeV/nucleon. 
      (S. Bakr et al. (2021) NIM B, 507:1119),
      (S. Bakr et al (2018), NIMB B, 436: 285-291)
 - posi.mac: to test PhysListEm19DStandard for positron
 - shen1.mac: Angle distribution of  high energy (50-200 GeV/c) protons
      transmitted through different targets.
      (G. Shen et al. Phys.Rev. D20 (1979) page 1584.)
 - shen2.mac: proton 175 GeV/c, transmitted through 8.004 mm Al
      (G. Shen et al. Phys.Rev. D20 (1979) page 1584.)
 - stepMax.mac: to test the command /testem/stepMax
 - tavora.mac: Back scattering of  35 keV electrons in Silver.
      (L.M. Tavora et al. J.Phys.D: Appl. Phys. 33 (2000) page 2497,
       Fig. 7)
 - tramu.mac: 1 TeV mu+, transmitted through 3 m of iron
      (Rev. of Particle Physics Eur. Phys. Jour. C (2000) page 172.
       Rev. of Particle Physics Letters B 592 (2004) page 251.)
 - vincour.mac: Angle distribution of  6.56 MeV protons transmitted through
      thin silicon targets.
      (J.Vincour,P.Bem NIM 148 (1978) page 396.)
 - vis.mac - to activate visualization
