\page ExampleTestEm17 Example TestEm17

 This example is intended to check implementation of the processes
 of muon interactions: ionization, direct (e+,e-) production, mu+mu-
 pair production, bremsstrahlung, and mu-nuclear interaction.
 It allows to compute differential cross sections (as function of the
 energy transfered to secondaries), total cross sections, and to compare
 with analytic calculations.
	
## GEOMETRY DEFINITION
 
 It is a single box of homogeneous medium.
 Two parameters define the geometry :
 - the material of the box,
 - the (full) size of the box.
 
 The default geometry (1 m of Iron) is constructed in 
 DetectorConstruction, but the above parameters can be changed 
 interactively via the commands defined in DetectorMessenger.
 	
## PHYSICS LIST
 
 The Physics List of the example uses the main physics constructor
 (builder) called "local", which includes only muon, pion, and proton
 processes under study. As an alternative standard "emstandard_opt0"
 and "emstandard_opt4" constructors may be used.	

 Default energy range for EM processes in this example 
 is from 100*eV to 1000*PeV.

 Optionally "muNucl" builder, MuNuclearBuilder, may be added activating muon-nuclear 
 inelastic interaction.
	 	 
## AN EVENT : THE PRIMARY GENERATOR
 
  The primary kinematic consists of a single particle starting at the edge
  of the box. The type of the particle and its energy are set in 
  PrimaryGeneratorAction (mu+ 10 TeV), and can be changed via the G4 
  build-in commands of ParticleGun class (see the macros provided with 
  this example).
 	
## PHYSICS
 
  The incident particle is a muon. During the tracking, secondary
  particles are killed.

  The number of interactions are plotted as a function of the energy 
  transfered to the secondaries.
  The total number of interactions is recorded, and the total cross section
  computed from this.  

  At RunAction::EndOfRun(..), the above results are compared with analytical
  calculations. The functions computing the theoretical cross sections have been
  provided by the G4 MEPhI group, and implemented in MuCrossSections class.

## HISTOGRAMS
         
  The test contains 8 built-in 1D histograms, which are managed by the
  HistoManager class and its messenger, HistoMessenger.

  - 1 Relative muon transferred energy distribution 
      (log10(eps/Emu kin) for knock-on electrons (ionization)
  - 2  ... direct (e+,e-) pair production by muons
  - 3  ... bremsstrahlung by muons
  - 4  ... nuclear interaction by muons
  - 5  ... ionistion for hadrons
  - 6  ... (e+,e-) pair production by hadrons
  - 7  ... bremsstrahlung by hadrons
  - 8  ... direct mu+,mu- pair production by muons


  The histos can be activated individually with the command :
```
/testem/histo/setHisto id nbBins  valMin valMax 
```
    min and max values of log10(eps/Emu kin).

    At RunAction::EndOfRunAction() the corresponding histos for analytic calculations are
    automatically created and filled (histo 11 to 14, and 18).
                                                    
  One can control the name and the type of the histograms file with 
  the command:
```
/testem/histo/setFileName  name  (default testem17)
```
   
  It is possible to choose the format of the histogram file :
  root (default), xml, csv by changing the default file type in HistoManager.cc.
     	 				
## VISUALIZATION
 
  The Visualization Manager is set in the main().
  The initialisation of the drawing is done via the commands
  /vis/... in the macro vis.mac. To get visualisation:
```
> /control/execute vis.mac
```
 	
  The detector has a default view which is a longitudinal view of the 
  box.
 
  The tracks are drawn at the end of event, and erased at the end of run.
	
## HOW TO START ?
 
  - Execute TestEm17 in 'batch' mode from macro files :
```
% ./TestEm17   allproc.mac
```
 		
  - Execute TestEm17 in 'interactive mode' with visualization :
```
% ./TestEm17
Idle> control/execute vis.mac
....
Idle> type your commands
....
Idle> exit
```
  