#
# PySNMP MIB module VRRP-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/VRRP-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:33:05 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, Integer, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueSizeConstraint, ValueRangeConstraint, ConstraintsIntersection, SingleValueConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueSizeConstraint", "ValueRangeConstraint", "ConstraintsIntersection", "SingleValueConstraint")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( InetAddressType, InetAddress, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddressType", "InetAddress")
( NotificationGroup, ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance", "ObjectGroup")
( Counter64, iso, mib_2, Integer32, ObjectIdentity, TimeTicks, Counter32, Gauge32, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, IpAddress, ModuleIdentity, Unsigned32, Bits, NotificationType, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter64", "iso", "mib-2", "Integer32", "ObjectIdentity", "TimeTicks", "Counter32", "Gauge32", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "IpAddress", "ModuleIdentity", "Unsigned32", "Bits", "NotificationType")
( TimeStamp, StorageType, RowStatus, TextualConvention, TimeInterval, TruthValue, MacAddress, DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "TimeStamp", "StorageType", "RowStatus", "TextualConvention", "TimeInterval", "TruthValue", "MacAddress", "DisplayString")
vrrpMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 68)).setRevisions(("2006-12-13 00:00", "2000-03-03 00:00",))
if mibBuilder.loadTexts: vrrpMIB.setLastUpdated('200612130000Z')
if mibBuilder.loadTexts: vrrpMIB.setOrganization('IETF VRRP Working Group')
if mibBuilder.loadTexts: vrrpMIB.setContactInfo('Kalyan Tata   \n                Nokia Inc.  \n                313 Fairchild Dr.  \n                Mountain View, CA 94043')
if mibBuilder.loadTexts: vrrpMIB.setDescription('This MIB describes objects used for managing Virtual  \n             Router Redundancy Protocol (VRRP) over IPv4 and IPv6 \n             protocols. \n \n             This MIB supports VRRP for IPv4 and IPv6 protocols \n             simultaneously running on a given interface of a  \n             router. \n     \n             Copyright (C) The IETF Trust (2006).')
class VrId(Integer32, TextualConvention):
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,255)

vrrpOperations = MibIdentifier((1, 3, 6, 1, 2, 1, 68, 1))
vrrpStatistics = MibIdentifier((1, 3, 6, 1, 2, 1, 68, 2))
vrrpConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 68, 3))
vrrpNodeVersion = MibScalar((1, 3, 6, 1, 2, 1, 68, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpNodeVersion.setDescription('This value identifies the particular version of the VRRP \n         supported by this node. \n         This object is deprecated in the IP Version Independent \n         MIB.')
vrrpNotificationCntl = MibScalar((1, 3, 6, 1, 2, 1, 68, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("enabled", 1), ("disabled", 2),)).clone('enabled')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vrrpNotificationCntl.setDescription("Indicates whether the VRRP-enabled router will generate \n            SNMP notifications for events defined in this MIB.  \n            'Enabled' results in SNMP notifications; 'disabled', no  \n            notifications are sent.")
vrrpOperationsTable = MibTable((1, 3, 6, 1, 2, 1, 68, 1, 7), )
if mibBuilder.loadTexts: vrrpOperationsTable.setDescription("Unified Operations table for a VRRP router which   \n             consists of a sequence (i.e., one or more conceptual \n             rows) of 'vrrpOperationsEntry' items which describe  \n             the operational characteristics of a virtual router.")
vrrpOperationsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 68, 1, 7, 1), ).setIndexNames((0, "VRRP-MIB", "vrrpOperationsInetAddrType"), (0, "VRRP-MIB", "vrrpOperationsVrId"), (0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: vrrpOperationsEntry.setDescription("An entry in the vrrpOperationsTable containing the   \n             operational characteristics of a virtual router.  On a  \n             VRRP router, a given virtual router is identified by a \n             combination of the IP version, VRID and ifIndex. \n             ifIndex represents a physical interface of the router. \n     \n             Note that rows in this table can be distinguished on a \n             multi-stacked device running VRRP over IPv4 and  \n             IPv6 on the same physical interface.  \n     \n             Rows in the table cannot be modified unless the value  \n             of 'vrrpOperationsState' has transitioned to  \n             'initialize'")
vrrpOperationsInetAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 1), InetAddressType())
if mibBuilder.loadTexts: vrrpOperationsInetAddrType.setDescription('The IP address type of VrrpOperationsEntry. This value  \n             applies to both vrrpOperationsMasterIpAddr and  \n             vrrpOperationsPrimaryIpAddr.')
vrrpOperationsVrId = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 2), VrId())
if mibBuilder.loadTexts: vrrpOperationsVrId.setDescription('This object contains the Virtual Router Identifier  \n             (VRID).')
vrrpOperationsVirtualMacAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 3), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpOperationsVirtualMacAddr.setDescription("The virtual MAC address of the virtual router.  \n            Although this object can be derived from the  \n            'vrrpOperationsVrId' object, it is defined so that it  \n            is easily obtainable by a management application and  \n            can be included in VRRP-related SNMP notifications.")
vrrpOperationsState = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("initialize", 1), ("backup", 2), ("master", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpOperationsState.setDescription("The current state of the virtual router. This object   \n            has three defined values:  \n     \n              - `initialize', which indicates that the  \n                virtual router is waiting for a startup event.  \n     \n              - `backup', which indicates the virtual router is  \n                monitoring the availability of the master router.  \n     \n              - `master', which indicates that the virtual router  \n                is forwarding packets for IP addresses that are  \n                associated with this router.")
vrrpOperationsPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255)).clone(100)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperationsPriority.setDescription("This object specifies the priority to be used for the  \n            virtual router master election process.  Higher values  \n            imply higher priority.  \n     \n            A priority of '0', although not settable, is sent by  \n            the master router to indicate that this router has  \n            ceased to participate in VRRP and a backup virtual  \n            router should transition to become a new master.  \n     \n            A priority of 255 is used for the router that owns the  \n            associated IP address(es) for VRRP over IPv4 and hence \n            not settable. \n \n            A 'badValue(3)' should be returned when a user tries to  \n            set 0 or 255 for this object. ")
vrrpOperationsAddrCount = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpOperationsAddrCount.setDescription('The number of IP addresses that are associated with  \n            this virtual router.  This number is equal to the  \n            number of rows in the vrrpAssociatedAddrTable that  \n            correspond to a given IP version/VRID/ifIndex.')
vrrpOperationsMasterIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 7), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpOperationsMasterIpAddr.setDescription("The master router's real IP address. Master router  \n            would set this address to vrrpOperationsPrimaryIpAddr  \n            while transitioning to master state. For backup  \n            routers, this is the IP address listed as the source in \n            VRRP advertisement last received by this virtual  \n            router.")
vrrpOperationsPrimaryIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 8), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperationsPrimaryIpAddr.setDescription("In the case where there are more than one IP  \n            Address (associated IP addresses) for a given  \n            `ifIndex', this object is used to specify the IP  \n            address that will become the \n            vrrpOperationsMasterIpAddr', should the virtual router  \n            transition from backup state to master.")
vrrpOperationsAdvInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 9), TimeInterval().subtype(subtypeSpec=ValueRangeConstraint(1,4096)).clone(100)).setUnits('centiseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperationsAdvInterval.setDescription('The time interval, in centiseconds, between sending  \n            advertisement messages. Only the master router sends  \n            VRRP advertisements.')
vrrpOperationsPreemptMode = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 10), TruthValue().clone('true')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperationsPreemptMode.setDescription('Controls whether a higher priority virtual router will \n            preempt a lower priority master.')
vrrpOperationsAcceptMode = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 11), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperationsAcceptMode.setDescription("Controls whether a virtual router in Master state  \n            will accept packets addressed to the address owner's  \n            IPv6 address as its own if it is not the IPv6 address  \n            owner.  Default is False. \n            This object is not relevant for rows representing VRRP \n            over IPv4 and should be set to false.")
vrrpOperationsUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 12), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpOperationsUpTime.setDescription("This is the value of the `sysUpTime' object when this  \n            virtual router (i.e., the `vrrpOperationsState')  \n            transitioned out of `initialized'.")
vrrpOperationsStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 13), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperationsStorageType.setDescription('The storage type for this conceptual row. Write access \n           is not required. It is optional to support nonVolatile  \n           StorageType enumeration.')
vrrpOperationsRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 7, 1, 14), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperationsRowStatus.setDescription("The RowStatus variable should be used in accordance to \n            installation and removal conventions for conceptual  \n            rows. When `vrrpOperationsRowStatus' is set to  \n            active(1), no other objects in the conceptual row can \n            be modified. \n     \n            To create a row in this table, a manager sets this  \n            object to either createAndGo(4) or createAndWait(5).  \n            Until instances of all corresponding columns are  \n            appropriately configured, the value of the  \n            corresponding instance of the `vrrpOperationsRowStatus' \n            column will be read as notReady(3).   \n            In particular, a newly created row cannot be made  \n            active(1) until (minimally) the corresponding instance  \n            of vrrpOperationsInetAddrType, vrrpOperationsVrId and  \n            vrrpOperationsPrimaryIpAddr has been set and there is  \n            at least one active row in the  \n            `vrrpAssociatedIpAddrTable' defining an associated  \n            IP address. \n \n            notInService(2) should be used to administratively  \n            bring the row down. \n \n            A typical order of operation to add a row is: \n            1. Create a row in vrrpOperationsTable with  \n            createAndWait(5). \n            2. Create one or more corresponding rows in \n            vrrpAssociatedIpAddrTable. \n            3. Populate the vrrpOperationsEntry. \n            4. set vrrpOperationsRowStatus to active(1). \n \n            A typical order of operation to delete an entry is: \n            1. Set vrrpOperationsRowStatus to notInService(2). \n            2. Set the corresponding rows in  \n            vrrpAssociatedIpAddrTable to destroy(6) to delete the  \n            entry.  \n            3. set vrrpOperationsRowStatus to destroy(6) to delete  \n            the entry.")
vrrpAssociatedIpAddrTable = MibTable((1, 3, 6, 1, 2, 1, 68, 1, 8), )
if mibBuilder.loadTexts: vrrpAssociatedIpAddrTable.setDescription('The table of addresses associated with this virtual  \n             router.')
vrrpAssociatedIpAddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 68, 1, 8, 1), ).setIndexNames((0, "VRRP-MIB", "vrrpOperationsInetAddrType"), (0, "VRRP-MIB", "vrrpOperationsVrId"), (0, "IF-MIB", "ifIndex"), (0, "VRRP-MIB", "vrrpAssociatedIpAddr"))
if mibBuilder.loadTexts: vrrpAssociatedIpAddrEntry.setDescription("An entry in the table contains an IP address that is  \n            associated with a virtual router.  The number of rows  \n            for a given IP version, VrID and ifIndex will equal the  \n            number of IP addresses associated (e.g., backed up) by  \n            the virtual router (equivalent to  \n            'vrrpOperationsIpAddrCount').  \n     \n            Rows in the table cannot be modified unless the value  \n            of `vrrpOperationsState' has transitioned to  \n            `initialize'.")
vrrpAssociatedIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 8, 1, 1), InetAddress().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(4,4),ValueSizeConstraint(16,16),)))
if mibBuilder.loadTexts: vrrpAssociatedIpAddr.setDescription('The assigned IP addresses that a virtual router is  \n            responsible for backing up. \n            The size of this object is either 4 or 16 depending on  \n            vrrpOperationsInetAddrType.')
vrrpAssociatedStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 8, 1, 2), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpAssociatedStorageType.setDescription('The storage type for this conceptual row. Write access  \n           is not required. It is optional to support nonVolatile  \n           StorageType enumeration.')
vrrpAssociatedIpAddrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 8, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpAssociatedIpAddrRowStatus.setDescription('The RowStatus variable, used according to  \n            installation and removal conventions for conceptual  \n            rows. To create a row in this table, a manager sets  \n            this object to either createAndGo(4) or  \n            createAndWait(5). Setting this object to active(1)  \n            results in the addition of an associated address for a  \n            virtual router. Setting this object to notInService(2)  \n            results in administratively bringing down the row. \n \n            Destroying the entry or setting it to destroy(6)  \n            removes the associated address from the virtual router. \n            The use of other values is implementation-dependent. \n \n            Only vrrpAssociatedStorageType can be modified when the  \n            row is in active(1) state for Implementations  \n            supporting write access to vrrpAssociatedStorageType \n \n            Implementations should not allow deletion of the last \n            row corresponding to an active row in  \n            vrrpOperationsTable. \n \n            Refer to description of vrrpOperationsRowStatus for a  \n            typical row creation and deletion scenarios.')
vrrpRouterChecksumErrors = MibScalar((1, 3, 6, 1, 2, 1, 68, 2, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpRouterChecksumErrors.setDescription('The total number of VRRP packets received with an \n            invalid VRRP checksum value.')
vrrpRouterVersionErrors = MibScalar((1, 3, 6, 1, 2, 1, 68, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpRouterVersionErrors.setDescription('The total number of VRRP packets received with an  \n            unknown or unsupported version number.')
vrrpRouterVrIdErrors = MibScalar((1, 3, 6, 1, 2, 1, 68, 2, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpRouterVrIdErrors.setDescription('The total number of VRRP packets received with an  \n            invalid VRID for this virtual router.')
vrrpRouterStatisticsTable = MibTable((1, 3, 6, 1, 2, 1, 68, 2, 5), )
if mibBuilder.loadTexts: vrrpRouterStatisticsTable.setDescription('Table of virtual router statistics.')
vrrpRouterStatisticsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 68, 2, 5, 1), )
vrrpOperationsEntry.registerAugmentions(("VRRP-MIB", "vrrpRouterStatisticsEntry"))
vrrpRouterStatisticsEntry.setIndexNames(*vrrpOperationsEntry.getIndexNames())
if mibBuilder.loadTexts: vrrpRouterStatisticsEntry.setDescription('An entry in the table, containing statistics  \n            information about a given virtual router.')
vrrpStatisticsMasterTransitions = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsMasterTransitions.setDescription("The total number of times that this virtual router's  \n            state has transitioned to MASTER.   \n     \n            Discontinuities in the value of this counter can occur  \n            at re-initialization of the management system, and at  \n            other times as indicated by the value of  \n            vrrpStatisticsDiscontinuityTime.")
vrrpStatisticsRcvdAdvertisements = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsRcvdAdvertisements.setDescription('The total number of VRRP advertisements received by  \n            this virtual router.   \n     \n            Discontinuities in the value of this counter can occur  \n            at re-initialization of the management system, and at  \n            other times as indicated by the value of  \n            vrrpStatisticsDiscontinuityTime.')
vrrpStatisticsAdvIntervalErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsAdvIntervalErrors.setDescription('The total number of VRRP advertisement packets  \n            received for which the advertisement interval is  \n            different than the one configured for the local virtual \n            router. \n     \n            Discontinuities in the value of this counter can occur  \n            at re-initialization of the management system, and at  \n            other times as indicated by the value of  \n            vrrpStatisticsDiscontinuityTime.')
vrrpStatisticsIpTtlErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsIpTtlErrors.setDescription('The total number of VRRP packets received by the  \n            Virtual router with IPv4 TTL (for VRRP over IPv4) or  \n            IPv6 Hop Limit (for VRRP over IPv6) not equal to 255. \n     \n            Discontinuities in the value of this counter can occur  \n            at re-initialization of the management system, and at  \n            other times as indicated by the value of  \n            vrrpStatisticsDiscontinuityTime.')
vrrpStatisticsRcvdPriZeroPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsRcvdPriZeroPackets.setDescription("The total number of VRRP packets received by the  \n            virtual router with a priority of '0'.   \n     \n            Discontinuities in the value of this counter can occur  \n            at re-initialization of the management system, and at  \n            other times as indicated by the value of  \n            vrrpStatisticsDiscontinuityTime.")
vrrpStatisticsSentPriZeroPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsSentPriZeroPackets.setDescription("The total number of VRRP packets sent by the virtual  \n            router with a priority of '0'.   \n     \n            Discontinuities in the value of this counter can occur  \n            at re-initialization of the management system, and at  \n            other times as indicated by the value of  \n            vrrpStatisticsDiscontinuityTime.")
vrrpStatisticsRcvdInvalidTypePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsRcvdInvalidTypePkts.setDescription("The number of VRRP packets received by the virtual  \n            router with an invalid value in the 'type' field.   \n     \n            Discontinuities in the value of this counter can occur  \n            at re-initialization of the management system, and at  \n            other times as indicated by the value of  \n            vrrpStatisticsDiscontinuityTime.")
vrrpStatisticsAddressListErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsAddressListErrors.setDescription('The total number of packets received for which the  \n            address list does not match the locally configured list \n            for the virtual router.   \n     \n            Discontinuities in the value of this counter can occur  \n            at re-initialization of the management system, and at  \n            other times as indicated by the value of  \n            vrrpStatisticsDiscontinuityTime.')
vrrpStatisticsPacketLengthErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsPacketLengthErrors.setDescription('The total number of packets received with a packet  \n            length less than the length of the VRRP header.   \n     \n            Discontinuities in the value of this counter can occur  \n            at re-initialization of the management system, and at  \n            other times as indicated by the value of  \n            vrrpStatisticsDiscontinuityTime.')
vrrpStatisticsRcvdInvalidAuthentications = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsRcvdInvalidAuthentications.setDescription('The total number of packets received with an unknown \n         authentication type.')
vrrpStatisticsDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 11), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at  \n            which any one or more of this entry's counters suffered \n            a discontinuity.  \n     \n            If no such discontinuities have occurred since the last \n            re-initialization of the local management subsystem,  \n            then this object contains a zero value.")
vrrpStatisticsRefreshRate = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 5, 1, 12), Unsigned32()).setUnits('milli-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatisticsRefreshRate.setDescription('The minimum reasonable polling interval for this entry. \n            This object provides an indication of the minimum  \n            Amount of time required to update the counters in this  \n            entry.')
vrrpNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 68, 0))
vrrpNewMasterReason = MibScalar((1, 3, 6, 1, 2, 1, 68, 1, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1, 2, 3,))).clone(namedValues=NamedValues(("notmaster", 0), ("priority", 1), ("preempted", 2), ("masterNoResponse", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpNewMasterReason.setDescription('This indicates the reason for vrrpNewMaster trap.  \n            Used by vrrpTrapNewMaster trap. The object can be  \n            polled if the vrrpNewMaster trap is lost to identify  \n            the reason for transmission. Backup router should  \n            return notmaster(0) when pooled. ')
vrrpTrapProtoErrReason = MibScalar((1, 3, 6, 1, 2, 1, 68, 1, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1, 2, 3,))).clone(namedValues=NamedValues(("hopLimitError", 0), ("versionError", 1), ("checksumError", 2), ("vridError", 3),))).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: vrrpTrapProtoErrReason.setDescription('This indicates the reason for protocol error trap.  \n            Used by vrrpTrapProtoError trap.')
vrrpTrapNewMaster = NotificationType((1, 3, 6, 1, 2, 1, 68, 0, 1)).setObjects(*(("VRRP-MIB", "vrrpOperationsMasterIpAddr"), ("VRRP-MIB", "vrrpNewMasterReason"),))
if mibBuilder.loadTexts: vrrpTrapNewMaster.setDescription("The newMaster trap indicates that the sending agent  \n            has transitioned to 'Master' state.")
vrrpTrapProtoError = NotificationType((1, 3, 6, 1, 2, 1, 68, 0, 3)).setObjects(*(("VRRP-MIB", "vrrpTrapProtoErrReason"),))
if mibBuilder.loadTexts: vrrpTrapProtoError.setDescription('The error trap indicates that the sending agent has  \n            encountered the protocol error indicated by  \n            vrrpTrapProtoErrorReason.')
vrrpOperTable = MibTable((1, 3, 6, 1, 2, 1, 68, 1, 3), )
if mibBuilder.loadTexts: vrrpOperTable.setDescription("Operations table for a VRRP router which consists of a \n          sequence (i.e., one or more conceptual rows) of \n          'vrrpOperEntry' items. \n \n          This table has been deprecated as a new IP version  \n          neutral 'vrrpOperationsTable' has been added. ")
vrrpOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 68, 1, 3, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VRRP-MIB", "vrrpOperVrId"))
if mibBuilder.loadTexts: vrrpOperEntry.setDescription("An entry in the vrrpOperTable containing the operational \n          characteristics of a virtual router.  On a VRRP router, \n          a given virtual router is identified by a combination \n          of the IF index and VRID. \n \n          Rows in the table cannot be modified unless the value \n          of `vrrpOperAdminState' is `disabled' and the \n          `vrrpOperState' has transitioned to `initialize'. \n \n          This object is deprecated in favor of the IP Version  \n          independent object, vrrpOperationsEntry")
vrrpOperVrId = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 1), VrId())
if mibBuilder.loadTexts: vrrpOperVrId.setDescription('This object contains the Virtual Router Identifier  \n         (VRID). \n         This object is deprecated in favor of the IP Version  \n         independent object, vrrpOperationsVrId ')
vrrpOperVirtualMacAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 2), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpOperVirtualMacAddr.setDescription("The virtual MAC address of the virtual router.  Although  \n         this object can be derived from the 'vrrpOperVrId' object, \n         it is defined so that it is easily obtainable by a  \n         management application and can be included in VRRP-related  \n         SNMP traps. \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpOperationsVirtualMacAddr.")
vrrpOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("initialize", 1), ("backup", 2), ("master", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpOperState.setDescription("The current state of the virtual router. This object has \n         three defined values: \n \n           - `initialize', which indicates that all the \n             virtual router is waiting for a startup event. \n \n           - `backup', which indicates the virtual router is \n             monitoring the availability of the master router. \n \n           - `master', which indicates that the virtual router \n             is forwarding packets for IP addresses that are \n             associated with this router. \n \n         Setting the `vrrpOperAdminState' object (below) initiates \n         transitions in the value of this object. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpOperationsState.")
vrrpOperAdminState = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("up", 1), ("down", 2),)).clone('down')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperAdminState.setDescription("This object will enable/disable the virtual router \n        function. \n         \n        Setting the value to `up', will transition the state of \n        the virtual router from `initialize' to `backup' or \n        `master', depending on the value of `vrrpOperPriority'. \n         \n        Setting the value to `down', will transition the router \n        from `master' or `backup' to `initialize'.  State \n        transitions may not be immediate; they sometimes depend on \n        other factors, such as the interface (IF) state. \n         \n        The `vrrpOperAdminState' object must be set to `down' prior \n        to modifying the other read-create objects in the \n        conceptual row.  The value of the `vrrpOperRowStatus' \n        object (below) must be `active', signifying that the \n        conceptual row is valid (i.e., the objects are correctly \n        set), in order for this object to be set to `up'. \n         \n         This object is deprecated in favor of the IP Version  \n        Independent object, vrrpOperationsState.")
vrrpOperPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255)).clone(100)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperPriority.setDescription("This object specifies the priority to be used for the \n         virtual router master election process.  Higher values  \n         imply higher priority. \n \n         A priority of '0', although not settable, is sent by \n         the master router to indicate that this router has ceased \n         to participate in VRRP and a backup virtual router should \n         transition to become a new master. \n \n         A priority of 255 is used for the router that owns the \n         associated IP address(es). \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpOperationsPriority.")
vrrpOperIpAddrCount = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpOperIpAddrCount.setDescription('The number of IP addresses that are associated with this \n         virtual router.  This number is equal to the number of  \n         rows in the vrrpAssoIpAddrTable that correspond to a  \n         given IF index/VRID pair. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpOperationsAddrCount.')
vrrpOperMasterIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 7), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpOperMasterIpAddr.setDescription("The master router's real (primary) IP address.  This is \n         the IP address listed as the source in VRRP advertisement \n         last received by this virtual router. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpOperationsMasterIpAddr.")
vrrpOperPrimaryIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 8), IpAddress().clone(hexValue="00000000")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperPrimaryIpAddr.setDescription("In the case where there is more than one IP address for \n         a given `ifIndex', this object is used to specify the IP \n         address that will become the `vrrpOperMasterIpAddr',  \n         should the virtual router transition from backup to  \n         master. If this object is set to 0.0.0.0, the IP address  \n         which is numerically lowest (of all the associated IP  \n         address for the interface) will be selected. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpOperationsPrimaryIpAddr.")
vrrpOperAuthType = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("noAuthentication", 1), ("simpleTextPassword", 2), ("ipAuthenticationHeader", 3),)).clone('noAuthentication')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperAuthType.setDescription('Authentication type used for VRRP protocol exchanges  \n         between virtual routers.  This value of this object is the  \n         same for a given ifIndex. \n \n         New enumerations to this list can only be added via a new \n         RFC on the standards track. \n \n         This object is deprecated in the IP Version MIB.')
vrrpOperAuthKey = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperAuthKey.setDescription("The Authentication Key.  This object is set according to \n         the value of the 'vrrpOperAuthType' object \n         ('simpleTextPassword' or 'ipAuthenticationHeader').  If  \n         the length of the value is less than 16 octets, the agent  \n         will left adjust and zero fill to 16 octets. The value of  \n         this object is the same for a given ifIndex. \n \n         When read, vrrpOperAuthKey always returns an Octet String \n         of length zero. \n \n         This object is deprecated in the IP Version MIB.")
vrrpOperAdvertisementInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,255)).clone(1)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperAdvertisementInterval.setDescription('The time interval, in seconds, between sending \n         advertisement messages.  Only the master router sends \n         VRRP advertisements. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpOperationsAdvInterval. ')
vrrpOperPreemptMode = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 12), TruthValue().clone('true')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperPreemptMode.setDescription('Controls whether a higher priority virtual router will \n         preempt a lower priority master. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpOperationsPreemptMode. ')
vrrpOperVirtualRouterUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 13), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpOperVirtualRouterUpTime.setDescription("This is the value of the `sysUpTime' object when this \n         virtual router (i.e., the `vrrpOperState') transitioned \n         out of `initialized'.  \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpOperationsUpTime.")
vrrpOperProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 14), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("ip", 1), ("bridge", 2), ("decnet", 3), ("other", 4),)).clone('ip')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperProtocol.setDescription('The particular protocol being controlled by this Virtual \n         Router. \n \n         New enumerations to this list can only be added via a new \n         RFC on the standards track. \n \n         This object is deprecated in the IP Version Independent  \n         MIB.')
vrrpOperRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 3, 1, 15), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpOperRowStatus.setDescription("The RowStatus variable, used in accordance to  \n         installation and removal conventions for conceptual rows.  \n         The RowStatus of a currently active row in the  \n         vrrpOperTable is constrained by the operational state of  \n         the corresponding virtual router. \n         When `vrrpOperRowStatus' is set to active(1), no other \n         objects in the conceptual row, with the exception of \n         `vrrpOperAdminState', can be modified. Prior to setting  \n         the `vrrpOperRowStatus' object from `active' to a  \n         different value, the `vrrpOperAdminState' object must be  \n         set to `down' and the `vrrpOperState' object be  \n         transitioned to `initialize'. \n \n         To create a row in this table, a manager sets this object \n         to either createAndGo(4) or createAndWait(5).  Until  \n         instances of all corresponding columns are appropriately  \n         configured, the value of the corresponding instance of the  \n         `vrrpOperRowStatus' column will be read as notReady(3). \n \n         In particular, a newly created row cannot be made  \n         active(1) until (minimally) the corresponding instance of \n         `vrrpOperVrId' has been set and there is at least one  \n         active row in the `vrrpAssoIpAddrTable' defining an  \n         associated IP address for the virtual router. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpOperationsRowStatus. ")
vrrpAssoIpAddrTable = MibTable((1, 3, 6, 1, 2, 1, 68, 1, 4), )
if mibBuilder.loadTexts: vrrpAssoIpAddrTable.setDescription('The table of addresses associated with this virtual \n          router. \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpAssociatedIpAddrTable. ')
vrrpAssoIpAddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 68, 1, 4, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VRRP-MIB", "vrrpOperVrId"), (0, "VRRP-MIB", "vrrpAssoIpAddr"))
if mibBuilder.loadTexts: vrrpAssoIpAddrEntry.setDescription("An entry in the table contains an IP address that is \n         associated with a virtual router.  The number of rows for \n         a given ifIndex and VrId will equal the number of IP \n         addresses associated (e.g., backed up) by the virtual \n         router (equivalent to 'vrrpOperIpAddrCount'). \n \n         Rows in the table cannot be modified unless the value \n         of `vrrpOperAdminState' is `disabled' and the \n         `vrrpOperState' has transitioned to `initialize'. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpAssociatedIpAddrEntry.")
vrrpAssoIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 4, 1, 1), IpAddress())
if mibBuilder.loadTexts: vrrpAssoIpAddr.setDescription('The assigned IP addresses that a virtual router is \n         responsible for backing up. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpAssociatedIpAddr.')
vrrpAssoIpAddrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 1, 4, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vrrpAssoIpAddrRowStatus.setDescription('The row status variable, used according to installation \n         and removal conventions for conceptual rows.  Setting this \n         object to active(1) or createAndGo(4) results in the \n         addition of an associated address for a virtual router. \n         Destroying the entry or setting it to notInService(2) \n         removes the associated address from the virtual router. \n         The use of other values is implementation-dependent. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpAssociatedIpAddrRowStatus.')
vrrpRouterStatsTable = MibTable((1, 3, 6, 1, 2, 1, 68, 2, 4), )
if mibBuilder.loadTexts: vrrpRouterStatsTable.setDescription('Table of virtual router statistics. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpRouterStatisticsTable.')
vrrpRouterStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 68, 2, 4, 1), )
vrrpOperEntry.registerAugmentions(("VRRP-MIB", "vrrpRouterStatsEntry"))
vrrpRouterStatsEntry.setIndexNames(*vrrpOperEntry.getIndexNames())
if mibBuilder.loadTexts: vrrpRouterStatsEntry.setDescription('An entry in the table, containing statistics information \n         about a given virtual router. \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpRouterStatisticsEntry.')
vrrpStatsBecomeMaster = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsBecomeMaster.setDescription("The total number of times that this virtual router's  \n         state has transitioned to MASTER. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpStatisticsMasterTransitions.")
vrrpStatsAdvertiseRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsAdvertiseRcvd.setDescription('The total number of VRRP advertisements received by this \n         virtual router. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpStatisticsRcvdAdvertisements.')
vrrpStatsAdvertiseIntervalErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsAdvertiseIntervalErrors.setDescription('The total number of VRRP advertisement packets received \n         for which the advertisement interval is different than the \n         one configured for the local virtual router. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpStatisticsAdvIntervalErrors.')
vrrpStatsAuthFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsAuthFailures.setDescription('The total number of VRRP packets received that do not  \n         pass the authentication check. \n \n         This object is deprecated in the IP Version MIB.')
vrrpStatsIpTtlErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsIpTtlErrors.setDescription('The total number of VRRP packets received by the virtual \n         router with IP TTL (Time-To-Live) not equal to 255. \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpStatisticsIpTtlErrors.')
vrrpStatsPriorityZeroPktsRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsPriorityZeroPktsRcvd.setDescription("The total number of VRRP packets received by the virtual \n         router with a priority of '0'. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpStatisticsRcvdPriZeroPackets.")
vrrpStatsPriorityZeroPktsSent = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsPriorityZeroPktsSent.setDescription("The total number of VRRP packets sent by the virtual  \n         router with a priority of '0'. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpStatisticsSentPriZeroPackets. ")
vrrpStatsInvalidTypePktsRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsInvalidTypePktsRcvd.setDescription("The number of VRRP packets received by the virtual router \n         with an invalid value in the 'type' field. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpStatisticsRcvdInvalidTypePkts. ")
vrrpStatsAddressListErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsAddressListErrors.setDescription('The total number of packets received for which the  \n         address list does not match the locally configured list  \n         for the virtual router. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpStatisticsAddressListErrors.')
vrrpStatsInvalidAuthType = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsInvalidAuthType.setDescription('The total number of packets received with an unknown \n         authentication type. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpStatisticsPacketLengthErrors.')
vrrpStatsAuthTypeMismatch = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsAuthTypeMismatch.setDescription("The total number of packets received with 'Auth Type' not \n         equal to the locally configured authentication method \n         (`vrrpOperAuthType'). \n \n         This object is deprecated in favor of the IP Version  \n         Independent object,  \n         vrrpStatisticsRcvdInvalidAuthentications.")
vrrpStatsPacketLengthErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 68, 2, 4, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vrrpStatsPacketLengthErrors.setDescription('The total number of packets received with a packet length \n         less than the length of the VRRP header. \n \n         This object is deprecated in favor of the IP Version  \n         Independent object, vrrpStatisticsPacketLengthErrors. ')
vrrpTrapPacketSrc = MibScalar((1, 3, 6, 1, 2, 1, 68, 1, 5), IpAddress()).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: vrrpTrapPacketSrc.setDescription('The IP address of an inbound VRRP packet. Used by \n          vrrpTrapAuthFailure trap. \n \n          This object is deprecated in the IP Version MIB. ')
vrrpTrapAuthErrorType = MibScalar((1, 3, 6, 1, 2, 1, 68, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("invalidAuthType", 1), ("authTypeMismatch", 2), ("authFailure", 3),))).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: vrrpTrapAuthErrorType.setDescription('Potential types of configuration conflicts. \n         Used by vrrpAuthFailure trap. \n \n         This object is deprecated in the IP Version MIB. ')
vrrpTrapAuthFailure = NotificationType((1, 3, 6, 1, 2, 1, 68, 0, 2)).setObjects(*(("VRRP-MIB", "vrrpTrapPacketSrc"), ("VRRP-MIB", "vrrpTrapAuthErrorType"),))
if mibBuilder.loadTexts: vrrpTrapAuthFailure.setDescription("A vrrpAuthFailure trap signifies that a packet has \n         been received from a router whose authentication key \n         or authentication type conflicts with this router's \n         authentication key or authentication type.  Implementation \n         of this trap is optional. \n \n         This object is deprecated in the IP Version MIB. ")
vrrpMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 68, 3, 1))
vrrpMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 68, 3, 2))
vrrpMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 68, 3, 1, 1)).setObjects(*(("VRRP-MIB", "vrrpOperGroup"), ("VRRP-MIB", "vrrpStatsGroup"), ("VRRP-MIB", "vrrpTrapGroup"), ("VRRP-MIB", "vrrpNotificationGroup"),))
if mibBuilder.loadTexts: vrrpMIBCompliance.setDescription('This compliance is deprecated in favour of   \n           vrrpModuleFullCompliance.')
vrrpModuleFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 68, 3, 1, 2)).setObjects(*(("VRRP-MIB", "vrrpOperationsGroup"), ("VRRP-MIB", "vrrpStatisticsGroup"), ("VRRP-MIB", "vrrpTrapInfoGroup"), ("VRRP-MIB", "vrrpNotificationsGroup"),))
if mibBuilder.loadTexts: vrrpModuleFullCompliance.setDescription('The compliance statement for both VRRP for IPv4 and  \n           VRRP for IPv6 implementations.')
vrrpModuleReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 68, 3, 1, 3)).setObjects(*(("VRRP-MIB", "vrrpOperationsGroup"), ("VRRP-MIB", "vrrpStatisticsGroup"), ("VRRP-MIB", "vrrpTrapInfoGroup"), ("VRRP-MIB", "vrrpNotificationsGroup"),))
if mibBuilder.loadTexts: vrrpModuleReadOnlyCompliance.setDescription('When this MIB is implemented without support for read- \n           create (i.e. in read-only mode), then such an  \n           implementation can claim read-only compliance. Such a  \n           device can then be monitored but can not be configured  \n           with this MIB.')
vrrpOperGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 68, 3, 2, 1)).setObjects(*(("VRRP-MIB", "vrrpNodeVersion"), ("VRRP-MIB", "vrrpNotificationCntl"), ("VRRP-MIB", "vrrpOperVirtualMacAddr"), ("VRRP-MIB", "vrrpOperState"), ("VRRP-MIB", "vrrpOperAdminState"), ("VRRP-MIB", "vrrpOperPriority"), ("VRRP-MIB", "vrrpOperIpAddrCount"), ("VRRP-MIB", "vrrpOperMasterIpAddr"), ("VRRP-MIB", "vrrpOperPrimaryIpAddr"), ("VRRP-MIB", "vrrpOperAuthType"), ("VRRP-MIB", "vrrpOperAuthKey"), ("VRRP-MIB", "vrrpOperAdvertisementInterval"), ("VRRP-MIB", "vrrpOperPreemptMode"), ("VRRP-MIB", "vrrpOperVirtualRouterUpTime"), ("VRRP-MIB", "vrrpOperProtocol"), ("VRRP-MIB", "vrrpOperRowStatus"), ("VRRP-MIB", "vrrpAssoIpAddrRowStatus"),))
if mibBuilder.loadTexts: vrrpOperGroup.setDescription('Conformance group for VRRP operations.')
vrrpStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 68, 3, 2, 2)).setObjects(*(("VRRP-MIB", "vrrpRouterChecksumErrors"), ("VRRP-MIB", "vrrpRouterVersionErrors"), ("VRRP-MIB", "vrrpRouterVrIdErrors"), ("VRRP-MIB", "vrrpStatsBecomeMaster"), ("VRRP-MIB", "vrrpStatsAdvertiseRcvd"), ("VRRP-MIB", "vrrpStatsAdvertiseIntervalErrors"), ("VRRP-MIB", "vrrpStatsAuthFailures"), ("VRRP-MIB", "vrrpStatsIpTtlErrors"), ("VRRP-MIB", "vrrpStatsPriorityZeroPktsRcvd"), ("VRRP-MIB", "vrrpStatsPriorityZeroPktsSent"), ("VRRP-MIB", "vrrpStatsInvalidTypePktsRcvd"), ("VRRP-MIB", "vrrpStatsAddressListErrors"), ("VRRP-MIB", "vrrpStatsInvalidAuthType"), ("VRRP-MIB", "vrrpStatsAuthTypeMismatch"), ("VRRP-MIB", "vrrpStatsPacketLengthErrors"),))
if mibBuilder.loadTexts: vrrpStatsGroup.setDescription('Conformance group for VRRP statistics.')
vrrpTrapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 68, 3, 2, 3)).setObjects(*(("VRRP-MIB", "vrrpTrapPacketSrc"), ("VRRP-MIB", "vrrpTrapAuthErrorType"),))
if mibBuilder.loadTexts: vrrpTrapGroup.setDescription('Conformance group for objects contained in VRRP  \n        notifications.')
vrrpNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 68, 3, 2, 4)).setObjects(*(("VRRP-MIB", "vrrpTrapNewMaster"), ("VRRP-MIB", "vrrpTrapAuthFailure"),))
if mibBuilder.loadTexts: vrrpNotificationGroup.setDescription('The VRRP MIB Notification Group.')
vrrpOperationsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 68, 3, 2, 5)).setObjects(*(("VRRP-MIB", "vrrpNotificationCntl"), ("VRRP-MIB", "vrrpOperationsVirtualMacAddr"), ("VRRP-MIB", "vrrpOperationsState"), ("VRRP-MIB", "vrrpOperationsPriority"), ("VRRP-MIB", "vrrpOperationsMasterIpAddr"), ("VRRP-MIB", "vrrpOperationsAdvInterval"), ("VRRP-MIB", "vrrpOperationsPreemptMode"), ("VRRP-MIB", "vrrpOperationsAcceptMode"), ("VRRP-MIB", "vrrpOperationsUpTime"), ("VRRP-MIB", "vrrpOperationsStorageType"), ("VRRP-MIB", "vrrpOperationsRowStatus"), ("VRRP-MIB", "vrrpOperationsAddrCount"), ("VRRP-MIB", "vrrpOperationsPrimaryIpAddr"), ("VRRP-MIB", "vrrpAssociatedStorageType"), ("VRRP-MIB", "vrrpAssociatedIpAddrRowStatus"),))
if mibBuilder.loadTexts: vrrpOperationsGroup.setDescription('Conformance group for VRRP over IPv4 and IPv6  \n           operations.')
vrrpStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 68, 3, 2, 6)).setObjects(*(("VRRP-MIB", "vrrpRouterChecksumErrors"), ("VRRP-MIB", "vrrpRouterVersionErrors"), ("VRRP-MIB", "vrrpRouterVrIdErrors"), ("VRRP-MIB", "vrrpStatisticsMasterTransitions"), ("VRRP-MIB", "vrrpStatisticsRcvdAdvertisements"), ("VRRP-MIB", "vrrpStatisticsAdvIntervalErrors"), ("VRRP-MIB", "vrrpStatisticsRcvdPriZeroPackets"), ("VRRP-MIB", "vrrpStatisticsSentPriZeroPackets"), ("VRRP-MIB", "vrrpStatisticsRcvdInvalidTypePkts"), ("VRRP-MIB", "vrrpStatisticsIpTtlErrors"), ("VRRP-MIB", "vrrpStatisticsAddressListErrors"), ("VRRP-MIB", "vrrpStatisticsPacketLengthErrors"), ("VRRP-MIB", "vrrpStatisticsRcvdInvalidAuthentications"), ("VRRP-MIB", "vrrpStatisticsDiscontinuityTime"), ("VRRP-MIB", "vrrpStatisticsRefreshRate"),))
if mibBuilder.loadTexts: vrrpStatisticsGroup.setDescription('Conformance group for VRRP over IPv4 and IPv6  \n           statistics.')
vrrpTrapInfoGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 68, 3, 2, 7)).setObjects(*(("VRRP-MIB", "vrrpNewMasterReason"), ("VRRP-MIB", "vrrpTrapProtoErrReason"),))
if mibBuilder.loadTexts: vrrpTrapInfoGroup.setDescription('Conformance group for objects contained in VRRP   \n            notifications.')
vrrpNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 68, 3, 2, 8)).setObjects(*(("VRRP-MIB", "vrrpTrapNewMaster"), ("VRRP-MIB", "vrrpTrapProtoError"),))
if mibBuilder.loadTexts: vrrpNotificationsGroup.setDescription('The VRRP MIB Notification Group.')
mibBuilder.exportSymbols("VRRP-MIB", vrrpOperAuthType=vrrpOperAuthType, vrrpOperationsMasterIpAddr=vrrpOperationsMasterIpAddr, vrrpOperationsAcceptMode=vrrpOperationsAcceptMode, vrrpOperationsEntry=vrrpOperationsEntry, VrId=VrId, vrrpStatistics=vrrpStatistics, vrrpOperAdvertisementInterval=vrrpOperAdvertisementInterval, vrrpOperMasterIpAddr=vrrpOperMasterIpAddr, vrrpNotificationGroup=vrrpNotificationGroup, vrrpRouterStatisticsTable=vrrpRouterStatisticsTable, vrrpStatisticsGroup=vrrpStatisticsGroup, vrrpMIB=vrrpMIB, vrrpOperationsStorageType=vrrpOperationsStorageType, vrrpRouterVersionErrors=vrrpRouterVersionErrors, vrrpOperProtocol=vrrpOperProtocol, vrrpRouterStatsEntry=vrrpRouterStatsEntry, vrrpOperationsTable=vrrpOperationsTable, vrrpStatisticsRefreshRate=vrrpStatisticsRefreshRate, vrrpStatisticsSentPriZeroPackets=vrrpStatisticsSentPriZeroPackets, vrrpStatsInvalidAuthType=vrrpStatsInvalidAuthType, vrrpOperPreemptMode=vrrpOperPreemptMode, vrrpStatsAuthTypeMismatch=vrrpStatsAuthTypeMismatch, vrrpStatsPacketLengthErrors=vrrpStatsPacketLengthErrors, vrrpOperAdminState=vrrpOperAdminState, vrrpRouterStatsTable=vrrpRouterStatsTable, vrrpStatsBecomeMaster=vrrpStatsBecomeMaster, vrrpOperIpAddrCount=vrrpOperIpAddrCount, vrrpMIBCompliances=vrrpMIBCompliances, vrrpOperations=vrrpOperations, vrrpNotificationCntl=vrrpNotificationCntl, vrrpTrapGroup=vrrpTrapGroup, vrrpStatsAddressListErrors=vrrpStatsAddressListErrors, vrrpStatisticsIpTtlErrors=vrrpStatisticsIpTtlErrors, vrrpOperEntry=vrrpOperEntry, vrrpOperAuthKey=vrrpOperAuthKey, vrrpModuleReadOnlyCompliance=vrrpModuleReadOnlyCompliance, vrrpTrapProtoError=vrrpTrapProtoError, vrrpOperRowStatus=vrrpOperRowStatus, vrrpTrapAuthErrorType=vrrpTrapAuthErrorType, vrrpStatisticsRcvdAdvertisements=vrrpStatisticsRcvdAdvertisements, vrrpOperationsVirtualMacAddr=vrrpOperationsVirtualMacAddr, vrrpNodeVersion=vrrpNodeVersion, vrrpAssoIpAddrRowStatus=vrrpAssoIpAddrRowStatus, vrrpStatisticsRcvdInvalidAuthentications=vrrpStatisticsRcvdInvalidAuthentications, vrrpStatisticsPacketLengthErrors=vrrpStatisticsPacketLengthErrors, vrrpStatsPriorityZeroPktsSent=vrrpStatsPriorityZeroPktsSent, vrrpStatsAdvertiseRcvd=vrrpStatsAdvertiseRcvd, vrrpStatisticsAddressListErrors=vrrpStatisticsAddressListErrors, vrrpTrapProtoErrReason=vrrpTrapProtoErrReason, vrrpStatisticsDiscontinuityTime=vrrpStatisticsDiscontinuityTime, vrrpOperTable=vrrpOperTable, vrrpMIBCompliance=vrrpMIBCompliance, vrrpTrapNewMaster=vrrpTrapNewMaster, vrrpConformance=vrrpConformance, vrrpNotifications=vrrpNotifications, vrrpOperVirtualRouterUpTime=vrrpOperVirtualRouterUpTime, vrrpAssoIpAddr=vrrpAssoIpAddr, vrrpOperationsInetAddrType=vrrpOperationsInetAddrType, vrrpOperationsPrimaryIpAddr=vrrpOperationsPrimaryIpAddr, vrrpOperPrimaryIpAddr=vrrpOperPrimaryIpAddr, vrrpAssociatedStorageType=vrrpAssociatedStorageType, vrrpOperationsRowStatus=vrrpOperationsRowStatus, vrrpOperationsPreemptMode=vrrpOperationsPreemptMode, vrrpOperationsAddrCount=vrrpOperationsAddrCount, vrrpOperVirtualMacAddr=vrrpOperVirtualMacAddr, vrrpStatsInvalidTypePktsRcvd=vrrpStatsInvalidTypePktsRcvd, vrrpNewMasterReason=vrrpNewMasterReason, vrrpRouterVrIdErrors=vrrpRouterVrIdErrors, vrrpStatsAuthFailures=vrrpStatsAuthFailures, vrrpRouterStatisticsEntry=vrrpRouterStatisticsEntry, vrrpOperationsGroup=vrrpOperationsGroup, vrrpTrapInfoGroup=vrrpTrapInfoGroup, vrrpStatsAdvertiseIntervalErrors=vrrpStatsAdvertiseIntervalErrors, vrrpStatsPriorityZeroPktsRcvd=vrrpStatsPriorityZeroPktsRcvd, vrrpOperationsState=vrrpOperationsState, vrrpOperGroup=vrrpOperGroup, vrrpOperVrId=vrrpOperVrId, vrrpStatisticsRcvdInvalidTypePkts=vrrpStatisticsRcvdInvalidTypePkts, vrrpRouterChecksumErrors=vrrpRouterChecksumErrors, vrrpOperationsPriority=vrrpOperationsPriority, vrrpAssoIpAddrEntry=vrrpAssoIpAddrEntry, vrrpAssoIpAddrTable=vrrpAssoIpAddrTable, vrrpNotificationsGroup=vrrpNotificationsGroup, vrrpOperPriority=vrrpOperPriority, vrrpAssociatedIpAddrEntry=vrrpAssociatedIpAddrEntry, vrrpStatisticsRcvdPriZeroPackets=vrrpStatisticsRcvdPriZeroPackets, vrrpModuleFullCompliance=vrrpModuleFullCompliance, vrrpOperState=vrrpOperState, vrrpOperationsAdvInterval=vrrpOperationsAdvInterval, vrrpOperationsVrId=vrrpOperationsVrId, vrrpTrapPacketSrc=vrrpTrapPacketSrc, vrrpAssociatedIpAddrTable=vrrpAssociatedIpAddrTable, vrrpAssociatedIpAddr=vrrpAssociatedIpAddr, vrrpStatsGroup=vrrpStatsGroup, vrrpMIBGroups=vrrpMIBGroups, vrrpStatisticsAdvIntervalErrors=vrrpStatisticsAdvIntervalErrors, vrrpStatsIpTtlErrors=vrrpStatsIpTtlErrors, vrrpOperationsUpTime=vrrpOperationsUpTime, vrrpStatisticsMasterTransitions=vrrpStatisticsMasterTransitions, PYSNMP_MODULE_ID=vrrpMIB, vrrpAssociatedIpAddrRowStatus=vrrpAssociatedIpAddrRowStatus, vrrpTrapAuthFailure=vrrpTrapAuthFailure)
