// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SslOptions ssl options
//
// swagger:model ssl_options
type SslOptions struct {

	// ssl engines
	SslEngines []*SslEngine `json:"engines,omitempty"`

	// ca base
	CaBase string `json:"ca_base,omitempty"`

	// crt base
	CrtBase string `json:"crt_base,omitempty"`

	// default bind ciphers
	DefaultBindCiphers string `json:"default_bind_ciphers,omitempty"`

	// default bind ciphersuites
	DefaultBindCiphersuites string `json:"default_bind_ciphersuites,omitempty"`

	// default bind client sigalgs
	DefaultBindClientSigalgs string `json:"default_bind_client_sigalgs,omitempty"`

	// default bind curves
	DefaultBindCurves string `json:"default_bind_curves,omitempty"`

	// default bind options
	DefaultBindOptions string `json:"default_bind_options,omitempty"`

	// default bind sigalgs
	DefaultBindSigalgs string `json:"default_bind_sigalgs,omitempty"`

	// default server ciphers
	DefaultServerCiphers string `json:"default_server_ciphers,omitempty"`

	// default server ciphersuites
	DefaultServerCiphersuites string `json:"default_server_ciphersuites,omitempty"`

	// default server client sigalgs
	DefaultServerClientSigalgs string `json:"default_server_client_sigalgs,omitempty"`

	// default server curves
	DefaultServerCurves string `json:"default_server_curves,omitempty"`

	// default server options
	DefaultServerOptions string `json:"default_server_options,omitempty"`

	// default server sigalgs
	DefaultServerSigalgs string `json:"default_server_sigalgs,omitempty"`

	// dh param file
	DhParamFile string `json:"dh_param_file,omitempty"`

	// issuers chain path
	IssuersChainPath string `json:"issuers_chain_path,omitempty"`

	// load extra files
	LoadExtraFiles string `json:"load_extra_files,omitempty"`

	// maxsslconn
	Maxsslconn int64 `json:"maxsslconn,omitempty"`

	// maxsslrate
	Maxsslrate int64 `json:"maxsslrate,omitempty"`

	// mode async
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	ModeAsync string `json:"mode_async,omitempty"`

	// propquery
	Propquery string `json:"propquery,omitempty"`

	// provider
	Provider string `json:"provider,omitempty"`

	// provider path
	ProviderPath string `json:"provider_path,omitempty"`

	// security level
	// Maximum: 5
	// Minimum: 0
	// +kubebuilder:validation:Maximum=5
	// +kubebuilder:validation:Minimum=0
	SecurityLevel *int64 `json:"security_level,omitempty"`

	// server verify
	// Enum: ["none","required"]
	// +kubebuilder:validation:Enum="none","required";
	ServerVerify string `json:"server_verify,omitempty"`

	// skip self issued ca
	SkipSelfIssuedCa bool `json:"skip_self_issued_ca,omitempty"`
}

// Validate validates this ssl options
func (m *SslOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSslEngines(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateModeAsync(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerVerify(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SslOptions) validateSslEngines(formats strfmt.Registry) error {
	if swag.IsZero(m.SslEngines) { // not required
		return nil
	}

	for i := 0; i < len(m.SslEngines); i++ {
		if swag.IsZero(m.SslEngines[i]) { // not required
			continue
		}

		if m.SslEngines[i] != nil {
			if err := m.SslEngines[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("engines" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("engines" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var sslOptionsTypeModeAsyncPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sslOptionsTypeModeAsyncPropEnum = append(sslOptionsTypeModeAsyncPropEnum, v)
	}
}

const (

	// SslOptionsModeAsyncEnabled captures enum value "enabled"
	SslOptionsModeAsyncEnabled string = "enabled"

	// SslOptionsModeAsyncDisabled captures enum value "disabled"
	SslOptionsModeAsyncDisabled string = "disabled"
)

// prop value enum
func (m *SslOptions) validateModeAsyncEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sslOptionsTypeModeAsyncPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SslOptions) validateModeAsync(formats strfmt.Registry) error {
	if swag.IsZero(m.ModeAsync) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeAsyncEnum("mode_async", "body", m.ModeAsync); err != nil {
		return err
	}

	return nil
}

func (m *SslOptions) validateSecurityLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityLevel) { // not required
		return nil
	}

	if err := validate.MinimumInt("security_level", "body", *m.SecurityLevel, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("security_level", "body", *m.SecurityLevel, 5, false); err != nil {
		return err
	}

	return nil
}

var sslOptionsTypeServerVerifyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sslOptionsTypeServerVerifyPropEnum = append(sslOptionsTypeServerVerifyPropEnum, v)
	}
}

const (

	// SslOptionsServerVerifyNone captures enum value "none"
	SslOptionsServerVerifyNone string = "none"

	// SslOptionsServerVerifyRequired captures enum value "required"
	SslOptionsServerVerifyRequired string = "required"
)

// prop value enum
func (m *SslOptions) validateServerVerifyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sslOptionsTypeServerVerifyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SslOptions) validateServerVerify(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerVerify) { // not required
		return nil
	}

	// value enum
	if err := m.validateServerVerifyEnum("server_verify", "body", m.ServerVerify); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ssl options based on the context it is used
func (m *SslOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSslEngines(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SslOptions) contextValidateSslEngines(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SslEngines); i++ {

		if m.SslEngines[i] != nil {

			if swag.IsZero(m.SslEngines[i]) { // not required
				return nil
			}

			if err := m.SslEngines[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("engines" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("engines" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SslOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SslOptions) UnmarshalBinary(b []byte) error {
	var res SslOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SslEngine ssl engine
//
// swagger:model SslEngine
type SslEngine struct {

	// algorithms
	Algorithms *string `json:"algorithms,omitempty"`

	// name
	// Required: true
	Name *string `json:"name"`
}

// Validate validates this ssl engine
func (m *SslEngine) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SslEngine) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ssl engine based on context it is used
func (m *SslEngine) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SslEngine) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SslEngine) UnmarshalBinary(b []byte) error {
	var res SslEngine
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
