/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.anim.dom.AbstractSVGAnimatedLength;
import org.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.apache.batik.anim.dom.SVGOMAnimatedLength;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGOMUseElement;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGOMUseShadowRoot;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGTransformable;
import org.w3c.dom.svg.SVGUseElement;

public class SVGUseElementBridge
extends AbstractGraphicsNodeBridge {
    protected ReferencedElementMutationListener l;
    protected BridgeContext subCtx;

    @Override
    public String getLocalName() {
        return "use";
    }

    @Override
    public Bridge getInstance() {
        return new SVGUseElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = this.buildCompositeGraphicsNode(bridgeContext, element, null);
        this.associateSVGContext(bridgeContext, element, (GraphicsNode)compositeGraphicsNode);
        return compositeGraphicsNode;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        NodeEventTarget nodeEventTarget;
        Rectangle2D rectangle2D;
        Object object;
        Attr attr;
        int n;
        Object object2;
        Element element2;
        Element element3;
        SVGOMUseElement sVGOMUseElement = (SVGOMUseElement)element;
        String string = sVGOMUseElement.getHref().getAnimVal();
        if (string.length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"xlink:href"});
        }
        Element element4 = bridgeContext.getReferencedElement(element, string);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
        SVGOMDocument sVGOMDocument2 = (SVGOMDocument)element4.getOwnerDocument();
        boolean bl = sVGOMDocument2 == sVGOMDocument;
        BridgeContext bridgeContext2 = bridgeContext;
        this.subCtx = null;
        if (!bl) {
            bridgeContext2 = this.subCtx = (BridgeContext)sVGOMDocument2.getCSSEngine().getCSSContext();
        }
        if ("symbol".equals((element3 = (Element)sVGOMDocument.importNode((Node)element4, true, true)).getLocalName())) {
            element2 = sVGOMDocument.createElementNS("http://www.w3.org/2000/svg", "svg");
            object2 = element3.getAttributes();
            n = object2.getLength();
            for (int i = 0; i < n; ++i) {
                attr = (Attr)object2.item(i);
                element2.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
            }
            object = element3.getFirstChild();
            while (object != null) {
                element2.appendChild((Node)object);
                object = element3.getFirstChild();
            }
            element3 = element2;
        }
        if ("svg".equals(element3.getLocalName())) {
            try {
                element2 = (SVGOMAnimatedLength)sVGOMUseElement.getWidth();
                if (element2.isSpecified()) {
                    element3.setAttributeNS(null, "width", element2.getAnimVal().getValueAsString());
                }
                if ((element2 = (SVGOMAnimatedLength)sVGOMUseElement.getHeight()).isSpecified()) {
                    element3.setAttributeNS(null, "height", element2.getAnimVal().getValueAsString());
                }
            }
            catch (LiveAttributeException liveAttributeException) {
                throw new BridgeException(bridgeContext, liveAttributeException);
            }
        }
        element2 = new SVGOMUseShadowRoot((AbstractDocument)sVGOMDocument, element, bl);
        element2.appendChild(element3);
        if (compositeGraphicsNode == null) {
            compositeGraphicsNode = new CompositeGraphicsNode();
            this.associateSVGContext(bridgeContext, element, this.node);
        } else {
            int n2 = compositeGraphicsNode.size();
            for (n = 0; n < n2; ++n) {
                compositeGraphicsNode.remove(0);
            }
        }
        object2 = sVGOMUseElement.getCSSFirstChild();
        if (object2 != null) {
            SVGUseElementBridge.disposeTree((Node)object2);
        }
        sVGOMUseElement.setUseShadowTree((SVGOMUseShadowRoot)element2);
        Element element5 = element3;
        CSSUtilities.computeStyleAndURIs(element4, element3, string);
        object = bridgeContext.getGVTBuilder();
        attr = ((GVTBuilder)object).build(bridgeContext, element5);
        compositeGraphicsNode.getChildren().add(attr);
        compositeGraphicsNode.setTransform(this.computeTransform((SVGTransformable)element, bridgeContext));
        compositeGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        RenderingHints renderingHints = null;
        renderingHints = CSSUtilities.convertColorRendering(element, renderingHints);
        if (renderingHints != null) {
            compositeGraphicsNode.setRenderingHints(renderingHints);
        }
        if ((rectangle2D = CSSUtilities.convertEnableBackground(element)) != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        if (this.l != null) {
            nodeEventTarget = this.l.target;
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", (EventListener)this.l, true);
            this.l = null;
        }
        if (bl && bridgeContext.isDynamic()) {
            this.l = new ReferencedElementMutationListener();
            this.l.target = nodeEventTarget = (NodeEventTarget)element4;
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)this.l, true, null);
            bridgeContext2.storeEventListenerNS((EventTarget)nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMAttrModified", this.l, true);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)this.l, true, null);
            bridgeContext2.storeEventListenerNS((EventTarget)nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.l, true);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)this.l, true, null);
            bridgeContext2.storeEventListenerNS((EventTarget)nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.l, true);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", (EventListener)this.l, true, null);
            bridgeContext2.storeEventListenerNS((EventTarget)nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.l, true);
        }
        return compositeGraphicsNode;
    }

    @Override
    public void dispose() {
        NodeEventTarget nodeEventTarget;
        if (this.l != null) {
            nodeEventTarget = this.l.target;
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)this.l, true);
            nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", (EventListener)this.l, true);
            this.l = null;
        }
        if ((nodeEventTarget = (SVGOMUseElement)this.e) != null && nodeEventTarget.getCSSFirstChild() != null) {
            SVGUseElementBridge.disposeTree(nodeEventTarget.getCSSFirstChild());
        }
        super.dispose();
        this.subCtx = null;
    }

    @Override
    protected AffineTransform computeTransform(SVGTransformable sVGTransformable, BridgeContext bridgeContext) {
        AffineTransform affineTransform = super.computeTransform(sVGTransformable, bridgeContext);
        SVGUseElement sVGUseElement = (SVGUseElement)sVGTransformable;
        try {
            AbstractSVGAnimatedLength abstractSVGAnimatedLength = (AbstractSVGAnimatedLength)sVGUseElement.getX();
            float f = abstractSVGAnimatedLength.getCheckedValue();
            AbstractSVGAnimatedLength abstractSVGAnimatedLength2 = (AbstractSVGAnimatedLength)sVGUseElement.getY();
            float f2 = abstractSVGAnimatedLength2.getCheckedValue();
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(f, f2);
            affineTransform2.preConcatenate(affineTransform);
            return affineTransform2;
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
        if (bridgeContext.isInteractive()) {
            NodeEventTarget nodeEventTarget = (NodeEventTarget)element;
            CursorMouseOverListener cursorMouseOverListener = new CursorMouseOverListener(bridgeContext);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", (EventListener)cursorMouseOverListener, false, null);
            bridgeContext.storeEventListenerNS((EventTarget)nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseover", cursorMouseOverListener, false);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        try {
            String string = animatedLiveAttributeValue.getNamespaceURI();
            String string2 = animatedLiveAttributeValue.getLocalName();
            if (string == null) {
                if (string2.equals("x") || string2.equals("y") || string2.equals("transform")) {
                    this.node.setTransform(this.computeTransform((SVGTransformable)this.e, this.ctx));
                    this.handleGeometryChanged();
                } else if (string2.equals("width") || string2.equals("height")) {
                    this.buildCompositeGraphicsNode(this.ctx, this.e, (CompositeGraphicsNode)this.node);
                }
            } else if (string.equals("http://www.w3.org/1999/xlink") && string2.equals("href")) {
                this.buildCompositeGraphicsNode(this.ctx, this.e, (CompositeGraphicsNode)this.node);
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(this.ctx, liveAttributeException);
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    protected class ReferencedElementMutationListener
    implements EventListener {
        protected NodeEventTarget target;

        protected ReferencedElementMutationListener() {
        }

        @Override
        public void handleEvent(Event event) {
            SVGUseElementBridge.this.buildCompositeGraphicsNode(SVGUseElementBridge.this.ctx, SVGUseElementBridge.this.e, (CompositeGraphicsNode)SVGUseElementBridge.this.node);
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected BridgeContext ctx;

        public CursorMouseOverListener(BridgeContext bridgeContext) {
            this.ctx = bridgeContext;
        }

        @Override
        public void handleEvent(Event event) {
            Cursor cursor;
            Element element = (Element)((Object)event.getCurrentTarget());
            if (!CSSUtilities.isAutoCursor(element) && (cursor = CSSUtilities.convertCursor(element, this.ctx)) != null) {
                this.ctx.getUserAgent().setSVGCursor(cursor);
            }
        }
    }
}

