#ifndef WIN32_SOCKETS_H
#define WIN32_SOCKETS_H


// use SELECT instead of poll
// because poll is not supported on win32
#define __RPC_STREAM_SELECT

inline int inet_aton(const char *cp, struct in_addr *addr)
{
  addr->s_addr = inet_addr(cp);
  return (addr->s_addr == INADDR_NONE) ? 0 : 1;
}

inline int recv_waitall(SOCKET sock, char* buf, int len, int flags)
{
	int result;
	int totalread = 0;
	do
	{
		result = ::recv(sock,buf+totalread,len-totalread,flags);
		if (result == -1 || result == 0)
			return totalread;
		totalread += result;
	}
	while (totalread != len);
	return totalread;
}

#endif
