/** VSys:$ppp-hndl.cc:0.0.3-024$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: ppp-hndl.cc; File version: 0.0.3-024
 */
/*
 * Ethernet IP packets parser.
 * Thanks to TCPDUMP Group for their code - it was very usefull in
 * learning BPF/PCAP usage
 */

#ifdef WIN32
#else
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include "config.h"
#endif

#include <stdlib.h>
#include "pcap.local.h"
#include "nf.h"
#include "nfc.h"
#include "handlers.h"
#include "iptonf.h"

#define __NEED_PPP
#include "nethdr.h"
#include "debug.h"

void ppp_handler( u_char * _if, const struct pcap_pkthdr *h, const u_char *p ) {
	if_list *iface = (if_list *) _if;
	if( !iface ) return;
	u_int16_t proto = PPP_IP_PROTO;
#ifdef __OS_BSD_LIKE
//	ppphdr *ph = (ppphdr *) p;
//	proto = ph->ph_prot;
	if( h->caplen < 4 + TCP_HDR_SZ ) return;
	p += 4;
/* #elif defined __RH9_PPP_HACK
	if( h->caplen < iface->ifl_ppp_offset + TCP_HDR_SZ ) return;
	p += iface->ifl_ppp_offset;
	proto = PPP_IP_PROTO;
#else
	if( h->caplen < 4 + TCP_HDR_SZ ) return;
	if (*p == PPP_ADDR_VAL && *(p + 1) == PPP_CNTL_VAL ) {
		ppphdr *ph = (ppphdr *) p;
		proto = ph->ph_prot;
		p += 4;         // ACFC not used
	}
#endif */
#else
	if( h->caplen < iface->ifl_ppp_offset + TCP_HDR_SZ ) return;
	p += iface->ifl_ppp_offset;
	proto = PPP_IP_PROTO;
#endif


	if( proto == PPP_IP_PROTO ) {
		iptonf( _if, &(h->ts), p );
	} else
		DEB(printf( "PPP proto: 0x%x\n", proto ));
}
