/** VSys:$config.cc:0.0.3-015$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: config.cc; File version: 0.0.3-015
 */

#include <iostream>
#include <stdlib.h>
#ifdef WIN32
#include <winsock2.h>
#define strncasecmp strnicmp

#else
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#endif
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>


#include "config_ndsad.h"
#include "iflist.h"
#include "mempool.h"

#include "debug.h"

_conf_tag cfg;
mempool *   nfpool;
mempool * ifl_pool;

void cfl_add( const char *, cf_list ** );


int load_config() {
	char buf[256], *ptr, *cmnt, *kwd, *val;
	FILE * fd;
	int cnt, ln;
	int ip_found=0,port_found=0;
	// Defaults
	cfg.dummy = 0;
	memset( &cfg.sa_in, 0, sizeof(sockaddr_in));
	cfg.sa_in.sin_family = AF_INET;
	cfg.sa_in.sin_addr.s_addr = htonl( 0x7f000001 );
	cfg.sa_in.sin_port = htons( 9996 );
	cfg.promisc = 0;
	cfg.dummy = 0;
	cfg.dummy_mode = 0;
	cfg.force = 0;
	cfg.nf_lifetime = NF_LIFETIME;

	cfg.sas = sizeof( sockaddr_in );
#ifdef __OS_BSD_LIKE
	cfg.sa_in.sin_len = cfg.sas;
#endif

	if( !cfg.file ) goto read;
config:
	ln = 0;
	//XXX Config file parsing...
//	DEB( fprintf(stderr, "Trying `%s' config file.\n", cfg.file ));
	fd = fopen( cfg.file, "r" );
	if( !fd ) goto read;
	fgets( buf, 256, fd );
	cnt = strlen( buf );
	fprintf(stderr, "Processing `%s' config file.\n", cfg.file );
	while( cnt ) {
		ptr = buf;
		
		cmnt = strchr( ptr, '\n' );
		if( cmnt ) { *cmnt = 0; cnt--; }
		DEB( fprintf( stderr, "Line[%d]: `%s'\n", cnt, buf));
		// Increase line number
		ln++;
		// Drop whitespaces
		while( isspace(*ptr) && cnt ) { ptr++; cnt--; };
		if( !cnt ) goto step;
		// Drop comments
		cmnt = strchr( ptr, '#' );
		if( cmnt ) {
			cnt -= strlen( cmnt );
			*cmnt = '\0';
		}
		// Drop trailing whitespaces
		cmnt = strchr( ptr, '\0' );
		if (cmnt != ptr) cmnt--; 
		while( isspace(*cmnt) && cnt ) { cmnt--; cnt--; };
		*(++cmnt) = '\0';
		if( !cnt ) goto step;
		// Cases
		kwd = ptr;
		val = ptr + strcspn( ptr, "\t " );
		cnt -= (val - ptr);
		if( val ) {
			*val = '\0';
			val++;
			while( isspace(*val) && cnt ) { val++; cnt--; };
		}
		// DEB( fprintf( stderr, "Word: `%s', Value: `%s'.\n", kwd, val ));
		if( !cnt || !val ) {
			fprintf( stderr, "Bare keyword found at %s:%d.\n", cfg.file, ln );
		} else if( !strncasecmp( ptr, "dump", 4 )) {
			// Periodic statistical dump
			cfg.stat = atoi( val );
			DEB( fprintf( stderr, "Statistical dump delay changed to %d\n", cfg.stat ));
		} else if( !strncasecmp( ptr, "ulog_group", 10 )) {
			int ulog_group = atoi(val);
			cfg.ulog_groups.push_back(ulog_group);
		} else if( !strncasecmp( ptr, "bsd_div_port", 12 )) {
			cfg.bsd_div_port = atoi(val);
		} else if( !strncasecmp( ptr, "bsd_div_copy", 12 )) {
			if(strlen(val)){
				cfg.bsd_div_copy = 1;
			};
		} else if( !strncasecmp( ptr, "nf_dest", 7 )) {
			// Destination IP:PORT. New syntax!
			std::string str = val;
			uint s_pos = str.find(":");
			if (s_pos > str.size()){
				//  "nf_dest syntax error ! Please provide ip:port"
				continue;
			};
			nf_dest tmp_d;
			// bzero(&tmp_d._sa_in, sizeof(tmp_d._sa_in));
			tmp_d._sa_in.sin_addr.s_addr = inet_addr( str.substr(0,s_pos).c_str() );
			tmp_d._sa_in.sin_port = htons(atoi(str.substr(s_pos+1).c_str()));
			tmp_d._sa_in.sin_family = AF_INET;
			tmp_d.sas = sizeof(tmp_d._sa_in);
			cfg.sa_pool.push_back(tmp_d);
		} else if( !strncasecmp( ptr, "ip", 2 )) {
			ip_found = 1;
			// Destination IP
			cfg.sa_in.sin_addr.s_addr = inet_addr( val );
			cfg.sa_in.sin_family = AF_INET;
			DEB( fprintf( stderr, "Destination IP changed to %s\n", inet_ntoa( cfg.sa_in.sin_addr ) ));
		} else if( !strncasecmp( ptr, "port", 4 )) {
			port_found = 1;
			// Destination port
			cfg.sa_in.sin_port = htons(atoi(val));
			DEB( fprintf( stderr, "Destination port changed to %d\n", cfg.sa_in.sin_port ));
		} else if( !strncasecmp( ptr, "heap", 4 )) {
			// Heap size
			cfg.heap = atoi(val);
			DEB( fprintf( stderr, "Heap size changed to %d\n", cfg.heap ));
		} else if( !strncasecmp( ptr, "nf_lifetime", 11 )) {
			// Net Flow life time
			int tmp = atoi(val);
			if (tmp < 0 || tmp > 7200)
				tmp = NF_LIFETIME;
			cfg.nf_lifetime = tmp;
			DEB( fprintf( stderr, "Net Flow lifetime changed %d\n", cfg.heap ));
		} else if( !strncasecmp( ptr, "dummy", 5 )) {
			// Dummy interface family
			if( !strncasecmp( val, "all", 3 )) {
				cfg.dummy_mode = 1;
				DEB( fprintf( stderr, "Dummy mode entered...\n")); 
				goto step;
			}
			iff_list * face = ifl_family( val );
			if( face ) { 
				face->iff_dummy = 1;
			} else
				DEB( fprintf( stderr, "Unsupported family `%s'.\n", val));
			DEB( fprintf( stderr, "Family `%s' marked as dummy\n", face->iff_name ));
		} else if( !strncasecmp( ptr, "force_family", 11 )) {
			// Force interface family
			iff_list * face = ifl_family( val );
			if( face ) { 
				face->iff_force = 1;
			} else
				DEB( fprintf( stderr, "Unsupported family `%s'.\n", val));
			DEB( fprintf( stderr, "Family `%s' is forced...\n", face->iff_name ));
		} else if( !strncasecmp( ptr, "force", 5 )) {
			// Forced interface
			cfl_add( val, &cfg.force );
			DEB( fprintf( stderr, "Device `%s' added to force list\n", val ));
		} else if( !strncasecmp( ptr, "filter", 6 )) {
			// Filter rule to interface
			// cfl_add( val, &cfg.filter );
			// DEB( fprintf( stderr, "Filter rule `%s' found \n", val ));
			std::string vals = val;
			std::string iface = vals.substr(0, vals.find(" "));
			std::string rule = vals.substr(vals.find(" ")+1);
			std::map<std::string, std::string>::iterator iter = cfg.rules.find(iface);
			if (iter == cfg.rules.end()){
				cfg.rules[iface] = rule;
			}else{
				(*iter).second = rule;
			};
			// std::cout << "Filter rule found:" << rule << " for iface:" << iface  << std::endl;
		} else if( !strncasecmp( ptr, "promisc", 7 )) {
			// Promisc interface
			cfl_add( val, &cfg.promisc );
			DEB( fprintf( stderr, "Device `%s' added to promisc list\n", val ));
		} else if( !strncasecmp( ptr, "ignore", 6 )) {
			// Dummy interface
			cfl_add( val, &cfg.dummy );
			DEB( fprintf( stderr, "Device `%s' added to ignore list\n", val ));
		} else if( !strncasecmp( ptr, "log", 3 )) {
			// Log file 
			delete( cfg.log );
			cfg.log = strdup( val );
			DEB(fprintf(stderr, "Log file changed to `%s'.\n", cfg.log));
		} else if( !strncasecmp( ptr, "pidfile", 7 )) {
			// Log file 
			free( cfg.pidfile );
			cfg.pidfile = strdup( val );
			DEB(fprintf(stderr, "Pidfile changed to `%s'.\n", cfg.pidfile));
		} else if( !strncasecmp( ptr, "config", 6 )) {
			// Proceed with another file 
			fclose( fd );
			DEB(fprintf(stderr, "Finished with `%s' config file.\n", cfg.file));
			free( cfg.file );
			cfg.file = strdup( val );
			goto config;
		} else if( !strncasecmp( ptr, "hash", 6 )) {
			// Hash size for iface family
			kwd = val;
			val += strcspn( val, "\t " );
			cnt -= (val - kwd);
			if( val ) {
				*val = '\0';
				val++;
				while( isspace(*val) && cnt ) { val++; cnt--; };
			}
//			DEB( fprintf( stderr, "Family: `%s', Value: `%s'.\n", kwd, val ));
			if( !strncasecmp( kwd, "all", 3 )) {
				__hs_default = atoi( val );
				DEB( fprintf( stderr, "Default hash size changed to %d\n", 
							__hs_default ));
				goto step;
			}
			iff_list *face = ifl_family( kwd );
			if( !face ) {
				DEB( fprintf( stderr, "Unknown family `%s'\n", kwd ));
				goto step;
			}
			face->iff_hash = atoi( val );
			DEB( fprintf( stderr, "Hash size for `%s' family changed to %d\n", 
						face->iff_name, face->iff_hash ));
		} else {
			fprintf( stderr, "Unknown keyword at %s:%d.\n", cfg.file, ln );
		}
step:
		buf[0] = '\0';
		fgets( buf, 256, fd );
		cnt = strlen( buf );
	}
	fclose( fd );
	DEB(fprintf(stderr, "Finished with `%s' config file.\n", cfg.file));
read:
	cfg.sock = socket( AF_INET, SOCK_DGRAM, IPPROTO_UDP );
	/// push ip/port value to pool if ip/port found or if sa_pool is empty
	if(!cfg.sa_pool.size() || ip_found || port_found){
		nf_dest tmp_d;
// 		bzero(&tmp_d._sa_in, sizeof(tmp_d._sa_in));
		tmp_d._sa_in = cfg.sa_in;
		tmp_d.sas = sizeof(tmp_d._sa_in);
		cfg.sa_pool.push_back(tmp_d);
	};

	nfpool = new mempool( cfg.heap );
	ifl_pool = new mempool( -1 ); // Infinite size
	if_list templ;
	templ.ifl_type = MPH_IFLIST;
	templ.ifl_size = sizeof( if_list );
	if( ifl_pool ) ifl_pool->init( MPH( &templ ));
	if( cfg.sock < 0 ) return -1;
	return 0;
}

void cfl_add( const char * name, cf_list ** cfl ) {
	// Add node
	cf_list * tmp = new cf_list;
	strncpy( tmp->cf_name, name, IFN_SIZE );
	// Better to do this then not to do... 
	tmp->cf_name[IFN_SIZE-1] = '\0'; 
	tmp->cf_next = *cfl;
	*cfl = tmp;
}

int cfl_find( const char * name, cf_list * cfl ) {
	cf_list * tmp = cfl;
	while( tmp ) {
		if( !strcmp( tmp->cf_name, name ))
				return 1;
		tmp = tmp->cf_next;
	} 
	return 0;
}

bool is_my_address(pcap_addr* addresses, const char* ip)
{
	unsigned long ip_long = inet_addr(ip);
	while (addresses !=0)
	{
		sockaddr_in* addr_in = (sockaddr_in*)addresses->addr;
		if (addr_in->sin_family == AF_INET && 
				addr_in->sin_addr.s_addr == ip_long) 
			return true;
		addresses = addresses->next;
	}
	return false;
}

int cfl_find_address( pcap_addr* addresses, cf_list* cfl)
{
	cf_list * tmp = cfl;
	while( tmp ) {
		if (is_my_address(addresses,tmp->cf_name))
			return 1;
		tmp = tmp->cf_next;
	} 
	return 0;
}
