// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolHistogramDataPoint = sync.Pool{
		New: func() any {
			return &otlpmetrics.HistogramDataPoint{}
		},
	}
	ProtoPoolHistogramDataPoint_Sum = sync.Pool{
		New: func() any {
			return &otlpmetrics.HistogramDataPoint_Sum{}
		},
	}

	ProtoPoolHistogramDataPoint_Min = sync.Pool{
		New: func() any {
			return &otlpmetrics.HistogramDataPoint_Min{}
		},
	}

	ProtoPoolHistogramDataPoint_Max = sync.Pool{
		New: func() any {
			return &otlpmetrics.HistogramDataPoint_Max{}
		},
	}
)

func NewOrigHistogramDataPoint() *otlpmetrics.HistogramDataPoint {
	if !UseProtoPooling.IsEnabled() {
		return &otlpmetrics.HistogramDataPoint{}
	}
	return protoPoolHistogramDataPoint.Get().(*otlpmetrics.HistogramDataPoint)
}

func DeleteOrigHistogramDataPoint(orig *otlpmetrics.HistogramDataPoint, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Attributes {
		DeleteOrigKeyValue(&orig.Attributes[i], false)
	}
	switch ov := orig.Sum_.(type) {
	case *otlpmetrics.HistogramDataPoint_Sum:
		if UseProtoPooling.IsEnabled() {
			ov.Sum = float64(0)
			ProtoPoolHistogramDataPoint_Sum.Put(ov)
		}

	}
	for i := range orig.Exemplars {
		DeleteOrigExemplar(&orig.Exemplars[i], false)
	}
	switch ov := orig.Min_.(type) {
	case *otlpmetrics.HistogramDataPoint_Min:
		if UseProtoPooling.IsEnabled() {
			ov.Min = float64(0)
			ProtoPoolHistogramDataPoint_Min.Put(ov)
		}

	}
	switch ov := orig.Max_.(type) {
	case *otlpmetrics.HistogramDataPoint_Max:
		if UseProtoPooling.IsEnabled() {
			ov.Max = float64(0)
			ProtoPoolHistogramDataPoint_Max.Put(ov)
		}

	}

	orig.Reset()
	if nullable {
		protoPoolHistogramDataPoint.Put(orig)
	}
}

func CopyOrigHistogramDataPoint(dest, src *otlpmetrics.HistogramDataPoint) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.StartTimeUnixNano = src.StartTimeUnixNano
	dest.TimeUnixNano = src.TimeUnixNano
	dest.Count = src.Count
	if srcSum, ok := src.Sum_.(*otlpmetrics.HistogramDataPoint_Sum); ok {
		destSum, ok := dest.Sum_.(*otlpmetrics.HistogramDataPoint_Sum)
		if !ok {
			destSum = &otlpmetrics.HistogramDataPoint_Sum{}
			dest.Sum_ = destSum
		}
		destSum.Sum = srcSum.Sum
	} else {
		dest.Sum_ = nil
	}
	dest.BucketCounts = CopyOrigUint64Slice(dest.BucketCounts, src.BucketCounts)
	dest.ExplicitBounds = CopyOrigFloat64Slice(dest.ExplicitBounds, src.ExplicitBounds)
	dest.Exemplars = CopyOrigExemplarSlice(dest.Exemplars, src.Exemplars)
	dest.Flags = src.Flags
	if srcMin, ok := src.Min_.(*otlpmetrics.HistogramDataPoint_Min); ok {
		destMin, ok := dest.Min_.(*otlpmetrics.HistogramDataPoint_Min)
		if !ok {
			destMin = &otlpmetrics.HistogramDataPoint_Min{}
			dest.Min_ = destMin
		}
		destMin.Min = srcMin.Min
	} else {
		dest.Min_ = nil
	}
	if srcMax, ok := src.Max_.(*otlpmetrics.HistogramDataPoint_Max); ok {
		destMax, ok := dest.Max_.(*otlpmetrics.HistogramDataPoint_Max)
		if !ok {
			destMax = &otlpmetrics.HistogramDataPoint_Max{}
			dest.Max_ = destMax
		}
		destMax.Max = srcMax.Max
	} else {
		dest.Max_ = nil
	}
}

func GenTestOrigHistogramDataPoint() *otlpmetrics.HistogramDataPoint {
	orig := NewOrigHistogramDataPoint()
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.StartTimeUnixNano = 1234567890
	orig.TimeUnixNano = 1234567890
	orig.Count = uint64(13)
	orig.Sum_ = &otlpmetrics.HistogramDataPoint_Sum{Sum: float64(3.1415926)}
	orig.BucketCounts = GenerateOrigTestUint64Slice()
	orig.ExplicitBounds = GenerateOrigTestFloat64Slice()
	orig.Exemplars = GenerateOrigTestExemplarSlice()
	orig.Flags = 1
	orig.Min_ = &otlpmetrics.HistogramDataPoint_Min{Min: float64(3.1415926)}
	orig.Max_ = &otlpmetrics.HistogramDataPoint_Max{Max: float64(3.1415926)}
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigHistogramDataPoint(orig *otlpmetrics.HistogramDataPoint, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.Count != uint64(0) {
		dest.WriteObjectField("count")
		dest.WriteUint64(orig.Count)
	}
	if orig, ok := orig.Sum_.(*otlpmetrics.HistogramDataPoint_Sum); ok {
		dest.WriteObjectField("sum")
		dest.WriteFloat64(orig.Sum)
	}
	if len(orig.BucketCounts) > 0 {
		dest.WriteObjectField("bucketCounts")
		dest.WriteArrayStart()
		dest.WriteUint64(orig.BucketCounts[0])
		for i := 1; i < len(orig.BucketCounts); i++ {
			dest.WriteMore()
			dest.WriteUint64(orig.BucketCounts[i])
		}
		dest.WriteArrayEnd()
	}
	if len(orig.ExplicitBounds) > 0 {
		dest.WriteObjectField("explicitBounds")
		dest.WriteArrayStart()
		dest.WriteFloat64(orig.ExplicitBounds[0])
		for i := 1; i < len(orig.ExplicitBounds); i++ {
			dest.WriteMore()
			dest.WriteFloat64(orig.ExplicitBounds[i])
		}
		dest.WriteArrayEnd()
	}
	if len(orig.Exemplars) > 0 {
		dest.WriteObjectField("exemplars")
		dest.WriteArrayStart()
		MarshalJSONOrigExemplar(&orig.Exemplars[0], dest)
		for i := 1; i < len(orig.Exemplars); i++ {
			dest.WriteMore()
			MarshalJSONOrigExemplar(&orig.Exemplars[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if orig, ok := orig.Min_.(*otlpmetrics.HistogramDataPoint_Min); ok {
		dest.WriteObjectField("min")
		dest.WriteFloat64(orig.Min)
	}
	if orig, ok := orig.Max_.(*otlpmetrics.HistogramDataPoint_Max); ok {
		dest.WriteObjectField("max")
		dest.WriteFloat64(orig.Max)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigHistogramDataPoint unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigHistogramDataPoint(orig *otlpmetrics.HistogramDataPoint, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
				UnmarshalJSONOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], iter)
			}

		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "count":
			orig.Count = iter.ReadUint64()
		case "sum":
			{
				var ov *otlpmetrics.HistogramDataPoint_Sum
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpmetrics.HistogramDataPoint_Sum{}
				} else {
					ov = ProtoPoolHistogramDataPoint_Sum.Get().(*otlpmetrics.HistogramDataPoint_Sum)
				}
				ov.Sum = iter.ReadFloat64()
				orig.Sum_ = ov
			}

		case "bucketCounts", "bucket_counts":
			for iter.ReadArray() {
				orig.BucketCounts = append(orig.BucketCounts, iter.ReadUint64())
			}

		case "explicitBounds", "explicit_bounds":
			for iter.ReadArray() {
				orig.ExplicitBounds = append(orig.ExplicitBounds, iter.ReadFloat64())
			}

		case "exemplars":
			for iter.ReadArray() {
				orig.Exemplars = append(orig.Exemplars, otlpmetrics.Exemplar{})
				UnmarshalJSONOrigExemplar(&orig.Exemplars[len(orig.Exemplars)-1], iter)
			}

		case "flags":
			orig.Flags = iter.ReadUint32()
		case "min":
			{
				var ov *otlpmetrics.HistogramDataPoint_Min
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpmetrics.HistogramDataPoint_Min{}
				} else {
					ov = ProtoPoolHistogramDataPoint_Min.Get().(*otlpmetrics.HistogramDataPoint_Min)
				}
				ov.Min = iter.ReadFloat64()
				orig.Min_ = ov
			}

		case "max":
			{
				var ov *otlpmetrics.HistogramDataPoint_Max
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpmetrics.HistogramDataPoint_Max{}
				} else {
					ov = ProtoPoolHistogramDataPoint_Max.Get().(*otlpmetrics.HistogramDataPoint_Max)
				}
				ov.Max = iter.ReadFloat64()
				orig.Max_ = ov
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigHistogramDataPoint(orig *otlpmetrics.HistogramDataPoint) int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.StartTimeUnixNano != 0 {
		n += 9
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	if orig.Count != 0 {
		n += 9
	}
	if orig, ok := orig.Sum_.(*otlpmetrics.HistogramDataPoint_Sum); ok {
		_ = orig
		n += 9
	}
	l = len(orig.BucketCounts)
	if l > 0 {
		l *= 8
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.ExplicitBounds)
	if l > 0 {
		l *= 8
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.Exemplars {
		l = SizeProtoOrigExemplar(&orig.Exemplars[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Flags != 0 {
		n += 1 + proto.Sov(uint64(orig.Flags))
	}
	if orig, ok := orig.Min_.(*otlpmetrics.HistogramDataPoint_Min); ok {
		_ = orig
		n += 9
	}
	if orig, ok := orig.Max_.(*otlpmetrics.HistogramDataPoint_Max); ok {
		_ = orig
		n += 9
	}
	return n
}

func MarshalProtoOrigHistogramDataPoint(orig *otlpmetrics.HistogramDataPoint, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x4a
	}
	if orig.StartTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	if orig.Count != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.Count))
		pos--
		buf[pos] = 0x21
	}
	if orig, ok := orig.Sum_.(*otlpmetrics.HistogramDataPoint_Sum); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Sum))
		pos--
		buf[pos] = 0x29
	}
	l = len(orig.BucketCounts)
	if l > 0 {
		for i := l - 1; i >= 0; i-- {
			pos -= 8
			binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.BucketCounts[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(l*8))
		pos--
		buf[pos] = 0x32
	}
	l = len(orig.ExplicitBounds)
	if l > 0 {
		for i := l - 1; i >= 0; i-- {
			pos -= 8
			binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.ExplicitBounds[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(l*8))
		pos--
		buf[pos] = 0x3a
	}
	for i := len(orig.Exemplars) - 1; i >= 0; i-- {
		l = MarshalProtoOrigExemplar(&orig.Exemplars[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x42
	}
	if orig.Flags != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Flags))
		pos--
		buf[pos] = 0x50
	}
	if orig, ok := orig.Min_.(*otlpmetrics.HistogramDataPoint_Min); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Min))
		pos--
		buf[pos] = 0x59
	}
	if orig, ok := orig.Max_.(*otlpmetrics.HistogramDataPoint_Max); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Max))
		pos--
		buf[pos] = 0x61
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigHistogramDataPoint(orig *otlpmetrics.HistogramDataPoint, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
			err = UnmarshalProtoOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.StartTimeUnixNano = uint64(num)

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 4:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.Count = uint64(num)

		case 5:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpmetrics.HistogramDataPoint_Sum
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpmetrics.HistogramDataPoint_Sum{}
			} else {
				ov = ProtoPoolHistogramDataPoint_Sum.Get().(*otlpmetrics.HistogramDataPoint_Sum)
			}
			ov.Sum = math.Float64frombits(num)
			orig.Sum_ = ov
		case 6:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field BucketCounts", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			size := length / 8
			orig.BucketCounts = make([]uint64, size)
			var num uint64
			for i := 0; i < size; i++ {
				num, startPos, err = proto.ConsumeI64(buf[:pos], startPos)
				if err != nil {
					return err
				}
				orig.BucketCounts[i] = uint64(num)
			}
			if startPos != pos {
				return fmt.Errorf("proto: invalid field len = %d for field BucketCounts", pos-startPos)
			}
		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ExplicitBounds", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			size := length / 8
			orig.ExplicitBounds = make([]float64, size)
			var num uint64
			for i := 0; i < size; i++ {
				num, startPos, err = proto.ConsumeI64(buf[:pos], startPos)
				if err != nil {
					return err
				}
				orig.ExplicitBounds[i] = math.Float64frombits(num)
			}
			if startPos != pos {
				return fmt.Errorf("proto: invalid field len = %d for field ExplicitBounds", pos-startPos)
			}

		case 8:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Exemplars = append(orig.Exemplars, otlpmetrics.Exemplar{})
			err = UnmarshalProtoOrigExemplar(&orig.Exemplars[len(orig.Exemplars)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 10:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)

		case 11:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpmetrics.HistogramDataPoint_Min
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpmetrics.HistogramDataPoint_Min{}
			} else {
				ov = ProtoPoolHistogramDataPoint_Min.Get().(*otlpmetrics.HistogramDataPoint_Min)
			}
			ov.Min = math.Float64frombits(num)
			orig.Min_ = ov

		case 12:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpmetrics.HistogramDataPoint_Max
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpmetrics.HistogramDataPoint_Max{}
			} else {
				ov = ProtoPoolHistogramDataPoint_Max.Get().(*otlpmetrics.HistogramDataPoint_Max)
			}
			ov.Max = math.Float64frombits(num)
			orig.Max_ = ov
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
