/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>

#include <tag.h>
#include <fileref.h>

using namespace std;

void usage() {
    fprintf(stderr, "taginfo 1.2\n");
    fprintf(stderr, "Usage: taginfo <file(s)>\n");
    
}

int main(int argc, char *argv[]) {
    if(argc < 2) {
        usage();
        exit(1);
    }
    
    for(int i = 1; i < argc; i++) {
        TagLib::FileRef f(argv[i]);
        if(!f.isNull() && f.tag()) {
            printf("FILE=\"%s\"\n", argv[i]);
            printf("ALBUM=\"%s\"\n", f.tag()->album().toCString());
            printf("TRACK=\"%d\"\n", f.tag()->track());
            printf("ARTIST=\"%s\"\n", f.tag()->artist().toCString());
            printf("TITLE=\"%s\"\n", f.tag()->title().toCString());
            printf("GENRE=\"%s\"\n", f.tag()->genre().toCString());
            printf("YEAR=\"%d\"\n", f.tag()->year());
            printf("COMMENT=\"%s\"\n", f.tag()->comment().toCString());
            printf("LENGTH=\"%d\"\n", f.audioProperties()->length());
            printf("BITRATE=\"%d\"\n", f.audioProperties()->bitrate());
            printf("SAMPLERATE=\"%d\"\n", f.audioProperties()->sampleRate());
            printf("CHANNELS=\"%d\"\n\n", f.audioProperties()->channels());
        } else {
            fprintf(stderr, "Error opening file: %s\n", argv[i]);
        }
    }

    return 0;
}
