// Code generated by help.awk. DO NOT EDIT.
// GENERATED FILE DO NOT EDIT

package parser

var helpMessages = map[string]HelpMessageBody{
	//line sql.y: 1075
	`ALTER`: {
		//line sql.y: 1076
		Category: hGroup,
		//line sql.y: 1077
		Text: `ALTER TABLE, ALTER INDEX, ALTER VIEW, ALTER SEQUENCE, ALTER DATABASE, ALTER USER
`,
	},
	//line sql.y: 1091
	`ALTER TABLE`: {
		ShortDescription: `change the definition of a table`,
		//line sql.y: 1092
		Category: hDDL,
		//line sql.y: 1093
		Text: `
ALTER TABLE [IF EXISTS] <tablename> <command> [, ...]

Commands:
  ALTER TABLE ... ADD [COLUMN] [IF NOT EXISTS] <colname> <type> [<qualifiers...>]
  ALTER TABLE ... ADD <constraint>
  ALTER TABLE ... DROP [COLUMN] [IF EXISTS] <colname> [RESTRICT | CASCADE]
  ALTER TABLE ... DROP CONSTRAINT [IF EXISTS] <constraintname> [RESTRICT | CASCADE]
  ALTER TABLE ... ALTER [COLUMN] <colname> {SET DEFAULT <expr> | DROP DEFAULT}
  ALTER TABLE ... ALTER [COLUMN] <colname> DROP NOT NULL
  ALTER TABLE ... ALTER [COLUMN] <colname> DROP STORED
  ALTER TABLE ... ALTER [COLUMN] <colname> [SET DATA] TYPE <type> [COLLATE <collation>]
  ALTER TABLE ... RENAME TO <newname>
  ALTER TABLE ... RENAME [COLUMN] <colname> TO <newname>
  ALTER TABLE ... VALIDATE CONSTRAINT <constraintname>
  ALTER TABLE ... SPLIT AT <selectclause>
  ALTER TABLE ... SCATTER [ FROM ( <exprs...> ) TO ( <exprs...> ) ]
  ALTER TABLE ... INJECT STATISTICS ...  (experimental)
  ALTER TABLE ... PARTITION BY RANGE ( <name...> ) ( <rangespec> )
  ALTER TABLE ... PARTITION BY LIST ( <name...> ) ( <listspec> )
  ALTER TABLE ... PARTITION BY NOTHING
  ALTER TABLE ... CONFIGURE ZONE <zoneconfig>
  ALTER PARTITION ... OF TABLE ... CONFIGURE ZONE <zoneconfig>

Column qualifiers:
  [CONSTRAINT <constraintname>] {NULL | NOT NULL | UNIQUE | PRIMARY KEY | CHECK (<expr>) | DEFAULT <expr>}
  FAMILY <familyname>, CREATE [IF NOT EXISTS] FAMILY [<familyname>]
  REFERENCES <tablename> [( <colnames...> )]
  COLLATE <collationname>

Zone configurations:
  DISCARD
  USING <var> = <expr> [, ...]
  USING <var> = COPY FROM PARENT [, ...]
  { TO | = } <expr>

`,
		//line sql.y: 1129
		SeeAlso: `WEBDOCS/alter-table.html
`,
	},
	//line sql.y: 1143
	`ALTER VIEW`: {
		ShortDescription: `change the definition of a view`,
		//line sql.y: 1144
		Category: hDDL,
		//line sql.y: 1145
		Text: `
ALTER VIEW [IF EXISTS] <name> RENAME TO <newname>
`,
		//line sql.y: 1147
		SeeAlso: `WEBDOCS/alter-view.html
`,
	},
	//line sql.y: 1154
	`ALTER SEQUENCE`: {
		ShortDescription: `change the definition of a sequence`,
		//line sql.y: 1155
		Category: hDDL,
		//line sql.y: 1156
		Text: `
ALTER SEQUENCE [IF EXISTS] <name>
  [INCREMENT <increment>]
  [MINVALUE <minvalue> | NO MINVALUE]
  [MAXVALUE <maxvalue> | NO MAXVALUE]
  [START <start>]
  [[NO] CYCLE]
ALTER SEQUENCE [IF EXISTS] <name> RENAME TO <newname>
`,
	},
	//line sql.y: 1181
	`ALTER USER`: {
		ShortDescription: `change user properties`,
		//line sql.y: 1182
		Category: hPriv,
		//line sql.y: 1183
		Text: `
ALTER USER [IF EXISTS] <name> WITH PASSWORD <password>
`,
		//line sql.y: 1185
		SeeAlso: `CREATE USER
`,
	},
	//line sql.y: 1190
	`ALTER DATABASE`: {
		ShortDescription: `change the definition of a database`,
		//line sql.y: 1191
		Category: hDDL,
		//line sql.y: 1192
		Text: `
ALTER DATABASE <name> RENAME TO <newname>
`,
		//line sql.y: 1194
		SeeAlso: `WEBDOCS/alter-database.html
`,
	},
	//line sql.y: 1202
	`ALTER RANGE`: {
		ShortDescription: `change the parameters of a range`,
		//line sql.y: 1203
		Category: hDDL,
		//line sql.y: 1204
		Text: `
ALTER RANGE <zonename> <command>

Commands:
  ALTER RANGE ... CONFIGURE ZONE <zoneconfig>

Zone configurations:
  DISCARD
  USING <var> = <expr> [, ...]
  USING <var> = COPY FROM PARENT [, ...]
  { TO | = } <expr>

`,
		//line sql.y: 1216
		SeeAlso: `ALTER TABLE
`,
	},
	//line sql.y: 1221
	`ALTER INDEX`: {
		ShortDescription: `change the definition of an index`,
		//line sql.y: 1222
		Category: hDDL,
		//line sql.y: 1223
		Text: `
ALTER INDEX [IF EXISTS] <idxname> <command>

Commands:
  ALTER INDEX ... RENAME TO <newname>
  ALTER INDEX ... SPLIT AT <selectclause>
  ALTER INDEX ... SCATTER [ FROM ( <exprs...> ) TO ( <exprs...> ) ]

`,
		//line sql.y: 1231
		SeeAlso: `WEBDOCS/alter-index.html
`,
	},
	//line sql.y: 1632
	`BACKUP`: {
		ShortDescription: `back up data to external storage`,
		//line sql.y: 1633
		Category: hCCL,
		//line sql.y: 1634
		Text: `
BACKUP <targets...> TO <location...>
       [ AS OF SYSTEM TIME <expr> ]
       [ INCREMENTAL FROM <location...> ]
       [ WITH <option> [= <value>] [, ...] ]

Targets:
   TABLE <pattern> [, ...]
   DATABASE <databasename> [, ...]

Location:
   "[scheme]://[host]/[path to backup]?[parameters]"

Options:
   INTO_DB
   SKIP_MISSING_FOREIGN_KEYS

`,
		//line sql.y: 1651
		SeeAlso: `RESTORE, WEBDOCS/backup.html
`,
	},
	//line sql.y: 1659
	`RESTORE`: {
		ShortDescription: `restore data from external storage`,
		//line sql.y: 1660
		Category: hCCL,
		//line sql.y: 1661
		Text: `
RESTORE <targets...> FROM <location...>
        [ AS OF SYSTEM TIME <expr> ]
        [ WITH <option> [= <value>] [, ...] ]

Targets:
   TABLE <pattern> [, ...]
   DATABASE <databasename> [, ...]

Locations:
   "[scheme]://[host]/[path to backup]?[parameters]"

Options:
   INTO_DB
   SKIP_MISSING_FOREIGN_KEYS

`,
		//line sql.y: 1677
		SeeAlso: `BACKUP, WEBDOCS/restore.html
`,
	},
	//line sql.y: 1695
	`IMPORT`: {
		ShortDescription: `load data from file in a distributed manner`,
		//line sql.y: 1696
		Category: hCCL,
		//line sql.y: 1697
		Text: `
-- Import both schema and table data:
IMPORT [ TABLE <tablename> FROM ]
       <format> <datafile>
       [ WITH <option> [= <value>] [, ...] ]

-- Import using specific schema, use only table data from external file:
IMPORT TABLE <tablename>
       { ( <elements> ) | CREATE USING <schemafile> }
       <format>
       DATA ( <datafile> [, ...] )
       [ WITH <option> [= <value>] [, ...] ]

Formats:
   CSV
   MYSQLOUTFILE
   MYSQLDUMP (mysqldump's SQL output)
   PGCOPY
   PGDUMP

Options:
   distributed = '...'
   sstsize = '...'
   temp = '...'
   delimiter = '...'      [CSV, PGCOPY-specific]
   nullif = '...'         [CSV, PGCOPY-specific]
   comment = '...'        [CSV-specific]

`,
		//line sql.y: 1725
		SeeAlso: `CREATE TABLE
`,
	},
	//line sql.y: 1759
	`EXPORT`: {
		ShortDescription: `export data to file in a distributed manner`,
		//line sql.y: 1760
		Category: hCCL,
		//line sql.y: 1761
		Text: `
EXPORT INTO <format> <datafile> [WITH <option> [= value] [,...]] FROM <query>

Formats:
   CSV

Options:
   delimiter = '...'   [CSV-specific]

`,
		//line sql.y: 1770
		SeeAlso: `SELECT
`,
	},
	//line sql.y: 1863
	`CANCEL`: {
		//line sql.y: 1864
		Category: hGroup,
		//line sql.y: 1865
		Text: `CANCEL JOBS, CANCEL QUERIES, CANCEL SESSIONS
`,
	},
	//line sql.y: 1872
	`CANCEL JOBS`: {
		ShortDescription: `cancel background jobs`,
		//line sql.y: 1873
		Category: hMisc,
		//line sql.y: 1874
		Text: `
CANCEL JOBS <selectclause>
CANCEL JOB <jobid>
`,
		//line sql.y: 1877
		SeeAlso: `SHOW JOBS, PAUSE JOBS, RESUME JOBS
`,
	},
	//line sql.y: 1895
	`CANCEL QUERIES`: {
		ShortDescription: `cancel running queries`,
		//line sql.y: 1896
		Category: hMisc,
		//line sql.y: 1897
		Text: `
CANCEL QUERIES [IF EXISTS] <selectclause>
CANCEL QUERY [IF EXISTS] <expr>
`,
		//line sql.y: 1900
		SeeAlso: `SHOW QUERIES
`,
	},
	//line sql.y: 1931
	`CANCEL SESSIONS`: {
		ShortDescription: `cancel open sessions`,
		//line sql.y: 1932
		Category: hMisc,
		//line sql.y: 1933
		Text: `
CANCEL SESSIONS [IF EXISTS] <selectclause>
CANCEL SESSION [IF EXISTS] <sessionid>
`,
		//line sql.y: 1936
		SeeAlso: `SHOW SESSIONS
`,
	},
	//line sql.y: 2009
	`CREATE`: {
		//line sql.y: 2010
		Category: hGroup,
		//line sql.y: 2011
		Text: `
CREATE DATABASE, CREATE TABLE, CREATE INDEX, CREATE TABLE AS,
CREATE USER, CREATE VIEW, CREATE SEQUENCE, CREATE STATISTICS,
CREATE ROLE
`,
	},
	//line sql.y: 2092
	`CREATE STATISTICS`: {
		ShortDescription: `create a new table statistic`,
		//line sql.y: 2093
		Category: hMisc,
		//line sql.y: 2094
		Text: `
CREATE STATISTICS <statisticname>
  [ON <colname> [, ...]]
  FROM <tablename> [AS OF SYSTEM TIME <expr>]
`,
	},
	//line sql.y: 2238
	`DELETE`: {
		ShortDescription: `delete rows from a table`,
		//line sql.y: 2239
		Category: hDML,
		//line sql.y: 2240
		Text: `DELETE FROM <tablename> [WHERE <expr>]
              [ORDER BY <exprs...>]
              [LIMIT <expr>]
              [RETURNING <exprs...>]
`,
		//line sql.y: 2244
		SeeAlso: `WEBDOCS/delete.html
`,
	},
	//line sql.y: 2259
	`DISCARD`: {
		ShortDescription: `reset the session to its initial state`,
		//line sql.y: 2260
		Category: hCfg,
		//line sql.y: 2261
		Text: `DISCARD ALL
`,
	},
	//line sql.y: 2273
	`DROP`: {
		//line sql.y: 2274
		Category: hGroup,
		//line sql.y: 2275
		Text: `
DROP DATABASE, DROP INDEX, DROP TABLE, DROP VIEW, DROP SEQUENCE,
DROP USER, DROP ROLE
`,
	},
	//line sql.y: 2292
	`DROP VIEW`: {
		ShortDescription: `remove a view`,
		//line sql.y: 2293
		Category: hDDL,
		//line sql.y: 2294
		Text: `DROP VIEW [IF EXISTS] <tablename> [, ...] [CASCADE | RESTRICT]
`,
		//line sql.y: 2295
		SeeAlso: `WEBDOCS/drop-index.html
`,
	},
	//line sql.y: 2307
	`DROP SEQUENCE`: {
		ShortDescription: `remove a sequence`,
		//line sql.y: 2308
		Category: hDDL,
		//line sql.y: 2309
		Text: `DROP SEQUENCE [IF EXISTS] <sequenceName> [, ...] [CASCADE | RESTRICT]
`,
		//line sql.y: 2310
		SeeAlso: `DROP
`,
	},
	//line sql.y: 2322
	`DROP TABLE`: {
		ShortDescription: `remove a table`,
		//line sql.y: 2323
		Category: hDDL,
		//line sql.y: 2324
		Text: `DROP TABLE [IF EXISTS] <tablename> [, ...] [CASCADE | RESTRICT]
`,
		//line sql.y: 2325
		SeeAlso: `WEBDOCS/drop-table.html
`,
	},
	//line sql.y: 2337
	`DROP INDEX`: {
		ShortDescription: `remove an index`,
		//line sql.y: 2338
		Category: hDDL,
		//line sql.y: 2339
		Text: `DROP INDEX [IF EXISTS] <idxname> [, ...] [CASCADE | RESTRICT]
`,
		//line sql.y: 2340
		SeeAlso: `WEBDOCS/drop-index.html
`,
	},
	//line sql.y: 2360
	`DROP DATABASE`: {
		ShortDescription: `remove a database`,
		//line sql.y: 2361
		Category: hDDL,
		//line sql.y: 2362
		Text: `DROP DATABASE [IF EXISTS] <databasename> [CASCADE | RESTRICT]
`,
		//line sql.y: 2363
		SeeAlso: `WEBDOCS/drop-database.html
`,
	},
	//line sql.y: 2383
	`DROP USER`: {
		ShortDescription: `remove a user`,
		//line sql.y: 2384
		Category: hPriv,
		//line sql.y: 2385
		Text: `DROP USER [IF EXISTS] <user> [, ...]
`,
		//line sql.y: 2386
		SeeAlso: `CREATE USER, SHOW USERS
`,
	},
	//line sql.y: 2398
	`DROP ROLE`: {
		ShortDescription: `remove a role`,
		//line sql.y: 2399
		Category: hPriv,
		//line sql.y: 2400
		Text: `DROP ROLE [IF EXISTS] <role> [, ...]
`,
		//line sql.y: 2401
		SeeAlso: `CREATE ROLE, SHOW ROLES
`,
	},
	//line sql.y: 2425
	`EXPLAIN`: {
		ShortDescription: `show the logical plan of a query`,
		//line sql.y: 2426
		Category: hMisc,
		//line sql.y: 2427
		Text: `
EXPLAIN <statement>
EXPLAIN ([PLAN ,] <planoptions...> ) <statement>
EXPLAIN [ANALYZE] (DISTSQL) <statement>
EXPLAIN ANALYZE [(DISTSQL)] <statement>

Explainable statements:
    SELECT, CREATE, DROP, ALTER, INSERT, UPSERT, UPDATE, DELETE,
    SHOW, EXPLAIN

Plan options:
    TYPES, VERBOSE, OPT

`,
		//line sql.y: 2440
		SeeAlso: `WEBDOCS/explain.html
`,
	},
	//line sql.y: 2500
	`PREPARE`: {
		ShortDescription: `prepare a statement for later execution`,
		//line sql.y: 2501
		Category: hMisc,
		//line sql.y: 2502
		Text: `PREPARE <name> [ ( <types...> ) ] AS <query>
`,
		//line sql.y: 2503
		SeeAlso: `EXECUTE, DEALLOCATE, DISCARD
`,
	},
	//line sql.y: 2534
	`EXECUTE`: {
		ShortDescription: `execute a statement prepared previously`,
		//line sql.y: 2535
		Category: hMisc,
		//line sql.y: 2536
		Text: `EXECUTE <name> [ ( <exprs...> ) ]
`,
		//line sql.y: 2537
		SeeAlso: `PREPARE, DEALLOCATE, DISCARD
`,
	},
	//line sql.y: 2567
	`DEALLOCATE`: {
		ShortDescription: `remove a prepared statement`,
		//line sql.y: 2568
		Category: hMisc,
		//line sql.y: 2569
		Text: `DEALLOCATE [PREPARE] { <name> | ALL }
`,
		//line sql.y: 2570
		SeeAlso: `PREPARE, EXECUTE, DISCARD
`,
	},
	//line sql.y: 2590
	`GRANT`: {
		ShortDescription: `define access privileges and role memberships`,
		//line sql.y: 2591
		Category: hPriv,
		//line sql.y: 2592
		Text: `
Grant privileges:
  GRANT {ALL | <privileges...> } ON <targets...> TO <grantees...>
Grant role membership (CCL only):
  GRANT <roles...> TO <grantees...> [WITH ADMIN OPTION]

Privileges:
  CREATE, DROP, GRANT, SELECT, INSERT, DELETE, UPDATE

Targets:
  DATABASE <databasename> [, ...]
  [TABLE] [<databasename> .] { <tablename> | * } [, ...]

`,
		//line sql.y: 2605
		SeeAlso: `REVOKE, WEBDOCS/grant.html
`,
	},
	//line sql.y: 2621
	`REVOKE`: {
		ShortDescription: `remove access privileges and role memberships`,
		//line sql.y: 2622
		Category: hPriv,
		//line sql.y: 2623
		Text: `
Revoke privileges:
  REVOKE {ALL | <privileges...> } ON <targets...> FROM <grantees...>
Revoke role membership (CCL only):
  REVOKE [ADMIN OPTION FOR] <roles...> FROM <grantees...>

Privileges:
  CREATE, DROP, GRANT, SELECT, INSERT, DELETE, UPDATE

Targets:
  DATABASE <databasename> [, <databasename>]...
  [TABLE] [<databasename> .] { <tablename> | * } [, ...]

`,
		//line sql.y: 2636
		SeeAlso: `GRANT, WEBDOCS/revoke.html
`,
	},
	//line sql.y: 2690
	`RESET`: {
		ShortDescription: `reset a session variable to its default value`,
		//line sql.y: 2691
		Category: hCfg,
		//line sql.y: 2692
		Text: `RESET [SESSION] <var>
`,
		//line sql.y: 2693
		SeeAlso: `RESET CLUSTER SETTING, WEBDOCS/set-vars.html
`,
	},
	//line sql.y: 2705
	`RESET CLUSTER SETTING`: {
		ShortDescription: `reset a cluster setting to its default value`,
		//line sql.y: 2706
		Category: hCfg,
		//line sql.y: 2707
		Text: `RESET CLUSTER SETTING <var>
`,
		//line sql.y: 2708
		SeeAlso: `SET CLUSTER SETTING, RESET
`,
	},
	//line sql.y: 2717
	`USE`: {
		ShortDescription: `set the current database`,
		//line sql.y: 2718
		Category: hCfg,
		//line sql.y: 2719
		Text: `USE <dbname>

"USE <dbname>" is an alias for "SET [SESSION] database = <dbname>".
`,
		//line sql.y: 2722
		SeeAlso: `SET SESSION, WEBDOCS/set-vars.html
`,
	},
	//line sql.y: 2743
	`SCRUB`: {
		ShortDescription: `run checks against databases or tables`,
		//line sql.y: 2744
		Category: hExperimental,
		//line sql.y: 2745
		Text: `
EXPERIMENTAL SCRUB TABLE <table> ...
EXPERIMENTAL SCRUB DATABASE <database>

The various checks that ca be run with SCRUB includes:
  - Physical table data (encoding)
  - Secondary index integrity
  - Constraint integrity (NOT NULL, CHECK, FOREIGN KEY, UNIQUE)
`,
		//line sql.y: 2753
		SeeAlso: `SCRUB TABLE, SCRUB DATABASE
`,
	},
	//line sql.y: 2759
	`SCRUB DATABASE`: {
		ShortDescription: `run scrub checks on a database`,
		//line sql.y: 2760
		Category: hExperimental,
		//line sql.y: 2761
		Text: `
EXPERIMENTAL SCRUB DATABASE <database>
                            [AS OF SYSTEM TIME <expr>]

All scrub checks will be run on the database. This includes:
  - Physical table data (encoding)
  - Secondary index integrity
  - Constraint integrity (NOT NULL, CHECK, FOREIGN KEY, UNIQUE)
`,
		//line sql.y: 2769
		SeeAlso: `SCRUB TABLE, SCRUB
`,
	},
	//line sql.y: 2777
	`SCRUB TABLE`: {
		ShortDescription: `run scrub checks on a table`,
		//line sql.y: 2778
		Category: hExperimental,
		//line sql.y: 2779
		Text: `
SCRUB TABLE <tablename>
            [AS OF SYSTEM TIME <expr>]
            [WITH OPTIONS <option> [, ...]]

Options:
  EXPERIMENTAL SCRUB TABLE ... WITH OPTIONS INDEX ALL
  EXPERIMENTAL SCRUB TABLE ... WITH OPTIONS INDEX (<index>...)
  EXPERIMENTAL SCRUB TABLE ... WITH OPTIONS CONSTRAINT ALL
  EXPERIMENTAL SCRUB TABLE ... WITH OPTIONS CONSTRAINT (<constraint>...)
  EXPERIMENTAL SCRUB TABLE ... WITH OPTIONS PHYSICAL
`,
		//line sql.y: 2790
		SeeAlso: `SCRUB DATABASE, SRUB
`,
	},
	//line sql.y: 2846
	`SET CLUSTER SETTING`: {
		ShortDescription: `change a cluster setting`,
		//line sql.y: 2847
		Category: hCfg,
		//line sql.y: 2848
		Text: `SET CLUSTER SETTING <var> { TO | = } <value>
`,
		//line sql.y: 2849
		SeeAlso: `SHOW CLUSTER SETTING, RESET CLUSTER SETTING, SET SESSION,
WEBDOCS/cluster-settings.html
`,
	},
	//line sql.y: 2870
	`SET SESSION`: {
		ShortDescription: `change a session variable`,
		//line sql.y: 2871
		Category: hCfg,
		//line sql.y: 2872
		Text: `
SET [SESSION] <var> { TO | = } <values...>
SET [SESSION] TIME ZONE <tz>
SET [SESSION] CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL { SNAPSHOT | SERIALIZABLE }
SET [SESSION] TRACING { TO | = } { on | off | cluster | local | kv | results } [,...]

`,
		//line sql.y: 2878
		SeeAlso: `SHOW SESSION, RESET, DISCARD, SHOW, SET CLUSTER SETTING, SET TRANSACTION,
WEBDOCS/set-vars.html
`,
	},
	//line sql.y: 2895
	`SET TRANSACTION`: {
		ShortDescription: `configure the transaction settings`,
		//line sql.y: 2896
		Category: hTxn,
		//line sql.y: 2897
		Text: `
SET [SESSION] TRANSACTION <txnparameters...>

Transaction parameters:
   ISOLATION LEVEL { SNAPSHOT | SERIALIZABLE }
   PRIORITY { LOW | NORMAL | HIGH }

`,
		//line sql.y: 2904
		SeeAlso: `SHOW TRANSACTION, SET SESSION,
WEBDOCS/set-transaction.html
`,
	},
	//line sql.y: 3087
	`SHOW`: {
		//line sql.y: 3088
		Category: hGroup,
		//line sql.y: 3089
		Text: `
SHOW BACKUP, SHOW CLUSTER SETTING, SHOW COLUMNS, SHOW CONSTRAINTS,
SHOW CREATE, SHOW DATABASES, SHOW HISTOGRAM, SHOW INDEXES, SHOW
JOBS, SHOW QUERIES, SHOW ROLES, SHOW SCHEMAS, SHOW SEQUENCES, SHOW
SESSION, SHOW SESSIONS, SHOW STATISTICS, SHOW SYNTAX, SHOW TABLES,
SHOW TRACE SHOW TRANSACTION, SHOW USERS
`,
	},
	//line sql.y: 3123
	`SHOW SESSION`: {
		ShortDescription: `display session variables`,
		//line sql.y: 3124
		Category: hCfg,
		//line sql.y: 3125
		Text: `SHOW [SESSION] { <var> | ALL }
`,
		//line sql.y: 3126
		SeeAlso: `WEBDOCS/show-vars.html
`,
	},
	//line sql.y: 3147
	`SHOW STATISTICS`: {
		ShortDescription: `display table statistics (experimental)`,
		//line sql.y: 3148
		Category: hExperimental,
		//line sql.y: 3149
		Text: `SHOW STATISTICS [USING JSON] FOR TABLE <table_name>

Returns the available statistics for a table.
The statistics can include a histogram ID, which can
be used with SHOW HISTOGRAM.
If USING JSON is specified, the statistics and histograms
are encoded in JSON format.
`,
		//line sql.y: 3156
		SeeAlso: `SHOW HISTOGRAM
`,
	},
	//line sql.y: 3171
	`SHOW HISTOGRAM`: {
		ShortDescription: `display histogram (experimental)`,
		//line sql.y: 3172
		Category: hExperimental,
		//line sql.y: 3173
		Text: `SHOW HISTOGRAM <histogram_id>

Returns the data in the histogram with the
given ID (as returned by SHOW STATISTICS).
`,
		//line sql.y: 3177
		SeeAlso: `SHOW STATISTICS
`,
	},
	//line sql.y: 3190
	`SHOW BACKUP`: {
		ShortDescription: `list backup contents`,
		//line sql.y: 3191
		Category: hCCL,
		//line sql.y: 3192
		Text: `SHOW BACKUP [FILES|RANGES] <location>
`,
		//line sql.y: 3193
		SeeAlso: `WEBDOCS/show-backup.html
`,
	},
	//line sql.y: 3220
	`SHOW CLUSTER SETTING`: {
		ShortDescription: `display cluster settings`,
		//line sql.y: 3221
		Category: hCfg,
		//line sql.y: 3222
		Text: `
SHOW CLUSTER SETTING <var>
SHOW ALL CLUSTER SETTINGS
`,
		//line sql.y: 3225
		SeeAlso: `WEBDOCS/cluster-settings.html
`,
	},
	//line sql.y: 3242
	`SHOW COLUMNS`: {
		ShortDescription: `list columns in relation`,
		//line sql.y: 3243
		Category: hDDL,
		//line sql.y: 3244
		Text: `SHOW COLUMNS FROM <tablename>
`,
		//line sql.y: 3245
		SeeAlso: `WEBDOCS/show-columns.html
`,
	},
	//line sql.y: 3254
	`SHOW DATABASES`: {
		ShortDescription: `list databases`,
		//line sql.y: 3255
		Category: hDDL,
		//line sql.y: 3256
		Text: `SHOW DATABASES
`,
		//line sql.y: 3257
		SeeAlso: `WEBDOCS/show-databases.html
`,
	},
	//line sql.y: 3265
	`SHOW GRANTS`: {
		ShortDescription: `list grants`,
		//line sql.y: 3266
		Category: hPriv,
		//line sql.y: 3267
		Text: `
Show privilege grants:
  SHOW GRANTS [ON <targets...>] [FOR <users...>]
Show role grants:
  SHOW GRANTS ON ROLE [<roles...>] [FOR <grantees...>]

`,
		//line sql.y: 3273
		SeeAlso: `WEBDOCS/show-grants.html
`,
	},
	//line sql.y: 3286
	`SHOW INDEXES`: {
		ShortDescription: `list indexes`,
		//line sql.y: 3287
		Category: hDDL,
		//line sql.y: 3288
		Text: `SHOW INDEXES FROM <tablename>
`,
		//line sql.y: 3289
		SeeAlso: `WEBDOCS/show-index.html
`,
	},
	//line sql.y: 3310
	`SHOW CONSTRAINTS`: {
		ShortDescription: `list constraints`,
		//line sql.y: 3311
		Category: hDDL,
		//line sql.y: 3312
		Text: `SHOW CONSTRAINTS FROM <tablename>
`,
		//line sql.y: 3313
		SeeAlso: `WEBDOCS/show-constraints.html
`,
	},
	//line sql.y: 3328
	`SHOW QUERIES`: {
		ShortDescription: `list running queries`,
		//line sql.y: 3329
		Category: hMisc,
		//line sql.y: 3330
		Text: `SHOW [ALL] [CLUSTER | LOCAL] QUERIES
`,
		//line sql.y: 3331
		SeeAlso: `CANCEL QUERIES
`,
	},
	//line sql.y: 3352
	`SHOW JOBS`: {
		ShortDescription: `list background jobs`,
		//line sql.y: 3353
		Category: hMisc,
		//line sql.y: 3354
		Text: `SHOW [AUTOMATIC] JOBS
`,
		//line sql.y: 3355
		SeeAlso: `CANCEL JOBS, PAUSE JOBS, RESUME JOBS
`,
	},
	//line sql.y: 3367
	`SHOW TRACE`: {
		ShortDescription: `display an execution trace`,
		//line sql.y: 3368
		Category: hMisc,
		//line sql.y: 3369
		Text: `
SHOW [COMPACT] [KV] TRACE FOR SESSION
`,
		//line sql.y: 3371
		SeeAlso: `EXPLAIN
`,
	},
	//line sql.y: 3394
	`SHOW SESSIONS`: {
		ShortDescription: `list open client sessions`,
		//line sql.y: 3395
		Category: hMisc,
		//line sql.y: 3396
		Text: `SHOW [ALL] [CLUSTER | LOCAL] SESSIONS
`,
		//line sql.y: 3397
		SeeAlso: `CANCEL SESSIONS
`,
	},
	//line sql.y: 3410
	`SHOW TABLES`: {
		ShortDescription: `list tables`,
		//line sql.y: 3411
		Category: hDDL,
		//line sql.y: 3412
		Text: `SHOW TABLES [FROM <databasename> [ . <schemaname> ] ] [WITH COMMENT]
`,
		//line sql.y: 3413
		SeeAlso: `WEBDOCS/show-tables.html
`,
	},
	//line sql.y: 3445
	`SHOW SCHEMAS`: {
		ShortDescription: `list schemas`,
		//line sql.y: 3446
		Category: hDDL,
		//line sql.y: 3447
		Text: `SHOW SCHEMAS [FROM <databasename> ]
`,
	},
	//line sql.y: 3459
	`SHOW SEQUENCES`: {
		ShortDescription: `list sequences`,
		//line sql.y: 3460
		Category: hDDL,
		//line sql.y: 3461
		Text: `SHOW SEQUENCES [FROM <databasename> ]
`,
	},
	//line sql.y: 3473
	`SHOW SYNTAX`: {
		ShortDescription: `analyze SQL syntax`,
		//line sql.y: 3474
		Category: hMisc,
		//line sql.y: 3475
		Text: `SHOW SYNTAX <string>
`,
	},
	//line sql.y: 3484
	`SHOW TRANSACTION`: {
		ShortDescription: `display current transaction properties`,
		//line sql.y: 3485
		Category: hCfg,
		//line sql.y: 3486
		Text: `SHOW TRANSACTION {ISOLATION LEVEL | PRIORITY | STATUS}
`,
		//line sql.y: 3487
		SeeAlso: `WEBDOCS/show-transaction.html
`,
	},
	//line sql.y: 3506
	`SHOW CREATE`: {
		ShortDescription: `display the CREATE statement for a table, sequence or view`,
		//line sql.y: 3507
		Category: hDDL,
		//line sql.y: 3508
		Text: `SHOW CREATE [ TABLE | SEQUENCE | VIEW ] <tablename>
`,
		//line sql.y: 3509
		SeeAlso: `WEBDOCS/show-create-table.html
`,
	},
	//line sql.y: 3529
	`SHOW USERS`: {
		ShortDescription: `list defined users`,
		//line sql.y: 3530
		Category: hPriv,
		//line sql.y: 3531
		Text: `SHOW USERS
`,
		//line sql.y: 3532
		SeeAlso: `CREATE USER, DROP USER, WEBDOCS/show-users.html
`,
	},
	//line sql.y: 3540
	`SHOW ROLES`: {
		ShortDescription: `list defined roles`,
		//line sql.y: 3541
		Category: hPriv,
		//line sql.y: 3542
		Text: `SHOW ROLES
`,
		//line sql.y: 3543
		SeeAlso: `CREATE ROLE, DROP ROLE
`,
	},
	//line sql.y: 3590
	`SHOW RANGES`: {
		ShortDescription: `list ranges`,
		//line sql.y: 3591
		Category: hMisc,
		//line sql.y: 3592
		Text: `
SHOW EXPERIMENTAL_RANGES FROM TABLE <tablename>
SHOW EXPERIMENTAL_RANGES FROM INDEX [ <tablename> @ ] <indexname>
`,
	},
	//line sql.y: 3830
	`PAUSE JOBS`: {
		ShortDescription: `pause background jobs`,
		//line sql.y: 3831
		Category: hMisc,
		//line sql.y: 3832
		Text: `
PAUSE JOBS <selectclause>
PAUSE JOB <jobid>
`,
		//line sql.y: 3835
		SeeAlso: `SHOW JOBS, CANCEL JOBS, RESUME JOBS
`,
	},
	//line sql.y: 3852
	`CREATE TABLE`: {
		ShortDescription: `create a new table`,
		//line sql.y: 3853
		Category: hDDL,
		//line sql.y: 3854
		Text: `
CREATE TABLE [IF NOT EXISTS] <tablename> ( <elements...> ) [<interleave>]
CREATE TABLE [IF NOT EXISTS] <tablename> [( <colnames...> )] AS <source>

Table elements:
   <name> <type> [<qualifiers...>]
   [UNIQUE | INVERTED] INDEX [<name>] ( <colname> [ASC | DESC] [, ...] )
                           [STORING ( <colnames...> )] [<interleave>]
   FAMILY [<name>] ( <colnames...> )
   [CONSTRAINT <name>] <constraint>

Table constraints:
   PRIMARY KEY ( <colnames...> )
   FOREIGN KEY ( <colnames...> ) REFERENCES <tablename> [( <colnames...> )] [ON DELETE {NO ACTION | RESTRICT}] [ON UPDATE {NO ACTION | RESTRICT}]
   UNIQUE ( <colnames... ) [STORING ( <colnames...> )] [<interleave>]
   CHECK ( <expr> )

Column qualifiers:
  [CONSTRAINT <constraintname>] {NULL | NOT NULL | UNIQUE | PRIMARY KEY | CHECK (<expr>) | DEFAULT <expr>}
  FAMILY <familyname>, CREATE [IF NOT EXISTS] FAMILY [<familyname>]
  REFERENCES <tablename> [( <colnames...> )] [ON DELETE {NO ACTION | RESTRICT}] [ON UPDATE {NO ACTION | RESTRICT}]
  COLLATE <collationname>
  AS ( <expr> ) STORED

Interleave clause:
   INTERLEAVE IN PARENT <tablename> ( <colnames...> ) [CASCADE | RESTRICT]

`,
		//line sql.y: 3881
		SeeAlso: `SHOW TABLES, CREATE VIEW, SHOW CREATE,
WEBDOCS/create-table.html
WEBDOCS/create-table-as.html
`,
	},
	//line sql.y: 4468
	`CREATE SEQUENCE`: {
		ShortDescription: `create a new sequence`,
		//line sql.y: 4469
		Category: hDDL,
		//line sql.y: 4470
		Text: `
CREATE SEQUENCE <seqname>
  [INCREMENT <increment>]
  [MINVALUE <minvalue> | NO MINVALUE]
  [MAXVALUE <maxvalue> | NO MAXVALUE]
  [START [WITH] <start>]
  [CACHE <cache>]
  [NO CYCLE]
  [VIRTUAL]

`,
		//line sql.y: 4480
		SeeAlso: `CREATE TABLE
`,
	},
	//line sql.y: 4527
	`TRUNCATE`: {
		ShortDescription: `empty one or more tables`,
		//line sql.y: 4528
		Category: hDML,
		//line sql.y: 4529
		Text: `TRUNCATE [TABLE] <tablename> [, ...] [CASCADE | RESTRICT]
`,
		//line sql.y: 4530
		SeeAlso: `WEBDOCS/truncate.html
`,
	},
	//line sql.y: 4538
	`CREATE USER`: {
		ShortDescription: `define a new user`,
		//line sql.y: 4539
		Category: hPriv,
		//line sql.y: 4540
		Text: `CREATE USER [IF NOT EXISTS] <name> [ [WITH] PASSWORD <passwd> ]
`,
		//line sql.y: 4541
		SeeAlso: `DROP USER, SHOW USERS, WEBDOCS/create-user.html
`,
	},
	//line sql.y: 4563
	`CREATE ROLE`: {
		ShortDescription: `define a new role`,
		//line sql.y: 4564
		Category: hPriv,
		//line sql.y: 4565
		Text: `CREATE ROLE [IF NOT EXISTS] <name>
`,
		//line sql.y: 4566
		SeeAlso: `DROP ROLE, SHOW ROLES
`,
	},
	//line sql.y: 4584
	`CREATE VIEW`: {
		ShortDescription: `create a new view`,
		//line sql.y: 4585
		Category: hDDL,
		//line sql.y: 4586
		Text: `CREATE VIEW <viewname> [( <colnames...> )] AS <source>
`,
		//line sql.y: 4587
		SeeAlso: `CREATE TABLE, SHOW CREATE, WEBDOCS/create-view.html
`,
	},
	//line sql.y: 4621
	`CREATE INDEX`: {
		ShortDescription: `create a new index`,
		//line sql.y: 4622
		Category: hDDL,
		//line sql.y: 4623
		Text: `
CREATE [UNIQUE | INVERTED] INDEX [IF NOT EXISTS] [<idxname>]
       ON <tablename> ( <colname> [ASC | DESC] [, ...] )
       [STORING ( <colnames...> )] [<interleave>]

Interleave clause:
   INTERLEAVE IN PARENT <tablename> ( <colnames...> ) [CASCADE | RESTRICT]

`,
		//line sql.y: 4631
		SeeAlso: `CREATE TABLE, SHOW INDEXES, SHOW CREATE,
WEBDOCS/create-index.html
`,
	},
	//line sql.y: 4849
	`RELEASE`: {
		ShortDescription: `complete a retryable block`,
		//line sql.y: 4850
		Category: hTxn,
		//line sql.y: 4851
		Text: `RELEASE [SAVEPOINT] cockroach_restart
`,
		//line sql.y: 4852
		SeeAlso: `SAVEPOINT, WEBDOCS/savepoint.html
`,
	},
	//line sql.y: 4860
	`RESUME JOBS`: {
		ShortDescription: `resume background jobs`,
		//line sql.y: 4861
		Category: hMisc,
		//line sql.y: 4862
		Text: `
RESUME JOBS <selectclause>
RESUME JOB <jobid>
`,
		//line sql.y: 4865
		SeeAlso: `SHOW JOBS, CANCEL JOBS, PAUSE JOBS
`,
	},
	//line sql.y: 4882
	`SAVEPOINT`: {
		ShortDescription: `start a retryable block`,
		//line sql.y: 4883
		Category: hTxn,
		//line sql.y: 4884
		Text: `SAVEPOINT cockroach_restart
`,
		//line sql.y: 4885
		SeeAlso: `RELEASE, WEBDOCS/savepoint.html
`,
	},
	//line sql.y: 4900
	`BEGIN`: {
		ShortDescription: `start a transaction`,
		//line sql.y: 4901
		Category: hTxn,
		//line sql.y: 4902
		Text: `
BEGIN [TRANSACTION] [ <txnparameter> [[,] ...] ]
START TRANSACTION [ <txnparameter> [[,] ...] ]

Transaction parameters:
   ISOLATION LEVEL { SNAPSHOT | SERIALIZABLE }
   PRIORITY { LOW | NORMAL | HIGH }

`,
		//line sql.y: 4910
		SeeAlso: `COMMIT, ROLLBACK, WEBDOCS/begin-transaction.html
`,
	},
	//line sql.y: 4923
	`COMMIT`: {
		ShortDescription: `commit the current transaction`,
		//line sql.y: 4924
		Category: hTxn,
		//line sql.y: 4925
		Text: `
COMMIT [TRANSACTION]
END [TRANSACTION]
`,
		//line sql.y: 4928
		SeeAlso: `BEGIN, ROLLBACK, WEBDOCS/commit-transaction.html
`,
	},
	//line sql.y: 4952
	`ROLLBACK`: {
		ShortDescription: `abort the current transaction`,
		//line sql.y: 4953
		Category: hTxn,
		//line sql.y: 4954
		Text: `ROLLBACK [TRANSACTION] [TO [SAVEPOINT] cockroach_restart]
`,
		//line sql.y: 4955
		SeeAlso: `BEGIN, COMMIT, SAVEPOINT, WEBDOCS/rollback-transaction.html
`,
	},
	//line sql.y: 5073
	`CREATE DATABASE`: {
		ShortDescription: `create a new database`,
		//line sql.y: 5074
		Category: hDDL,
		//line sql.y: 5075
		Text: `CREATE DATABASE [IF NOT EXISTS] <name>
`,
		//line sql.y: 5076
		SeeAlso: `WEBDOCS/create-database.html
`,
	},
	//line sql.y: 5145
	`INSERT`: {
		ShortDescription: `create new rows in a table`,
		//line sql.y: 5146
		Category: hDML,
		//line sql.y: 5147
		Text: `
INSERT INTO <tablename> [[AS] <name>] [( <colnames...> )]
       <selectclause>
       [ON CONFLICT [( <colnames...> )] {DO UPDATE SET ... [WHERE <expr>] | DO NOTHING}]
       [RETURNING <exprs...>]
`,
		//line sql.y: 5152
		SeeAlso: `UPSERT, UPDATE, DELETE, WEBDOCS/insert.html
`,
	},
	//line sql.y: 5171
	`UPSERT`: {
		ShortDescription: `create or replace rows in a table`,
		//line sql.y: 5172
		Category: hDML,
		//line sql.y: 5173
		Text: `
UPSERT INTO <tablename> [AS <name>] [( <colnames...> )]
       <selectclause>
       [RETURNING <exprs...>]
`,
		//line sql.y: 5177
		SeeAlso: `INSERT, UPDATE, DELETE, WEBDOCS/upsert.html
`,
	},
	//line sql.y: 5284
	`UPDATE`: {
		ShortDescription: `update rows of a table`,
		//line sql.y: 5285
		Category: hDML,
		//line sql.y: 5286
		Text: `
UPDATE <tablename> [[AS] <name>]
       SET ...
       [WHERE <expr>]
       [ORDER BY <exprs...>]
       [LIMIT <expr>]
       [RETURNING <exprs...>]
`,
		//line sql.y: 5293
		SeeAlso: `INSERT, UPSERT, DELETE, WEBDOCS/update.html
`,
	},
	//line sql.y: 5467
	`<SELECTCLAUSE>`: {
		ShortDescription: `access tabular data`,
		//line sql.y: 5468
		Category: hDML,
		//line sql.y: 5469
		Text: `
Select clause:
  TABLE <tablename>
  VALUES ( <exprs...> ) [ , ... ]
  SELECT ... [ { INTERSECT | UNION | EXCEPT } [ ALL | DISTINCT ] <selectclause> ]
`,
	},
	//line sql.y: 5480
	`SELECT`: {
		ShortDescription: `retrieve rows from a data source and compute a result`,
		//line sql.y: 5481
		Category: hDML,
		//line sql.y: 5482
		Text: `
SELECT [DISTINCT [ ON ( <expr> [ , ... ] ) ] ]
       { <expr> [[AS] <name>] | [ [<dbname>.] <tablename>. ] * } [, ...]
       [ FROM <source> ]
       [ WHERE <expr> ]
       [ GROUP BY <expr> [ , ... ] ]
       [ HAVING <expr> ]
       [ WINDOW <name> AS ( <definition> ) ]
       [ { UNION | INTERSECT | EXCEPT } [ ALL | DISTINCT ] <selectclause> ]
       [ ORDER BY <expr> [ ASC | DESC ] [, ...] ]
       [ LIMIT { <expr> | ALL } ]
       [ OFFSET <expr> [ ROW | ROWS ] ]
`,
		//line sql.y: 5494
		SeeAlso: `WEBDOCS/select-clause.html
`,
	},
	//line sql.y: 5569
	`TABLE`: {
		ShortDescription: `select an entire table`,
		//line sql.y: 5570
		Category: hDML,
		//line sql.y: 5571
		Text: `TABLE <tablename>
`,
		//line sql.y: 5572
		SeeAlso: `SELECT, VALUES, WEBDOCS/table-expressions.html
`,
	},
	//line sql.y: 5852
	`VALUES`: {
		ShortDescription: `select a given set of values`,
		//line sql.y: 5853
		Category: hDML,
		//line sql.y: 5854
		Text: `VALUES ( <exprs...> ) [, ...]
`,
		//line sql.y: 5855
		SeeAlso: `SELECT, TABLE, WEBDOCS/table-expressions.html
`,
	},
	//line sql.y: 5958
	`<SOURCE>`: {
		ShortDescription: `define a data source for SELECT`,
		//line sql.y: 5959
		Category: hDML,
		//line sql.y: 5960
		Text: `
Data sources:
  <tablename> [ @ { <idxname> | <indexflags> } ]
  <tablefunc> ( <exprs...> )
  ( { <selectclause> | <source> } )
  <source> [AS] <alias> [( <colnames...> )]
  <source> [ <jointype> ] JOIN <source> ON <expr>
  <source> [ <jointype> ] JOIN <source> USING ( <colnames...> )
  <source> NATURAL [ <jointype> ] JOIN <source>
  <source> CROSS JOIN <source>
  <source> WITH ORDINALITY
  '[' EXPLAIN ... ']'
  '[' SHOW ... ']'

Index flags:
  '{' FORCE_INDEX = <idxname> [, ...] '}'
  '{' NO_INDEX_JOIN [, ...] '}'

Join types:
  { INNER | { LEFT | RIGHT | FULL } [OUTER] } [ { HASH | MERGE | LOOKUP } ]

`,
		//line sql.y: 5981
		SeeAlso: `WEBDOCS/table-expressions.html
`,
	},
}
