// Code generated by optgen; DO NOT EDIT.

package norm

import (
	"github.com/cockroachdb/cockroach/pkg/sql/coltypes"
	"github.com/cockroachdb/cockroach/pkg/sql/opt"
	"github.com/cockroachdb/cockroach/pkg/sql/opt/memo"
	"github.com/cockroachdb/cockroach/pkg/sql/opt/props/physical"
	"github.com/cockroachdb/cockroach/pkg/sql/pgwire/pgerror"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/types"
	"github.com/cockroachdb/cockroach/pkg/util/log"
)

// ConstructScan constructs an expression for the Scan operator.
// Scan returns a result set containing every row in a table by scanning one of
// the table's indexes according to its ordering. The ScanPrivate field
// identifies the table and index to scan, as well as the subset of columns to
// project from it.
//
// The scan can be constrained and/or have an internal row limit. A scan can be
// executed either as a forward or as a reverse scan (except when it has a limit,
// in which case the direction is fixed).
func (_f *Factory) ConstructScan(
	scanPrivate *memo.ScanPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeScan(scanPrivate)
	return _f.onConstructRelational(e)
}

// ConstructVirtualScan constructs an expression for the VirtualScan operator.
// VirtualScan returns a result set containing every row in a virtual table.
// Virtual tables are system tables that are populated "on the fly" with rows
// synthesized from system metadata and other state. An example is the
// "information_schema.tables" virtual table which returns one row for each
// accessible system or user table.
//
// VirtualScan has many of the same characteristics as the Scan operator.
// However, virtual tables do not have indexes or keys, and the physical operator
// used to scan virtual tables does not support limits or constraints. Therefore,
// nearly all the rules that apply to Scan do not apply to VirtualScan, so it
// makes sense to have a separate operator.
func (_f *Factory) ConstructVirtualScan(
	virtualScanPrivate *memo.VirtualScanPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeVirtualScan(virtualScanPrivate)
	return _f.onConstructRelational(e)
}

// ConstructSequenceSelect constructs an expression for the SequenceSelect operator.
// SequenceSelect represents a read from a sequence as a data source. It always returns
// three columns, last_value, log_cnt, and is_called, with a single row. last_value is
// the most recent value returned from the sequence and log_cnt and is_called are
// always 0 and true, respectively.
func (_f *Factory) ConstructSequenceSelect(
	sequenceSelectPrivate *memo.SequenceSelectPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeSequenceSelect(sequenceSelectPrivate)
	return _f.onConstructRelational(e)
}

// ConstructValues constructs an expression for the Values operator.
// Values returns a manufactured result set containing a constant number of rows.
// specified by the Rows list field. Each row must contain the same set of
// columns in the same order.
//
// The Rows field contains a list of Tuples, one for each row. Each tuple has
// the same length (same with that of Cols).
//
// The Cols field contains the set of column indices returned by each row
// as an opt.ColList. It is legal for Cols to be empty.
func (_f *Factory) ConstructValues(
	rows memo.ScalarListExpr,
	valuesPrivate *memo.ValuesPrivate,
) memo.RelExpr {
	// [HoistValuesSubquery]
	{
		for i := range rows {
			item := rows[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := valuesPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistValuesSubquery) {
					_expr := _f.funcs.HoistValuesSubquery(rows, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistValuesSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeValues(rows, valuesPrivate)
	return _f.onConstructRelational(e)
}

// ConstructSelect constructs an expression for the Select operator.
// Select filters rows from its input result set, based on the boolean filter
// predicate expression. Rows which do not match the filter are discarded. While
// the Filter operand can be any boolean expression, normalization rules will
// typically convert it to a Filters operator in order to make conjunction list
// matching easier.
func (_f *Factory) ConstructSelect(
	input memo.RelExpr,
	filters memo.FiltersExpr,
) memo.RelExpr {
	// [RejectNullsLeftJoin]
	{
		if input.Op() == opt.LeftJoinOp || input.Op() == opt.LeftJoinApplyOp || input.Op() == opt.FullJoinOp || input.Op() == opt.FullJoinApplyOp {
			left := input.Child(0).(memo.RelExpr)
			right := input.Child(1).(memo.RelExpr)
			on := *input.Child(2).(*memo.FiltersExpr)
			private := input.Private().(*memo.JoinPrivate)
			if _f.funcs.HasNullRejectingFilter(filters, _f.funcs.OutputCols(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.RejectNullsLeftJoin) {
					_expr := _f.ConstructSelect(
						_f.funcs.ConstructNonLeftJoin(input.Op(), left, right, on, private),
						filters,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.RejectNullsLeftJoin, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [RejectNullsRightJoin]
	{
		if input.Op() == opt.RightJoinOp || input.Op() == opt.RightJoinApplyOp || input.Op() == opt.FullJoinOp || input.Op() == opt.FullJoinApplyOp {
			left := input.Child(0).(memo.RelExpr)
			right := input.Child(1).(memo.RelExpr)
			on := *input.Child(2).(*memo.FiltersExpr)
			private := input.Private().(*memo.JoinPrivate)
			if _f.funcs.HasNullRejectingFilter(filters, _f.funcs.OutputCols(left)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.RejectNullsRightJoin) {
					_expr := _f.ConstructSelect(
						_f.funcs.ConstructNonRightJoin(input.Op(), left, right, on, private),
						filters,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.RejectNullsRightJoin, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifySelectFilters]
	{
		for i := range filters {
			_item := &filters[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(filters) {
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifySelectFilters) {
						_expr := _f.ConstructSelect(
							input,
							_f.funcs.SimplifyFilters(filters),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifySelectFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeSelectAnyFilter]
	{
		for i := range filters {
			item := &filters[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeSelectAnyFilter) {
					_expr := _f.ConstructSelect(
						input,
						_f.funcs.ReplaceFiltersItem(filters, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeSelectAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeSelectNotAnyFilter]
	{
		for i := range filters {
			item := &filters[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeSelectNotAnyFilter) {
						_expr := _f.ConstructSelect(
							input,
							_f.funcs.ReplaceFiltersItem(filters, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeSelectNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineSelectConstants]
	{
		constCols := _f.funcs.FindInlinableConstants(input)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range filters {
				item := &filters[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineSelectConstants) {
						_expr := _f.ConstructSelect(
							input,
							_f.funcs.InlineFilterConstants(filters, input, constCols),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineSelectConstants, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectSelectContradiction]
	{
		for i := range filters {
			item := &filters[i]
			if _f.funcs.IsContradiction(item) {
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectSelectContradiction) {
					_expr := _f.funcs.ConstructEmptyValues(_f.funcs.OutputCols(input)).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectSelectContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [EliminateSelect]
	{
		if len(filters) == 0 {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateSelect) {
				_expr := input
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateSelect, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [MergeSelects]
	{
		_select, _ := input.(*memo.SelectExpr)
		if _select != nil {
			input := _select.Input
			innerFilters := _select.Filters
			if _f.matchedRule == nil || _f.matchedRule(opt.MergeSelects) {
				_expr := _f.ConstructSelect(
					input,
					_f.funcs.ConcatFilters(innerFilters, filters),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.MergeSelects, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [PushSelectIntoProject]
	{
		_project, _ := input.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			passthrough := _project.Passthrough
			for i := range filters {
				item := &filters[i]
				inputCols := _f.funcs.OutputCols(input)
				if _f.funcs.IsBoundBy(item, inputCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectIntoProject) {
						_expr := _f.ConstructSelect(
							_f.ConstructProject(
								_f.ConstructSelect(
									input,
									_f.funcs.ExtractBoundConditions(filters, inputCols),
								),
								projections,
								passthrough,
							),
							_f.funcs.ExtractUnboundConditions(filters, inputCols),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushSelectIntoProject, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [MergeSelectInnerJoin]
	{
		if input.Op() == opt.InnerJoinOp || input.Op() == opt.InnerJoinApplyOp {
			left := input.Child(0).(memo.RelExpr)
			right := input.Child(1).(memo.RelExpr)
			on := *input.Child(2).(*memo.FiltersExpr)
			private := input.Private().(*memo.JoinPrivate)
			if _f.matchedRule == nil || _f.matchedRule(opt.MergeSelectInnerJoin) {
				_arg := _f.funcs.ConcatFilters(on, filters)
				_expr := _f.DynamicConstruct(
					input.Op(),
					left,
					right,
					&_arg,
					private,
				).(memo.RelExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.MergeSelectInnerJoin, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [PushSelectCondLeftIntoJoinLeftAndRight]
	{
		if input.Op() == opt.InnerJoinOp || input.Op() == opt.InnerJoinApplyOp || input.Op() == opt.LeftJoinOp || input.Op() == opt.LeftJoinApplyOp || input.Op() == opt.SemiJoinOp || input.Op() == opt.SemiJoinApplyOp || input.Op() == opt.AntiJoinOp || input.Op() == opt.AntiJoinApplyOp {
			left := input.Child(0).(memo.RelExpr)
			right := input.Child(1).(memo.RelExpr)
			on := *input.Child(2).(*memo.FiltersExpr)
			private := input.Private().(*memo.JoinPrivate)
			for i := range filters {
				item := &filters[i]
				condition := item.Condition
				if _f.funcs.IsBoundBy(item, _f.funcs.OutputCols(left)) {
					if _f.funcs.CanMap(on, item, right) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectCondLeftIntoJoinLeftAndRight) {
							on := on
							_expr := _f.ConstructSelect(
								_f.DynamicConstruct(
									input.Op(),
									_f.ConstructSelect(
										left,
										memo.FiltersExpr{
											{
												Condition: condition,
											},
										},
									),
									_f.ConstructSelect(
										right,
										memo.FiltersExpr{
											{
												Condition: _f.funcs.Map(on, item, right),
											},
										},
									),
									&on,
									private,
								).(memo.RelExpr),
								_f.funcs.RemoveFiltersItem(filters, item),
							)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushSelectCondLeftIntoJoinLeftAndRight, nil, _expr)
							}
							return _expr
						}
					}
				}
			}
		}
	}

	// [PushSelectCondRightIntoJoinLeftAndRight]
	{
		if input.Op() == opt.InnerJoinOp || input.Op() == opt.InnerJoinApplyOp || input.Op() == opt.RightJoinOp || input.Op() == opt.RightJoinApplyOp {
			left := input.Child(0).(memo.RelExpr)
			right := input.Child(1).(memo.RelExpr)
			on := *input.Child(2).(*memo.FiltersExpr)
			private := input.Private().(*memo.JoinPrivate)
			for i := range filters {
				item := &filters[i]
				condition := item.Condition
				if _f.funcs.IsBoundBy(item, _f.funcs.OutputCols(right)) {
					if _f.funcs.CanMap(on, item, left) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectCondRightIntoJoinLeftAndRight) {
							on := on
							_expr := _f.ConstructSelect(
								_f.DynamicConstruct(
									input.Op(),
									_f.ConstructSelect(
										left,
										memo.FiltersExpr{
											{
												Condition: _f.funcs.Map(on, item, left),
											},
										},
									),
									_f.ConstructSelect(
										right,
										memo.FiltersExpr{
											{
												Condition: condition,
											},
										},
									),
									&on,
									private,
								).(memo.RelExpr),
								_f.funcs.RemoveFiltersItem(filters, item),
							)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushSelectCondRightIntoJoinLeftAndRight, nil, _expr)
							}
							return _expr
						}
					}
				}
			}
		}
	}

	// [PushSelectIntoJoinLeft]
	{
		if input.Op() == opt.InnerJoinOp || input.Op() == opt.InnerJoinApplyOp || input.Op() == opt.LeftJoinOp || input.Op() == opt.LeftJoinApplyOp || input.Op() == opt.SemiJoinOp || input.Op() == opt.SemiJoinApplyOp || input.Op() == opt.AntiJoinOp || input.Op() == opt.AntiJoinApplyOp {
			left := input.Child(0).(memo.RelExpr)
			right := input.Child(1).(memo.RelExpr)
			on := *input.Child(2).(*memo.FiltersExpr)
			private := input.Private().(*memo.JoinPrivate)
			for i := range filters {
				item := &filters[i]
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(item, leftCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectIntoJoinLeft) {
						on := on
						_expr := _f.ConstructSelect(
							_f.DynamicConstruct(
								input.Op(),
								_f.ConstructSelect(
									left,
									_f.funcs.ExtractBoundConditions(filters, leftCols),
								),
								right,
								&on,
								private,
							).(memo.RelExpr),
							_f.funcs.ExtractUnboundConditions(filters, leftCols),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushSelectIntoJoinLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [PushSelectIntoJoinRight]
	{
		if input.Op() == opt.InnerJoinOp || input.Op() == opt.InnerJoinApplyOp || input.Op() == opt.RightJoinOp || input.Op() == opt.RightJoinApplyOp {
			left := input.Child(0).(memo.RelExpr)
			right := input.Child(1).(memo.RelExpr)
			on := *input.Child(2).(*memo.FiltersExpr)
			private := input.Private().(*memo.JoinPrivate)
			for i := range filters {
				item := &filters[i]
				rightCols := _f.funcs.OutputCols(right)
				if _f.funcs.IsBoundBy(item, rightCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectIntoJoinRight) {
						on := on
						_expr := _f.ConstructSelect(
							_f.DynamicConstruct(
								input.Op(),
								left,
								_f.ConstructSelect(
									right,
									_f.funcs.ExtractBoundConditions(filters, rightCols),
								),
								&on,
								private,
							).(memo.RelExpr),
							_f.funcs.ExtractUnboundConditions(filters, rightCols),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushSelectIntoJoinRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [PushSelectIntoGroupBy]
	{
		if input.Op() == opt.GroupByOp || input.Op() == opt.DistinctOnOp {
			groupingInput := input.Child(0).(memo.RelExpr)
			aggregations := *input.Child(1).(*memo.AggregationsExpr)
			groupingPrivate := input.Private().(*memo.GroupingPrivate)
			for i := range filters {
				item := &filters[i]
				passthrough := _f.funcs.GroupingAndConstCols(groupingPrivate, aggregations)
				if _f.funcs.IsBoundBy(item, passthrough) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectIntoGroupBy) {
						aggregations := aggregations
						_expr := _f.ConstructSelect(
							_f.DynamicConstruct(
								input.Op(),
								_f.ConstructSelect(
									groupingInput,
									_f.funcs.ExtractBoundConditions(filters, passthrough),
								),
								&aggregations,
								groupingPrivate,
							).(memo.RelExpr),
							_f.funcs.ExtractUnboundConditions(filters, passthrough),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushSelectIntoGroupBy, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [RemoveNotNullCondition]
	{
		for i := range filters {
			item := &filters[i]
			_isNot, _ := item.Condition.(*memo.IsNotExpr)
			if _isNot != nil {
				_variable, _ := _isNot.Left.(*memo.VariableExpr)
				if _variable != nil {
					col := _variable.Col
					if _f.funcs.IsColNotNull(col, input) {
						_null, _ := _isNot.Right.(*memo.NullExpr)
						if _null != nil {
							if _f.matchedRule == nil || _f.matchedRule(opt.RemoveNotNullCondition) {
								_expr := _f.ConstructSelect(
									input,
									_f.funcs.RemoveFiltersItem(filters, item),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.RemoveNotNullCondition, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [HoistSelectExists]
	{
		for i := range filters {
			item := &filters[i]
			if _f.funcs.HasHoistableSubquery(item) {
				_exists, _ := item.Condition.(*memo.ExistsExpr)
				if _exists != nil {
					subquery := _exists.Input
					if _f.matchedRule == nil || _f.matchedRule(opt.HoistSelectExists) {
						_expr := _f.ConstructSelect(
							_f.ConstructSemiJoinApply(
								input,
								subquery,
								memo.EmptyFiltersExpr,
								_f.funcs.EmptyJoinPrivate(),
							),
							_f.funcs.RemoveFiltersItem(filters, item),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.HoistSelectExists, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [HoistSelectNotExists]
	{
		for i := range filters {
			item := &filters[i]
			if _f.funcs.HasHoistableSubquery(item) {
				_not, _ := item.Condition.(*memo.NotExpr)
				if _not != nil {
					_exists, _ := _not.Input.(*memo.ExistsExpr)
					if _exists != nil {
						subquery := _exists.Input
						if _f.matchedRule == nil || _f.matchedRule(opt.HoistSelectNotExists) {
							_expr := _f.ConstructSelect(
								_f.ConstructAntiJoinApply(
									input,
									subquery,
									memo.EmptyFiltersExpr,
									_f.funcs.EmptyJoinPrivate(),
								),
								_f.funcs.RemoveFiltersItem(filters, item),
							)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.HoistSelectNotExists, nil, _expr)
							}
							return _expr
						}
					}
				}
			}
		}
	}

	// [HoistSelectSubquery]
	{
		for i := range filters {
			item := &filters[i]
			if _f.funcs.HasHoistableSubquery(item) {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistSelectSubquery) {
					_expr := _f.funcs.HoistSelectSubquery(input, filters).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistSelectSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PushSelectIntoInlinableProject]
	{
		_project, _ := input.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			if _f.funcs.CanInlineProjections(projections) {
				passthrough := _project.Passthrough
				if !_f.funcs.FilterHasCorrelatedSubquery(filters) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectIntoInlinableProject) {
						_expr := _f.ConstructProject(
							_f.ConstructSelect(
								input,
								_f.funcs.InlineSelectProject(filters, projections),
							),
							projections,
							passthrough,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushSelectIntoInlinableProject, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [RejectNullsGroupBy]
	{
		if input.Op() == opt.GroupByOp || input.Op() == opt.ScalarGroupByOp {
			innerInput := input.Child(0).(memo.RelExpr)
			aggregations := *input.Child(1).(*memo.AggregationsExpr)
			groupingPrivate := input.Private().(*memo.GroupingPrivate)
			rejectCols := _f.funcs.RejectNullCols(input)
			if _f.funcs.HasNullRejectingFilter(filters, rejectCols) {
				if _f.matchedRule == nil || _f.matchedRule(opt.RejectNullsGroupBy) {
					aggregations := aggregations
					_expr := _f.ConstructSelect(
						_f.DynamicConstruct(
							input.Op(),
							_f.ConstructSelect(
								innerInput,
								memo.FiltersExpr{
									{
										Condition: _f.ConstructIsNot(
											_f.funcs.NullRejectAggVar(aggregations, rejectCols),
											_f.ConstructNull(
												_f.funcs.AnyType(),
											),
										),
									},
								},
							),
							&aggregations,
							groupingPrivate,
						).(memo.RelExpr),
						filters,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.RejectNullsGroupBy, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [ConsolidateSelectFilters]
	{
		if _f.funcs.CanConsolidateFilters(filters) {
			if _f.matchedRule == nil || _f.matchedRule(opt.ConsolidateSelectFilters) {
				_expr := _f.ConstructSelect(
					input,
					_f.funcs.ConsolidateFilters(filters),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.ConsolidateSelectFilters, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeSelect(input, filters)
	return _f.onConstructRelational(e)
}

// ConstructProject constructs an expression for the Project operator.
// Project modifies the set of columns returned by the input result set. Columns
// can be removed, reordered, or renamed. In addition, new columns can be
// synthesized.
//
// Projections describes the synthesized columns constructed by Project, and
// Passthrough describes the input columns that are passed through as Project
// output columns.
func (_f *Factory) ConstructProject(
	input memo.RelExpr,
	projections memo.ProjectionsExpr,
	passthrough opt.ColSet,
) memo.RelExpr {
	// [InlineProjectConstants]
	{
		constCols := _f.funcs.FindInlinableConstants(input)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range projections {
				item := &projections[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineProjectConstants) {
						_expr := _f.ConstructProject(
							input,
							_f.funcs.InlineProjectionConstants(projections, input, constCols),
							passthrough,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineProjectConstants, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [EliminateProject]
	{
		if len(projections) == 0 {
			if _f.funcs.ColsAreEqual(passthrough, _f.funcs.OutputCols(input)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateProject) {
					_expr := input
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateProject, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [MergeProjects]
	{
		_project, _ := input.(*memo.ProjectExpr)
		if _project != nil {
			innerInput := _project.Input
			innerProjections := _project.Projections
			if _f.funcs.CanMergeProjections(projections, innerProjections) {
				if _f.matchedRule == nil || _f.matchedRule(opt.MergeProjects) {
					_expr := _f.ConstructProject(
						innerInput,
						_f.funcs.MergeProjections(projections, innerProjections, passthrough),
						_f.funcs.DifferenceCols(passthrough, _f.funcs.ProjectionCols(innerProjections)),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.MergeProjects, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [MergeProjectWithValues]
	{
		_values, _ := input.(*memo.ValuesExpr)
		if _values != nil {
			if len(_values.Rows) == 1 {
				if !_f.funcs.AreProjectionsCorrelated(projections, _f.funcs.OutputCols(input)) {
					if _f.matchedRule == nil || _f.matchedRule(opt.MergeProjectWithValues) {
						_expr := _f.funcs.MergeProjectWithValues(projections, passthrough, input).(memo.RelExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.MergeProjectWithValues, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [PruneProjectCols]
	{
		project := input
		_project, _ := project.(*memo.ProjectExpr)
		if _project != nil {
			needed := _f.funcs.UnionCols(_f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneCols(project, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneProjectCols) {
					_expr := _f.ConstructProject(
						_f.funcs.PruneCols(project, needed),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneProjectCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PruneScanCols]
	{
		_scan, _ := input.(*memo.ScanExpr)
		if _scan != nil {
			needed := _f.funcs.UnionCols(_f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneCols(input, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneScanCols) {
					_expr := _f.ConstructProject(
						_f.funcs.PruneCols(input, needed),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneScanCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PruneSelectCols]
	{
		_select, _ := input.(*memo.SelectExpr)
		if _select != nil {
			input := _select.Input
			filters := _select.Filters
			needed := _f.funcs.UnionCols3(_f.funcs.FilterOuterCols(filters), _f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneCols(input, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneSelectCols) {
					_expr := _f.ConstructProject(
						_f.ConstructSelect(
							_f.funcs.PruneCols(input, needed),
							filters,
						),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneSelectCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PruneLimitCols]
	{
		_limit, _ := input.(*memo.LimitExpr)
		if _limit != nil {
			input := _limit.Input
			limit := _limit.Limit
			ordering := _limit.Ordering
			needed := _f.funcs.UnionCols3(_f.funcs.OrderingCols(ordering), _f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneCols(input, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneLimitCols) {
					_expr := _f.ConstructProject(
						_f.ConstructLimit(
							_f.funcs.PruneCols(input, needed),
							limit,
							_f.funcs.PruneOrdering(ordering, needed),
						),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneLimitCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PruneOffsetCols]
	{
		_offset, _ := input.(*memo.OffsetExpr)
		if _offset != nil {
			input := _offset.Input
			offset := _offset.Offset
			ordering := _offset.Ordering
			needed := _f.funcs.UnionCols3(_f.funcs.OrderingCols(ordering), _f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneCols(input, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneOffsetCols) {
					_expr := _f.ConstructProject(
						_f.ConstructOffset(
							_f.funcs.PruneCols(input, needed),
							offset,
							_f.funcs.PruneOrdering(ordering, needed),
						),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneOffsetCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PruneJoinLeftCols]
	{
		if opt.IsJoinOp(input) {
			left := input.Child(0).(memo.RelExpr)
			right := input.Child(1).(memo.RelExpr)
			on := *input.Child(2).(*memo.FiltersExpr)
			private := input.Private().(*memo.JoinPrivate)
			needed := _f.funcs.UnionCols4(_f.funcs.OuterCols(right), _f.funcs.FilterOuterCols(on), _f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneCols(left, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneJoinLeftCols) {
					on := on
					_expr := _f.ConstructProject(
						_f.DynamicConstruct(
							input.Op(),
							_f.funcs.PruneCols(left, needed),
							right,
							&on,
							private,
						).(memo.RelExpr),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneJoinLeftCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PruneJoinRightCols]
	{
		if opt.IsJoinOp(input) {
			left := input.Child(0).(memo.RelExpr)
			right := input.Child(1).(memo.RelExpr)
			on := *input.Child(2).(*memo.FiltersExpr)
			private := input.Private().(*memo.JoinPrivate)
			needed := _f.funcs.UnionCols3(_f.funcs.FilterOuterCols(on), _f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneCols(right, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneJoinRightCols) {
					on := on
					_expr := _f.ConstructProject(
						_f.DynamicConstruct(
							input.Op(),
							left,
							_f.funcs.PruneCols(right, needed),
							&on,
							private,
						).(memo.RelExpr),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneJoinRightCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PruneAggCols]
	{
		if input.Op() == opt.GroupByOp || input.Op() == opt.ScalarGroupByOp || input.Op() == opt.DistinctOnOp {
			innerInput := input.Child(0).(memo.RelExpr)
			aggregations := *input.Child(1).(*memo.AggregationsExpr)
			groupingPrivate := input.Private().(*memo.GroupingPrivate)
			needed := _f.funcs.UnionCols(_f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneAggCols(aggregations, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneAggCols) {
					_arg := _f.funcs.PruneAggCols(aggregations, needed)
					_expr := _f.ConstructProject(
						_f.DynamicConstruct(
							input.Op(),
							innerInput,
							&_arg,
							groupingPrivate,
						).(memo.RelExpr),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneAggCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PruneValuesCols]
	{
		_values, _ := input.(*memo.ValuesExpr)
		if _values != nil {
			needed := _f.funcs.UnionCols(_f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneCols(input, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneValuesCols) {
					_expr := _f.ConstructProject(
						_f.funcs.PruneCols(input, needed),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneValuesCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PruneRowNumberCols]
	{
		_rowNumber, _ := input.(*memo.RowNumberExpr)
		if _rowNumber != nil {
			input := _rowNumber.Input
			rowNumberPrivate := &_rowNumber.RowNumberPrivate
			needed := _f.funcs.UnionCols3(_f.funcs.NeededRowNumberCols(rowNumberPrivate), _f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneCols(input, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneRowNumberCols) {
					_expr := _f.ConstructProject(
						_f.ConstructRowNumber(
							_f.funcs.PruneCols(input, needed),
							_f.funcs.PruneOrderingRowNumber(rowNumberPrivate, needed),
						),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneRowNumberCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PruneProjectSetCols]
	{
		_projectSet, _ := input.(*memo.ProjectSetExpr)
		if _projectSet != nil {
			innerInput := _projectSet.Input
			zip := _projectSet.Zip
			needed := _f.funcs.UnionCols3(_f.funcs.ZipOuterCols(zip), _f.funcs.ProjectionOuterCols(projections), passthrough)
			if _f.funcs.CanPruneCols(input, needed) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneProjectSetCols) {
					_expr := _f.ConstructProject(
						_f.ConstructProjectSet(
							_f.funcs.PruneCols(innerInput, needed),
							zip,
						),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneProjectSetCols, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [HoistProjectSubquery]
	{
		for i := range projections {
			item := &projections[i]
			if _f.funcs.HasHoistableSubquery(item) {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistProjectSubquery) {
					_expr := _f.funcs.HoistProjectSubquery(input, projections, passthrough).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistProjectSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [InlineProjectInProject]
	{
		_project, _ := input.(*memo.ProjectExpr)
		if _project != nil {
			innerProjections := _project.Projections
			if !_f.funcs.HasDuplicateRefs(projections, passthrough, _f.funcs.ProjectionCols(innerProjections)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.InlineProjectInProject) {
					_expr := _f.funcs.InlineProjectProject(input, projections, passthrough).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.InlineProjectInProject, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeProject(input, projections, passthrough)
	return _f.onConstructRelational(e)
}

// ConstructInnerJoin constructs an expression for the InnerJoin operator.
// InnerJoin creates a result set that combines columns from its left and right
// inputs, based upon its "on" join predicate. Rows which do not match the
// predicate are filtered. While expressions in the predicate can refer to
// columns projected by either the left or right inputs, the inputs are not
// allowed to refer to the other's projected columns.
func (_f *Factory) ConstructInnerJoin(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructInnerJoin(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_select, _ := right.(*memo.SelectExpr)
			if _select != nil {
				input := _select.Input
				filters := _select.Filters
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
					_expr := _f.ConstructInnerJoin(
						left,
						input,
						_f.funcs.ConcatFilters(on, filters),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateSelect, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [TryDecorrelateProject]
	{
		if _f.funcs.HasOuterCols(right) {
			_project, _ := right.(*memo.ProjectExpr)
			if _project != nil {
				input := _project.Input
				projections := _project.Projections
				passthrough := _project.Passthrough
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateProject) {
					_expr := _f.ConstructSelect(
						_f.ConstructProject(
							_f.ConstructInnerJoin(
								left,
								input,
								memo.EmptyFiltersExpr,
								private,
							),
							projections,
							_f.funcs.UnionCols(_f.funcs.OutputCols(left), passthrough),
						),
						on,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateProject, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if right.Op() == opt.InnerJoinOp || right.Op() == opt.InnerJoinApplyOp {
				innerLeft := right.Child(0).(memo.RelExpr)
				innerRight := right.Child(1).(memo.RelExpr)
				innerOn := *right.Child(2).(*memo.FiltersExpr)
				if !_f.funcs.FiltersBoundBy(innerOn, _f.funcs.OutputCols2(innerLeft, innerRight)) {
					innerPrivate := right.Private().(*memo.JoinPrivate)
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_expr := _f.ConstructInnerJoin(
							left,
							_f.DynamicConstruct(
								right.Op(),
								innerLeft,
								innerRight,
								&memo.EmptyFiltersExpr,
								innerPrivate,
							).(memo.RelExpr),
							_f.funcs.ConcatFilters(on, innerOn),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerLeftJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_leftJoin, _ := right.(*memo.LeftJoinExpr)
			if _leftJoin != nil {
				innerLeft := _leftJoin.Left
				innerRight := _leftJoin.Right
				innerOn := _leftJoin.On
				innerPrivate := &_leftJoin.JoinPrivate
				if _f.funcs.FiltersBoundBy(on, _f.funcs.OutputCols2(left, innerLeft)) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerLeftJoin) {
						_expr := _f.ConstructLeftJoinApply(
							_f.ConstructInnerJoin(
								left,
								innerLeft,
								on,
								innerPrivate,
							),
							innerRight,
							innerOn,
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerLeftJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateGroupBy]
	{
		if _f.funcs.HasOuterCols(right) {
			if right.Op() == opt.GroupByOp || right.Op() == opt.DistinctOnOp {
				input := right.Child(0).(memo.RelExpr)
				aggregations := *right.Child(1).(*memo.AggregationsExpr)
				groupingPrivate := right.Private().(*memo.GroupingPrivate)
				if _f.funcs.IsUnorderedGrouping(groupingPrivate) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateGroupBy) {
						newLeft := _f.funcs.EnsureKey(left)
						_arg := _f.funcs.AppendAggCols(aggregations, opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft))
						_expr := _f.ConstructSelect(
							_f.DynamicConstruct(
								right.Op(),
								_f.ConstructInnerJoinApply(
									newLeft,
									input,
									memo.EmptyFiltersExpr,
									private,
								),
								&_arg,
								_f.funcs.AddColsToGrouping(groupingPrivate, _f.funcs.KeyCols(newLeft)),
							).(memo.RelExpr),
							on,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateGroupBy, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateScalarGroupBy]
	{
		if _f.funcs.HasOuterCols(right) {
			_scalarGroupBy, _ := right.(*memo.ScalarGroupByExpr)
			if _scalarGroupBy != nil {
				input := _scalarGroupBy.Input
				aggregations := _scalarGroupBy.Aggregations
				groupingPrivate := &_scalarGroupBy.GroupingPrivate
				if _f.funcs.AggsCanBeDecorrelated(aggregations) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateScalarGroupBy) {
						leftWithKey := _f.funcs.EnsureKey(left)
						canaryCol := _f.funcs.EnsureCanaryCol(input, aggregations)
						rightWithCanary := _f.funcs.EnsureCanary(input, canaryCol)
						translatedAggs := _f.funcs.EnsureAggsCanIgnoreNulls(rightWithCanary, aggregations)
						_expr := _f.ConstructSelect(
							_f.funcs.TranslateNonIgnoreAggs(_f.ConstructGroupBy(
								_f.ConstructLeftJoinApply(
									leftWithKey,
									rightWithCanary,
									memo.EmptyFiltersExpr,
									private,
								),
								_f.funcs.AppendAggCols2(translatedAggs, opt.ConstAggOp, _f.funcs.NonKeyCols(leftWithKey), opt.AnyNotNullAggOp, _f.funcs.CanaryColSet(canaryCol)),
								_f.funcs.MakeOrderedGrouping(_f.funcs.KeyCols(leftWithKey), _f.funcs.ExtractGroupingOrdering(groupingPrivate)),
							), translatedAggs, rightWithCanary, aggregations, canaryCol),
							on,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateScalarGroupBy, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateLimitOne]
	{
		if _f.funcs.HasOuterCols(right) {
			_limit, _ := right.(*memo.LimitExpr)
			if _limit != nil {
				input := _limit.Input
				_const, _ := _limit.Limit.(*memo.ConstExpr)
				if _const != nil {
					if _f.funcs.EqualsNumber(_const.Value, 1) {
						ordering := _limit.Ordering
						private := joinPrivate
						if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateLimitOne) {
							newLeft := _f.funcs.EnsureKey(left)
							_expr := _f.ConstructDistinctOn(
								_f.ConstructInnerJoin(
									newLeft,
									input,
									on,
									private,
								),
								_f.funcs.MakeAggCols2(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft), opt.FirstAggOp, _f.funcs.OutputCols(input)),
								_f.funcs.MakeOrderedGrouping(_f.funcs.KeyCols(newLeft), ordering),
							)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.TryDecorrelateLimitOne, nil, _expr)
							}
							return _expr
						}
					}
				}
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructInnerJoin(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructInnerJoin(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructInnerJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructInnerJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructInnerJoin(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PushFilterIntoJoinLeftAndRight]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				for i := range on {
					item := &on[i]
					_match := false
					_eq, _ := item.Condition.(*memo.EqExpr)
					if _eq != nil {
						_variable, _ := _eq.Left.(*memo.VariableExpr)
						if _variable != nil {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								_match = true
							}
						}
					}

					if !_match {
						if _f.funcs.CanMap(on, item, left) {
							if _f.funcs.CanMap(on, item, right) {
								private := joinPrivate
								if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeftAndRight) {
									_expr := _f.ConstructInnerJoin(
										_f.ConstructSelect(
											left,
											memo.FiltersExpr{
												{
													Condition: _f.funcs.Map(on, item, left),
												},
											},
										),
										_f.ConstructSelect(
											right,
											memo.FiltersExpr{
												{
													Condition: _f.funcs.Map(on, item, right),
												},
											},
										),
										_f.funcs.RemoveFiltersItem(on, item),
										private,
									)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.PushFilterIntoJoinLeftAndRight, nil, _expr)
									}
									return _expr
								}
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(on, item, left) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_expr := _f.ConstructInnerJoin(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, left)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(right)) {
						if _f.funcs.CanMap(on, item, right) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
								_expr := _f.ConstructInnerJoin(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, right)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinRight, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(item, leftCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_expr := _f.ConstructInnerJoin(
							_f.ConstructSelect(
								left,
								_f.funcs.ExtractBoundConditions(on, leftCols),
							),
							right,
							_f.funcs.ExtractUnboundConditions(on, leftCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				rightCols := _f.funcs.OutputCols(right)
				if _f.funcs.IsBoundBy(item, rightCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
						_expr := _f.ConstructInnerJoin(
							left,
							_f.ConstructSelect(
								right,
								_f.funcs.ExtractBoundConditions(on, rightCols),
							),
							_f.funcs.ExtractUnboundConditions(on, rightCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [EliminateJoinNoColsLeft]
	{
		if _f.funcs.HasNoCols(left) {
			if _f.funcs.HasOneRow(left) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateJoinNoColsLeft) {
					_expr := _f.ConstructSelect(
						right,
						on,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateJoinNoColsLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [EliminateJoinNoColsRight]
	{
		if _f.funcs.HasNoCols(right) {
			if _f.funcs.HasOneRow(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateJoinNoColsRight) {
					_expr := _f.ConstructSelect(
						left,
						on,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateJoinNoColsRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [HoistJoinProjectRight]
	{
		_project, _ := right.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			if len(projections) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProjectRight) {
					_expr := _f.ConstructProject(
						_f.ConstructInnerJoin(
							left,
							input,
							on,
							private,
						),
						projections,
						_f.funcs.OutputCols2(left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinProjectRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [HoistJoinProjectLeft]
	{
		_project, _ := left.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			if len(projections) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProjectLeft) {
					_expr := _f.ConstructProject(
						_f.ConstructInnerJoin(
							input,
							right,
							on,
							private,
						),
						projections,
						_f.funcs.OutputCols2(left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinProjectLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructInnerJoin(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				for i := range on {
					item := &on[i]
					_eq, _ := item.Condition.(*memo.EqExpr)
					if _eq != nil {
						a := _eq.Left
						if !(opt.IsConstValueOp(a)) {
							b := _eq.Right
							if !(opt.IsConstValueOp(b)) {
								if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
									private := joinPrivate
									if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
										_expr := _f.funcs.ExtractJoinEquality(opt.InnerJoinOp, left, right, on, item, private).(memo.RelExpr)
										if _f.appliedRule != nil {
											_f.appliedRule(opt.ExtractJoinEqualities, nil, _expr)
										}
										return _expr
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [SortFiltersInJoin]
	{
		if !_f.funcs.AreFiltersSorted(on) {
			private := joinPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.SortFiltersInJoin) {
				_expr := _f.ConstructInnerJoin(
					left,
					right,
					_f.funcs.SortFilters(on),
					private,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SortFiltersInJoin, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.InnerJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeInnerJoin(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructLeftJoin constructs an expression for the LeftJoin operator.
func (_f *Factory) ConstructLeftJoin(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructLeftJoin(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_select, _ := right.(*memo.SelectExpr)
			if _select != nil {
				input := _select.Input
				filters := _select.Filters
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
					_expr := _f.ConstructLeftJoin(
						left,
						input,
						_f.funcs.ConcatFilters(on, filters),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateSelect, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if right.Op() == opt.InnerJoinOp || right.Op() == opt.InnerJoinApplyOp {
				innerLeft := right.Child(0).(memo.RelExpr)
				innerRight := right.Child(1).(memo.RelExpr)
				innerOn := *right.Child(2).(*memo.FiltersExpr)
				if !_f.funcs.FiltersBoundBy(innerOn, _f.funcs.OutputCols2(innerLeft, innerRight)) {
					innerPrivate := right.Private().(*memo.JoinPrivate)
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_expr := _f.ConstructLeftJoin(
							left,
							_f.DynamicConstruct(
								right.Op(),
								innerLeft,
								innerRight,
								&memo.EmptyFiltersExpr,
								innerPrivate,
							).(memo.RelExpr),
							_f.funcs.ConcatFilters(on, innerOn),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateLimitOne]
	{
		if _f.funcs.HasOuterCols(right) {
			_limit, _ := right.(*memo.LimitExpr)
			if _limit != nil {
				input := _limit.Input
				_const, _ := _limit.Limit.(*memo.ConstExpr)
				if _const != nil {
					if _f.funcs.EqualsNumber(_const.Value, 1) {
						ordering := _limit.Ordering
						private := joinPrivate
						if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateLimitOne) {
							newLeft := _f.funcs.EnsureKey(left)
							_expr := _f.ConstructDistinctOn(
								_f.ConstructLeftJoin(
									newLeft,
									input,
									on,
									private,
								),
								_f.funcs.MakeAggCols2(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft), opt.FirstAggOp, _f.funcs.OutputCols(input)),
								_f.funcs.MakeOrderedGrouping(_f.funcs.KeyCols(newLeft), ordering),
							)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.TryDecorrelateLimitOne, nil, _expr)
							}
							return _expr
						}
					}
				}
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructLeftJoin(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructLeftJoin(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructLeftJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructLeftJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructLeftJoin(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(right)) {
						if _f.funcs.CanMap(on, item, right) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
								_expr := _f.ConstructLeftJoin(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, right)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinRight, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				rightCols := _f.funcs.OutputCols(right)
				if _f.funcs.IsBoundBy(item, rightCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
						_expr := _f.ConstructLeftJoin(
							left,
							_f.ConstructSelect(
								right,
								_f.funcs.ExtractBoundConditions(on, rightCols),
							),
							_f.funcs.ExtractUnboundConditions(on, rightCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [SimplifyLeftJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			if len(on) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithoutFilters) {
					_expr := _f.funcs.ConstructNonLeftJoin(opt.LeftJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithoutFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyLeftJoinWithFilters]
	{
		if len(on) != 0 {
			if _f.funcs.JoinFiltersMatchAllLeftRows(left, right, on) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithFilters) {
					_expr := _f.funcs.ConstructNonLeftJoin(opt.LeftJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [HoistJoinProjectRight]
	{
		_project, _ := right.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			if len(projections) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProjectRight) {
					_expr := _f.ConstructProject(
						_f.ConstructLeftJoin(
							left,
							input,
							on,
							private,
						),
						projections,
						_f.funcs.OutputCols2(left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinProjectRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [HoistJoinProjectLeft]
	{
		_project, _ := left.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			if len(projections) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProjectLeft) {
					_expr := _f.ConstructProject(
						_f.ConstructLeftJoin(
							input,
							right,
							on,
							private,
						),
						projections,
						_f.funcs.OutputCols2(left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinProjectLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructLeftJoin(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				for i := range on {
					item := &on[i]
					_eq, _ := item.Condition.(*memo.EqExpr)
					if _eq != nil {
						a := _eq.Left
						if !(opt.IsConstValueOp(a)) {
							b := _eq.Right
							if !(opt.IsConstValueOp(b)) {
								if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
									private := joinPrivate
									if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
										_expr := _f.funcs.ExtractJoinEquality(opt.LeftJoinOp, left, right, on, item, private).(memo.RelExpr)
										if _f.appliedRule != nil {
											_f.appliedRule(opt.ExtractJoinEqualities, nil, _expr)
										}
										return _expr
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.LeftJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeLeftJoin(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructRightJoin constructs an expression for the RightJoin operator.
func (_f *Factory) ConstructRightJoin(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructRightJoin(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructRightJoin(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructRightJoin(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructRightJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructRightJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructRightJoin(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(on, item, left) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_expr := _f.ConstructRightJoin(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, left)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(item, leftCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_expr := _f.ConstructRightJoin(
							_f.ConstructSelect(
								left,
								_f.funcs.ExtractBoundConditions(on, leftCols),
							),
							right,
							_f.funcs.ExtractUnboundConditions(on, leftCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [SimplifyRightJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(left) {
			if len(on) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithoutFilters) {
					_expr := _f.funcs.ConstructNonRightJoin(opt.RightJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithoutFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyRightJoinWithFilters]
	{
		if len(on) != 0 {
			if _f.funcs.JoinFiltersMatchAllLeftRows(right, left, on) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithFilters) {
					_expr := _f.funcs.ConstructNonRightJoin(opt.RightJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructRightJoin(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				for i := range on {
					item := &on[i]
					_eq, _ := item.Condition.(*memo.EqExpr)
					if _eq != nil {
						a := _eq.Left
						if !(opt.IsConstValueOp(a)) {
							b := _eq.Right
							if !(opt.IsConstValueOp(b)) {
								if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
									private := joinPrivate
									if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
										_expr := _f.funcs.ExtractJoinEquality(opt.RightJoinOp, left, right, on, item, private).(memo.RelExpr)
										if _f.appliedRule != nil {
											_f.appliedRule(opt.ExtractJoinEqualities, nil, _expr)
										}
										return _expr
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.RightJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeRightJoin(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructFullJoin constructs an expression for the FullJoin operator.
func (_f *Factory) ConstructFullJoin(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructFullJoin(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructFullJoin(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructFullJoin(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructFullJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructFullJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructFullJoin(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyLeftJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			if len(on) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithoutFilters) {
					_expr := _f.funcs.ConstructNonLeftJoin(opt.FullJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithoutFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyRightJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(left) {
			if len(on) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithoutFilters) {
					_expr := _f.funcs.ConstructNonRightJoin(opt.FullJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithoutFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyLeftJoinWithFilters]
	{
		if len(on) != 0 {
			if _f.funcs.JoinFiltersMatchAllLeftRows(left, right, on) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithFilters) {
					_expr := _f.funcs.ConstructNonLeftJoin(opt.FullJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyRightJoinWithFilters]
	{
		if len(on) != 0 {
			if _f.funcs.JoinFiltersMatchAllLeftRows(right, left, on) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithFilters) {
					_expr := _f.funcs.ConstructNonRightJoin(opt.FullJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructFullJoin(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				for i := range on {
					item := &on[i]
					_eq, _ := item.Condition.(*memo.EqExpr)
					if _eq != nil {
						a := _eq.Left
						if !(opt.IsConstValueOp(a)) {
							b := _eq.Right
							if !(opt.IsConstValueOp(b)) {
								if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
									private := joinPrivate
									if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
										_expr := _f.funcs.ExtractJoinEquality(opt.FullJoinOp, left, right, on, item, private).(memo.RelExpr)
										if _f.appliedRule != nil {
											_f.appliedRule(opt.ExtractJoinEqualities, nil, _expr)
										}
										return _expr
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.FullJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeFullJoin(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructSemiJoin constructs an expression for the SemiJoin operator.
func (_f *Factory) ConstructSemiJoin(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructSemiJoin(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_select, _ := right.(*memo.SelectExpr)
			if _select != nil {
				input := _select.Input
				filters := _select.Filters
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
					_expr := _f.ConstructSemiJoin(
						left,
						input,
						_f.funcs.ConcatFilters(on, filters),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateSelect, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if right.Op() == opt.InnerJoinOp || right.Op() == opt.InnerJoinApplyOp {
				innerLeft := right.Child(0).(memo.RelExpr)
				innerRight := right.Child(1).(memo.RelExpr)
				innerOn := *right.Child(2).(*memo.FiltersExpr)
				if !_f.funcs.FiltersBoundBy(innerOn, _f.funcs.OutputCols2(innerLeft, innerRight)) {
					innerPrivate := right.Private().(*memo.JoinPrivate)
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_expr := _f.ConstructSemiJoin(
							left,
							_f.DynamicConstruct(
								right.Op(),
								innerLeft,
								innerRight,
								&memo.EmptyFiltersExpr,
								innerPrivate,
							).(memo.RelExpr),
							_f.funcs.ConcatFilters(on, innerOn),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateSemiJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if _f.funcs.CanHaveZeroRows(right) {
				if right.Op() == opt.GroupByOp || right.Op() == opt.DistinctOnOp || right.Op() == opt.ProjectOp || right.Op() == opt.ProjectSetOp {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSemiJoin) {
						newLeft := _f.funcs.EnsureKey(left)
						_expr := _f.ConstructGroupBy(
							_f.ConstructInnerJoinApply(
								newLeft,
								right,
								on,
								private,
							),
							_f.funcs.MakeAggCols(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft)),
							_f.funcs.MakeGrouping(_f.funcs.KeyCols(newLeft)),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSemiJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructSemiJoin(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructSemiJoin(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructSemiJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructSemiJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructSemiJoin(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PushFilterIntoJoinLeftAndRight]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				for i := range on {
					item := &on[i]
					_match := false
					_eq, _ := item.Condition.(*memo.EqExpr)
					if _eq != nil {
						_variable, _ := _eq.Left.(*memo.VariableExpr)
						if _variable != nil {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								_match = true
							}
						}
					}

					if !_match {
						if _f.funcs.CanMap(on, item, left) {
							if _f.funcs.CanMap(on, item, right) {
								private := joinPrivate
								if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeftAndRight) {
									_expr := _f.ConstructSemiJoin(
										_f.ConstructSelect(
											left,
											memo.FiltersExpr{
												{
													Condition: _f.funcs.Map(on, item, left),
												},
											},
										),
										_f.ConstructSelect(
											right,
											memo.FiltersExpr{
												{
													Condition: _f.funcs.Map(on, item, right),
												},
											},
										),
										_f.funcs.RemoveFiltersItem(on, item),
										private,
									)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.PushFilterIntoJoinLeftAndRight, nil, _expr)
									}
									return _expr
								}
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(on, item, left) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_expr := _f.ConstructSemiJoin(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, left)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(right)) {
						if _f.funcs.CanMap(on, item, right) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
								_expr := _f.ConstructSemiJoin(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, right)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinRight, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(item, leftCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_expr := _f.ConstructSemiJoin(
							_f.ConstructSelect(
								left,
								_f.funcs.ExtractBoundConditions(on, leftCols),
							),
							right,
							_f.funcs.ExtractUnboundConditions(on, leftCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				rightCols := _f.funcs.OutputCols(right)
				if _f.funcs.IsBoundBy(item, rightCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
						_expr := _f.ConstructSemiJoin(
							left,
							_f.ConstructSelect(
								right,
								_f.funcs.ExtractBoundConditions(on, rightCols),
							),
							_f.funcs.ExtractUnboundConditions(on, rightCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [EliminateSemiJoin]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			if len(on) == 0 {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateSemiJoin) {
					_expr := left
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateSemiJoin, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructSemiJoin(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				for i := range on {
					item := &on[i]
					_eq, _ := item.Condition.(*memo.EqExpr)
					if _eq != nil {
						a := _eq.Left
						if !(opt.IsConstValueOp(a)) {
							b := _eq.Right
							if !(opt.IsConstValueOp(b)) {
								if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
									private := joinPrivate
									if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
										_expr := _f.funcs.ExtractJoinEquality(opt.SemiJoinOp, left, right, on, item, private).(memo.RelExpr)
										if _f.appliedRule != nil {
											_f.appliedRule(opt.ExtractJoinEqualities, nil, _expr)
										}
										return _expr
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.SemiJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeSemiJoin(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructAntiJoin constructs an expression for the AntiJoin operator.
func (_f *Factory) ConstructAntiJoin(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructAntiJoin(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_select, _ := right.(*memo.SelectExpr)
			if _select != nil {
				input := _select.Input
				filters := _select.Filters
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
					_expr := _f.ConstructAntiJoin(
						left,
						input,
						_f.funcs.ConcatFilters(on, filters),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateSelect, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if right.Op() == opt.InnerJoinOp || right.Op() == opt.InnerJoinApplyOp {
				innerLeft := right.Child(0).(memo.RelExpr)
				innerRight := right.Child(1).(memo.RelExpr)
				innerOn := *right.Child(2).(*memo.FiltersExpr)
				if !_f.funcs.FiltersBoundBy(innerOn, _f.funcs.OutputCols2(innerLeft, innerRight)) {
					innerPrivate := right.Private().(*memo.JoinPrivate)
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_expr := _f.ConstructAntiJoin(
							left,
							_f.DynamicConstruct(
								right.Op(),
								innerLeft,
								innerRight,
								&memo.EmptyFiltersExpr,
								innerPrivate,
							).(memo.RelExpr),
							_f.funcs.ConcatFilters(on, innerOn),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructAntiJoin(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructAntiJoin(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructAntiJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructAntiJoin(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructAntiJoin(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(right)) {
						if _f.funcs.CanMap(on, item, right) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
								_expr := _f.ConstructAntiJoin(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, right)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinRight, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				rightCols := _f.funcs.OutputCols(right)
				if _f.funcs.IsBoundBy(item, rightCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
						_expr := _f.ConstructAntiJoin(
							left,
							_f.ConstructSelect(
								right,
								_f.funcs.ExtractBoundConditions(on, rightCols),
							),
							_f.funcs.ExtractUnboundConditions(on, rightCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [EliminateAntiJoin]
	{
		if _f.funcs.HasZeroRows(right) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAntiJoin) {
				_expr := left
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAntiJoin, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructAntiJoin(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				for i := range on {
					item := &on[i]
					_eq, _ := item.Condition.(*memo.EqExpr)
					if _eq != nil {
						a := _eq.Left
						if !(opt.IsConstValueOp(a)) {
							b := _eq.Right
							if !(opt.IsConstValueOp(b)) {
								if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
									private := joinPrivate
									if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
										_expr := _f.funcs.ExtractJoinEquality(opt.AntiJoinOp, left, right, on, item, private).(memo.RelExpr)
										if _f.appliedRule != nil {
											_f.appliedRule(opt.ExtractJoinEqualities, nil, _expr)
										}
										return _expr
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.AntiJoinOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeAntiJoin(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructIndexJoin constructs an expression for the IndexJoin operator.
// IndexJoin represents an inner join between an input expression and a primary
// index. It is a special case of LookupJoin where the input columns are the PK
// columns of the table we are looking up into, and every input row results in
// exactly one output row.
//
// IndexJoin operators are created from Scan operators (unlike lookup joins which
// are created from Join operators).
func (_f *Factory) ConstructIndexJoin(
	input memo.RelExpr,
	indexJoinPrivate *memo.IndexJoinPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeIndexJoin(input, indexJoinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructLookupJoin constructs an expression for the LookupJoin operator.
// LookupJoin represents a join between an input expression and an index. The
// type of join is in the LookupJoinPrivate field.
func (_f *Factory) ConstructLookupJoin(
	input memo.RelExpr,
	on memo.FiltersExpr,
	lookupJoinPrivate *memo.LookupJoinPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeLookupJoin(input, on, lookupJoinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructMergeJoin constructs an expression for the MergeJoin operator.
// MergeJoin represents a join that is executed using merge-join.
// MergeOn is a scalar which contains the ON condition and merge-join ordering
// information; see the MergeOn scalar operator.
// It can be any type of join (identified in the MergeJoinPrivate field).
func (_f *Factory) ConstructMergeJoin(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	mergeJoinPrivate *memo.MergeJoinPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeMergeJoin(left, right, on, mergeJoinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructZigzagJoin constructs an expression for the ZigzagJoin operator.
// ZigzagJoin represents a join that is executed using the zigzag joiner.
// All fields except for the ON expression are stored in the private;
// since the zigzag joiner operates directly on indexes and doesn't
// support arbitrary inputs.
//
// TODO(itsbilal): Add support for representing multi-way zigzag joins.
func (_f *Factory) ConstructZigzagJoin(
	on memo.FiltersExpr,
	zigzagJoinPrivate *memo.ZigzagJoinPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeZigzagJoin(on, zigzagJoinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructInnerJoinApply constructs an expression for the InnerJoinApply operator.
// InnerJoinApply has the same join semantics as InnerJoin. However, unlike
// InnerJoin, it allows the right input to refer to columns projected by the
// left input.
func (_f *Factory) ConstructInnerJoinApply(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructInnerJoinApply(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			private := joinPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_expr := _f.funcs.ConstructNonApplyJoin(opt.InnerJoinApplyOp, left, right, on, private).(memo.RelExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_select, _ := right.(*memo.SelectExpr)
			if _select != nil {
				input := _select.Input
				filters := _select.Filters
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
					_expr := _f.ConstructInnerJoinApply(
						left,
						input,
						_f.funcs.ConcatFilters(on, filters),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateSelect, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [TryDecorrelateProject]
	{
		if _f.funcs.HasOuterCols(right) {
			_project, _ := right.(*memo.ProjectExpr)
			if _project != nil {
				input := _project.Input
				projections := _project.Projections
				passthrough := _project.Passthrough
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateProject) {
					_expr := _f.ConstructSelect(
						_f.ConstructProject(
							_f.ConstructInnerJoinApply(
								left,
								input,
								memo.EmptyFiltersExpr,
								private,
							),
							projections,
							_f.funcs.UnionCols(_f.funcs.OutputCols(left), passthrough),
						),
						on,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateProject, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if right.Op() == opt.InnerJoinOp || right.Op() == opt.InnerJoinApplyOp {
				innerLeft := right.Child(0).(memo.RelExpr)
				innerRight := right.Child(1).(memo.RelExpr)
				innerOn := *right.Child(2).(*memo.FiltersExpr)
				if !_f.funcs.FiltersBoundBy(innerOn, _f.funcs.OutputCols2(innerLeft, innerRight)) {
					innerPrivate := right.Private().(*memo.JoinPrivate)
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_expr := _f.ConstructInnerJoinApply(
							left,
							_f.DynamicConstruct(
								right.Op(),
								innerLeft,
								innerRight,
								&memo.EmptyFiltersExpr,
								innerPrivate,
							).(memo.RelExpr),
							_f.funcs.ConcatFilters(on, innerOn),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerLeftJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_leftJoin, _ := right.(*memo.LeftJoinExpr)
			if _leftJoin != nil {
				innerLeft := _leftJoin.Left
				innerRight := _leftJoin.Right
				innerOn := _leftJoin.On
				innerPrivate := &_leftJoin.JoinPrivate
				if _f.funcs.FiltersBoundBy(on, _f.funcs.OutputCols2(left, innerLeft)) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerLeftJoin) {
						_expr := _f.ConstructLeftJoinApply(
							_f.ConstructInnerJoinApply(
								left,
								innerLeft,
								on,
								innerPrivate,
							),
							innerRight,
							innerOn,
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerLeftJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateGroupBy]
	{
		if _f.funcs.HasOuterCols(right) {
			if right.Op() == opt.GroupByOp || right.Op() == opt.DistinctOnOp {
				input := right.Child(0).(memo.RelExpr)
				aggregations := *right.Child(1).(*memo.AggregationsExpr)
				groupingPrivate := right.Private().(*memo.GroupingPrivate)
				if _f.funcs.IsUnorderedGrouping(groupingPrivate) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateGroupBy) {
						newLeft := _f.funcs.EnsureKey(left)
						_arg := _f.funcs.AppendAggCols(aggregations, opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft))
						_expr := _f.ConstructSelect(
							_f.DynamicConstruct(
								right.Op(),
								_f.ConstructInnerJoinApply(
									newLeft,
									input,
									memo.EmptyFiltersExpr,
									private,
								),
								&_arg,
								_f.funcs.AddColsToGrouping(groupingPrivate, _f.funcs.KeyCols(newLeft)),
							).(memo.RelExpr),
							on,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateGroupBy, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateScalarGroupBy]
	{
		if _f.funcs.HasOuterCols(right) {
			_scalarGroupBy, _ := right.(*memo.ScalarGroupByExpr)
			if _scalarGroupBy != nil {
				input := _scalarGroupBy.Input
				aggregations := _scalarGroupBy.Aggregations
				groupingPrivate := &_scalarGroupBy.GroupingPrivate
				if _f.funcs.AggsCanBeDecorrelated(aggregations) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateScalarGroupBy) {
						leftWithKey := _f.funcs.EnsureKey(left)
						canaryCol := _f.funcs.EnsureCanaryCol(input, aggregations)
						rightWithCanary := _f.funcs.EnsureCanary(input, canaryCol)
						translatedAggs := _f.funcs.EnsureAggsCanIgnoreNulls(rightWithCanary, aggregations)
						_expr := _f.ConstructSelect(
							_f.funcs.TranslateNonIgnoreAggs(_f.ConstructGroupBy(
								_f.ConstructLeftJoinApply(
									leftWithKey,
									rightWithCanary,
									memo.EmptyFiltersExpr,
									private,
								),
								_f.funcs.AppendAggCols2(translatedAggs, opt.ConstAggOp, _f.funcs.NonKeyCols(leftWithKey), opt.AnyNotNullAggOp, _f.funcs.CanaryColSet(canaryCol)),
								_f.funcs.MakeOrderedGrouping(_f.funcs.KeyCols(leftWithKey), _f.funcs.ExtractGroupingOrdering(groupingPrivate)),
							), translatedAggs, rightWithCanary, aggregations, canaryCol),
							on,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateScalarGroupBy, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateLimitOne]
	{
		if _f.funcs.HasOuterCols(right) {
			_limit, _ := right.(*memo.LimitExpr)
			if _limit != nil {
				input := _limit.Input
				_const, _ := _limit.Limit.(*memo.ConstExpr)
				if _const != nil {
					if _f.funcs.EqualsNumber(_const.Value, 1) {
						ordering := _limit.Ordering
						private := joinPrivate
						if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateLimitOne) {
							newLeft := _f.funcs.EnsureKey(left)
							_expr := _f.ConstructDistinctOn(
								_f.ConstructInnerJoinApply(
									newLeft,
									input,
									on,
									private,
								),
								_f.funcs.MakeAggCols2(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft), opt.FirstAggOp, _f.funcs.OutputCols(input)),
								_f.funcs.MakeOrderedGrouping(_f.funcs.KeyCols(newLeft), ordering),
							)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.TryDecorrelateLimitOne, nil, _expr)
							}
							return _expr
						}
					}
				}
			}
		}
	}

	// [TryDecorrelateProjectSet]
	{
		_projectSet, _ := right.(*memo.ProjectSetExpr)
		if _projectSet != nil {
			input := _projectSet.Input
			zip := _projectSet.Zip
			private := joinPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateProjectSet) {
				_expr := _f.ConstructSelect(
					_f.ConstructProjectSet(
						_f.ConstructInnerJoinApply(
							left,
							input,
							memo.EmptyFiltersExpr,
							private,
						),
						zip,
					),
					on,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.TryDecorrelateProjectSet, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructInnerJoinApply(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructInnerJoinApply(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructInnerJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructInnerJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructInnerJoinApply(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(on, item, left) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_expr := _f.ConstructInnerJoinApply(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, left)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(right)) {
						if _f.funcs.CanMap(on, item, right) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
								_expr := _f.ConstructInnerJoinApply(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, right)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinRight, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(item, leftCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_expr := _f.ConstructInnerJoinApply(
							_f.ConstructSelect(
								left,
								_f.funcs.ExtractBoundConditions(on, leftCols),
							),
							right,
							_f.funcs.ExtractUnboundConditions(on, leftCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				rightCols := _f.funcs.OutputCols(right)
				if _f.funcs.IsBoundBy(item, rightCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
						_expr := _f.ConstructInnerJoinApply(
							left,
							_f.ConstructSelect(
								right,
								_f.funcs.ExtractBoundConditions(on, rightCols),
							),
							_f.funcs.ExtractUnboundConditions(on, rightCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [EliminateJoinNoColsLeft]
	{
		if _f.funcs.HasNoCols(left) {
			if _f.funcs.HasOneRow(left) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateJoinNoColsLeft) {
					_expr := _f.ConstructSelect(
						right,
						on,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateJoinNoColsLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [EliminateJoinNoColsRight]
	{
		if _f.funcs.HasNoCols(right) {
			if _f.funcs.HasOneRow(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateJoinNoColsRight) {
					_expr := _f.ConstructSelect(
						left,
						on,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateJoinNoColsRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [HoistJoinProjectRight]
	{
		_project, _ := right.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			if len(projections) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProjectRight) {
					_expr := _f.ConstructProject(
						_f.ConstructInnerJoinApply(
							left,
							input,
							on,
							private,
						),
						projections,
						_f.funcs.OutputCols2(left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinProjectRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [HoistJoinProjectLeft]
	{
		_project, _ := left.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			if len(projections) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProjectLeft) {
					_expr := _f.ConstructProject(
						_f.ConstructInnerJoinApply(
							input,
							right,
							on,
							private,
						),
						projections,
						_f.funcs.OutputCols2(left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinProjectLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructInnerJoinApply(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.InnerJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeInnerJoinApply(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructLeftJoinApply constructs an expression for the LeftJoinApply operator.
func (_f *Factory) ConstructLeftJoinApply(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [TryDecorrelateProjectInnerJoin]
	{
		_project, _ := right.(*memo.ProjectExpr)
		if _project != nil {
			join := _project.Input
			if join.Op() == opt.InnerJoinOp || join.Op() == opt.InnerJoinApplyOp {
				innerLeft := join.Child(0).(memo.RelExpr)
				innerRight := join.Child(1).(memo.RelExpr)
				innerOn := *join.Child(2).(*memo.FiltersExpr)
				if !_f.funcs.FiltersBoundBy(innerOn, _f.funcs.OutputCols2(innerLeft, innerRight)) {
					innerPrivate := join.Private().(*memo.JoinPrivate)
					projections := _project.Projections
					passthrough := _project.Passthrough
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateProjectInnerJoin) {
						_expr := _f.ConstructProject(
							_f.ConstructLeftJoinApply(
								left,
								_f.ConstructProject(
									_f.DynamicConstruct(
										join.Op(),
										innerLeft,
										innerRight,
										&memo.EmptyFiltersExpr,
										innerPrivate,
									).(memo.RelExpr),
									projections,
									_f.funcs.UnionCols(passthrough, _f.funcs.OutputCols(join)),
								),
								_f.funcs.ConcatFilters(on, innerOn),
								private,
							),
							memo.EmptyProjectionsExpr,
							_f.funcs.OutputCols2(left, right),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateProjectInnerJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructLeftJoinApply(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			private := joinPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_expr := _f.funcs.ConstructNonApplyJoin(opt.LeftJoinApplyOp, left, right, on, private).(memo.RelExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_select, _ := right.(*memo.SelectExpr)
			if _select != nil {
				input := _select.Input
				filters := _select.Filters
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
					_expr := _f.ConstructLeftJoinApply(
						left,
						input,
						_f.funcs.ConcatFilters(on, filters),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateSelect, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [TryDecorrelateProjectSelect]
	{
		_project, _ := right.(*memo.ProjectExpr)
		if _project != nil {
			_select, _ := _project.Input.(*memo.SelectExpr)
			if _select != nil {
				selectInput := _select.Input
				filters := _select.Filters
				if !_f.funcs.FiltersBoundBy(filters, _f.funcs.OutputCols(selectInput)) {
					projections := _project.Projections
					passthrough := _project.Passthrough
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateProjectSelect) {
						_expr := _f.ConstructProject(
							_f.ConstructLeftJoinApply(
								left,
								_f.ConstructProject(
									selectInput,
									projections,
									_f.funcs.UnionCols(passthrough, _f.funcs.OutputCols(selectInput)),
								),
								_f.funcs.ConcatFilters(on, filters),
								private,
							),
							memo.EmptyProjectionsExpr,
							_f.funcs.OutputCols2(left, right),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateProjectSelect, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if right.Op() == opt.InnerJoinOp || right.Op() == opt.InnerJoinApplyOp {
				innerLeft := right.Child(0).(memo.RelExpr)
				innerRight := right.Child(1).(memo.RelExpr)
				innerOn := *right.Child(2).(*memo.FiltersExpr)
				if !_f.funcs.FiltersBoundBy(innerOn, _f.funcs.OutputCols2(innerLeft, innerRight)) {
					innerPrivate := right.Private().(*memo.JoinPrivate)
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_expr := _f.ConstructLeftJoinApply(
							left,
							_f.DynamicConstruct(
								right.Op(),
								innerLeft,
								innerRight,
								&memo.EmptyFiltersExpr,
								innerPrivate,
							).(memo.RelExpr),
							_f.funcs.ConcatFilters(on, innerOn),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateLimitOne]
	{
		if _f.funcs.HasOuterCols(right) {
			_limit, _ := right.(*memo.LimitExpr)
			if _limit != nil {
				input := _limit.Input
				_const, _ := _limit.Limit.(*memo.ConstExpr)
				if _const != nil {
					if _f.funcs.EqualsNumber(_const.Value, 1) {
						ordering := _limit.Ordering
						private := joinPrivate
						if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateLimitOne) {
							newLeft := _f.funcs.EnsureKey(left)
							_expr := _f.ConstructDistinctOn(
								_f.ConstructLeftJoinApply(
									newLeft,
									input,
									on,
									private,
								),
								_f.funcs.MakeAggCols2(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft), opt.FirstAggOp, _f.funcs.OutputCols(input)),
								_f.funcs.MakeOrderedGrouping(_f.funcs.KeyCols(newLeft), ordering),
							)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.TryDecorrelateLimitOne, nil, _expr)
							}
							return _expr
						}
					}
				}
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructLeftJoinApply(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructLeftJoinApply(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructLeftJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructLeftJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructLeftJoinApply(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(right)) {
						if _f.funcs.CanMap(on, item, right) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
								_expr := _f.ConstructLeftJoinApply(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, right)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinRight, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				rightCols := _f.funcs.OutputCols(right)
				if _f.funcs.IsBoundBy(item, rightCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
						_expr := _f.ConstructLeftJoinApply(
							left,
							_f.ConstructSelect(
								right,
								_f.funcs.ExtractBoundConditions(on, rightCols),
							),
							_f.funcs.ExtractUnboundConditions(on, rightCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [SimplifyLeftJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			if len(on) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithoutFilters) {
					_expr := _f.funcs.ConstructNonLeftJoin(opt.LeftJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithoutFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyLeftJoinWithFilters]
	{
		if len(on) != 0 {
			if _f.funcs.JoinFiltersMatchAllLeftRows(left, right, on) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithFilters) {
					_expr := _f.funcs.ConstructNonLeftJoin(opt.LeftJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [HoistJoinProjectRight]
	{
		_project, _ := right.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			if len(projections) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProjectRight) {
					_expr := _f.ConstructProject(
						_f.ConstructLeftJoinApply(
							left,
							input,
							on,
							private,
						),
						projections,
						_f.funcs.OutputCols2(left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinProjectRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [HoistJoinProjectLeft]
	{
		_project, _ := left.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			if len(projections) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProjectLeft) {
					_expr := _f.ConstructProject(
						_f.ConstructLeftJoinApply(
							input,
							right,
							on,
							private,
						),
						projections,
						_f.funcs.OutputCols2(left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinProjectLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructLeftJoinApply(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.LeftJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeLeftJoinApply(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructRightJoinApply constructs an expression for the RightJoinApply operator.
func (_f *Factory) ConstructRightJoinApply(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructRightJoinApply(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			private := joinPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_expr := _f.funcs.ConstructNonApplyJoin(opt.RightJoinApplyOp, left, right, on, private).(memo.RelExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructRightJoinApply(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructRightJoinApply(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructRightJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructRightJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructRightJoinApply(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(on, item, left) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_expr := _f.ConstructRightJoinApply(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, left)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(item, leftCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_expr := _f.ConstructRightJoinApply(
							_f.ConstructSelect(
								left,
								_f.funcs.ExtractBoundConditions(on, leftCols),
							),
							right,
							_f.funcs.ExtractUnboundConditions(on, leftCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [SimplifyRightJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(left) {
			if len(on) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithoutFilters) {
					_expr := _f.funcs.ConstructNonRightJoin(opt.RightJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithoutFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyRightJoinWithFilters]
	{
		if len(on) != 0 {
			if _f.funcs.JoinFiltersMatchAllLeftRows(right, left, on) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithFilters) {
					_expr := _f.funcs.ConstructNonRightJoin(opt.RightJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructRightJoinApply(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.RightJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeRightJoinApply(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructFullJoinApply constructs an expression for the FullJoinApply operator.
func (_f *Factory) ConstructFullJoinApply(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructFullJoinApply(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			private := joinPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_expr := _f.funcs.ConstructNonApplyJoin(opt.FullJoinApplyOp, left, right, on, private).(memo.RelExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructFullJoinApply(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructFullJoinApply(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructFullJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructFullJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructFullJoinApply(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyLeftJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			if len(on) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithoutFilters) {
					_expr := _f.funcs.ConstructNonLeftJoin(opt.FullJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithoutFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyRightJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(left) {
			if len(on) == 0 {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithoutFilters) {
					_expr := _f.funcs.ConstructNonRightJoin(opt.FullJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithoutFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyLeftJoinWithFilters]
	{
		if len(on) != 0 {
			if _f.funcs.JoinFiltersMatchAllLeftRows(left, right, on) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithFilters) {
					_expr := _f.funcs.ConstructNonLeftJoin(opt.FullJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyRightJoinWithFilters]
	{
		if len(on) != 0 {
			if _f.funcs.JoinFiltersMatchAllLeftRows(right, left, on) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithFilters) {
					_expr := _f.funcs.ConstructNonRightJoin(opt.FullJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithFilters, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructFullJoinApply(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.FullJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeFullJoinApply(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructSemiJoinApply constructs an expression for the SemiJoinApply operator.
func (_f *Factory) ConstructSemiJoinApply(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructSemiJoinApply(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			private := joinPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_expr := _f.funcs.ConstructNonApplyJoin(opt.SemiJoinApplyOp, left, right, on, private).(memo.RelExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_select, _ := right.(*memo.SelectExpr)
			if _select != nil {
				input := _select.Input
				filters := _select.Filters
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
					_expr := _f.ConstructSemiJoinApply(
						left,
						input,
						_f.funcs.ConcatFilters(on, filters),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateSelect, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if right.Op() == opt.InnerJoinOp || right.Op() == opt.InnerJoinApplyOp {
				innerLeft := right.Child(0).(memo.RelExpr)
				innerRight := right.Child(1).(memo.RelExpr)
				innerOn := *right.Child(2).(*memo.FiltersExpr)
				if !_f.funcs.FiltersBoundBy(innerOn, _f.funcs.OutputCols2(innerLeft, innerRight)) {
					innerPrivate := right.Private().(*memo.JoinPrivate)
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_expr := _f.ConstructSemiJoinApply(
							left,
							_f.DynamicConstruct(
								right.Op(),
								innerLeft,
								innerRight,
								&memo.EmptyFiltersExpr,
								innerPrivate,
							).(memo.RelExpr),
							_f.funcs.ConcatFilters(on, innerOn),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [TryDecorrelateSemiJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if _f.funcs.CanHaveZeroRows(right) {
				if right.Op() == opt.GroupByOp || right.Op() == opt.DistinctOnOp || right.Op() == opt.ProjectOp || right.Op() == opt.ProjectSetOp {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSemiJoin) {
						newLeft := _f.funcs.EnsureKey(left)
						_expr := _f.ConstructGroupBy(
							_f.ConstructInnerJoinApply(
								newLeft,
								right,
								on,
								private,
							),
							_f.funcs.MakeAggCols(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft)),
							_f.funcs.MakeGrouping(_f.funcs.KeyCols(newLeft)),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSemiJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructSemiJoinApply(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructSemiJoinApply(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructSemiJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructSemiJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructSemiJoinApply(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(on, item, left) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_expr := _f.ConstructSemiJoinApply(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, left)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(right)) {
						if _f.funcs.CanMap(on, item, right) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
								_expr := _f.ConstructSemiJoinApply(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, right)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinRight, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		if !_f.funcs.HasOuterCols(left) {
			for i := range on {
				item := &on[i]
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(item, leftCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_expr := _f.ConstructSemiJoinApply(
							_f.ConstructSelect(
								left,
								_f.funcs.ExtractBoundConditions(on, leftCols),
							),
							right,
							_f.funcs.ExtractUnboundConditions(on, leftCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				rightCols := _f.funcs.OutputCols(right)
				if _f.funcs.IsBoundBy(item, rightCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
						_expr := _f.ConstructSemiJoinApply(
							left,
							_f.ConstructSelect(
								right,
								_f.funcs.ExtractBoundConditions(on, rightCols),
							),
							_f.funcs.ExtractUnboundConditions(on, rightCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [EliminateSemiJoin]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			if len(on) == 0 {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateSemiJoin) {
					_expr := left
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateSemiJoin, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructSemiJoinApply(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.SemiJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeSemiJoinApply(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructAntiJoinApply constructs an expression for the AntiJoinApply operator.
func (_f *Factory) ConstructAntiJoinApply(
	left memo.RelExpr,
	right memo.RelExpr,
	on memo.FiltersExpr,
	joinPrivate *memo.JoinPrivate,
) memo.RelExpr {
	// [SimplifyJoinFilters]
	{
		for i := range on {
			_item := &on[i]
			if _item.Condition.Op() == opt.AndOp || _item.Condition.Op() == opt.TrueOp || _item.Condition.Op() == opt.FalseOp || _item.Condition.Op() == opt.NullOp {
				if !_f.funcs.IsFilterFalse(on) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinFilters) {
						_expr := _f.ConstructAntiJoinApply(
							left,
							right,
							_f.funcs.SimplifyFilters(on),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.SimplifyJoinFilters, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			private := joinPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_expr := _f.funcs.ConstructNonApplyJoin(opt.AntiJoinApplyOp, left, right, on, private).(memo.RelExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_select, _ := right.(*memo.SelectExpr)
			if _select != nil {
				input := _select.Input
				filters := _select.Filters
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
					_expr := _f.ConstructAntiJoinApply(
						left,
						input,
						_f.funcs.ConcatFilters(on, filters),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateSelect, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if right.Op() == opt.InnerJoinOp || right.Op() == opt.InnerJoinApplyOp {
				innerLeft := right.Child(0).(memo.RelExpr)
				innerRight := right.Child(1).(memo.RelExpr)
				innerOn := *right.Child(2).(*memo.FiltersExpr)
				if !_f.funcs.FiltersBoundBy(innerOn, _f.funcs.OutputCols2(innerLeft, innerRight)) {
					innerPrivate := right.Private().(*memo.JoinPrivate)
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_expr := _f.ConstructAntiJoinApply(
							left,
							_f.DynamicConstruct(
								right.Op(),
								innerLeft,
								innerRight,
								&memo.EmptyFiltersExpr,
								innerPrivate,
							).(memo.RelExpr),
							_f.funcs.ConcatFilters(on, innerOn),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeJoinAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_any, _ := item.Condition.(*memo.AnyExpr)
			if _any != nil {
				anyInput := _any.Input
				scalar := _any.Scalar
				anyPrivate := &_any.SubqueryPrivate
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinAnyFilter) {
					_expr := _f.ConstructAntiJoinApply(
						left,
						right,
						_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructExists(
							_f.ConstructSelect(
								anyInput,
								memo.FiltersExpr{
									{
										Condition: _f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
									},
								},
							),
							anyPrivate,
						)),
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeJoinAnyFilter, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeJoinNotAnyFilter]
	{
		for i := range on {
			item := &on[i]
			_not, _ := item.Condition.(*memo.NotExpr)
			if _not != nil {
				_any, _ := _not.Input.(*memo.AnyExpr)
				if _any != nil {
					anyInput := _any.Input
					scalar := _any.Scalar
					anyPrivate := &_any.SubqueryPrivate
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJoinNotAnyFilter) {
						_expr := _f.ConstructAntiJoinApply(
							left,
							right,
							_f.funcs.ReplaceFiltersItem(on, item, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										anyInput,
										memo.FiltersExpr{
											{
												Condition: _f.ConstructIsNot(
													_f.funcs.ConstructAnyCondition(anyInput, scalar, anyPrivate),
													_f.ConstructFalse(),
												),
											},
										},
									),
									anyPrivate,
								),
							)),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeJoinNotAnyFilter, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsLeft]
	{
		constCols := _f.funcs.FindInlinableConstants(left)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsLeft) {
						_expr := _f.ConstructAntiJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, left, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsLeft, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [InlineJoinConstantsRight]
	{
		constCols := _f.funcs.FindInlinableConstants(right)
		if !_f.funcs.ColsAreEmpty(constCols) {
			for i := range on {
				item := &on[i]
				if _f.funcs.ColsIntersect(_f.funcs.OuterCols(item), constCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.InlineJoinConstantsRight) {
						_expr := _f.ConstructAntiJoinApply(
							left,
							right,
							_f.funcs.InlineFilterConstants(on, right, constCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.InlineJoinConstantsRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [DetectJoinContradiction]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.IsContradiction(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.DetectJoinContradiction) {
					_expr := _f.ConstructAntiJoinApply(
						left,
						right,
						memo.FiltersExpr{
							{
								Condition: _f.ConstructFalse(),
							},
						},
						private,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DetectJoinContradiction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				_match := false
				_eq, _ := item.Condition.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						_variable2, _ := _eq.Right.(*memo.VariableExpr)
						if _variable2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(item, _f.funcs.OutputCols(right)) {
						if _f.funcs.CanMap(on, item, right) {
							private := joinPrivate
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
								_expr := _f.ConstructAntiJoinApply(
									left,
									right,
									_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.Map(on, item, right)),
									private,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinRight, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		if !_f.funcs.HasOuterCols(right) {
			for i := range on {
				item := &on[i]
				rightCols := _f.funcs.OutputCols(right)
				if _f.funcs.IsBoundBy(item, rightCols) {
					private := joinPrivate
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
						_expr := _f.ConstructAntiJoinApply(
							left,
							_f.ConstructSelect(
								right,
								_f.funcs.ExtractBoundConditions(on, rightCols),
							),
							_f.funcs.ExtractUnboundConditions(on, rightCols),
							private,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinRight, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [EliminateAntiJoin]
	{
		if _f.funcs.HasZeroRows(right) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAntiJoin) {
				_expr := left
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAntiJoin, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		for i := range on {
			item := &on[i]
			condition := item.Condition
			if condition.Op() == opt.IsOp || condition.Op() == opt.IsNotOp {
				eq := condition.Child(0).(opt.ScalarExpr)
				_eq, _ := eq.(*memo.EqExpr)
				if _eq != nil {
					_variable, _ := _eq.Left.(*memo.VariableExpr)
					if _variable != nil {
						col1 := _variable.Col
						if _f.funcs.IsColNotNull2(col1, left, right) {
							_variable2, _ := _eq.Right.(*memo.VariableExpr)
							if _variable2 != nil {
								col2 := _variable2.Col
								if _f.funcs.IsColNotNull2(col2, left, right) {
									cnst := condition.Child(1).(opt.ScalarExpr)
									if cnst.Op() == opt.TrueOp || cnst.Op() == opt.FalseOp || cnst.Op() == opt.NullOp {
										private := joinPrivate
										if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
											_expr := _f.ConstructAntiJoinApply(
												left,
												right,
												_f.funcs.ReplaceFiltersItem(on, item, _f.funcs.SimplifyNotNullEquality(eq, condition.Op(), cnst.Op())),
												private,
											)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.SimplifyJoinNotNullEquality, nil, _expr)
											}
											return _expr
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		for i := range on {
			item := &on[i]
			if _f.funcs.HasHoistableSubquery(item) {
				private := joinPrivate
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_expr := _f.funcs.HoistJoinSubquery(opt.AntiJoinApplyOp, left, right, on, private).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeAntiJoinApply(left, right, on, joinPrivate)
	return _f.onConstructRelational(e)
}

// ConstructGroupBy constructs an expression for the GroupBy operator.
// GroupBy computes aggregate functions over groups of input rows. Input rows
// that are equal on the grouping columns are grouped together. The set of
// computed aggregate functions is described by the Aggregations field (which is
// always an Aggregations operator).
//
// The arguments of the aggregate functions are columns from the input
// (i.e. Variables), possibly wrapped in aggregate modifiers like AggDistinct.
//
// If the set of input rows is empty, then the output of the GroupBy operator
// will also be empty. If the grouping columns are empty, then all input rows
// form a single group. GroupBy is used for queries with aggregate functions,
// HAVING clauses and/or GROUP BY expressions.
//
// The GroupingPrivate field contains an ordering; this ordering is used to
// determine intra-group ordering and is only useful if there is an order-
// dependent aggregation (like ARRAY_AGG). Grouping columns are inconsequential
// in this ordering; we currently set all grouping columns as optional in this
// ordering (but note that this is not required by the operator).
func (_f *Factory) ConstructGroupBy(
	input memo.RelExpr,
	aggregations memo.AggregationsExpr,
	groupingPrivate *memo.GroupingPrivate,
) memo.RelExpr {
	// [ConvertGroupByToDistinct]
	{
		if len(aggregations) == 0 {
			if _f.matchedRule == nil || _f.matchedRule(opt.ConvertGroupByToDistinct) {
				_expr := _f.ConstructDistinctOn(
					input,
					aggregations,
					groupingPrivate,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.ConvertGroupByToDistinct, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [EliminateGroupByProject]
	{
		_project, _ := input.(*memo.ProjectExpr)
		if _project != nil {
			innerInput := _project.Input
			if _f.funcs.ColsAreSubset(_f.funcs.OutputCols(input), _f.funcs.OutputCols(innerInput)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateGroupByProject) {
					_expr := _f.ConstructGroupBy(
						innerInput,
						aggregations,
						groupingPrivate,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateGroupByProject, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [ReduceGroupingCols]
	{
		if _f.funcs.CanReduceGroupingCols(input, groupingPrivate) {
			if _f.matchedRule == nil || _f.matchedRule(opt.ReduceGroupingCols) {
				_expr := _f.ConstructGroupBy(
					input,
					_f.funcs.AppendReducedGroupingCols(input, aggregations, groupingPrivate),
					_f.funcs.ReduceGroupingCols(input, groupingPrivate),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.ReduceGroupingCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [EliminateAggDistinctForKeys]
	{
		if _f.funcs.CanRemoveAggDistinctForKeys(aggregations, groupingPrivate, input) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinctForKeys) {
				_expr := _f.ConstructGroupBy(
					input,
					_f.funcs.RemoveAggDistinctForKeys(aggregations, groupingPrivate, input),
					groupingPrivate,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinctForKeys, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyGroupByOrdering]
	{
		if _f.funcs.CanSimplifyGroupingOrdering(input, groupingPrivate) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyGroupByOrdering) {
				_expr := _f.ConstructGroupBy(
					input,
					aggregations,
					_f.funcs.SimplifyGroupingOrdering(input, groupingPrivate),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyGroupByOrdering, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [PruneGroupByCols]
	{
		needed := _f.funcs.UnionCols(_f.funcs.AggregationOuterCols(aggregations), _f.funcs.NeededGroupingCols(groupingPrivate))
		if _f.funcs.CanPruneCols(input, needed) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneGroupByCols) {
				_expr := _f.ConstructGroupBy(
					_f.funcs.PruneCols(input, needed),
					aggregations,
					_f.funcs.PruneOrderingGroupBy(groupingPrivate, needed),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneGroupByCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeGroupBy(input, aggregations, groupingPrivate)
	return _f.onConstructRelational(e)
}

// ConstructScalarGroupBy constructs an expression for the ScalarGroupBy operator.
// ScalarGroupBy computes aggregate functions over the complete set of input
// rows. This is similar to GroupBy with empty grouping columns, where all input
// rows form a single group. However, there is an important difference. If the
// input set is empty, then the output of the ScalarGroupBy operator will have a
// single row containing default values for each aggregate function (typically
// null or zero, depending on the function). ScalarGroupBy always returns exactly
// one row - either the single-group aggregates or the default aggregate values.
//
// ScalarGroupBy uses the GroupingPrivate struct so that it's polymorphic with
// GroupBy and can be used in the same rules (when appropriate). In the
// ScalarGroupBy case, the grouping column field in GroupingPrivate is always
// empty.
func (_f *Factory) ConstructScalarGroupBy(
	input memo.RelExpr,
	aggregations memo.AggregationsExpr,
	groupingPrivate *memo.GroupingPrivate,
) memo.RelExpr {
	// [EliminateGroupByProject]
	{
		_project, _ := input.(*memo.ProjectExpr)
		if _project != nil {
			innerInput := _project.Input
			if _f.funcs.ColsAreSubset(_f.funcs.OutputCols(input), _f.funcs.OutputCols(innerInput)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateGroupByProject) {
					_expr := _f.ConstructScalarGroupBy(
						innerInput,
						aggregations,
						groupingPrivate,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateGroupByProject, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [EliminateAggDistinctForKeys]
	{
		if _f.funcs.CanRemoveAggDistinctForKeys(aggregations, groupingPrivate, input) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinctForKeys) {
				_expr := _f.ConstructScalarGroupBy(
					input,
					_f.funcs.RemoveAggDistinctForKeys(aggregations, groupingPrivate, input),
					groupingPrivate,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinctForKeys, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyGroupByOrdering]
	{
		if _f.funcs.CanSimplifyGroupingOrdering(input, groupingPrivate) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyGroupByOrdering) {
				_expr := _f.ConstructScalarGroupBy(
					input,
					aggregations,
					_f.funcs.SimplifyGroupingOrdering(input, groupingPrivate),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyGroupByOrdering, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeScalarGroupBy(input, aggregations, groupingPrivate)
	return _f.onConstructRelational(e)
}

// ConstructDistinctOn constructs an expression for the DistinctOn operator.
// DistinctOn filters out rows that are identical on the set of grouping columns;
// only the first row (according to an ordering) is kept for each set of possible
// values. It is roughly equivalent with a GroupBy on the same grouping columns
// except that it uses FirstAgg functions that ensure the value on the first row
// is chosen (across all aggregations).
//
// In addition, the value on that first row must be chosen for all the grouping
// columns as well; this is relevant in the case of equal but non-identical
// values, like decimals. For example, if we have rows (1, 2.0) and (1.0, 2) and
// we are grouping on these two columns, the values output can be either (1, 2.0)
// or (1.0, 2), but not (1.0, 2.0).
//
// The execution of DistinctOn resembles that of Select more than that of
// GroupBy: each row is tested against a map of what groups we have seen already,
// and is either passed through or discarded. In particular, note that this
// preserves the input ordering.
//
// The ordering in the GroupingPrivate field will be required of the input; it
// determines which row can get "chosen" for each group of values on the grouping
// columns. There is no restriction on the ordering; but note that grouping
// columns are inconsequential - they can appear anywhere in the ordering and
// they won't change the results (other than the result ordering).
//
// Currently when we build DistinctOn, we set all grouping columns as optional
// cols in Ordering (but this is not required by the operator).
//
// TODO(radu): in the future we may want an exploration transform to try out more
// specific interesting orderings because execution is more efficient when we can
// rely on an ordering on the grouping columns (or a subset of them).
//
// DistinctOn uses an Aggregations child and the GroupingPrivate struct so that
// it's polymorphic with GroupBy and can be used in the same rules (when
// appropriate). In the DistinctOn case, the aggregations can be only FirstAgg or
// ConstAgg.
func (_f *Factory) ConstructDistinctOn(
	input memo.RelExpr,
	aggregations memo.AggregationsExpr,
	groupingPrivate *memo.GroupingPrivate,
) memo.RelExpr {
	// [EliminateDistinct]
	{
		if _f.funcs.GroupingColsAreKey(groupingPrivate, input) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateDistinct) {
				_expr := input
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateDistinct, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [EliminateGroupByProject]
	{
		_project, _ := input.(*memo.ProjectExpr)
		if _project != nil {
			innerInput := _project.Input
			if _f.funcs.ColsAreSubset(_f.funcs.OutputCols(input), _f.funcs.OutputCols(innerInput)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateGroupByProject) {
					_expr := _f.ConstructDistinctOn(
						innerInput,
						aggregations,
						groupingPrivate,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateGroupByProject, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [ReduceGroupingCols]
	{
		if _f.funcs.CanReduceGroupingCols(input, groupingPrivate) {
			if _f.matchedRule == nil || _f.matchedRule(opt.ReduceGroupingCols) {
				_expr := _f.ConstructDistinctOn(
					input,
					_f.funcs.AppendReducedGroupingCols(input, aggregations, groupingPrivate),
					_f.funcs.ReduceGroupingCols(input, groupingPrivate),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.ReduceGroupingCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [EliminateDistinctOnNoColumns]
	{
		if _f.funcs.HasNoGroupingCols(groupingPrivate) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateDistinctOnNoColumns) {
				_expr := _f.funcs.ConstructProjectionFromDistinctOn(_f.ConstructLimit(
					input,
					_f.ConstructConst(
						tree.NewDInt(1),
					),
					_f.funcs.GroupingInputOrdering(groupingPrivate),
				), aggregations).(memo.RelExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateDistinctOnNoColumns, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyGroupByOrdering]
	{
		if _f.funcs.CanSimplifyGroupingOrdering(input, groupingPrivate) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyGroupByOrdering) {
				_expr := _f.ConstructDistinctOn(
					input,
					aggregations,
					_f.funcs.SimplifyGroupingOrdering(input, groupingPrivate),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyGroupByOrdering, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [PruneGroupByCols]
	{
		needed := _f.funcs.UnionCols(_f.funcs.AggregationOuterCols(aggregations), _f.funcs.NeededGroupingCols(groupingPrivate))
		if _f.funcs.CanPruneCols(input, needed) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneGroupByCols) {
				_expr := _f.ConstructDistinctOn(
					_f.funcs.PruneCols(input, needed),
					aggregations,
					_f.funcs.PruneOrderingGroupBy(groupingPrivate, needed),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneGroupByCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeDistinctOn(input, aggregations, groupingPrivate)
	return _f.onConstructRelational(e)
}

// ConstructUnion constructs an expression for the Union operator.
// Union is an operator used to combine the Left and Right input relations into
// a single set containing rows from both inputs. Duplicate rows are discarded.
// The SetPrivate field matches columns from the Left and Right inputs of the
// Union with the output columns. See the comment above SetPrivate for more
// details.
func (_f *Factory) ConstructUnion(
	left memo.RelExpr,
	right memo.RelExpr,
	setPrivate *memo.SetPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeUnion(left, right, setPrivate)
	return _f.onConstructRelational(e)
}

// ConstructIntersect constructs an expression for the Intersect operator.
// Intersect is an operator used to perform an intersection between the Left
// and Right input relations. The result consists only of rows in the Left
// relation that are also present in the Right relation. Duplicate rows are
// discarded.
// The SetPrivate field matches columns from the Left and Right inputs of the
// Intersect with the output columns. See the comment above SetPrivate for more
// details.
func (_f *Factory) ConstructIntersect(
	left memo.RelExpr,
	right memo.RelExpr,
	setPrivate *memo.SetPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeIntersect(left, right, setPrivate)
	return _f.onConstructRelational(e)
}

// ConstructExcept constructs an expression for the Except operator.
// Except is an operator used to perform a set difference between the Left and
// Right input relations. The result consists only of rows in the Left relation
// that are not present in the Right relation. Duplicate rows are discarded.
// The SetPrivate field matches columns from the Left and Right inputs of the Except
// with the output columns. See the comment above SetPrivate for more details.
func (_f *Factory) ConstructExcept(
	left memo.RelExpr,
	right memo.RelExpr,
	setPrivate *memo.SetPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeExcept(left, right, setPrivate)
	return _f.onConstructRelational(e)
}

// ConstructUnionAll constructs an expression for the UnionAll operator.
// UnionAll is an operator used to combine the Left and Right input relations
// into a single set containing rows from both inputs. Duplicate rows are
// not discarded. For example:
//
//   SELECT x FROM xx UNION ALL SELECT y FROM yy
//     x       y         out
//   -----   -----      -----
//     1       1          1
//     1       2    ->    1
//     2       3          1
//                        2
//                        2
//                        3
//
// The SetPrivate field matches columns from the Left and Right inputs of the
// UnionAll with the output columns. See the comment above SetPrivate for more
// details.
func (_f *Factory) ConstructUnionAll(
	left memo.RelExpr,
	right memo.RelExpr,
	setPrivate *memo.SetPrivate,
) memo.RelExpr {
	// [EliminateUnionAllLeft]
	{
		if _f.funcs.HasZeroRows(right) {
			colmap := setPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateUnionAllLeft) {
				_expr := _f.ConstructProject(
					left,
					_f.funcs.ProjectColMapLeft(colmap),
					_f.funcs.MakeEmptyColSet(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateUnionAllLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [EliminateUnionAllRight]
	{
		if _f.funcs.HasZeroRows(left) {
			colmap := setPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateUnionAllRight) {
				_expr := _f.ConstructProject(
					right,
					_f.funcs.ProjectColMapRight(colmap),
					_f.funcs.MakeEmptyColSet(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateUnionAllRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeUnionAll(left, right, setPrivate)
	return _f.onConstructRelational(e)
}

// ConstructIntersectAll constructs an expression for the IntersectAll operator.
// IntersectAll is an operator used to perform an intersection between the Left
// and Right input relations. The result consists only of rows in the Left
// relation that have a corresponding row in the Right relation. Duplicate rows
// are not discarded. This effectively creates a one-to-one mapping between the
// Left and Right rows. For example:
//
//   SELECT x FROM xx INTERSECT ALL SELECT y FROM yy
//     x       y         out
//   -----   -----      -----
//     1       1          1
//     1       1    ->    1
//     1       2          2
//     2       2          2
//     2       3
//     4
//
// The SetPrivate field matches columns from the Left and Right inputs of the
// IntersectAll with the output columns. See the comment above SetPrivate for more
// details.
func (_f *Factory) ConstructIntersectAll(
	left memo.RelExpr,
	right memo.RelExpr,
	setPrivate *memo.SetPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeIntersectAll(left, right, setPrivate)
	return _f.onConstructRelational(e)
}

// ConstructExceptAll constructs an expression for the ExceptAll operator.
// ExceptAll is an operator used to perform a set difference between the Left
// and Right input relations. The result consists only of rows in the Left
// relation that do not have a corresponding row in the Right relation.
// Duplicate rows are not discarded. This effectively creates a one-to-one
// mapping between the Left and Right rows. For example:
//   SELECT x FROM xx EXCEPT ALL SELECT y FROM yy
//     x       y         out
//   -----   -----      -----
//     1       1    ->    1
//     1       1          4
//     1       2
//     2       2
//     2       3
//     4
//
// The SetPrivate field matches columns from the Left and Right inputs of the
// ExceptAll with the output columns. See the comment above SetPrivate for more
// details.
func (_f *Factory) ConstructExceptAll(
	left memo.RelExpr,
	right memo.RelExpr,
	setPrivate *memo.SetPrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeExceptAll(left, right, setPrivate)
	return _f.onConstructRelational(e)
}

// ConstructLimit constructs an expression for the Limit operator.
// Limit returns a limited subset of the results in the input relation. The limit
// expression is a scalar value; the operator returns at most this many rows. The
// Orering field is a physical.OrderingChoice which indicates the row ordering
// required from the input (the first rows with respect to this ordering are
// returned).
func (_f *Factory) ConstructLimit(
	input memo.RelExpr,
	limit opt.ScalarExpr,
	ordering physical.OrderingChoice,
) memo.RelExpr {
	// [EliminateLimit]
	{
		_const, _ := limit.(*memo.ConstExpr)
		if _const != nil {
			limit := _const.Value
			if _f.funcs.LimitGeMaxRows(limit, input) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateLimit) {
					_expr := input
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateLimit, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [PushLimitIntoProject]
	{
		_project, _ := input.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			passthrough := _project.Passthrough
			if _f.funcs.HasColsInOrdering(input, ordering) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PushLimitIntoProject) {
					_expr := _f.ConstructProject(
						_f.ConstructLimit(
							input,
							limit,
							_f.funcs.PruneOrdering(ordering, _f.funcs.OutputCols(input)),
						),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PushLimitIntoProject, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyLimitOrdering]
	{
		if _f.funcs.CanSimplifyLimitOffsetOrdering(input, ordering) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLimitOrdering) {
				_expr := _f.ConstructLimit(
					input,
					limit,
					_f.funcs.SimplifyLimitOffsetOrdering(input, ordering),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyLimitOrdering, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeLimit(input, limit, ordering)
	return _f.onConstructRelational(e)
}

// ConstructOffset constructs an expression for the Offset operator.
// Offset filters out the first Offset rows of the input relation; used in
// conjunction with Limit.
func (_f *Factory) ConstructOffset(
	input memo.RelExpr,
	offset opt.ScalarExpr,
	ordering physical.OrderingChoice,
) memo.RelExpr {
	// [PushOffsetIntoProject]
	{
		_project, _ := input.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			projections := _project.Projections
			passthrough := _project.Passthrough
			if _f.funcs.HasColsInOrdering(input, ordering) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PushOffsetIntoProject) {
					_expr := _f.ConstructProject(
						_f.ConstructOffset(
							input,
							offset,
							_f.funcs.PruneOrdering(ordering, _f.funcs.OutputCols(input)),
						),
						projections,
						passthrough,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PushOffsetIntoProject, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyOffsetOrdering]
	{
		if _f.funcs.CanSimplifyLimitOffsetOrdering(input, ordering) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyOffsetOrdering) {
				_expr := _f.ConstructOffset(
					input,
					offset,
					_f.funcs.SimplifyLimitOffsetOrdering(input, ordering),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyOffsetOrdering, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeOffset(input, offset, ordering)
	return _f.onConstructRelational(e)
}

// ConstructMax1Row constructs an expression for the Max1Row operator.
// Max1Row enforces that its input must return at most one row. It is used as
// input to the Subquery operator. See the comment above Subquery for more
// details.
func (_f *Factory) ConstructMax1Row(
	input memo.RelExpr,
) memo.RelExpr {
	// [EliminateMax1Row]
	{
		if _f.funcs.HasZeroOrOneRow(input) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateMax1Row) {
				_expr := input
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateMax1Row, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeMax1Row(input)
	return _f.onConstructRelational(e)
}

// ConstructExplain constructs an expression for the Explain operator.
// Explain returns information about the execution plan of the "input"
// expression.
func (_f *Factory) ConstructExplain(
	input memo.RelExpr,
	explainPrivate *memo.ExplainPrivate,
) memo.RelExpr {
	// [SimplifyExplainOrdering]
	{
		if _f.funcs.CanSimplifyExplainOrdering(input, explainPrivate) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyExplainOrdering) {
				_expr := _f.ConstructExplain(
					input,
					_f.funcs.SimplifyExplainOrdering(input, explainPrivate),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyExplainOrdering, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [PruneExplainCols]
	{
		needed := _f.funcs.NeededExplainCols(explainPrivate)
		if _f.funcs.CanPruneCols(input, needed) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneExplainCols) {
				_expr := _f.ConstructExplain(
					_f.funcs.PruneCols(input, needed),
					explainPrivate,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneExplainCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeExplain(input, explainPrivate)
	return _f.onConstructRelational(e)
}

// ConstructShowTraceForSession constructs an expression for the ShowTraceForSession operator.
// ShowTraceForSession returns the current session traces.
func (_f *Factory) ConstructShowTraceForSession(
	showTracePrivate *memo.ShowTracePrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeShowTraceForSession(showTracePrivate)
	return _f.onConstructRelational(e)
}

// ConstructRowNumber constructs an expression for the RowNumber operator.
// RowNumber adds a column to each row in its input containing a unique,
// increasing number.
func (_f *Factory) ConstructRowNumber(
	input memo.RelExpr,
	rowNumberPrivate *memo.RowNumberPrivate,
) memo.RelExpr {
	// [SimplifyRowNumberOrdering]
	{
		if _f.funcs.CanSimplifyRowNumberOrdering(input, rowNumberPrivate) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRowNumberOrdering) {
				_expr := _f.ConstructRowNumber(
					input,
					_f.funcs.SimplifyRowNumberOrdering(input, rowNumberPrivate),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyRowNumberOrdering, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeRowNumber(input, rowNumberPrivate)
	return _f.onConstructRelational(e)
}

// ConstructProjectSet constructs an expression for the ProjectSet operator.
// ProjectSet represents a relational operator which zips through a list of
// generators for every row of the input.
//
// As a reminder, a functional zip over generators a,b,c returns tuples of
// values from a,b,c picked "simultaneously". NULLs are used when a generator is
// "shorter" than another.  For example:
//
//    zip([1,2,3], ['a','b']) = [(1,'a'), (2,'b'), (3, null)]
//
// ProjectSet corresponds to a relational operator project(R, a, b, c, ...)
// which, for each row in R, produces all the rows produced by zip(a, b, c, ...)
// with the values of R prefixed. Formally, this performs a lateral cross join
// of R with zip(a,b,c).
//
// See the Zip header for more details.
func (_f *Factory) ConstructProjectSet(
	input memo.RelExpr,
	zip memo.ZipExpr,
) memo.RelExpr {
	// [DecorrelateProjectSet]
	{
		_values, _ := input.(*memo.ValuesExpr)
		if _values == nil {
			if !_f.funcs.IsZipCorrelated(zip, _f.funcs.OutputCols(input)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateProjectSet) {
					_expr := _f.ConstructInnerJoin(
						input,
						_f.ConstructProjectSet(
							_f.funcs.ConstructNoColsRow(),
							zip,
						),
						memo.EmptyFiltersExpr,
						_f.funcs.EmptyJoinPrivate(),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.DecorrelateProjectSet, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [HoistProjectSetSubquery]
	{
		for i := range zip {
			item := &zip[i]
			if _f.funcs.HasHoistableSubquery(item) {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistProjectSetSubquery) {
					_expr := _f.funcs.HoistProjectSetSubquery(input, zip).(memo.RelExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistProjectSetSubquery, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeProjectSet(input, zip)
	return _f.onConstructRelational(e)
}

// ConstructSubquery constructs an expression for the Subquery operator.
// Subquery is a subquery in a single-row context. Here are some examples:
//
//   SELECT 1 = (SELECT 1)
//   SELECT (1, 'a') = (SELECT 1, 'a')`
//
// In a single-row context, the outer query is only valid if the subquery returns
// at most one row. Subqueries in a multi-row context can be transformed to a
// single row context using the Any operator. See the comment above the Any
// operator for more details.
//
// The Input field contains the subquery itself, which should be wrapped in a
// Max1Row operator to enforce that the subquery can return at most one row
// (Max1Row may be removed by the optimizer later if it can determine statically
// that the subquery will always return at most one row). In addition, the
// subquery must project exactly one output column. If the subquery returns one
// row, then that column is bound to the single column value in that row. If the
// subquery returns zero rows, then that column is bound to NULL.
func (_f *Factory) ConstructSubquery(
	input memo.RelExpr,
	subqueryPrivate *memo.SubqueryPrivate,
) opt.ScalarExpr {
	e := _f.mem.MemoizeSubquery(input, subqueryPrivate)
	return _f.onConstructScalar(e)
}

// ConstructAny constructs an expression for the Any operator.
// Any is a SQL operator that applies a comparison to every row of an input
// subquery and returns true if any of the comparisons are true, else returns
// null if any of the comparisons are null, else returns false. The following
// transformations map from various SQL operators into the Any operator:
//
//   <scalar> IN (<subquery>)
//   ==> (Any <subquery> <scalar> EqOp)
//
//   <scalar> NOT IN (<subquery>)
//   ==> (Not (Any <subquery> <scalar> EqOp))
//
//   <scalar> <cmp> {SOME|ANY}(<subquery>)
//   ==> (Any <subquery> <scalar> <cmp>)
//
//   <scalar> <cmp> ALL(<subquery>)
//   ==> (Not (Any <subquery> <scalar> <negated-cmp>))
//
// Any expects the input subquery to return a single column of any data type. The
// scalar value is compared with that column using the specified comparison
// operator.
func (_f *Factory) ConstructAny(
	input memo.RelExpr,
	scalar opt.ScalarExpr,
	subqueryPrivate *memo.SubqueryPrivate,
) opt.ScalarExpr {
	e := _f.mem.MemoizeAny(input, scalar, subqueryPrivate)
	return _f.onConstructScalar(e)
}

// ConstructExists constructs an expression for the Exists operator.
// Exists takes a relational query as its input, and evaluates to true if the
// query returns at least one row.
func (_f *Factory) ConstructExists(
	input memo.RelExpr,
	subqueryPrivate *memo.SubqueryPrivate,
) opt.ScalarExpr {
	// [EliminateExistsProject]
	{
		_project, _ := input.(*memo.ProjectExpr)
		if _project != nil {
			input := _project.Input
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateExistsProject) {
				_expr := _f.ConstructExists(
					input,
					subqueryPrivate,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateExistsProject, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [EliminateExistsGroupBy]
	{
		if input.Op() == opt.GroupByOp || input.Op() == opt.DistinctOnOp {
			input := input.Child(0).(memo.RelExpr)
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateExistsGroupBy) {
				_expr := _f.ConstructExists(
					input,
					subqueryPrivate,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateExistsGroupBy, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [IntroduceExistsLimit]
	{
		if !(input.Op() == opt.ProjectOp || input.Op() == opt.GroupByOp || input.Op() == opt.DistinctOnOp) {
			if !_f.funcs.HasOuterCols(input) {
				if !_f.funcs.HasZeroOrOneRow(input) {
					if !_f.funcs.IsLimited(subqueryPrivate) {
						if _f.matchedRule == nil || _f.matchedRule(opt.IntroduceExistsLimit) {
							_expr := _f.ConstructExists(
								_f.ConstructLimit(
									input,
									_f.ConstructConst(
										tree.NewDInt(1),
									),
									_f.funcs.EmptyOrdering(),
								),
								_f.funcs.MakeLimited(subqueryPrivate),
							)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.IntroduceExistsLimit, nil, _expr)
							}
							return _expr
						}
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeExists(input, subqueryPrivate)
	return _f.onConstructScalar(e)
}

// ConstructVariable constructs an expression for the Variable operator.
// Variable is the typed scalar value of a column in the query. The Col field is
// a metadata ColumnID value that references the column by index.
func (_f *Factory) ConstructVariable(
	col opt.ColumnID,
) opt.ScalarExpr {
	e := _f.mem.MemoizeVariable(col)
	return _f.onConstructScalar(e)
}

// ConstructConst constructs an expression for the Const operator.
// Const is a typed scalar constant value. The Value field is a tree.Datum value
// having any datum type that's legal in the expression's context.
func (_f *Factory) ConstructConst(
	value tree.Datum,
) opt.ScalarExpr {
	e := _f.mem.MemoizeConst(value)
	return _f.onConstructScalar(e)
}

// ConstructNull constructs an expression for the Null operator.
// Null is the constant SQL null value that has "unknown value" semantics. If
// the Typ field is not types.Unknown, then the value is known to be in the
// domain of that type. This is important for preserving correct types in
// replacement patterns. For example:
//   (Plus (Function ...) (Const 1))
//
// If the function in that expression has a static type of Int, but then it gets
// constant folded to (Null), then its type must remain as Int. Any other type
// violates logical equivalence of the expression, breaking type inference and
// possibly changing the results of execution. The solution is to tag the null
// with the correct type:
//   (Plus (Null (Int)) (Const 1))
//
// Null is its own operator rather than a Const datum in order to make matching
// and replacement easier and more efficient, as patterns can contain (Null)
// expressions.
func (_f *Factory) ConstructNull(
	typ types.T,
) opt.ScalarExpr {
	e := _f.mem.MemoizeNull(typ)
	return _f.onConstructScalar(e)
}

// ConstructTrue constructs an expression for the True operator.
// True is the boolean true value that is equivalent to the tree.DBoolTrue datum
// value. It is a separate operator to make matching and replacement simpler and
// more efficient, as patterns can contain (True) expressions.
func (_f *Factory) ConstructTrue() opt.ScalarExpr {
	e := _f.mem.MemoizeTrue()
	return _f.onConstructScalar(e)
}

// ConstructFalse constructs an expression for the False operator.
// False is the boolean false value that is equivalent to the tree.DBoolFalse
// datum value. It is a separate operator to make matching and replacement
// simpler and more efficient, as patterns can contain (False) expressions.
func (_f *Factory) ConstructFalse() opt.ScalarExpr {
	e := _f.mem.MemoizeFalse()
	return _f.onConstructScalar(e)
}

// ConstructPlaceholder constructs an expression for the Placeholder operator.
func (_f *Factory) ConstructPlaceholder(
	value tree.TypedExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizePlaceholder(value)
	return _f.onConstructScalar(e)
}

// ConstructTuple constructs an expression for the Tuple operator.
func (_f *Factory) ConstructTuple(
	elems memo.ScalarListExpr,
	typ types.T,
) opt.ScalarExpr {
	e := _f.mem.MemoizeTuple(elems, typ)
	return _f.onConstructScalar(e)
}

// ConstructAnd constructs an expression for the And operator.
// And is the boolean conjunction operator that evalutes to true only if both of
// its conditions evaluate to true.
func (_f *Factory) ConstructAnd(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [NormalizeNestedAnds]
	{
		_and, _ := right.(*memo.AndExpr)
		if _and != nil {
			innerLeft := _and.Left
			innerRight := _and.Right
			if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeNestedAnds) {
				_expr := _f.ConstructAnd(
					_f.funcs.ConcatLeftDeepAnds(left, innerLeft),
					innerRight,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.NormalizeNestedAnds, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyTrueAnd]
	{
		_true, _ := left.(*memo.TrueExpr)
		if _true != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyTrueAnd) {
				_expr := right
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyTrueAnd, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyAndTrue]
	{
		_true, _ := right.(*memo.TrueExpr)
		if _true != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyAndTrue) {
				_expr := left
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyAndTrue, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyFalseAnd]
	{
		_false, _ := left.(*memo.FalseExpr)
		if _false != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyFalseAnd) {
				_expr := left
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyFalseAnd, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyAndFalse]
	{
		_false, _ := right.(*memo.FalseExpr)
		if _false != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyAndFalse) {
				_expr := right
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyAndFalse, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullAndOr]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			_null2, _ := right.(*memo.NullExpr)
			if _null2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullAndOr) {
					_expr := _f.ConstructNull(
						_f.funcs.BoolType(),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullAndOr, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeAnd(left, right)
	return _f.onConstructScalar(e)
}

// ConstructOr constructs an expression for the Or operator.
// Or is the boolean disjunction operator that evaluates to true if either one of
// its conditions evaluates to true.
func (_f *Factory) ConstructOr(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [SimplifyTrueOr]
	{
		_true, _ := left.(*memo.TrueExpr)
		if _true != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyTrueOr) {
				_expr := left
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyTrueOr, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyOrTrue]
	{
		_true, _ := right.(*memo.TrueExpr)
		if _true != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyOrTrue) {
				_expr := right
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyOrTrue, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyFalseOr]
	{
		_false, _ := left.(*memo.FalseExpr)
		if _false != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyFalseOr) {
				_expr := right
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyFalseOr, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyOrFalse]
	{
		_false, _ := right.(*memo.FalseExpr)
		if _false != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyOrFalse) {
				_expr := left
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyOrFalse, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullAndOr]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			_null2, _ := right.(*memo.NullExpr)
			if _null2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullAndOr) {
					_expr := _f.ConstructNull(
						_f.funcs.BoolType(),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullAndOr, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [ExtractRedundantConjunct]
	{
		_or, _ := left.(*memo.OrExpr)
		if _or == nil {
			_or2, _ := right.(*memo.OrExpr)
			if _or2 == nil {
				conjunct := _f.funcs.FindRedundantConjunct(left, right)
				if _f.funcs.Succeeded(conjunct) {
					if _f.matchedRule == nil || _f.matchedRule(opt.ExtractRedundantConjunct) {
						_expr := _f.funcs.ExtractRedundantConjunct(conjunct, left, right).(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.ExtractRedundantConjunct, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeOr(left, right)
	return _f.onConstructScalar(e)
}

// ConstructRange constructs an expression for the Range operator.
// Range contains an And expression that constrains a single variable to a
// range. For example, the And expression might be x > 5 AND x < 10. The
// children of the And expression can be arbitrary expressions (including nested
// And expressions), but they must all constrain the same variable, and the
// constraints must be tight.
//
// Currently, Range expressions are only created by the ConsolidateSelectFilters
// normalization rule.
func (_f *Factory) ConstructRange(
	and opt.ScalarExpr,
) opt.ScalarExpr {
	// [SimplifyRange]
	{
		input := and
		_and, _ := input.(*memo.AndExpr)
		if _and == nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRange) {
				_expr := input
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyRange, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeRange(and)
	return _f.onConstructScalar(e)
}

// ConstructNot constructs an expression for the Not operator.
// Not is the boolean negation operator that evaluates to true if its input
// evaluates to false.
func (_f *Factory) ConstructNot(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNotTrue]
	{
		_true, _ := input.(*memo.TrueExpr)
		if _true != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNotTrue) {
				_expr := _f.ConstructFalse()
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNotTrue, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNotFalse]
	{
		_false, _ := input.(*memo.FalseExpr)
		if _false != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNotFalse) {
				_expr := _f.ConstructTrue()
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNotFalse, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [NegateComparison]
	{
		if opt.IsComparisonOp(input) {
			left := input.Child(0).(opt.ScalarExpr)
			right := input.Child(1).(opt.ScalarExpr)
			if !(input.Op() == opt.ContainsOp || input.Op() == opt.JsonExistsOp || input.Op() == opt.JsonSomeExistsOp || input.Op() == opt.JsonAllExistsOp) {
				if _f.matchedRule == nil || _f.matchedRule(opt.NegateComparison) {
					_expr := _f.funcs.NegateComparison(input.Op(), left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NegateComparison, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [EliminateNot]
	{
		_not, _ := input.(*memo.NotExpr)
		if _not != nil {
			input := _not.Input
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateNot) {
				_expr := input
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateNot, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [NegateAnd]
	{
		_and, _ := input.(*memo.AndExpr)
		if _and != nil {
			left := _and.Left
			right := _and.Right
			if _f.matchedRule == nil || _f.matchedRule(opt.NegateAnd) {
				_expr := _f.ConstructOr(
					_f.ConstructNot(
						left,
					),
					_f.ConstructNot(
						right,
					),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.NegateAnd, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [NegateOr]
	{
		_or, _ := input.(*memo.OrExpr)
		if _or != nil {
			left := _or.Left
			right := _or.Right
			if _f.matchedRule == nil || _f.matchedRule(opt.NegateOr) {
				_expr := _f.ConstructAnd(
					_f.ConstructNot(
						left,
					),
					_f.ConstructNot(
						right,
					),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.NegateOr, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeNot(input)
	return _f.onConstructScalar(e)
}

// ConstructEq constructs an expression for the Eq operator.
func (_f *Factory) ConstructEq(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [NormalizeCmpPlusConst]
	{
		_plus, _ := left.(*memo.PlusExpr)
		if _plus != nil {
			leftLeft := _plus.Left
			if !(opt.IsConstValueOp(leftLeft)) {
				leftRight := _plus.Right
				if opt.IsConstValueOp(leftRight) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpPlusConst) {
								_expr := _f.ConstructEq(
									leftLeft,
									_f.ConstructMinus(
										right,
										leftRight,
									),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpPlusConst, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpMinusConst]
	{
		_minus, _ := left.(*memo.MinusExpr)
		if _minus != nil {
			leftLeft := _minus.Left
			if !(opt.IsConstValueOp(leftLeft)) {
				leftRight := _minus.Right
				if opt.IsConstValueOp(leftRight) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.PlusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpMinusConst) {
								_expr := _f.ConstructEq(
									leftLeft,
									_f.ConstructPlus(
										right,
										leftRight,
									),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpMinusConst, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpConstMinus]
	{
		_minus, _ := left.(*memo.MinusExpr)
		if _minus != nil {
			leftLeft := _minus.Left
			if opt.IsConstValueOp(leftLeft) {
				leftRight := _minus.Right
				if !(opt.IsConstValueOp(leftRight)) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, leftLeft, right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpConstMinus) {
								_expr := _f.ConstructEq(
									_f.ConstructMinus(
										leftLeft,
										right,
									),
									leftRight,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpConstMinus, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeTupleEquality]
	{
		_tuple, _ := left.(*memo.TupleExpr)
		if _tuple != nil {
			left := _tuple.Elems
			_tuple2, _ := right.(*memo.TupleExpr)
			if _tuple2 != nil {
				right := _tuple2.Elems
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeTupleEquality) {
					_expr := _f.funcs.NormalizeTupleEquality(left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeTupleEquality, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [CommuteVar]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_expr := _f.ConstructEq(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConst]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_expr := _f.ConstructEq(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructEq(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeJSONFieldAccess]
	{
		_fetchVal, _ := left.(*memo.FetchValExpr)
		if _fetchVal != nil {
			val := _fetchVal.Json
			key := _fetchVal.Index
			_const, _ := key.(*memo.ConstExpr)
			if _const != nil {
				if _f.funcs.IsString(key) {
					_const2, _ := right.(*memo.ConstExpr)
					if _const2 != nil {
						if _f.funcs.IsJSONScalar(right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJSONFieldAccess) {
								_expr := _f.ConstructContains(
									val,
									_f.funcs.MakeSingleKeyJSONObject(key, right),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeJSONFieldAccess, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.EqOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeEq(left, right)
	return _f.onConstructScalar(e)
}

// ConstructLt constructs an expression for the Lt operator.
func (_f *Factory) ConstructLt(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [CommuteVarInequality]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVarInequality) {
					_expr := _f.funcs.CommuteInequality(opt.LtOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVarInequality, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConstInequality]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConstInequality) {
					_expr := _f.funcs.CommuteInequality(opt.LtOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConstInequality, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeCmpPlusConst]
	{
		_plus, _ := left.(*memo.PlusExpr)
		if _plus != nil {
			leftLeft := _plus.Left
			if !(opt.IsConstValueOp(leftLeft)) {
				leftRight := _plus.Right
				if opt.IsConstValueOp(leftRight) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpPlusConst) {
								_expr := _f.ConstructLt(
									leftLeft,
									_f.ConstructMinus(
										right,
										leftRight,
									),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpPlusConst, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpMinusConst]
	{
		_minus, _ := left.(*memo.MinusExpr)
		if _minus != nil {
			leftLeft := _minus.Left
			if !(opt.IsConstValueOp(leftLeft)) {
				leftRight := _minus.Right
				if opt.IsConstValueOp(leftRight) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.PlusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpMinusConst) {
								_expr := _f.ConstructLt(
									leftLeft,
									_f.ConstructPlus(
										right,
										leftRight,
									),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpMinusConst, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpConstMinus]
	{
		_minus, _ := left.(*memo.MinusExpr)
		if _minus != nil {
			leftLeft := _minus.Left
			if opt.IsConstValueOp(leftLeft) {
				leftRight := _minus.Right
				if !(opt.IsConstValueOp(leftRight)) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, leftLeft, right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpConstMinus) {
								_expr := _f.ConstructLt(
									_f.ConstructMinus(
										leftLeft,
										right,
									),
									leftRight,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpConstMinus, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructLt(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.LtOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeLt(left, right)
	return _f.onConstructScalar(e)
}

// ConstructGt constructs an expression for the Gt operator.
func (_f *Factory) ConstructGt(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [CommuteVarInequality]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVarInequality) {
					_expr := _f.funcs.CommuteInequality(opt.GtOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVarInequality, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConstInequality]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConstInequality) {
					_expr := _f.funcs.CommuteInequality(opt.GtOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConstInequality, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeCmpPlusConst]
	{
		_plus, _ := left.(*memo.PlusExpr)
		if _plus != nil {
			leftLeft := _plus.Left
			if !(opt.IsConstValueOp(leftLeft)) {
				leftRight := _plus.Right
				if opt.IsConstValueOp(leftRight) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpPlusConst) {
								_expr := _f.ConstructGt(
									leftLeft,
									_f.ConstructMinus(
										right,
										leftRight,
									),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpPlusConst, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpMinusConst]
	{
		_minus, _ := left.(*memo.MinusExpr)
		if _minus != nil {
			leftLeft := _minus.Left
			if !(opt.IsConstValueOp(leftLeft)) {
				leftRight := _minus.Right
				if opt.IsConstValueOp(leftRight) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.PlusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpMinusConst) {
								_expr := _f.ConstructGt(
									leftLeft,
									_f.ConstructPlus(
										right,
										leftRight,
									),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpMinusConst, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpConstMinus]
	{
		_minus, _ := left.(*memo.MinusExpr)
		if _minus != nil {
			leftLeft := _minus.Left
			if opt.IsConstValueOp(leftLeft) {
				leftRight := _minus.Right
				if !(opt.IsConstValueOp(leftRight)) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, leftLeft, right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpConstMinus) {
								_expr := _f.ConstructGt(
									_f.ConstructMinus(
										leftLeft,
										right,
									),
									leftRight,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpConstMinus, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructGt(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.GtOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeGt(left, right)
	return _f.onConstructScalar(e)
}

// ConstructLe constructs an expression for the Le operator.
func (_f *Factory) ConstructLe(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [CommuteVarInequality]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVarInequality) {
					_expr := _f.funcs.CommuteInequality(opt.LeOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVarInequality, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConstInequality]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConstInequality) {
					_expr := _f.funcs.CommuteInequality(opt.LeOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConstInequality, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeCmpPlusConst]
	{
		_plus, _ := left.(*memo.PlusExpr)
		if _plus != nil {
			leftLeft := _plus.Left
			if !(opt.IsConstValueOp(leftLeft)) {
				leftRight := _plus.Right
				if opt.IsConstValueOp(leftRight) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpPlusConst) {
								_expr := _f.ConstructLe(
									leftLeft,
									_f.ConstructMinus(
										right,
										leftRight,
									),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpPlusConst, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpMinusConst]
	{
		_minus, _ := left.(*memo.MinusExpr)
		if _minus != nil {
			leftLeft := _minus.Left
			if !(opt.IsConstValueOp(leftLeft)) {
				leftRight := _minus.Right
				if opt.IsConstValueOp(leftRight) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.PlusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpMinusConst) {
								_expr := _f.ConstructLe(
									leftLeft,
									_f.ConstructPlus(
										right,
										leftRight,
									),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpMinusConst, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpConstMinus]
	{
		_minus, _ := left.(*memo.MinusExpr)
		if _minus != nil {
			leftLeft := _minus.Left
			if opt.IsConstValueOp(leftLeft) {
				leftRight := _minus.Right
				if !(opt.IsConstValueOp(leftRight)) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, leftLeft, right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpConstMinus) {
								_expr := _f.ConstructLe(
									_f.ConstructMinus(
										leftLeft,
										right,
									),
									leftRight,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpConstMinus, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructLe(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.LeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeLe(left, right)
	return _f.onConstructScalar(e)
}

// ConstructGe constructs an expression for the Ge operator.
func (_f *Factory) ConstructGe(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [CommuteVarInequality]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVarInequality) {
					_expr := _f.funcs.CommuteInequality(opt.GeOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVarInequality, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConstInequality]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConstInequality) {
					_expr := _f.funcs.CommuteInequality(opt.GeOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConstInequality, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [NormalizeCmpPlusConst]
	{
		_plus, _ := left.(*memo.PlusExpr)
		if _plus != nil {
			leftLeft := _plus.Left
			if !(opt.IsConstValueOp(leftLeft)) {
				leftRight := _plus.Right
				if opt.IsConstValueOp(leftRight) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpPlusConst) {
								_expr := _f.ConstructGe(
									leftLeft,
									_f.ConstructMinus(
										right,
										leftRight,
									),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpPlusConst, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpMinusConst]
	{
		_minus, _ := left.(*memo.MinusExpr)
		if _minus != nil {
			leftLeft := _minus.Left
			if !(opt.IsConstValueOp(leftLeft)) {
				leftRight := _minus.Right
				if opt.IsConstValueOp(leftRight) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.PlusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpMinusConst) {
								_expr := _f.ConstructGe(
									leftLeft,
									_f.ConstructPlus(
										right,
										leftRight,
									),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpMinusConst, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpConstMinus]
	{
		_minus, _ := left.(*memo.MinusExpr)
		if _minus != nil {
			leftLeft := _minus.Left
			if opt.IsConstValueOp(leftLeft) {
				leftRight := _minus.Right
				if !(opt.IsConstValueOp(leftRight)) {
					if opt.IsConstValueOp(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, leftLeft, right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpConstMinus) {
								_expr := _f.ConstructGe(
									_f.ConstructMinus(
										leftLeft,
										right,
									),
									leftRight,
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpConstMinus, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructGe(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.GeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeGe(left, right)
	return _f.onConstructScalar(e)
}

// ConstructNe constructs an expression for the Ne operator.
func (_f *Factory) ConstructNe(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [CommuteVar]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_expr := _f.ConstructNe(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConst]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_expr := _f.ConstructNe(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructNe(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeNe(left, right)
	return _f.onConstructScalar(e)
}

// ConstructIn constructs an expression for the In operator.
func (_f *Factory) ConstructIn(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullInNonEmpty]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			_tuple, _ := right.(*memo.TupleExpr)
			if _tuple != nil {
				if len(_tuple.Elems) != 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullInNonEmpty) {
						_expr := _f.ConstructNull(
							_f.funcs.BoolType(),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNullInNonEmpty, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldNullInEmpty]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			_tuple, _ := right.(*memo.TupleExpr)
			if _tuple != nil {
				if len(_tuple.Elems) == 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullInEmpty) {
						_expr := _f.ConstructFalse()
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNullInEmpty, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeInConst]
	{
		_tuple, _ := right.(*memo.TupleExpr)
		if _tuple != nil {
			elems := _tuple.Elems
			if _f.funcs.NeedSortedUniqueList(elems) {
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeInConst) {
					_expr := _f.ConstructIn(
						left,
						_f.ConstructTuple(
							_f.funcs.ConstructSortedUniqueList(elems),
						),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeInConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldInNull]
	{
		_tuple, _ := right.(*memo.TupleExpr)
		if _tuple != nil {
			if len(_tuple.Elems) == 1 {
				_item := _tuple.Elems[0]
				_null, _ := _item.(*memo.NullExpr)
				if _null != nil {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldInNull) {
						_expr := _f.ConstructNull(
							_f.funcs.BoolType(),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldInNull, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructIn(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.InOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeIn(left, right)
	return _f.onConstructScalar(e)
}

// ConstructNotIn constructs an expression for the NotIn operator.
func (_f *Factory) ConstructNotIn(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullInNonEmpty]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			_tuple, _ := right.(*memo.TupleExpr)
			if _tuple != nil {
				if len(_tuple.Elems) != 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullInNonEmpty) {
						_expr := _f.ConstructNull(
							_f.funcs.BoolType(),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNullInNonEmpty, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldNullNotInEmpty]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			_tuple, _ := right.(*memo.TupleExpr)
			if _tuple != nil {
				if len(_tuple.Elems) == 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullNotInEmpty) {
						_expr := _f.ConstructTrue()
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNullNotInEmpty, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeInConst]
	{
		_tuple, _ := right.(*memo.TupleExpr)
		if _tuple != nil {
			elems := _tuple.Elems
			if _f.funcs.NeedSortedUniqueList(elems) {
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeInConst) {
					_expr := _f.ConstructNotIn(
						left,
						_f.ConstructTuple(
							_f.funcs.ConstructSortedUniqueList(elems),
						),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeInConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldInNull]
	{
		_tuple, _ := right.(*memo.TupleExpr)
		if _tuple != nil {
			if len(_tuple.Elems) == 1 {
				_item := _tuple.Elems[0]
				_null, _ := _item.(*memo.NullExpr)
				if _null != nil {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldInNull) {
						_expr := _f.ConstructNull(
							_f.funcs.BoolType(),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldInNull, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructNotIn(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotInOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeNotIn(left, right)
	return _f.onConstructScalar(e)
}

// ConstructLike constructs an expression for the Like operator.
func (_f *Factory) ConstructLike(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructLike(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.LikeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeLike(left, right)
	return _f.onConstructScalar(e)
}

// ConstructNotLike constructs an expression for the NotLike operator.
func (_f *Factory) ConstructNotLike(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructNotLike(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotLikeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeNotLike(left, right)
	return _f.onConstructScalar(e)
}

// ConstructILike constructs an expression for the ILike operator.
func (_f *Factory) ConstructILike(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructILike(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.ILikeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeILike(left, right)
	return _f.onConstructScalar(e)
}

// ConstructNotILike constructs an expression for the NotILike operator.
func (_f *Factory) ConstructNotILike(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructNotILike(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotILikeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeNotILike(left, right)
	return _f.onConstructScalar(e)
}

// ConstructSimilarTo constructs an expression for the SimilarTo operator.
func (_f *Factory) ConstructSimilarTo(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructSimilarTo(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.SimilarToOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeSimilarTo(left, right)
	return _f.onConstructScalar(e)
}

// ConstructNotSimilarTo constructs an expression for the NotSimilarTo operator.
func (_f *Factory) ConstructNotSimilarTo(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructNotSimilarTo(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotSimilarToOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeNotSimilarTo(left, right)
	return _f.onConstructScalar(e)
}

// ConstructRegMatch constructs an expression for the RegMatch operator.
func (_f *Factory) ConstructRegMatch(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructRegMatch(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.RegMatchOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeRegMatch(left, right)
	return _f.onConstructScalar(e)
}

// ConstructNotRegMatch constructs an expression for the NotRegMatch operator.
func (_f *Factory) ConstructNotRegMatch(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructNotRegMatch(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotRegMatchOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeNotRegMatch(left, right)
	return _f.onConstructScalar(e)
}

// ConstructRegIMatch constructs an expression for the RegIMatch operator.
func (_f *Factory) ConstructRegIMatch(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructRegIMatch(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.RegIMatchOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeRegIMatch(left, right)
	return _f.onConstructScalar(e)
}

// ConstructNotRegIMatch constructs an expression for the NotRegIMatch operator.
func (_f *Factory) ConstructNotRegIMatch(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructNotRegIMatch(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotRegIMatchOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeNotRegIMatch(left, right)
	return _f.onConstructScalar(e)
}

// ConstructIs constructs an expression for the Is operator.
func (_f *Factory) ConstructIs(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldIsNull]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			_null2, _ := right.(*memo.NullExpr)
			if _null2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldIsNull) {
					_expr := _f.ConstructTrue()
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldIsNull, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNonNullIsNull]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null == nil {
			if _f.funcs.IsConstValueOrTuple(left) {
				_null2, _ := right.(*memo.NullExpr)
				if _null2 != nil {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNonNullIsNull) {
						_expr := _f.ConstructFalse()
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNonNullIsNull, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [CommuteNullIs]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			_null2, _ := right.(*memo.NullExpr)
			if _null2 == nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteNullIs) {
					_expr := _f.ConstructIs(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteNullIs, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteVar]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_expr := _f.ConstructIs(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConst]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_expr := _f.ConstructIs(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructIs(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.IsOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeIs(left, right)
	return _f.onConstructScalar(e)
}

// ConstructIsNot constructs an expression for the IsNot operator.
func (_f *Factory) ConstructIsNot(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldIsNotNull]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			_null2, _ := right.(*memo.NullExpr)
			if _null2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldIsNotNull) {
					_expr := _f.ConstructFalse()
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldIsNotNull, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNonNullIsNotNull]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null == nil {
			if _f.funcs.IsConstValueOrTuple(left) {
				_null2, _ := right.(*memo.NullExpr)
				if _null2 != nil {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNonNullIsNotNull) {
						_expr := _f.ConstructTrue()
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNonNullIsNotNull, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [CommuteNullIs]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			_null2, _ := right.(*memo.NullExpr)
			if _null2 == nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteNullIs) {
					_expr := _f.ConstructIsNot(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteNullIs, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteVar]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_expr := _f.ConstructIsNot(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConst]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_expr := _f.ConstructIsNot(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructIsNot(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.IsNotOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeIsNot(left, right)
	return _f.onConstructScalar(e)
}

// ConstructContains constructs an expression for the Contains operator.
func (_f *Factory) ConstructContains(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructContains(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [NormalizeJSONContains]
	{
		_fetchVal, _ := left.(*memo.FetchValExpr)
		if _fetchVal != nil {
			val := _fetchVal.Json
			key := _fetchVal.Index
			_const, _ := key.(*memo.ConstExpr)
			if _const != nil {
				if _f.funcs.IsString(key) {
					_const2, _ := right.(*memo.ConstExpr)
					if _const2 != nil {
						if !_f.funcs.IsJSONScalar(right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJSONContains) {
								_expr := _f.ConstructContains(
									val,
									_f.funcs.MakeSingleKeyJSONObject(key, right),
								)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeJSONContains, nil, _expr)
								}
								return _expr
							}
						}
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.ContainsOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeContains(left, right)
	return _f.onConstructScalar(e)
}

// ConstructJsonExists constructs an expression for the JsonExists operator.
func (_f *Factory) ConstructJsonExists(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructJsonExists(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.JsonExistsOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeJsonExists(left, right)
	return _f.onConstructScalar(e)
}

// ConstructJsonAllExists constructs an expression for the JsonAllExists operator.
func (_f *Factory) ConstructJsonAllExists(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructJsonAllExists(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.JsonAllExistsOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeJsonAllExists(left, right)
	return _f.onConstructScalar(e)
}

// ConstructJsonSomeExists constructs an expression for the JsonSomeExists operator.
func (_f *Factory) ConstructJsonSomeExists(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullComparisonLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_expr := _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable != nil {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_expr := _f.ConstructJsonSomeExists(
							left,
							result,
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.JsonSomeExistsOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeJsonSomeExists(left, right)
	return _f.onConstructScalar(e)
}

// ConstructAnyScalar constructs an expression for the AnyScalar operator.
// AnyScalar is the form of ANY which refers to an ANY operation on a
// tuple or array, as opposed to Any which operates on a subquery.
func (_f *Factory) ConstructAnyScalar(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
	cmp opt.Operator,
) opt.ScalarExpr {
	// [SimplifyEqualsAnyTuple]
	{
		input := left
		tuple := right
		_tuple, _ := tuple.(*memo.TupleExpr)
		if _tuple != nil {
			if _f.funcs.OpsAreSame(cmp, opt.EqOp) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyEqualsAnyTuple) {
					_expr := _f.ConstructIn(
						input,
						tuple,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyEqualsAnyTuple, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [SimplifyAnyScalarArray]
	{
		input := left
		ary := right
		_const, _ := ary.(*memo.ConstExpr)
		if _const != nil {
			if _f.funcs.IsConstArray(ary) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyAnyScalarArray) {
					_expr := _f.ConstructAnyScalar(
						input,
						_f.funcs.ConvertConstArrayToTuple(ary),
						cmp,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyAnyScalarArray, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeAnyScalar(left, right, cmp)
	return _f.onConstructScalar(e)
}

// ConstructBitand constructs an expression for the Bitand operator.
func (_f *Factory) ConstructBitand(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [CommuteVar]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_expr := _f.ConstructBitand(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConst]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_expr := _f.ConstructBitand(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.BitandOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.BitandOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.BitandOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.BitandOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.BitandOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeBitand(left, right)
	return _f.onConstructScalar(e)
}

// ConstructBitor constructs an expression for the Bitor operator.
func (_f *Factory) ConstructBitor(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [CommuteVar]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_expr := _f.ConstructBitor(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConst]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_expr := _f.ConstructBitor(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.BitorOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.BitorOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.BitorOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.BitorOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.BitorOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeBitor(left, right)
	return _f.onConstructScalar(e)
}

// ConstructBitxor constructs an expression for the Bitxor operator.
func (_f *Factory) ConstructBitxor(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [CommuteVar]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_expr := _f.ConstructBitxor(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConst]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_expr := _f.ConstructBitxor(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.BitxorOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.BitxorOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.BitxorOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.BitxorOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.BitxorOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeBitxor(left, right)
	return _f.onConstructScalar(e)
}

// ConstructPlus constructs an expression for the Plus operator.
func (_f *Factory) ConstructPlus(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldPlusZero]
	{
		_const, _ := right.(*memo.ConstExpr)
		if _const != nil {
			if _f.funcs.EqualsNumber(_const.Value, 0) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldPlusZero) {
					_expr := _f.ConstructCast(
						left,
						_f.funcs.BinaryColType(opt.PlusOp, left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldPlusZero, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldZeroPlus]
	{
		_const, _ := left.(*memo.ConstExpr)
		if _const != nil {
			if _f.funcs.EqualsNumber(_const.Value, 0) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldZeroPlus) {
					_expr := _f.ConstructCast(
						right,
						_f.funcs.BinaryColType(opt.PlusOp, left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldZeroPlus, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteVar]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_expr := _f.ConstructPlus(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConst]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_expr := _f.ConstructPlus(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.PlusOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.PlusOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.PlusOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.PlusOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.PlusOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizePlus(left, right)
	return _f.onConstructScalar(e)
}

// ConstructMinus constructs an expression for the Minus operator.
func (_f *Factory) ConstructMinus(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldMinusZero]
	{
		if _f.funcs.IsAdditive(left) {
			_const, _ := right.(*memo.ConstExpr)
			if _const != nil {
				if _f.funcs.EqualsNumber(_const.Value, 0) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldMinusZero) {
						_expr := _f.ConstructCast(
							left,
							_f.funcs.BinaryColType(opt.MinusOp, left, right),
						)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldMinusZero, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.MinusOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.MinusOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.MinusOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.MinusOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.MinusOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeMinus(left, right)
	return _f.onConstructScalar(e)
}

// ConstructMult constructs an expression for the Mult operator.
func (_f *Factory) ConstructMult(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldMultOne]
	{
		_const, _ := right.(*memo.ConstExpr)
		if _const != nil {
			if _f.funcs.EqualsNumber(_const.Value, 1) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldMultOne) {
					_expr := _f.ConstructCast(
						left,
						_f.funcs.BinaryColType(opt.MultOp, left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldMultOne, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldOneMult]
	{
		_const, _ := left.(*memo.ConstExpr)
		if _const != nil {
			if _f.funcs.EqualsNumber(_const.Value, 1) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldOneMult) {
					_expr := _f.ConstructCast(
						right,
						_f.funcs.BinaryColType(opt.MultOp, left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldOneMult, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteVar]
	{
		_variable, _ := left.(*memo.VariableExpr)
		if _variable == nil {
			_variable2, _ := right.(*memo.VariableExpr)
			if _variable2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_expr := _f.ConstructMult(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [CommuteConst]
	{
		if opt.IsConstValueOp(left) {
			if !(opt.IsConstValueOp(right)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_expr := _f.ConstructMult(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.MultOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.MultOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.MultOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.MultOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.MultOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeMult(left, right)
	return _f.onConstructScalar(e)
}

// ConstructDiv constructs an expression for the Div operator.
func (_f *Factory) ConstructDiv(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldDivOne]
	{
		_const, _ := right.(*memo.ConstExpr)
		if _const != nil {
			if _f.funcs.EqualsNumber(_const.Value, 1) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldDivOne) {
					_expr := _f.ConstructCast(
						left,
						_f.funcs.BinaryColType(opt.DivOp, left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldDivOne, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.DivOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.DivOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.DivOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.DivOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.DivOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeDiv(left, right)
	return _f.onConstructScalar(e)
}

// ConstructFloorDiv constructs an expression for the FloorDiv operator.
func (_f *Factory) ConstructFloorDiv(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldDivOne]
	{
		_const, _ := right.(*memo.ConstExpr)
		if _const != nil {
			if _f.funcs.EqualsNumber(_const.Value, 1) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldDivOne) {
					_expr := _f.ConstructCast(
						left,
						_f.funcs.BinaryColType(opt.FloorDivOp, left, right),
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldDivOne, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.FloorDivOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.FloorDivOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.FloorDivOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.FloorDivOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.FloorDivOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeFloorDiv(left, right)
	return _f.onConstructScalar(e)
}

// ConstructMod constructs an expression for the Mod operator.
func (_f *Factory) ConstructMod(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.ModOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.ModOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.ModOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.ModOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.ModOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeMod(left, right)
	return _f.onConstructScalar(e)
}

// ConstructPow constructs an expression for the Pow operator.
func (_f *Factory) ConstructPow(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.PowOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.PowOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.PowOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.PowOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.PowOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizePow(left, right)
	return _f.onConstructScalar(e)
}

// ConstructConcat constructs an expression for the Concat operator.
func (_f *Factory) ConstructConcat(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.ConcatOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.ConcatOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.ConcatOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.ConcatOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.ConcatOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeConcat(left, right)
	return _f.onConstructScalar(e)
}

// ConstructLShift constructs an expression for the LShift operator.
func (_f *Factory) ConstructLShift(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.LShiftOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.LShiftOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.LShiftOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.LShiftOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.LShiftOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeLShift(left, right)
	return _f.onConstructScalar(e)
}

// ConstructRShift constructs an expression for the RShift operator.
func (_f *Factory) ConstructRShift(
	left opt.ScalarExpr,
	right opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullBinaryLeft]
	{
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.RShiftOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.RShiftOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.RShiftOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.RShiftOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.RShiftOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeRShift(left, right)
	return _f.onConstructScalar(e)
}

// ConstructFetchVal constructs an expression for the FetchVal operator.
func (_f *Factory) ConstructFetchVal(
	json opt.ScalarExpr,
	index opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullBinaryLeft]
	{
		left := json
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			right := index
			if !_f.funcs.AllowNullArgs(opt.FetchValOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.FetchValOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		left := json
		right := index
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.FetchValOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.FetchValOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		left := json
		if _f.funcs.IsConstValueOrTuple(left) {
			right := index
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.FetchValOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeFetchVal(json, index)
	return _f.onConstructScalar(e)
}

// ConstructFetchText constructs an expression for the FetchText operator.
func (_f *Factory) ConstructFetchText(
	json opt.ScalarExpr,
	index opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullBinaryLeft]
	{
		left := json
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			right := index
			if !_f.funcs.AllowNullArgs(opt.FetchTextOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.FetchTextOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		left := json
		right := index
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.FetchTextOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.FetchTextOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		left := json
		if _f.funcs.IsConstValueOrTuple(left) {
			right := index
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.FetchTextOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeFetchText(json, index)
	return _f.onConstructScalar(e)
}

// ConstructFetchValPath constructs an expression for the FetchValPath operator.
func (_f *Factory) ConstructFetchValPath(
	json opt.ScalarExpr,
	path opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullBinaryLeft]
	{
		left := json
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			right := path
			if !_f.funcs.AllowNullArgs(opt.FetchValPathOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.FetchValPathOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		left := json
		right := path
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.FetchValPathOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.FetchValPathOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		left := json
		if _f.funcs.IsConstValueOrTuple(left) {
			right := path
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.FetchValPathOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeFetchValPath(json, path)
	return _f.onConstructScalar(e)
}

// ConstructFetchTextPath constructs an expression for the FetchTextPath operator.
func (_f *Factory) ConstructFetchTextPath(
	json opt.ScalarExpr,
	path opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullBinaryLeft]
	{
		left := json
		_null, _ := left.(*memo.NullExpr)
		if _null != nil {
			right := path
			if !_f.funcs.AllowNullArgs(opt.FetchTextPathOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_expr := _f.funcs.FoldNullBinary(opt.FetchTextPathOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		left := json
		right := path
		_null, _ := right.(*memo.NullExpr)
		if _null != nil {
			if !_f.funcs.AllowNullArgs(opt.FetchTextPathOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_expr := _f.funcs.FoldNullBinary(opt.FetchTextPathOp, left, right).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [FoldBinary]
	{
		left := json
		if _f.funcs.IsConstValueOrTuple(left) {
			right := path
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.FetchTextPathOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_expr := result.(opt.ScalarExpr)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, nil, _expr)
						}
						return _expr
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeFetchTextPath(json, path)
	return _f.onConstructScalar(e)
}

// ConstructUnaryMinus constructs an expression for the UnaryMinus operator.
func (_f *Factory) ConstructUnaryMinus(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	// [InvertMinus]
	{
		_minus, _ := input.(*memo.MinusExpr)
		if _minus != nil {
			left := _minus.Left
			right := _minus.Right
			if _f.funcs.CanConstructBinary(opt.MinusOp, right, left) {
				if _f.matchedRule == nil || _f.matchedRule(opt.InvertMinus) {
					_expr := _f.ConstructMinus(
						right,
						left,
					)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.InvertMinus, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	// [EliminateUnaryMinus]
	{
		_unaryMinus, _ := input.(*memo.UnaryMinusExpr)
		if _unaryMinus != nil {
			input := _unaryMinus.Input
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateUnaryMinus) {
				_expr := input
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateUnaryMinus, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullUnary]
	{
		_null, _ := input.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullUnary) {
				_expr := _f.funcs.FoldNullUnary(opt.UnaryMinusOp, input).(opt.ScalarExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullUnary, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldUnary]
	{
		if _f.funcs.IsConstValueOrTuple(input) {
			result := _f.funcs.FoldUnary(opt.UnaryMinusOp, input)
			if _f.funcs.Succeeded(result) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldUnary) {
					_expr := result.(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldUnary, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeUnaryMinus(input)
	return _f.onConstructScalar(e)
}

// ConstructUnaryComplement constructs an expression for the UnaryComplement operator.
func (_f *Factory) ConstructUnaryComplement(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	// [FoldNullUnary]
	{
		_null, _ := input.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullUnary) {
				_expr := _f.funcs.FoldNullUnary(opt.UnaryComplementOp, input).(opt.ScalarExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullUnary, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldUnary]
	{
		if _f.funcs.IsConstValueOrTuple(input) {
			result := _f.funcs.FoldUnary(opt.UnaryComplementOp, input)
			if _f.funcs.Succeeded(result) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldUnary) {
					_expr := result.(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldUnary, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeUnaryComplement(input)
	return _f.onConstructScalar(e)
}

// ConstructCast constructs an expression for the Cast operator.
// Cast converts the input expression into an expression of the target type.
// While the input's type is restricted to the datum types in the types package,
// the target type can be any of the column types in the coltypes package. For
// example, this is a legal cast:
//
//   'hello'::VARCHAR(2)
//
// That expression has the effect of truncating the string to just 'he', since
// the target data type allows a maximum of two characters. This is one example
// of a "lossy" cast.
func (_f *Factory) ConstructCast(
	input opt.ScalarExpr,
	targetTyp coltypes.T,
) opt.ScalarExpr {
	// [EliminateCast]
	{
		if _f.funcs.HasColType(input, targetTyp) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateCast) {
				_expr := input
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateCast, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldNullCast]
	{
		_null, _ := input.(*memo.NullExpr)
		if _null != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullCast) {
				_expr := _f.ConstructNull(
					_f.funcs.ColTypeToDatumType(targetTyp),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullCast, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [FoldCast]
	{
		typ := targetTyp
		if _f.funcs.IsConstValueOrTuple(input) {
			result := _f.funcs.FoldCast(input, typ)
			if _f.funcs.Succeeded(result) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldCast) {
					_expr := result.(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldCast, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeCast(input, targetTyp)
	return _f.onConstructScalar(e)
}

// ConstructIfErr constructs an expression for the IfErr operator.
// IfErr is roughly a runtime try-catch operator. It has different semantics
// depending on which of its fields are set.
//
// If ErrCode is set, only errors which match the given error code will be
// caught. If ErrCode is not set, all errors will be caught.
//
// If OrElse is not set, IfErr evaluates to true or false indicating whether an
// error was caught.  If OrElse is set, IfErr evaluates to Cond if no error was
// caught and to OrElse if an error was caught.
//
// TODO(justin): The implementation here is a hack: ErrCode and OrElse are
// optional, so we repurpose lists as an optional field (since it's not
// valid to use nil). If this comes up again, we might want to consider
// adding an explicit Option type.
func (_f *Factory) ConstructIfErr(
	cond opt.ScalarExpr,
	orElse memo.ScalarListExpr,
	errCode memo.ScalarListExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeIfErr(cond, orElse, errCode)
	return _f.onConstructScalar(e)
}

// ConstructCase constructs an expression for the Case operator.
// Case is a CASE statement of the form:
//
//   CASE [ <Input> ]
//       WHEN <condval1> THEN <expr1>
//     [ WHEN <condval2> THEN <expr2> ] ...
//     [ ELSE <expr> ]
//   END
//
// The Case operator evaluates <Input> (if not provided, Input is set to True),
// then picks the WHEN branch where <condval> is equal to <Input>, then evaluates
// and returns the corresponding THEN expression. If no WHEN branch matches, the
// ELSE expression is evaluated and returned, if any. Otherwise, NULL is
// returned.
//
// Note that the Whens list inside Case is used to represent all the WHEN
// branches as well as the ELSE statement if it exists. It is of the form:
//
//   [(When <condval1> <expr1>),(When <condval2> <expr2>),...,<expr>]
//
func (_f *Factory) ConstructCase(
	input opt.ScalarExpr,
	whens memo.ScalarListExpr,
	orElse opt.ScalarExpr,
) opt.ScalarExpr {
	// [SimplifyCaseWhenConstValue]
	{
		condition := input
		if opt.IsConstValueOp(condition) {
			for i := range whens {
				_item := whens[i]
				_when, _ := _item.(*memo.WhenExpr)
				if _when != nil {
					if opt.IsConstValueOp(_when.Condition) {
						if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyCaseWhenConstValue) {
							_expr := _f.funcs.SimplifyWhens(condition, whens, orElse).(opt.ScalarExpr)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.SimplifyCaseWhenConstValue, nil, _expr)
							}
							return _expr
						}
					}
				}
			}
		}
	}

	e := _f.mem.MemoizeCase(input, whens, orElse)
	return _f.onConstructScalar(e)
}

// ConstructWhen constructs an expression for the When operator.
// When represents a single WHEN ... THEN ... condition inside a CASE statement.
// It is the type of each list item in Whens (except for the last item which is
// a raw expression for the ELSE statement).
func (_f *Factory) ConstructWhen(
	condition opt.ScalarExpr,
	value opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeWhen(condition, value)
	return _f.onConstructScalar(e)
}

// ConstructArray constructs an expression for the Array operator.
// Array is an ARRAY literal of the form ARRAY[<expr1>, <expr2>, ..., <exprN>].
func (_f *Factory) ConstructArray(
	elems memo.ScalarListExpr,
	typ types.T,
) opt.ScalarExpr {
	// [FoldArray]
	{
		if _f.funcs.IsListOfConstants(elems) {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldArray) {
				_expr := _f.funcs.FoldArray(elems, typ).(opt.ScalarExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldArray, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeArray(elems, typ)
	return _f.onConstructScalar(e)
}

// ConstructIndirection constructs an expression for the Indirection operator.
// Indirection is a subscripting expression of the form <expr>[<index>].
// Input must be an Array type and Index must be an int. Multiple indirections
// and slicing are not supported.
func (_f *Factory) ConstructIndirection(
	input opt.ScalarExpr,
	index opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeIndirection(input, index)
	return _f.onConstructScalar(e)
}

// ConstructArrayFlatten constructs an expression for the ArrayFlatten operator.
// ArrayFlatten is an ARRAY(<subquery>) expression. ArrayFlatten takes as input
// a subquery which returns a single column and constructs a scalar array as the
// output. Any NULLs are included in the results, and if the subquery has an
// ORDER BY clause that ordering will be respected by the resulting array.
func (_f *Factory) ConstructArrayFlatten(
	input memo.RelExpr,
	subqueryPrivate *memo.SubqueryPrivate,
) opt.ScalarExpr {
	// [NormalizeArrayFlattenToAgg]
	{
		if _f.funcs.HasOuterCols(input) {
			subquery := subqueryPrivate
			if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeArrayFlattenToAgg) {
				_expr := _f.ConstructCoalesce(
					memo.ScalarListExpr{
						_f.ConstructSubquery(
							_f.ConstructScalarGroupBy(
								input,
								memo.AggregationsExpr{
									{
										Agg: _f.ConstructArrayAgg(
											_f.ConstructVariable(
												_f.funcs.FirstCol(input),
											),
										),
										ColPrivate: *_f.funcs.MakeArrayAggCol(_f.funcs.ArrayType(input)),
									},
								},
								_f.funcs.MakeOrderedGrouping(_f.funcs.MakeEmptyColSet(), _f.funcs.SubqueryOrdering(subquery)),
							),
							_f.funcs.MakeUnorderedSubquery(),
						),
						_f.ConstructArray(
							memo.EmptyScalarListExpr,
							_f.funcs.ArrayType(input),
						),
					},
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.NormalizeArrayFlattenToAgg, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeArrayFlatten(input, subqueryPrivate)
	return _f.onConstructScalar(e)
}

// ConstructFunction constructs an expression for the Function operator.
// Function invokes a builtin SQL function like CONCAT or NOW, passing the given
// arguments. The FunctionPrivate field contains the name of the function as well
// as pointers to its type and properties.
func (_f *Factory) ConstructFunction(
	args memo.ScalarListExpr,
	functionPrivate *memo.FunctionPrivate,
) opt.ScalarExpr {
	// [FoldFunction]
	{
		if _f.funcs.IsListOfConstants(args) {
			private := functionPrivate
			result := _f.funcs.FoldFunction(args, private)
			if _f.funcs.Succeeded(result) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldFunction) {
					_expr := result.(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldFunction, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeFunction(args, functionPrivate)
	return _f.onConstructScalar(e)
}

// ConstructCollate constructs an expression for the Collate operator.
// Collate is an expression of the form
//
//     x COLLATE y
//
// Where x is a "string type" (meaning either a normal string or a collated string),
// and y is a locale. It evaluates to the string collated to the given locale.
func (_f *Factory) ConstructCollate(
	input opt.ScalarExpr,
	locale string,
) opt.ScalarExpr {
	// [FoldCollate]
	{
		_const, _ := input.(*memo.ConstExpr)
		if _const != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldCollate) {
				_expr := _f.funcs.CastToCollatedString(input, locale).(opt.ScalarExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldCollate, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeCollate(input, locale)
	return _f.onConstructScalar(e)
}

// ConstructCoalesce constructs an expression for the Coalesce operator.
func (_f *Factory) ConstructCoalesce(
	args memo.ScalarListExpr,
) opt.ScalarExpr {
	// [EliminateCoalesce]
	{
		if len(args) == 1 {
			item := args[0]
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateCoalesce) {
				_expr := item.(opt.ScalarExpr)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateCoalesce, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [SimplifyCoalesce]
	{
		if len(args) > 0 {
			arg := args[0]
			if _f.funcs.IsConstValueOrTuple(arg) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyCoalesce) {
					_expr := _f.funcs.SimplifyCoalesce(args).(opt.ScalarExpr)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyCoalesce, nil, _expr)
					}
					return _expr
				}
			}
		}
	}

	e := _f.mem.MemoizeCoalesce(args)
	return _f.onConstructScalar(e)
}

// ConstructColumnAccess constructs an expression for the ColumnAccess operator.
// ColumnAccess is a scalar expression that returns a column from the given
// input expression (which is assumed to be of type Tuple). Idx is the ordinal
// index of the column in Input.
func (_f *Factory) ConstructColumnAccess(
	input opt.ScalarExpr,
	idx memo.TupleOrdinal,
) opt.ScalarExpr {
	e := _f.mem.MemoizeColumnAccess(input, idx)
	return _f.onConstructScalar(e)
}

// ConstructUnsupportedExpr constructs an expression for the UnsupportedExpr operator.
// UnsupportedExpr is used for interfacing with the old planner code. It can
// encapsulate a TypedExpr that is otherwise not supported by the optimizer.
func (_f *Factory) ConstructUnsupportedExpr(
	value tree.TypedExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeUnsupportedExpr(value)
	return _f.onConstructScalar(e)
}

// ConstructArrayAgg constructs an expression for the ArrayAgg operator.
func (_f *Factory) ConstructArrayAgg(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeArrayAgg(input)
	return _f.onConstructScalar(e)
}

// ConstructAvg constructs an expression for the Avg operator.
func (_f *Factory) ConstructAvg(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeAvg(input)
	return _f.onConstructScalar(e)
}

// ConstructBoolAnd constructs an expression for the BoolAnd operator.
func (_f *Factory) ConstructBoolAnd(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	// [EliminateAggDistinct]
	{
		_aggDistinct, _ := input.(*memo.AggDistinctExpr)
		if _aggDistinct != nil {
			in := _aggDistinct.Input
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinct) {
				_expr := _f.ConstructBoolAnd(
					in,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinct, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeBoolAnd(input)
	return _f.onConstructScalar(e)
}

// ConstructBoolOr constructs an expression for the BoolOr operator.
func (_f *Factory) ConstructBoolOr(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	// [EliminateAggDistinct]
	{
		_aggDistinct, _ := input.(*memo.AggDistinctExpr)
		if _aggDistinct != nil {
			in := _aggDistinct.Input
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinct) {
				_expr := _f.ConstructBoolOr(
					in,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinct, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeBoolOr(input)
	return _f.onConstructScalar(e)
}

// ConstructConcatAgg constructs an expression for the ConcatAgg operator.
func (_f *Factory) ConstructConcatAgg(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeConcatAgg(input)
	return _f.onConstructScalar(e)
}

// ConstructCount constructs an expression for the Count operator.
func (_f *Factory) ConstructCount(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeCount(input)
	return _f.onConstructScalar(e)
}

// ConstructCountRows constructs an expression for the CountRows operator.
func (_f *Factory) ConstructCountRows() opt.ScalarExpr {
	e := _f.mem.MemoizeCountRows()
	return _f.onConstructScalar(e)
}

// ConstructMax constructs an expression for the Max operator.
func (_f *Factory) ConstructMax(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	// [EliminateAggDistinct]
	{
		_aggDistinct, _ := input.(*memo.AggDistinctExpr)
		if _aggDistinct != nil {
			in := _aggDistinct.Input
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinct) {
				_expr := _f.ConstructMax(
					in,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinct, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeMax(input)
	return _f.onConstructScalar(e)
}

// ConstructMin constructs an expression for the Min operator.
func (_f *Factory) ConstructMin(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	// [EliminateAggDistinct]
	{
		_aggDistinct, _ := input.(*memo.AggDistinctExpr)
		if _aggDistinct != nil {
			in := _aggDistinct.Input
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinct) {
				_expr := _f.ConstructMin(
					in,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinct, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeMin(input)
	return _f.onConstructScalar(e)
}

// ConstructSumInt constructs an expression for the SumInt operator.
func (_f *Factory) ConstructSumInt(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeSumInt(input)
	return _f.onConstructScalar(e)
}

// ConstructSum constructs an expression for the Sum operator.
func (_f *Factory) ConstructSum(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeSum(input)
	return _f.onConstructScalar(e)
}

// ConstructSqrDiff constructs an expression for the SqrDiff operator.
func (_f *Factory) ConstructSqrDiff(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeSqrDiff(input)
	return _f.onConstructScalar(e)
}

// ConstructVariance constructs an expression for the Variance operator.
func (_f *Factory) ConstructVariance(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeVariance(input)
	return _f.onConstructScalar(e)
}

// ConstructStdDev constructs an expression for the StdDev operator.
func (_f *Factory) ConstructStdDev(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeStdDev(input)
	return _f.onConstructScalar(e)
}

// ConstructXorAgg constructs an expression for the XorAgg operator.
func (_f *Factory) ConstructXorAgg(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeXorAgg(input)
	return _f.onConstructScalar(e)
}

// ConstructJsonAgg constructs an expression for the JsonAgg operator.
func (_f *Factory) ConstructJsonAgg(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeJsonAgg(input)
	return _f.onConstructScalar(e)
}

// ConstructJsonbAgg constructs an expression for the JsonbAgg operator.
func (_f *Factory) ConstructJsonbAgg(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeJsonbAgg(input)
	return _f.onConstructScalar(e)
}

// ConstructStringAgg constructs an expression for the StringAgg operator.
func (_f *Factory) ConstructStringAgg(
	input opt.ScalarExpr,
	sep opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeStringAgg(input, sep)
	return _f.onConstructScalar(e)
}

// ConstructConstAgg constructs an expression for the ConstAgg operator.
// ConstAgg is used in the special case when the value of a column is known to be
// constant within a grouping set; it returns that value. If there are no rows
// in the grouping set, then ConstAgg returns NULL.
//
// ConstAgg is not part of SQL, but it's used internally to rewrite correlated
// subqueries into an efficient and convenient form.
func (_f *Factory) ConstructConstAgg(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeConstAgg(input)
	return _f.onConstructScalar(e)
}

// ConstructConstNotNullAgg constructs an expression for the ConstNotNullAgg operator.
// ConstNotNullAgg is used in the special case when the value of a column is
// known to be constant within a grouping set, except on some rows where it can
// have a NULL value; it returns the non-NULL constant value. If there are no
// rows in the grouping set, or all rows have a NULL value, then ConstNotNullAgg
// returns NULL.
//
// ConstNotNullAgg is not part of SQL, but it's used internally to rewrite
// correlated subqueries into an efficient and convenient form.
func (_f *Factory) ConstructConstNotNullAgg(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeConstNotNullAgg(input)
	return _f.onConstructScalar(e)
}

// ConstructAnyNotNullAgg constructs an expression for the AnyNotNullAgg operator.
// AnyNotNullAgg returns any non-NULL value it receives, with no other guarantees.
// If it does not receive any values, it returns NULL.
//
// AnyNotNullAgg is not part of SQL, but it's used internally to rewrite
// correlated subqueries into an efficient and convenient form.
func (_f *Factory) ConstructAnyNotNullAgg(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeAnyNotNullAgg(input)
	return _f.onConstructScalar(e)
}

// ConstructFirstAgg constructs an expression for the FirstAgg operator.
// FirstAgg is used only by DistinctOn; it returns the value on the first row
// according to an ordering; if the ordering is unspecified (or partially
// specified), it is an arbitrary ordering but it must be the same across all
// FirstAggs in a DistinctOn.
func (_f *Factory) ConstructFirstAgg(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeFirstAgg(input)
	return _f.onConstructScalar(e)
}

// ConstructAggDistinct constructs an expression for the AggDistinct operator.
// AggDistinct is used as a modifier that wraps the input of an aggregate
// function. It causes the respective aggregation to only process each distinct
// value once.
func (_f *Factory) ConstructAggDistinct(
	input opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeAggDistinct(input)
	return _f.onConstructScalar(e)
}

// ConstructAggFilter constructs an expression for the AggFilter operator.
// AggFilter is used as a modifier that wraps the input of an aggregate
// function. It causes only rows for which the filter expression is true
// to be processed. AggFilter should always occur on top of AggDistinct
// if they are both present.
func (_f *Factory) ConstructAggFilter(
	input opt.ScalarExpr,
	filter opt.ScalarExpr,
) opt.ScalarExpr {
	e := _f.mem.MemoizeAggFilter(input, filter)
	return _f.onConstructScalar(e)
}

// ConstructInsert constructs an expression for the Insert operator.
// Insert evaluates a relational input expression, and inserts values from it
// into a target table. The input may be an arbitrarily complex expression:
//
//   INSERT INTO ab SELECT x, y+1 FROM xy ORDER BY y
//
// It can also be a simple VALUES clause:
//
//   INSERT INTO ab VALUES (1, 2)
//
// It may also return rows, which can be further composed:
//
//   SELECT a + b FROM [INSERT INTO ab VALUES (1, 2) RETURNING a, b]
//
// The Insert operator is capable of inserting values into computed columns and
// mutation columns, which are not writable (or even visible in the case of
// mutation columns) by SQL users.
func (_f *Factory) ConstructInsert(
	input memo.RelExpr,
	mutationPrivate *memo.MutationPrivate,
) memo.RelExpr {
	// [PruneMutationInputCols]
	{
		needed := _f.funcs.NeededMutationCols(mutationPrivate)
		if _f.funcs.CanPruneCols(input, needed) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneMutationInputCols) {
				_expr := _f.ConstructInsert(
					_f.funcs.PruneCols(input, needed),
					mutationPrivate,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneMutationInputCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeInsert(input, mutationPrivate)
	return _f.onConstructRelational(e)
}

// ConstructUpdate constructs an expression for the Update operator.
// Update evaluates a relational input expression that fetches existing rows from
// a target table and computes new values for one or more columns. Arbitrary
// subsets of rows can be selected from the target table and processed in order,
// as with this example:
//
//   UPDATE abc SET b=10 WHERE a>0 ORDER BY b+c LIMIT 10
//
// The Update operator will also update any computed columns, including mutation
// columns that are computed.
func (_f *Factory) ConstructUpdate(
	input memo.RelExpr,
	mutationPrivate *memo.MutationPrivate,
) memo.RelExpr {
	// [PruneMutationFetchCols]
	{
		needed := _f.funcs.NeededMutationFetchCols(opt.UpdateOp, mutationPrivate)
		if _f.funcs.CanPruneMutationFetchCols(mutationPrivate, needed) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneMutationFetchCols) {
				_expr := _f.ConstructUpdate(
					input,
					_f.funcs.PruneMutationFetchCols(mutationPrivate, needed),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneMutationFetchCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [PruneMutationInputCols]
	{
		needed := _f.funcs.NeededMutationCols(mutationPrivate)
		if _f.funcs.CanPruneCols(input, needed) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneMutationInputCols) {
				_expr := _f.ConstructUpdate(
					_f.funcs.PruneCols(input, needed),
					mutationPrivate,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneMutationInputCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeUpdate(input, mutationPrivate)
	return _f.onConstructRelational(e)
}

// ConstructUpsert constructs an expression for the Upsert operator.
// Upsert evaluates a relational input expression that tries to insert a new row
// into a target table. If a conflicting row already exists, then Upsert will
// instead update the existing row. The Upsert operator is used for all of these
// syntactic variants:
//
//   INSERT..ON CONFLICT DO UPDATE
//     INSERT INTO abc VALUES (1, 2, 3) ON CONFLICT (a) DO UPDATE SET b=10
//
//   INSERT..ON CONFLICT DO NOTHING
//     INSERT INTO abc VALUES (1, 2, 3) ON CONFLICT DO NOTHING
//
//   UPSERT
//     UPSERT INTO abc VALUES (1, 2, 3)
//
// The Update operator will also insert/update any computed columns, including
// mutation columns that are computed.
func (_f *Factory) ConstructUpsert(
	input memo.RelExpr,
	mutationPrivate *memo.MutationPrivate,
) memo.RelExpr {
	// [PruneMutationFetchCols]
	{
		needed := _f.funcs.NeededMutationFetchCols(opt.UpsertOp, mutationPrivate)
		if _f.funcs.CanPruneMutationFetchCols(mutationPrivate, needed) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneMutationFetchCols) {
				_expr := _f.ConstructUpsert(
					input,
					_f.funcs.PruneMutationFetchCols(mutationPrivate, needed),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneMutationFetchCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [PruneMutationInputCols]
	{
		needed := _f.funcs.NeededMutationCols(mutationPrivate)
		if _f.funcs.CanPruneCols(input, needed) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneMutationInputCols) {
				_expr := _f.ConstructUpsert(
					_f.funcs.PruneCols(input, needed),
					mutationPrivate,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneMutationInputCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeUpsert(input, mutationPrivate)
	return _f.onConstructRelational(e)
}

// ConstructDelete constructs an expression for the Delete operator.
// Delete is an operator used to delete all rows that are selected by a
// relational input expression:
//
//   DELETE FROM abc WHERE a>0 ORDER BY b LIMIT 10
//
func (_f *Factory) ConstructDelete(
	input memo.RelExpr,
	mutationPrivate *memo.MutationPrivate,
) memo.RelExpr {
	// [PruneMutationFetchCols]
	{
		needed := _f.funcs.NeededMutationFetchCols(opt.DeleteOp, mutationPrivate)
		if _f.funcs.CanPruneMutationFetchCols(mutationPrivate, needed) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneMutationFetchCols) {
				_expr := _f.ConstructDelete(
					input,
					_f.funcs.PruneMutationFetchCols(mutationPrivate, needed),
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneMutationFetchCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	// [PruneMutationInputCols]
	{
		needed := _f.funcs.NeededMutationCols(mutationPrivate)
		if _f.funcs.CanPruneCols(input, needed) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneMutationInputCols) {
				_expr := _f.ConstructDelete(
					_f.funcs.PruneCols(input, needed),
					mutationPrivate,
				)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneMutationInputCols, nil, _expr)
				}
				return _expr
			}
		}
	}

	e := _f.mem.MemoizeDelete(input, mutationPrivate)
	return _f.onConstructRelational(e)
}

// ConstructCreateTable constructs an expression for the CreateTable operator.
// CreateTable represents a CREATE TABLE statement.
func (_f *Factory) ConstructCreateTable(
	input memo.RelExpr,
	createTablePrivate *memo.CreateTablePrivate,
) memo.RelExpr {
	e := _f.mem.MemoizeCreateTable(input, createTablePrivate)
	return _f.onConstructRelational(e)
}

// Replace enables an expression subtree to be rewritten under the control of
// the caller. It passes each child of the given expression to the replace
// callback. The caller can continue traversing the expression tree within the
// callback by recursively calling Replace. It can also return a replacement
// expression; if it does, then Replace will rebuild the operator and its
// ancestors via a calls to the corresponding factory Construct methods. Here
// is example usage:
//
//   var replace func(e opt.Expr, replace ReplaceFunc) opt.Expr
//   replace = func(e opt.Expr, replace ReplaceFunc) opt.Expr {
//     if e.Op() == opt.VariableOp {
//       return getReplaceVar(e)
//     }
//     return e.Replace(e, replace)
//   }
//   replace(root, replace)
//
// Here, all variables in the tree are being replaced by some other expression
// in a pre-order traversal of the tree. Post-order traversal is trivially
// achieved by moving the e.Replace call to the top of the replace function
// rather than bottom.
func (f *Factory) Replace(e opt.Expr, replace ReplaceFunc) opt.Expr {
	switch t := e.(type) {
	case *memo.ScanExpr:
		return t

	case *memo.VirtualScanExpr:
		return t

	case *memo.SequenceSelectExpr:
		return t

	case *memo.ValuesExpr:
		rows, rowsChanged := f.replaceScalarListExpr(t.Rows, replace)
		if rowsChanged {
			return f.ConstructValues(rows, &t.ValuesPrivate)
		}
		return t

	case *memo.SelectExpr:
		input := replace(t.Input).(memo.RelExpr)
		filters, filtersChanged := f.replaceFiltersExpr(t.Filters, replace)
		if input != t.Input || filtersChanged {
			return f.ConstructSelect(input, filters)
		}
		return t

	case *memo.ProjectExpr:
		input := replace(t.Input).(memo.RelExpr)
		projections, projectionsChanged := f.replaceProjectionsExpr(t.Projections, replace)
		if input != t.Input || projectionsChanged {
			return f.ConstructProject(input, projections, t.Passthrough)
		}
		return t

	case *memo.InnerJoinExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructInnerJoin(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.LeftJoinExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructLeftJoin(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.RightJoinExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructRightJoin(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.FullJoinExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructFullJoin(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.SemiJoinExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructSemiJoin(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.AntiJoinExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructAntiJoin(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.IndexJoinExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructIndexJoin(input, &t.IndexJoinPrivate)
		}
		return t

	case *memo.LookupJoinExpr:
		input := replace(t.Input).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if input != t.Input || onChanged {
			return f.ConstructLookupJoin(input, on, &t.LookupJoinPrivate)
		}
		return t

	case *memo.MergeJoinExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructMergeJoin(left, right, on, &t.MergeJoinPrivate)
		}
		return t

	case *memo.ZigzagJoinExpr:
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if onChanged {
			return f.ConstructZigzagJoin(on, &t.ZigzagJoinPrivate)
		}
		return t

	case *memo.InnerJoinApplyExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructInnerJoinApply(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.LeftJoinApplyExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructLeftJoinApply(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.RightJoinApplyExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructRightJoinApply(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.FullJoinApplyExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructFullJoinApply(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.SemiJoinApplyExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructSemiJoinApply(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.AntiJoinApplyExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		on, onChanged := f.replaceFiltersExpr(t.On, replace)
		if left != t.Left || right != t.Right || onChanged {
			return f.ConstructAntiJoinApply(left, right, on, &t.JoinPrivate)
		}
		return t

	case *memo.GroupByExpr:
		input := replace(t.Input).(memo.RelExpr)
		aggregations, aggregationsChanged := f.replaceAggregationsExpr(t.Aggregations, replace)
		if input != t.Input || aggregationsChanged {
			return f.ConstructGroupBy(input, aggregations, &t.GroupingPrivate)
		}
		return t

	case *memo.ScalarGroupByExpr:
		input := replace(t.Input).(memo.RelExpr)
		aggregations, aggregationsChanged := f.replaceAggregationsExpr(t.Aggregations, replace)
		if input != t.Input || aggregationsChanged {
			return f.ConstructScalarGroupBy(input, aggregations, &t.GroupingPrivate)
		}
		return t

	case *memo.DistinctOnExpr:
		input := replace(t.Input).(memo.RelExpr)
		aggregations, aggregationsChanged := f.replaceAggregationsExpr(t.Aggregations, replace)
		if input != t.Input || aggregationsChanged {
			return f.ConstructDistinctOn(input, aggregations, &t.GroupingPrivate)
		}
		return t

	case *memo.UnionExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructUnion(left, right, &t.SetPrivate)
		}
		return t

	case *memo.IntersectExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructIntersect(left, right, &t.SetPrivate)
		}
		return t

	case *memo.ExceptExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructExcept(left, right, &t.SetPrivate)
		}
		return t

	case *memo.UnionAllExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructUnionAll(left, right, &t.SetPrivate)
		}
		return t

	case *memo.IntersectAllExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructIntersectAll(left, right, &t.SetPrivate)
		}
		return t

	case *memo.ExceptAllExpr:
		left := replace(t.Left).(memo.RelExpr)
		right := replace(t.Right).(memo.RelExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructExceptAll(left, right, &t.SetPrivate)
		}
		return t

	case *memo.LimitExpr:
		input := replace(t.Input).(memo.RelExpr)
		limit := replace(t.Limit).(opt.ScalarExpr)
		if input != t.Input || limit != t.Limit {
			return f.ConstructLimit(input, limit, t.Ordering)
		}
		return t

	case *memo.OffsetExpr:
		input := replace(t.Input).(memo.RelExpr)
		offset := replace(t.Offset).(opt.ScalarExpr)
		if input != t.Input || offset != t.Offset {
			return f.ConstructOffset(input, offset, t.Ordering)
		}
		return t

	case *memo.Max1RowExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructMax1Row(input)
		}
		return t

	case *memo.ExplainExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructExplain(input, &t.ExplainPrivate)
		}
		return t

	case *memo.ShowTraceForSessionExpr:
		return t

	case *memo.RowNumberExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructRowNumber(input, &t.RowNumberPrivate)
		}
		return t

	case *memo.ProjectSetExpr:
		input := replace(t.Input).(memo.RelExpr)
		zip, zipChanged := f.replaceZipExpr(t.Zip, replace)
		if input != t.Input || zipChanged {
			return f.ConstructProjectSet(input, zip)
		}
		return t

	case *memo.SubqueryExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructSubquery(input, &t.SubqueryPrivate)
		}
		return t

	case *memo.AnyExpr:
		input := replace(t.Input).(memo.RelExpr)
		scalar := replace(t.Scalar).(opt.ScalarExpr)
		if input != t.Input || scalar != t.Scalar {
			return f.ConstructAny(input, scalar, &t.SubqueryPrivate)
		}
		return t

	case *memo.ExistsExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructExists(input, &t.SubqueryPrivate)
		}
		return t

	case *memo.VariableExpr:
		return t

	case *memo.ConstExpr:
		return t

	case *memo.NullExpr:
		return t

	case *memo.TrueExpr:
		return t

	case *memo.FalseExpr:
		return t

	case *memo.PlaceholderExpr:
		return t

	case *memo.TupleExpr:
		elems, elemsChanged := f.replaceScalarListExpr(t.Elems, replace)
		if elemsChanged {
			return f.ConstructTuple(elems, t.Typ)
		}
		return t

	case *memo.ProjectionsExpr:
		if after, changed := f.replaceProjectionsExpr(*t, replace); changed {
			return &after
		}
		return t

	case *memo.AggregationsExpr:
		if after, changed := f.replaceAggregationsExpr(*t, replace); changed {
			return &after
		}
		return t

	case *memo.FiltersExpr:
		if after, changed := f.replaceFiltersExpr(*t, replace); changed {
			return &after
		}
		return t

	case *memo.ZipExpr:
		if after, changed := f.replaceZipExpr(*t, replace); changed {
			return &after
		}
		return t

	case *memo.AndExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructAnd(left, right)
		}
		return t

	case *memo.OrExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructOr(left, right)
		}
		return t

	case *memo.RangeExpr:
		and := replace(t.And).(opt.ScalarExpr)
		if and != t.And {
			return f.ConstructRange(and)
		}
		return t

	case *memo.NotExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructNot(input)
		}
		return t

	case *memo.EqExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructEq(left, right)
		}
		return t

	case *memo.LtExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructLt(left, right)
		}
		return t

	case *memo.GtExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructGt(left, right)
		}
		return t

	case *memo.LeExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructLe(left, right)
		}
		return t

	case *memo.GeExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructGe(left, right)
		}
		return t

	case *memo.NeExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructNe(left, right)
		}
		return t

	case *memo.InExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructIn(left, right)
		}
		return t

	case *memo.NotInExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructNotIn(left, right)
		}
		return t

	case *memo.LikeExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructLike(left, right)
		}
		return t

	case *memo.NotLikeExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructNotLike(left, right)
		}
		return t

	case *memo.ILikeExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructILike(left, right)
		}
		return t

	case *memo.NotILikeExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructNotILike(left, right)
		}
		return t

	case *memo.SimilarToExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructSimilarTo(left, right)
		}
		return t

	case *memo.NotSimilarToExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructNotSimilarTo(left, right)
		}
		return t

	case *memo.RegMatchExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructRegMatch(left, right)
		}
		return t

	case *memo.NotRegMatchExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructNotRegMatch(left, right)
		}
		return t

	case *memo.RegIMatchExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructRegIMatch(left, right)
		}
		return t

	case *memo.NotRegIMatchExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructNotRegIMatch(left, right)
		}
		return t

	case *memo.IsExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructIs(left, right)
		}
		return t

	case *memo.IsNotExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructIsNot(left, right)
		}
		return t

	case *memo.ContainsExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructContains(left, right)
		}
		return t

	case *memo.JsonExistsExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructJsonExists(left, right)
		}
		return t

	case *memo.JsonAllExistsExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructJsonAllExists(left, right)
		}
		return t

	case *memo.JsonSomeExistsExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructJsonSomeExists(left, right)
		}
		return t

	case *memo.AnyScalarExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructAnyScalar(left, right, t.Cmp)
		}
		return t

	case *memo.BitandExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructBitand(left, right)
		}
		return t

	case *memo.BitorExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructBitor(left, right)
		}
		return t

	case *memo.BitxorExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructBitxor(left, right)
		}
		return t

	case *memo.PlusExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructPlus(left, right)
		}
		return t

	case *memo.MinusExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructMinus(left, right)
		}
		return t

	case *memo.MultExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructMult(left, right)
		}
		return t

	case *memo.DivExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructDiv(left, right)
		}
		return t

	case *memo.FloorDivExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructFloorDiv(left, right)
		}
		return t

	case *memo.ModExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructMod(left, right)
		}
		return t

	case *memo.PowExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructPow(left, right)
		}
		return t

	case *memo.ConcatExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructConcat(left, right)
		}
		return t

	case *memo.LShiftExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructLShift(left, right)
		}
		return t

	case *memo.RShiftExpr:
		left := replace(t.Left).(opt.ScalarExpr)
		right := replace(t.Right).(opt.ScalarExpr)
		if left != t.Left || right != t.Right {
			return f.ConstructRShift(left, right)
		}
		return t

	case *memo.FetchValExpr:
		json := replace(t.Json).(opt.ScalarExpr)
		index := replace(t.Index).(opt.ScalarExpr)
		if json != t.Json || index != t.Index {
			return f.ConstructFetchVal(json, index)
		}
		return t

	case *memo.FetchTextExpr:
		json := replace(t.Json).(opt.ScalarExpr)
		index := replace(t.Index).(opt.ScalarExpr)
		if json != t.Json || index != t.Index {
			return f.ConstructFetchText(json, index)
		}
		return t

	case *memo.FetchValPathExpr:
		json := replace(t.Json).(opt.ScalarExpr)
		path := replace(t.Path).(opt.ScalarExpr)
		if json != t.Json || path != t.Path {
			return f.ConstructFetchValPath(json, path)
		}
		return t

	case *memo.FetchTextPathExpr:
		json := replace(t.Json).(opt.ScalarExpr)
		path := replace(t.Path).(opt.ScalarExpr)
		if json != t.Json || path != t.Path {
			return f.ConstructFetchTextPath(json, path)
		}
		return t

	case *memo.UnaryMinusExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructUnaryMinus(input)
		}
		return t

	case *memo.UnaryComplementExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructUnaryComplement(input)
		}
		return t

	case *memo.CastExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructCast(input, t.TargetTyp)
		}
		return t

	case *memo.IfErrExpr:
		cond := replace(t.Cond).(opt.ScalarExpr)
		orElse, orElseChanged := f.replaceScalarListExpr(t.OrElse, replace)
		errCode, errCodeChanged := f.replaceScalarListExpr(t.ErrCode, replace)
		if cond != t.Cond || orElseChanged || errCodeChanged {
			return f.ConstructIfErr(cond, orElse, errCode)
		}
		return t

	case *memo.CaseExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		whens, whensChanged := f.replaceScalarListExpr(t.Whens, replace)
		orElse := replace(t.OrElse).(opt.ScalarExpr)
		if input != t.Input || whensChanged || orElse != t.OrElse {
			return f.ConstructCase(input, whens, orElse)
		}
		return t

	case *memo.WhenExpr:
		condition := replace(t.Condition).(opt.ScalarExpr)
		value := replace(t.Value).(opt.ScalarExpr)
		if condition != t.Condition || value != t.Value {
			return f.ConstructWhen(condition, value)
		}
		return t

	case *memo.ArrayExpr:
		elems, elemsChanged := f.replaceScalarListExpr(t.Elems, replace)
		if elemsChanged {
			return f.ConstructArray(elems, t.Typ)
		}
		return t

	case *memo.IndirectionExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		index := replace(t.Index).(opt.ScalarExpr)
		if input != t.Input || index != t.Index {
			return f.ConstructIndirection(input, index)
		}
		return t

	case *memo.ArrayFlattenExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructArrayFlatten(input, &t.SubqueryPrivate)
		}
		return t

	case *memo.FunctionExpr:
		args, argsChanged := f.replaceScalarListExpr(t.Args, replace)
		if argsChanged {
			return f.ConstructFunction(args, &t.FunctionPrivate)
		}
		return t

	case *memo.CollateExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructCollate(input, t.Locale)
		}
		return t

	case *memo.CoalesceExpr:
		args, argsChanged := f.replaceScalarListExpr(t.Args, replace)
		if argsChanged {
			return f.ConstructCoalesce(args)
		}
		return t

	case *memo.ColumnAccessExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructColumnAccess(input, t.Idx)
		}
		return t

	case *memo.UnsupportedExprExpr:
		return t

	case *memo.ArrayAggExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructArrayAgg(input)
		}
		return t

	case *memo.AvgExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructAvg(input)
		}
		return t

	case *memo.BoolAndExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructBoolAnd(input)
		}
		return t

	case *memo.BoolOrExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructBoolOr(input)
		}
		return t

	case *memo.ConcatAggExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructConcatAgg(input)
		}
		return t

	case *memo.CountExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructCount(input)
		}
		return t

	case *memo.CountRowsExpr:
		return t

	case *memo.MaxExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructMax(input)
		}
		return t

	case *memo.MinExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructMin(input)
		}
		return t

	case *memo.SumIntExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructSumInt(input)
		}
		return t

	case *memo.SumExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructSum(input)
		}
		return t

	case *memo.SqrDiffExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructSqrDiff(input)
		}
		return t

	case *memo.VarianceExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructVariance(input)
		}
		return t

	case *memo.StdDevExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructStdDev(input)
		}
		return t

	case *memo.XorAggExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructXorAgg(input)
		}
		return t

	case *memo.JsonAggExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructJsonAgg(input)
		}
		return t

	case *memo.JsonbAggExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructJsonbAgg(input)
		}
		return t

	case *memo.StringAggExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		sep := replace(t.Sep).(opt.ScalarExpr)
		if input != t.Input || sep != t.Sep {
			return f.ConstructStringAgg(input, sep)
		}
		return t

	case *memo.ConstAggExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructConstAgg(input)
		}
		return t

	case *memo.ConstNotNullAggExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructConstNotNullAgg(input)
		}
		return t

	case *memo.AnyNotNullAggExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructAnyNotNullAgg(input)
		}
		return t

	case *memo.FirstAggExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructFirstAgg(input)
		}
		return t

	case *memo.AggDistinctExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		if input != t.Input {
			return f.ConstructAggDistinct(input)
		}
		return t

	case *memo.AggFilterExpr:
		input := replace(t.Input).(opt.ScalarExpr)
		filter := replace(t.Filter).(opt.ScalarExpr)
		if input != t.Input || filter != t.Filter {
			return f.ConstructAggFilter(input, filter)
		}
		return t

	case *memo.ScalarListExpr:
		if after, changed := f.replaceScalarListExpr(*t, replace); changed {
			return &after
		}
		return t

	case *memo.InsertExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructInsert(input, &t.MutationPrivate)
		}
		return t

	case *memo.UpdateExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructUpdate(input, &t.MutationPrivate)
		}
		return t

	case *memo.UpsertExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructUpsert(input, &t.MutationPrivate)
		}
		return t

	case *memo.DeleteExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructDelete(input, &t.MutationPrivate)
		}
		return t

	case *memo.CreateTableExpr:
		input := replace(t.Input).(memo.RelExpr)
		if input != t.Input {
			return f.ConstructCreateTable(input, &t.CreateTablePrivate)
		}
		return t

	}
	panic(pgerror.NewAssertionErrorf("unhandled op %s", log.Safe(e.Op())))
}

func (f *Factory) replaceProjectionsExpr(list memo.ProjectionsExpr, replace ReplaceFunc) (_ memo.ProjectionsExpr, changed bool) {
	var newList []memo.ProjectionsItem
	for i := range list {
		before := list[i].Element
		after := replace(before).(opt.ScalarExpr)
		if before != after {
			if newList == nil {
				newList = make([]memo.ProjectionsItem, len(list))
				copy(newList, list[:i])
			}
			newList[i].Element = after
			newList[i].Col = list[i].Col
		} else if newList != nil {
			newList[i] = list[i]
		}
	}
	if newList == nil {
		return list, false
	}
	return newList, true
}

func (f *Factory) replaceAggregationsExpr(list memo.AggregationsExpr, replace ReplaceFunc) (_ memo.AggregationsExpr, changed bool) {
	var newList []memo.AggregationsItem
	for i := range list {
		before := list[i].Agg
		after := replace(before).(opt.ScalarExpr)
		if before != after {
			if newList == nil {
				newList = make([]memo.AggregationsItem, len(list))
				copy(newList, list[:i])
			}
			newList[i].Agg = after
			newList[i].Col = list[i].Col
		} else if newList != nil {
			newList[i] = list[i]
		}
	}
	if newList == nil {
		return list, false
	}
	return newList, true
}

func (f *Factory) replaceFiltersExpr(list memo.FiltersExpr, replace ReplaceFunc) (_ memo.FiltersExpr, changed bool) {
	var newList []memo.FiltersItem
	for i := range list {
		before := list[i].Condition
		after := replace(before).(opt.ScalarExpr)
		if before != after {
			if newList == nil {
				newList = make([]memo.FiltersItem, len(list))
				copy(newList, list[:i])
			}
			newList[i].Condition = after
		} else if newList != nil {
			newList[i] = list[i]
		}
	}
	if newList == nil {
		return list, false
	}
	return newList, true
}

func (f *Factory) replaceZipExpr(list memo.ZipExpr, replace ReplaceFunc) (_ memo.ZipExpr, changed bool) {
	var newList []memo.ZipItem
	for i := range list {
		before := list[i].Func
		after := replace(before).(opt.ScalarExpr)
		if before != after {
			if newList == nil {
				newList = make([]memo.ZipItem, len(list))
				copy(newList, list[:i])
			}
			newList[i].Func = after
			newList[i].Cols = list[i].Cols
		} else if newList != nil {
			newList[i] = list[i]
		}
	}
	if newList == nil {
		return list, false
	}
	return newList, true
}

func (f *Factory) replaceScalarListExpr(list memo.ScalarListExpr, replace ReplaceFunc) (_ memo.ScalarListExpr, changed bool) {
	var newList []opt.ScalarExpr
	for i := range list {
		before := list[i]
		after := replace(before).(opt.ScalarExpr)
		if before != after {
			if newList == nil {
				newList = make([]opt.ScalarExpr, len(list))
				copy(newList, list[:i])
			}
			newList[i] = after
		} else if newList != nil {
			newList[i] = list[i]
		}
	}
	if newList == nil {
		return list, false
	}
	return newList, true
}

// CopyAndReplaceDefault performs the default traversal and cloning behavior
// for the CopyAndReplace method. It constructs a copy of the given source
// operator using children copied (and potentially remapped) by the given replace
// function. See comments for CopyAndReplace for more details.
func (f *Factory) CopyAndReplaceDefault(src opt.Expr, replace ReplaceFunc) (dst opt.Expr) {
	switch t := src.(type) {
	case *memo.ScanExpr:
		return f.mem.MemoizeScan(&t.ScanPrivate)

	case *memo.VirtualScanExpr:
		return f.mem.MemoizeVirtualScan(&t.VirtualScanPrivate)

	case *memo.SequenceSelectExpr:
		return f.mem.MemoizeSequenceSelect(&t.SequenceSelectPrivate)

	case *memo.ValuesExpr:
		return f.ConstructValues(
			f.copyAndReplaceDefaultScalarListExpr(t.Rows, replace),
			&t.ValuesPrivate,
		)

	case *memo.SelectExpr:
		return f.ConstructSelect(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.Filters, replace),
		)

	case *memo.ProjectExpr:
		return f.ConstructProject(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultProjectionsExpr(t.Projections, replace),
			t.Passthrough,
		)

	case *memo.InnerJoinExpr:
		return f.ConstructInnerJoin(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.LeftJoinExpr:
		return f.ConstructLeftJoin(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.RightJoinExpr:
		return f.ConstructRightJoin(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.FullJoinExpr:
		return f.ConstructFullJoin(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.SemiJoinExpr:
		return f.ConstructSemiJoin(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.AntiJoinExpr:
		return f.ConstructAntiJoin(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.IndexJoinExpr:
		return f.ConstructIndexJoin(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.IndexJoinPrivate,
		)

	case *memo.LookupJoinExpr:
		return f.ConstructLookupJoin(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.LookupJoinPrivate,
		)

	case *memo.MergeJoinExpr:
		return f.ConstructMergeJoin(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.MergeJoinPrivate,
		)

	case *memo.ZigzagJoinExpr:
		return f.ConstructZigzagJoin(
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.ZigzagJoinPrivate,
		)

	case *memo.InnerJoinApplyExpr:
		return f.ConstructInnerJoinApply(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.LeftJoinApplyExpr:
		return f.ConstructLeftJoinApply(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.RightJoinApplyExpr:
		return f.ConstructRightJoinApply(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.FullJoinApplyExpr:
		return f.ConstructFullJoinApply(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.SemiJoinApplyExpr:
		return f.ConstructSemiJoinApply(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.AntiJoinApplyExpr:
		return f.ConstructAntiJoinApply(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultFiltersExpr(t.On, replace),
			&t.JoinPrivate,
		)

	case *memo.GroupByExpr:
		return f.ConstructGroupBy(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultAggregationsExpr(t.Aggregations, replace),
			&t.GroupingPrivate,
		)

	case *memo.ScalarGroupByExpr:
		return f.ConstructScalarGroupBy(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultAggregationsExpr(t.Aggregations, replace),
			&t.GroupingPrivate,
		)

	case *memo.DistinctOnExpr:
		return f.ConstructDistinctOn(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultAggregationsExpr(t.Aggregations, replace),
			&t.GroupingPrivate,
		)

	case *memo.UnionExpr:
		return f.ConstructUnion(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			&t.SetPrivate,
		)

	case *memo.IntersectExpr:
		return f.ConstructIntersect(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			&t.SetPrivate,
		)

	case *memo.ExceptExpr:
		return f.ConstructExcept(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			&t.SetPrivate,
		)

	case *memo.UnionAllExpr:
		return f.ConstructUnionAll(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			&t.SetPrivate,
		)

	case *memo.IntersectAllExpr:
		return f.ConstructIntersectAll(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			&t.SetPrivate,
		)

	case *memo.ExceptAllExpr:
		return f.ConstructExceptAll(
			f.invokeReplace(t.Left, replace).(memo.RelExpr),
			f.invokeReplace(t.Right, replace).(memo.RelExpr),
			&t.SetPrivate,
		)

	case *memo.LimitExpr:
		return f.ConstructLimit(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			f.invokeReplace(t.Limit, replace).(opt.ScalarExpr),
			t.Ordering,
		)

	case *memo.OffsetExpr:
		return f.ConstructOffset(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			f.invokeReplace(t.Offset, replace).(opt.ScalarExpr),
			t.Ordering,
		)

	case *memo.Max1RowExpr:
		return f.ConstructMax1Row(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
		)

	case *memo.ExplainExpr:
		return f.ConstructExplain(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.ExplainPrivate,
		)

	case *memo.ShowTraceForSessionExpr:
		return f.mem.MemoizeShowTraceForSession(&t.ShowTracePrivate)

	case *memo.RowNumberExpr:
		return f.ConstructRowNumber(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.RowNumberPrivate,
		)

	case *memo.ProjectSetExpr:
		return f.ConstructProjectSet(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			f.copyAndReplaceDefaultZipExpr(t.Zip, replace),
		)

	case *memo.SubqueryExpr:
		return f.ConstructSubquery(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.SubqueryPrivate,
		)

	case *memo.AnyExpr:
		return f.ConstructAny(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			f.invokeReplace(t.Scalar, replace).(opt.ScalarExpr),
			&t.SubqueryPrivate,
		)

	case *memo.ExistsExpr:
		return f.ConstructExists(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.SubqueryPrivate,
		)

	case *memo.VariableExpr:
		return t

	case *memo.ConstExpr:
		return t

	case *memo.NullExpr:
		return t

	case *memo.TrueExpr:
		return t

	case *memo.FalseExpr:
		return t

	case *memo.PlaceholderExpr:
		return t

	case *memo.TupleExpr:
		return f.ConstructTuple(
			f.copyAndReplaceDefaultScalarListExpr(t.Elems, replace),
			t.Typ,
		)

	case *memo.AndExpr:
		return f.ConstructAnd(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.OrExpr:
		return f.ConstructOr(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.RangeExpr:
		return f.ConstructRange(
			f.invokeReplace(t.And, replace).(opt.ScalarExpr),
		)

	case *memo.NotExpr:
		return f.ConstructNot(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.EqExpr:
		return f.ConstructEq(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.LtExpr:
		return f.ConstructLt(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.GtExpr:
		return f.ConstructGt(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.LeExpr:
		return f.ConstructLe(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.GeExpr:
		return f.ConstructGe(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.NeExpr:
		return f.ConstructNe(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.InExpr:
		return f.ConstructIn(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.NotInExpr:
		return f.ConstructNotIn(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.LikeExpr:
		return f.ConstructLike(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.NotLikeExpr:
		return f.ConstructNotLike(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.ILikeExpr:
		return f.ConstructILike(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.NotILikeExpr:
		return f.ConstructNotILike(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.SimilarToExpr:
		return f.ConstructSimilarTo(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.NotSimilarToExpr:
		return f.ConstructNotSimilarTo(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.RegMatchExpr:
		return f.ConstructRegMatch(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.NotRegMatchExpr:
		return f.ConstructNotRegMatch(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.RegIMatchExpr:
		return f.ConstructRegIMatch(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.NotRegIMatchExpr:
		return f.ConstructNotRegIMatch(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.IsExpr:
		return f.ConstructIs(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.IsNotExpr:
		return f.ConstructIsNot(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.ContainsExpr:
		return f.ConstructContains(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.JsonExistsExpr:
		return f.ConstructJsonExists(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.JsonAllExistsExpr:
		return f.ConstructJsonAllExists(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.JsonSomeExistsExpr:
		return f.ConstructJsonSomeExists(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.AnyScalarExpr:
		return f.ConstructAnyScalar(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
			t.Cmp,
		)

	case *memo.BitandExpr:
		return f.ConstructBitand(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.BitorExpr:
		return f.ConstructBitor(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.BitxorExpr:
		return f.ConstructBitxor(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.PlusExpr:
		return f.ConstructPlus(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.MinusExpr:
		return f.ConstructMinus(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.MultExpr:
		return f.ConstructMult(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.DivExpr:
		return f.ConstructDiv(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.FloorDivExpr:
		return f.ConstructFloorDiv(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.ModExpr:
		return f.ConstructMod(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.PowExpr:
		return f.ConstructPow(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.ConcatExpr:
		return f.ConstructConcat(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.LShiftExpr:
		return f.ConstructLShift(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.RShiftExpr:
		return f.ConstructRShift(
			f.invokeReplace(t.Left, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Right, replace).(opt.ScalarExpr),
		)

	case *memo.FetchValExpr:
		return f.ConstructFetchVal(
			f.invokeReplace(t.Json, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Index, replace).(opt.ScalarExpr),
		)

	case *memo.FetchTextExpr:
		return f.ConstructFetchText(
			f.invokeReplace(t.Json, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Index, replace).(opt.ScalarExpr),
		)

	case *memo.FetchValPathExpr:
		return f.ConstructFetchValPath(
			f.invokeReplace(t.Json, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Path, replace).(opt.ScalarExpr),
		)

	case *memo.FetchTextPathExpr:
		return f.ConstructFetchTextPath(
			f.invokeReplace(t.Json, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Path, replace).(opt.ScalarExpr),
		)

	case *memo.UnaryMinusExpr:
		return f.ConstructUnaryMinus(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.UnaryComplementExpr:
		return f.ConstructUnaryComplement(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.CastExpr:
		return f.ConstructCast(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
			t.TargetTyp,
		)

	case *memo.IfErrExpr:
		return f.ConstructIfErr(
			f.invokeReplace(t.Cond, replace).(opt.ScalarExpr),
			f.copyAndReplaceDefaultScalarListExpr(t.OrElse, replace),
			f.copyAndReplaceDefaultScalarListExpr(t.ErrCode, replace),
		)

	case *memo.CaseExpr:
		return f.ConstructCase(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
			f.copyAndReplaceDefaultScalarListExpr(t.Whens, replace),
			f.invokeReplace(t.OrElse, replace).(opt.ScalarExpr),
		)

	case *memo.WhenExpr:
		return f.ConstructWhen(
			f.invokeReplace(t.Condition, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Value, replace).(opt.ScalarExpr),
		)

	case *memo.ArrayExpr:
		return f.ConstructArray(
			f.copyAndReplaceDefaultScalarListExpr(t.Elems, replace),
			t.Typ,
		)

	case *memo.IndirectionExpr:
		return f.ConstructIndirection(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Index, replace).(opt.ScalarExpr),
		)

	case *memo.ArrayFlattenExpr:
		return f.ConstructArrayFlatten(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.SubqueryPrivate,
		)

	case *memo.FunctionExpr:
		return f.ConstructFunction(
			f.copyAndReplaceDefaultScalarListExpr(t.Args, replace),
			&t.FunctionPrivate,
		)

	case *memo.CollateExpr:
		return f.ConstructCollate(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
			t.Locale,
		)

	case *memo.CoalesceExpr:
		return f.ConstructCoalesce(
			f.copyAndReplaceDefaultScalarListExpr(t.Args, replace),
		)

	case *memo.ColumnAccessExpr:
		return f.ConstructColumnAccess(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
			t.Idx,
		)

	case *memo.UnsupportedExprExpr:
		return t

	case *memo.ArrayAggExpr:
		return f.ConstructArrayAgg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.AvgExpr:
		return f.ConstructAvg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.BoolAndExpr:
		return f.ConstructBoolAnd(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.BoolOrExpr:
		return f.ConstructBoolOr(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.ConcatAggExpr:
		return f.ConstructConcatAgg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.CountExpr:
		return f.ConstructCount(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.CountRowsExpr:
		return t

	case *memo.MaxExpr:
		return f.ConstructMax(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.MinExpr:
		return f.ConstructMin(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.SumIntExpr:
		return f.ConstructSumInt(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.SumExpr:
		return f.ConstructSum(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.SqrDiffExpr:
		return f.ConstructSqrDiff(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.VarianceExpr:
		return f.ConstructVariance(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.StdDevExpr:
		return f.ConstructStdDev(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.XorAggExpr:
		return f.ConstructXorAgg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.JsonAggExpr:
		return f.ConstructJsonAgg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.JsonbAggExpr:
		return f.ConstructJsonbAgg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.StringAggExpr:
		return f.ConstructStringAgg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Sep, replace).(opt.ScalarExpr),
		)

	case *memo.ConstAggExpr:
		return f.ConstructConstAgg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.ConstNotNullAggExpr:
		return f.ConstructConstNotNullAgg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.AnyNotNullAggExpr:
		return f.ConstructAnyNotNullAgg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.FirstAggExpr:
		return f.ConstructFirstAgg(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.AggDistinctExpr:
		return f.ConstructAggDistinct(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
		)

	case *memo.AggFilterExpr:
		return f.ConstructAggFilter(
			f.invokeReplace(t.Input, replace).(opt.ScalarExpr),
			f.invokeReplace(t.Filter, replace).(opt.ScalarExpr),
		)

	case *memo.InsertExpr:
		return f.ConstructInsert(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.MutationPrivate,
		)

	case *memo.UpdateExpr:
		return f.ConstructUpdate(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.MutationPrivate,
		)

	case *memo.UpsertExpr:
		return f.ConstructUpsert(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.MutationPrivate,
		)

	case *memo.DeleteExpr:
		return f.ConstructDelete(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.MutationPrivate,
		)

	case *memo.CreateTableExpr:
		return f.ConstructCreateTable(
			f.invokeReplace(t.Input, replace).(memo.RelExpr),
			&t.CreateTablePrivate,
		)

	}
	panic(pgerror.NewAssertionErrorf("unhandled op %s", log.Safe(src.Op())))
}

func (f *Factory) copyAndReplaceDefaultProjectionsExpr(src memo.ProjectionsExpr, replace ReplaceFunc) (dst memo.ProjectionsExpr) {
	dst = make(memo.ProjectionsExpr, len(src))
	for i := range src {
		dst[i].Element = f.invokeReplace(src[i].Element, replace).(opt.ScalarExpr)
		dst[i].Col = src[i].Col
	}
	return dst
}

func (f *Factory) copyAndReplaceDefaultAggregationsExpr(src memo.AggregationsExpr, replace ReplaceFunc) (dst memo.AggregationsExpr) {
	dst = make(memo.AggregationsExpr, len(src))
	for i := range src {
		dst[i].Agg = f.invokeReplace(src[i].Agg, replace).(opt.ScalarExpr)
		dst[i].Col = src[i].Col
	}
	return dst
}

func (f *Factory) copyAndReplaceDefaultFiltersExpr(src memo.FiltersExpr, replace ReplaceFunc) (dst memo.FiltersExpr) {
	dst = make(memo.FiltersExpr, len(src))
	for i := range src {
		dst[i].Condition = f.invokeReplace(src[i].Condition, replace).(opt.ScalarExpr)
	}
	return dst
}

func (f *Factory) copyAndReplaceDefaultZipExpr(src memo.ZipExpr, replace ReplaceFunc) (dst memo.ZipExpr) {
	dst = make(memo.ZipExpr, len(src))
	for i := range src {
		dst[i].Func = f.invokeReplace(src[i].Func, replace).(opt.ScalarExpr)
		dst[i].Cols = src[i].Cols
	}
	return dst
}

func (f *Factory) copyAndReplaceDefaultScalarListExpr(src memo.ScalarListExpr, replace ReplaceFunc) (dst memo.ScalarListExpr) {
	dst = make(memo.ScalarListExpr, len(src))
	for i := range src {
		dst[i] = f.invokeReplace(src[i], replace).(opt.ScalarExpr)
	}
	return dst
}

// invokeReplace wraps the user-provided replace function. See comments for
// CopyAndReplace for more details.
func (f *Factory) invokeReplace(src opt.Expr, replace ReplaceFunc) (dst opt.Expr) {
	if rel, ok := src.(memo.RelExpr); ok {
		src = rel.FirstExpr()
	}
	return replace(src)
}

func (f *Factory) DynamicConstruct(op opt.Operator, args ...interface{}) opt.Expr {
	switch op {
	case opt.ScanOp:
		return f.ConstructScan(
			args[0].(*memo.ScanPrivate),
		)
	case opt.VirtualScanOp:
		return f.ConstructVirtualScan(
			args[0].(*memo.VirtualScanPrivate),
		)
	case opt.SequenceSelectOp:
		return f.ConstructSequenceSelect(
			args[0].(*memo.SequenceSelectPrivate),
		)
	case opt.ValuesOp:
		return f.ConstructValues(
			*args[0].(*memo.ScalarListExpr),
			args[1].(*memo.ValuesPrivate),
		)
	case opt.SelectOp:
		return f.ConstructSelect(
			args[0].(memo.RelExpr),
			*args[1].(*memo.FiltersExpr),
		)
	case opt.ProjectOp:
		return f.ConstructProject(
			args[0].(memo.RelExpr),
			*args[1].(*memo.ProjectionsExpr),
			*args[2].(*opt.ColSet),
		)
	case opt.InnerJoinOp:
		return f.ConstructInnerJoin(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.LeftJoinOp:
		return f.ConstructLeftJoin(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.RightJoinOp:
		return f.ConstructRightJoin(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.FullJoinOp:
		return f.ConstructFullJoin(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.SemiJoinOp:
		return f.ConstructSemiJoin(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.AntiJoinOp:
		return f.ConstructAntiJoin(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.IndexJoinOp:
		return f.ConstructIndexJoin(
			args[0].(memo.RelExpr),
			args[1].(*memo.IndexJoinPrivate),
		)
	case opt.LookupJoinOp:
		return f.ConstructLookupJoin(
			args[0].(memo.RelExpr),
			*args[1].(*memo.FiltersExpr),
			args[2].(*memo.LookupJoinPrivate),
		)
	case opt.MergeJoinOp:
		return f.ConstructMergeJoin(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.MergeJoinPrivate),
		)
	case opt.ZigzagJoinOp:
		return f.ConstructZigzagJoin(
			*args[0].(*memo.FiltersExpr),
			args[1].(*memo.ZigzagJoinPrivate),
		)
	case opt.InnerJoinApplyOp:
		return f.ConstructInnerJoinApply(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.LeftJoinApplyOp:
		return f.ConstructLeftJoinApply(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.RightJoinApplyOp:
		return f.ConstructRightJoinApply(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.FullJoinApplyOp:
		return f.ConstructFullJoinApply(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.SemiJoinApplyOp:
		return f.ConstructSemiJoinApply(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.AntiJoinApplyOp:
		return f.ConstructAntiJoinApply(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			*args[2].(*memo.FiltersExpr),
			args[3].(*memo.JoinPrivate),
		)
	case opt.GroupByOp:
		return f.ConstructGroupBy(
			args[0].(memo.RelExpr),
			*args[1].(*memo.AggregationsExpr),
			args[2].(*memo.GroupingPrivate),
		)
	case opt.ScalarGroupByOp:
		return f.ConstructScalarGroupBy(
			args[0].(memo.RelExpr),
			*args[1].(*memo.AggregationsExpr),
			args[2].(*memo.GroupingPrivate),
		)
	case opt.DistinctOnOp:
		return f.ConstructDistinctOn(
			args[0].(memo.RelExpr),
			*args[1].(*memo.AggregationsExpr),
			args[2].(*memo.GroupingPrivate),
		)
	case opt.UnionOp:
		return f.ConstructUnion(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			args[2].(*memo.SetPrivate),
		)
	case opt.IntersectOp:
		return f.ConstructIntersect(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			args[2].(*memo.SetPrivate),
		)
	case opt.ExceptOp:
		return f.ConstructExcept(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			args[2].(*memo.SetPrivate),
		)
	case opt.UnionAllOp:
		return f.ConstructUnionAll(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			args[2].(*memo.SetPrivate),
		)
	case opt.IntersectAllOp:
		return f.ConstructIntersectAll(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			args[2].(*memo.SetPrivate),
		)
	case opt.ExceptAllOp:
		return f.ConstructExceptAll(
			args[0].(memo.RelExpr),
			args[1].(memo.RelExpr),
			args[2].(*memo.SetPrivate),
		)
	case opt.LimitOp:
		return f.ConstructLimit(
			args[0].(memo.RelExpr),
			args[1].(opt.ScalarExpr),
			*args[2].(*physical.OrderingChoice),
		)
	case opt.OffsetOp:
		return f.ConstructOffset(
			args[0].(memo.RelExpr),
			args[1].(opt.ScalarExpr),
			*args[2].(*physical.OrderingChoice),
		)
	case opt.Max1RowOp:
		return f.ConstructMax1Row(
			args[0].(memo.RelExpr),
		)
	case opt.ExplainOp:
		return f.ConstructExplain(
			args[0].(memo.RelExpr),
			args[1].(*memo.ExplainPrivate),
		)
	case opt.ShowTraceForSessionOp:
		return f.ConstructShowTraceForSession(
			args[0].(*memo.ShowTracePrivate),
		)
	case opt.RowNumberOp:
		return f.ConstructRowNumber(
			args[0].(memo.RelExpr),
			args[1].(*memo.RowNumberPrivate),
		)
	case opt.ProjectSetOp:
		return f.ConstructProjectSet(
			args[0].(memo.RelExpr),
			*args[1].(*memo.ZipExpr),
		)
	case opt.SubqueryOp:
		return f.ConstructSubquery(
			args[0].(memo.RelExpr),
			args[1].(*memo.SubqueryPrivate),
		)
	case opt.AnyOp:
		return f.ConstructAny(
			args[0].(memo.RelExpr),
			args[1].(opt.ScalarExpr),
			args[2].(*memo.SubqueryPrivate),
		)
	case opt.ExistsOp:
		return f.ConstructExists(
			args[0].(memo.RelExpr),
			args[1].(*memo.SubqueryPrivate),
		)
	case opt.VariableOp:
		return f.ConstructVariable(
			*args[0].(*opt.ColumnID),
		)
	case opt.ConstOp:
		return f.ConstructConst(
			args[0].(tree.Datum),
		)
	case opt.NullOp:
		return f.ConstructNull(
			args[0].(types.T),
		)
	case opt.TrueOp:
		return f.ConstructTrue()
	case opt.FalseOp:
		return f.ConstructFalse()
	case opt.PlaceholderOp:
		return f.ConstructPlaceholder(
			args[0].(tree.TypedExpr),
		)
	case opt.TupleOp:
		return f.ConstructTuple(
			*args[0].(*memo.ScalarListExpr),
			args[1].(types.T),
		)
	case opt.AndOp:
		return f.ConstructAnd(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.OrOp:
		return f.ConstructOr(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.RangeOp:
		return f.ConstructRange(
			args[0].(opt.ScalarExpr),
		)
	case opt.NotOp:
		return f.ConstructNot(
			args[0].(opt.ScalarExpr),
		)
	case opt.EqOp:
		return f.ConstructEq(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.LtOp:
		return f.ConstructLt(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.GtOp:
		return f.ConstructGt(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.LeOp:
		return f.ConstructLe(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.GeOp:
		return f.ConstructGe(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.NeOp:
		return f.ConstructNe(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.InOp:
		return f.ConstructIn(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.NotInOp:
		return f.ConstructNotIn(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.LikeOp:
		return f.ConstructLike(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.NotLikeOp:
		return f.ConstructNotLike(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.ILikeOp:
		return f.ConstructILike(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.NotILikeOp:
		return f.ConstructNotILike(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.SimilarToOp:
		return f.ConstructSimilarTo(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.NotSimilarToOp:
		return f.ConstructNotSimilarTo(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.RegMatchOp:
		return f.ConstructRegMatch(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.NotRegMatchOp:
		return f.ConstructNotRegMatch(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.RegIMatchOp:
		return f.ConstructRegIMatch(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.NotRegIMatchOp:
		return f.ConstructNotRegIMatch(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.IsOp:
		return f.ConstructIs(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.IsNotOp:
		return f.ConstructIsNot(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.ContainsOp:
		return f.ConstructContains(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.JsonExistsOp:
		return f.ConstructJsonExists(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.JsonAllExistsOp:
		return f.ConstructJsonAllExists(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.JsonSomeExistsOp:
		return f.ConstructJsonSomeExists(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.AnyScalarOp:
		return f.ConstructAnyScalar(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
			*args[2].(*opt.Operator),
		)
	case opt.BitandOp:
		return f.ConstructBitand(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.BitorOp:
		return f.ConstructBitor(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.BitxorOp:
		return f.ConstructBitxor(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.PlusOp:
		return f.ConstructPlus(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.MinusOp:
		return f.ConstructMinus(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.MultOp:
		return f.ConstructMult(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.DivOp:
		return f.ConstructDiv(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.FloorDivOp:
		return f.ConstructFloorDiv(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.ModOp:
		return f.ConstructMod(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.PowOp:
		return f.ConstructPow(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.ConcatOp:
		return f.ConstructConcat(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.LShiftOp:
		return f.ConstructLShift(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.RShiftOp:
		return f.ConstructRShift(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.FetchValOp:
		return f.ConstructFetchVal(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.FetchTextOp:
		return f.ConstructFetchText(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.FetchValPathOp:
		return f.ConstructFetchValPath(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.FetchTextPathOp:
		return f.ConstructFetchTextPath(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.UnaryMinusOp:
		return f.ConstructUnaryMinus(
			args[0].(opt.ScalarExpr),
		)
	case opt.UnaryComplementOp:
		return f.ConstructUnaryComplement(
			args[0].(opt.ScalarExpr),
		)
	case opt.CastOp:
		return f.ConstructCast(
			args[0].(opt.ScalarExpr),
			args[1].(coltypes.T),
		)
	case opt.IfErrOp:
		return f.ConstructIfErr(
			args[0].(opt.ScalarExpr),
			*args[1].(*memo.ScalarListExpr),
			*args[2].(*memo.ScalarListExpr),
		)
	case opt.CaseOp:
		return f.ConstructCase(
			args[0].(opt.ScalarExpr),
			*args[1].(*memo.ScalarListExpr),
			args[2].(opt.ScalarExpr),
		)
	case opt.WhenOp:
		return f.ConstructWhen(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.ArrayOp:
		return f.ConstructArray(
			*args[0].(*memo.ScalarListExpr),
			args[1].(types.T),
		)
	case opt.IndirectionOp:
		return f.ConstructIndirection(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.ArrayFlattenOp:
		return f.ConstructArrayFlatten(
			args[0].(memo.RelExpr),
			args[1].(*memo.SubqueryPrivate),
		)
	case opt.FunctionOp:
		return f.ConstructFunction(
			*args[0].(*memo.ScalarListExpr),
			args[1].(*memo.FunctionPrivate),
		)
	case opt.CollateOp:
		return f.ConstructCollate(
			args[0].(opt.ScalarExpr),
			*args[1].(*string),
		)
	case opt.CoalesceOp:
		return f.ConstructCoalesce(
			*args[0].(*memo.ScalarListExpr),
		)
	case opt.ColumnAccessOp:
		return f.ConstructColumnAccess(
			args[0].(opt.ScalarExpr),
			*args[1].(*memo.TupleOrdinal),
		)
	case opt.UnsupportedExprOp:
		return f.ConstructUnsupportedExpr(
			args[0].(tree.TypedExpr),
		)
	case opt.ArrayAggOp:
		return f.ConstructArrayAgg(
			args[0].(opt.ScalarExpr),
		)
	case opt.AvgOp:
		return f.ConstructAvg(
			args[0].(opt.ScalarExpr),
		)
	case opt.BoolAndOp:
		return f.ConstructBoolAnd(
			args[0].(opt.ScalarExpr),
		)
	case opt.BoolOrOp:
		return f.ConstructBoolOr(
			args[0].(opt.ScalarExpr),
		)
	case opt.ConcatAggOp:
		return f.ConstructConcatAgg(
			args[0].(opt.ScalarExpr),
		)
	case opt.CountOp:
		return f.ConstructCount(
			args[0].(opt.ScalarExpr),
		)
	case opt.CountRowsOp:
		return f.ConstructCountRows()
	case opt.MaxOp:
		return f.ConstructMax(
			args[0].(opt.ScalarExpr),
		)
	case opt.MinOp:
		return f.ConstructMin(
			args[0].(opt.ScalarExpr),
		)
	case opt.SumIntOp:
		return f.ConstructSumInt(
			args[0].(opt.ScalarExpr),
		)
	case opt.SumOp:
		return f.ConstructSum(
			args[0].(opt.ScalarExpr),
		)
	case opt.SqrDiffOp:
		return f.ConstructSqrDiff(
			args[0].(opt.ScalarExpr),
		)
	case opt.VarianceOp:
		return f.ConstructVariance(
			args[0].(opt.ScalarExpr),
		)
	case opt.StdDevOp:
		return f.ConstructStdDev(
			args[0].(opt.ScalarExpr),
		)
	case opt.XorAggOp:
		return f.ConstructXorAgg(
			args[0].(opt.ScalarExpr),
		)
	case opt.JsonAggOp:
		return f.ConstructJsonAgg(
			args[0].(opt.ScalarExpr),
		)
	case opt.JsonbAggOp:
		return f.ConstructJsonbAgg(
			args[0].(opt.ScalarExpr),
		)
	case opt.StringAggOp:
		return f.ConstructStringAgg(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.ConstAggOp:
		return f.ConstructConstAgg(
			args[0].(opt.ScalarExpr),
		)
	case opt.ConstNotNullAggOp:
		return f.ConstructConstNotNullAgg(
			args[0].(opt.ScalarExpr),
		)
	case opt.AnyNotNullAggOp:
		return f.ConstructAnyNotNullAgg(
			args[0].(opt.ScalarExpr),
		)
	case opt.FirstAggOp:
		return f.ConstructFirstAgg(
			args[0].(opt.ScalarExpr),
		)
	case opt.AggDistinctOp:
		return f.ConstructAggDistinct(
			args[0].(opt.ScalarExpr),
		)
	case opt.AggFilterOp:
		return f.ConstructAggFilter(
			args[0].(opt.ScalarExpr),
			args[1].(opt.ScalarExpr),
		)
	case opt.InsertOp:
		return f.ConstructInsert(
			args[0].(memo.RelExpr),
			args[1].(*memo.MutationPrivate),
		)
	case opt.UpdateOp:
		return f.ConstructUpdate(
			args[0].(memo.RelExpr),
			args[1].(*memo.MutationPrivate),
		)
	case opt.UpsertOp:
		return f.ConstructUpsert(
			args[0].(memo.RelExpr),
			args[1].(*memo.MutationPrivate),
		)
	case opt.DeleteOp:
		return f.ConstructDelete(
			args[0].(memo.RelExpr),
			args[1].(*memo.MutationPrivate),
		)
	case opt.CreateTableOp:
		return f.ConstructCreateTable(
			args[0].(memo.RelExpr),
			args[1].(*memo.CreateTablePrivate),
		)
	}
	panic(pgerror.NewAssertionErrorf("cannot dynamically construct operator %s", log.Safe(op)))
}
