// Code generated by execgen; DO NOT EDIT.
// Copyright 2018 The Cockroach Authors.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//     http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
// implied. See the License for the specific language governing
// permissions and limitations under the License.

package exec

import (
	"bytes"
	"fmt"

	"github.com/cockroachdb/apd"
	"github.com/cockroachdb/cockroach/pkg/sql/distsqlpb"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/coldata"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/types"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/pkg/errors"
)

func newSingleSorter(t types.T, dir distsqlpb.Ordering_Column_Direction) (colSorter, error) {
	switch t {
	case types.Bool:
		switch dir {
		case distsqlpb.Ordering_Column_ASC:
			return &sortBoolAscOp{}, nil
		case distsqlpb.Ordering_Column_DESC:
			return &sortBoolDescOp{}, nil
		default:
			return nil, errors.Errorf("unsupported sort dir %s", dir)
		}
	case types.Bytes:
		switch dir {
		case distsqlpb.Ordering_Column_ASC:
			return &sortBytesAscOp{}, nil
		case distsqlpb.Ordering_Column_DESC:
			return &sortBytesDescOp{}, nil
		default:
			return nil, errors.Errorf("unsupported sort dir %s", dir)
		}
	case types.Decimal:
		switch dir {
		case distsqlpb.Ordering_Column_ASC:
			return &sortDecimalAscOp{}, nil
		case distsqlpb.Ordering_Column_DESC:
			return &sortDecimalDescOp{}, nil
		default:
			return nil, errors.Errorf("unsupported sort dir %s", dir)
		}
	case types.Int8:
		switch dir {
		case distsqlpb.Ordering_Column_ASC:
			return &sortInt8AscOp{}, nil
		case distsqlpb.Ordering_Column_DESC:
			return &sortInt8DescOp{}, nil
		default:
			return nil, errors.Errorf("unsupported sort dir %s", dir)
		}
	case types.Int16:
		switch dir {
		case distsqlpb.Ordering_Column_ASC:
			return &sortInt16AscOp{}, nil
		case distsqlpb.Ordering_Column_DESC:
			return &sortInt16DescOp{}, nil
		default:
			return nil, errors.Errorf("unsupported sort dir %s", dir)
		}
	case types.Int32:
		switch dir {
		case distsqlpb.Ordering_Column_ASC:
			return &sortInt32AscOp{}, nil
		case distsqlpb.Ordering_Column_DESC:
			return &sortInt32DescOp{}, nil
		default:
			return nil, errors.Errorf("unsupported sort dir %s", dir)
		}
	case types.Int64:
		switch dir {
		case distsqlpb.Ordering_Column_ASC:
			return &sortInt64AscOp{}, nil
		case distsqlpb.Ordering_Column_DESC:
			return &sortInt64DescOp{}, nil
		default:
			return nil, errors.Errorf("unsupported sort dir %s", dir)
		}
	case types.Float32:
		switch dir {
		case distsqlpb.Ordering_Column_ASC:
			return &sortFloat32AscOp{}, nil
		case distsqlpb.Ordering_Column_DESC:
			return &sortFloat32DescOp{}, nil
		default:
			return nil, errors.Errorf("unsupported sort dir %s", dir)
		}
	case types.Float64:
		switch dir {
		case distsqlpb.Ordering_Column_ASC:
			return &sortFloat64AscOp{}, nil
		case distsqlpb.Ordering_Column_DESC:
			return &sortFloat64DescOp{}, nil
		default:
			return nil, errors.Errorf("unsupported sort dir %s", dir)
		}
	default:
		return nil, errors.Errorf("unsupported sort type %s", t)
	}
}

type sortBoolAscOp struct {
	sortCol      []bool
	order        []uint64
	workingSpace []uint64
}

func (s *sortBoolAscOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Bool()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortBoolAscOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortBoolAscOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortBoolAscOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortBoolAscOp) Less(i, j int) bool {
	var lt bool
	lt = tree.CompareBools(s.sortCol[i], s.sortCol[j]) < 0
	return lt
}

func (s *sortBoolAscOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBoolAscOp) Len() int {
	return len(s.order)
}

type sortBoolDescOp struct {
	sortCol      []bool
	order        []uint64
	workingSpace []uint64
}

func (s *sortBoolDescOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Bool()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortBoolDescOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortBoolDescOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortBoolDescOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortBoolDescOp) Less(i, j int) bool {
	var lt bool
	lt = tree.CompareBools(s.sortCol[i], s.sortCol[j]) > 0
	return lt
}

func (s *sortBoolDescOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBoolDescOp) Len() int {
	return len(s.order)
}

type sortBytesAscOp struct {
	sortCol      [][]byte
	order        []uint64
	workingSpace []uint64
}

func (s *sortBytesAscOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Bytes()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortBytesAscOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortBytesAscOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortBytesAscOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortBytesAscOp) Less(i, j int) bool {
	var lt bool
	lt = bytes.Compare(s.sortCol[i], s.sortCol[j]) < 0
	return lt
}

func (s *sortBytesAscOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBytesAscOp) Len() int {
	return len(s.order)
}

type sortBytesDescOp struct {
	sortCol      [][]byte
	order        []uint64
	workingSpace []uint64
}

func (s *sortBytesDescOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Bytes()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortBytesDescOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortBytesDescOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortBytesDescOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortBytesDescOp) Less(i, j int) bool {
	var lt bool
	lt = bytes.Compare(s.sortCol[i], s.sortCol[j]) > 0
	return lt
}

func (s *sortBytesDescOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortBytesDescOp) Len() int {
	return len(s.order)
}

type sortDecimalAscOp struct {
	sortCol      []apd.Decimal
	order        []uint64
	workingSpace []uint64
}

func (s *sortDecimalAscOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Decimal()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortDecimalAscOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortDecimalAscOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortDecimalAscOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortDecimalAscOp) Less(i, j int) bool {
	var lt bool
	lt = tree.CompareDecimals(&s.sortCol[i], &s.sortCol[j]) < 0
	return lt
}

func (s *sortDecimalAscOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortDecimalAscOp) Len() int {
	return len(s.order)
}

type sortDecimalDescOp struct {
	sortCol      []apd.Decimal
	order        []uint64
	workingSpace []uint64
}

func (s *sortDecimalDescOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Decimal()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortDecimalDescOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortDecimalDescOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortDecimalDescOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortDecimalDescOp) Less(i, j int) bool {
	var lt bool
	lt = tree.CompareDecimals(&s.sortCol[i], &s.sortCol[j]) > 0
	return lt
}

func (s *sortDecimalDescOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortDecimalDescOp) Len() int {
	return len(s.order)
}

type sortInt8AscOp struct {
	sortCol      []int8
	order        []uint64
	workingSpace []uint64
}

func (s *sortInt8AscOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Int8()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortInt8AscOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortInt8AscOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortInt8AscOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortInt8AscOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] < s.sortCol[j]
	return lt
}

func (s *sortInt8AscOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt8AscOp) Len() int {
	return len(s.order)
}

type sortInt8DescOp struct {
	sortCol      []int8
	order        []uint64
	workingSpace []uint64
}

func (s *sortInt8DescOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Int8()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortInt8DescOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortInt8DescOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortInt8DescOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortInt8DescOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] > s.sortCol[j]
	return lt
}

func (s *sortInt8DescOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt8DescOp) Len() int {
	return len(s.order)
}

type sortInt16AscOp struct {
	sortCol      []int16
	order        []uint64
	workingSpace []uint64
}

func (s *sortInt16AscOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Int16()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortInt16AscOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortInt16AscOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortInt16AscOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortInt16AscOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] < s.sortCol[j]
	return lt
}

func (s *sortInt16AscOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt16AscOp) Len() int {
	return len(s.order)
}

type sortInt16DescOp struct {
	sortCol      []int16
	order        []uint64
	workingSpace []uint64
}

func (s *sortInt16DescOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Int16()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortInt16DescOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortInt16DescOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortInt16DescOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortInt16DescOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] > s.sortCol[j]
	return lt
}

func (s *sortInt16DescOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt16DescOp) Len() int {
	return len(s.order)
}

type sortInt32AscOp struct {
	sortCol      []int32
	order        []uint64
	workingSpace []uint64
}

func (s *sortInt32AscOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Int32()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortInt32AscOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortInt32AscOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortInt32AscOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortInt32AscOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] < s.sortCol[j]
	return lt
}

func (s *sortInt32AscOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt32AscOp) Len() int {
	return len(s.order)
}

type sortInt32DescOp struct {
	sortCol      []int32
	order        []uint64
	workingSpace []uint64
}

func (s *sortInt32DescOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Int32()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortInt32DescOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortInt32DescOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortInt32DescOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortInt32DescOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] > s.sortCol[j]
	return lt
}

func (s *sortInt32DescOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt32DescOp) Len() int {
	return len(s.order)
}

type sortInt64AscOp struct {
	sortCol      []int64
	order        []uint64
	workingSpace []uint64
}

func (s *sortInt64AscOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Int64()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortInt64AscOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortInt64AscOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortInt64AscOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortInt64AscOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] < s.sortCol[j]
	return lt
}

func (s *sortInt64AscOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt64AscOp) Len() int {
	return len(s.order)
}

type sortInt64DescOp struct {
	sortCol      []int64
	order        []uint64
	workingSpace []uint64
}

func (s *sortInt64DescOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Int64()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortInt64DescOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortInt64DescOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortInt64DescOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortInt64DescOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] > s.sortCol[j]
	return lt
}

func (s *sortInt64DescOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortInt64DescOp) Len() int {
	return len(s.order)
}

type sortFloat32AscOp struct {
	sortCol      []float32
	order        []uint64
	workingSpace []uint64
}

func (s *sortFloat32AscOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Float32()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortFloat32AscOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortFloat32AscOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortFloat32AscOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortFloat32AscOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] < s.sortCol[j]
	return lt
}

func (s *sortFloat32AscOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortFloat32AscOp) Len() int {
	return len(s.order)
}

type sortFloat32DescOp struct {
	sortCol      []float32
	order        []uint64
	workingSpace []uint64
}

func (s *sortFloat32DescOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Float32()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortFloat32DescOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortFloat32DescOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortFloat32DescOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortFloat32DescOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] > s.sortCol[j]
	return lt
}

func (s *sortFloat32DescOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortFloat32DescOp) Len() int {
	return len(s.order)
}

type sortFloat64AscOp struct {
	sortCol      []float64
	order        []uint64
	workingSpace []uint64
}

func (s *sortFloat64AscOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Float64()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortFloat64AscOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortFloat64AscOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortFloat64AscOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortFloat64AscOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] < s.sortCol[j]
	return lt
}

func (s *sortFloat64AscOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortFloat64AscOp) Len() int {
	return len(s.order)
}

type sortFloat64DescOp struct {
	sortCol      []float64
	order        []uint64
	workingSpace []uint64
}

func (s *sortFloat64DescOp) init(col coldata.Vec, order []uint64, workingSpace []uint64) {
	s.sortCol = col.Float64()
	s.order = order
	s.workingSpace = workingSpace
}

func (s *sortFloat64DescOp) sort() {
	n := len(s.sortCol)
	s.quickSort(0, n, maxDepth(n))
}

func (s *sortFloat64DescOp) reorder() {
	// Initialize our index vector to the inverse of the order vector. This
	// creates what is known as a permutation. Position i in the permutation has
	// the output index for the value at position i in the original ordering of
	// the data we sorted. For example, if we were sorting the column [d,c,a,b],
	// the order vector would be [2,3,1,0], and the permutation would be
	// [3,2,0,1].
	index := s.workingSpace
	for idx, ord := range s.order {
		index[int(ord)] = uint64(idx)
	}
	// Once we have our permutation, we apply it to our value column by following
	// each cycle within the permutation until we reach the identity. This
	// algorithm takes just O(n) swaps to reorder the sortCol. It also returns
	// the index array to an ordinal list in the process.
	for i := range index {
		for index[i] != uint64(i) {
			s.sortCol[index[i]], s.sortCol[i] = s.sortCol[i], s.sortCol[index[i]]
			index[i], index[index[i]] = index[index[i]], index[i]
		}
	}
}

func (s *sortFloat64DescOp) sortPartitions(partitions []uint64) {
	if len(partitions) < 1 {
		panic(fmt.Sprintf("invalid partitions list %v", partitions))
	}
	order := s.order
	sortCol := s.sortCol
	for i, partitionStart := range partitions {
		var partitionEnd uint64
		if i == len(partitions)-1 {
			partitionEnd = uint64(len(order))
		} else {
			partitionEnd = partitions[i+1]
		}
		s.order = order[partitionStart:partitionEnd]
		s.sortCol = sortCol[partitionStart:partitionEnd]
		n := int(partitionEnd - partitionStart)
		s.quickSort(0, n, maxDepth(n))
	}
}

func (s *sortFloat64DescOp) Less(i, j int) bool {
	var lt bool
	lt = s.sortCol[i] > s.sortCol[j]
	return lt
}

func (s *sortFloat64DescOp) Swap(i, j int) {
	// Swap needs to swap the values in the column being sorted, as otherwise
	// subsequent calls to Less would be incorrect.
	// We also store the swap order in s.order to swap all the other columns.
	s.sortCol[i], s.sortCol[j] = s.sortCol[j], s.sortCol[i]
	s.order[i], s.order[j] = s.order[j], s.order[i]
}

func (s *sortFloat64DescOp) Len() int {
	return len(s.order)
}
