"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const yargs = require("yargs");
const lib_1 = require("../../lib");
const ACTION_KEYS = Object.keys(lib_1.ACTIONS);
// Validate and normalize.
const validate = (parser) => {
    const { argv } = parser;
    const { action, format } = argv;
    // Defaults
    const statsFile = argv.stats;
    return Promise.resolve()
        // Stats
        .then(() => lib_1.readJson(statsFile))
        // Final object
        .then((stats) => ({
        action,
        format,
        stats,
    }));
};
const args = () => yargs
    .usage(`Usage: inspectpack -s <file> -a <action> [options]`)
    // Actions
    .option("action", {
    alias: "a",
    choices: ACTION_KEYS,
    describe: "Actions to take",
    required: true,
    type: "string",
})
    .example("inspectpack -s stats.json -a duplicates", "Show duplicates files")
    .example("inspectpack -s stats.json -a versions", "Show version skews in a project")
    .example("inspectpack -s stats.json -a sizes", "Show raw file sizes")
    // Files
    .option("stats", {
    alias: "s",
    describe: "Path to webpack-created stats JSON object",
    required: true,
    type: "string",
})
    // Display
    .option("format", {
    alias: "f",
    choices: Object.keys(lib_1.TemplateFormat),
    default: lib_1.TemplateFormat.text,
    describe: "Display output format",
    type: "string",
})
    // Logistical
    .help().alias("help", "h")
    .version().alias("version", "v")
    .strict();
exports.parse = () => validate(args());
