/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class TimestampInequalityRule
extends AbstractRule {
    static final long serialVersionUID = -4642641663914789241L;
    private static final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private transient String inequalitySymbol;
    private long timeStamp;

    private TimestampInequalityRule(String inequalitySymbol, String value) {
        this.inequalitySymbol = inequalitySymbol;
        try {
            this.timeStamp = dateFormat.parse(value).getTime();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Could not parse date: " + value);
        }
    }

    public static Rule getRule(String inequalitySymbol, String value) {
        return new TimestampInequalityRule(inequalitySymbol, value);
    }

    public boolean evaluate(LoggingEvent event) {
        long eventTimeStamp = Long.parseLong(resolver.getValue("TIMESTAMP", event).toString()) / 1000L * 1000L;
        boolean result = false;
        long first = eventTimeStamp;
        long second = this.timeStamp;
        if ("<".equals(this.inequalitySymbol)) {
            result = first < second;
        } else if (">".equals(this.inequalitySymbol)) {
            result = first > second;
        } else if ("<=".equals(this.inequalitySymbol)) {
            result = first <= second;
        } else if (">=".equals(this.inequalitySymbol)) {
            result = first >= second;
        }
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.inequalitySymbol = (String)in.readObject();
        this.timeStamp = in.readLong();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.inequalitySymbol);
        out.writeLong(this.timeStamp);
    }
}

