/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.spi;

import java.util.ArrayList;

public class Pattern {
    ArrayList components = new ArrayList();

    public Pattern() {
    }

    public Object clone() {
        Pattern p = new Pattern();
        p.components.addAll(this.components);
        return p;
    }

    public Pattern(String p) {
        this();
        if (p == null) {
            return;
        }
        int lastIndex = 0;
        while (true) {
            int k;
            if ((k = p.indexOf(47, lastIndex)) == -1) break;
            String c = p.substring(lastIndex, k);
            if (c.length() > 0) {
                this.components.add(c);
            }
            lastIndex = k + 1;
        }
        this.components.add(p.substring(lastIndex));
    }

    public void push(String s) {
        this.components.add(s);
    }

    public int size() {
        return this.components.size();
    }

    public String get(int i) {
        return (String)this.components.get(i);
    }

    public void pop() {
        if (!this.components.isEmpty()) {
            this.components.remove(this.components.size() - 1);
        }
    }

    public String peekLast() {
        if (!this.components.isEmpty()) {
            int size = this.components.size();
            return (String)this.components.get(size - 1);
        }
        return null;
    }

    public int tailMatch(Pattern p) {
        if (p == null) {
            return 0;
        }
        int lSize = this.components.size();
        int rSize = p.components.size();
        if (lSize == 0 || rSize == 0) {
            return 0;
        }
        int minLen = lSize <= rSize ? lSize : rSize;
        int match = 0;
        int i = 1;
        while (i <= minLen) {
            String r;
            String l = (String)this.components.get(lSize - i);
            if (!l.equals(r = (String)p.components.get(rSize - i))) break;
            ++match;
            ++i;
        }
        return match;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Pattern)) {
            return false;
        }
        Pattern r = (Pattern)o;
        if (r.size() != this.size()) {
            return false;
        }
        int len = this.size();
        int i = 0;
        while (i < len) {
            if (!this.get(i).equals(r.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        int len = this.size();
        int i = 0;
        while (i < len) {
            hc ^= this.get(i).hashCode();
            ++i;
        }
        return hc;
    }

    public String toString() {
        int size = this.components.size();
        String result = "";
        int i = 0;
        while (i < size) {
            result = result + "/" + this.components.get(i);
            ++i;
        }
        return result;
    }
}

